/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.maploader;

import android.text.TextUtils;
import com.autonavi.ae.gmap.GLMapEngine;
import com.autonavi.ae.gmap.maploader.BaseMapLoader;
import com.autonavi.ae.gmap.maploader.MapSourceGridData;
import com.autonavi.ae.gmap.utils.GLConvertUtil;
import com.autonavi.ae.gmap.utils.GLMD5Util;
import com.autonavi.ae.gmap.utils.GLMapUtil;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class IndoorMapLoader
extends BaseMapLoader {
    private static final String INDOOR_CHANNEL = "amap7";
    private static final String INDOOR_SIGN_KEY = "@1071a2a4e3gte2Uc32cY3a98Tf33H1c4Gc23f";
    private static final int AM_INVALID_FLOOR = -9999;

    public IndoorMapLoader(int n2, GLMapEngine gLMapEngine, int n3) {
        super(n2);
        this.mGLMapEngine = gLMapEngine;
        this.mDataSource = n3;
        this.mCreateTime = System.currentTimeMillis();
    }

    protected String getMapAddress() {
        return this.mGLMapEngine.getMapIndoorAddress();
    }

    protected String getMapServerPath() {
        String string = "/ws/transfer/auth/map/indoor_maps/?";
        return string;
    }

    protected String getGridParams() {
        return this.getIndoorRequestParams();
    }

    protected boolean processReceivedDataHeader() {
        if (this.mReceivedDataSize > 5) {
            int n2 = 6;
            this.mReceivedDataSize -= n2;
            if (this.mReceivedDataSize > 0) {
                GLConvertUtil.moveArray(this.mReceivedDataBuffer, n2, this.mReceivedDataBuffer, 0, this.mReceivedDataSize);
            }
            this.mNextImgDataLength = 0;
            this.isReceivedHeader = true;
            this.processReceivedIndoorData();
            return true;
        }
        return false;
    }

    protected void processReceivedDataByType() {
        this.processReceivedIndoorData();
    }

    protected void processReceivedVersion() {
        if (this.mDataSource == 9) {
            super.processReceivedVersionData(this.mReceivedDataBuffer, 0, this.mReceivedDataSize);
        }
    }

    public boolean isRequestValid() {
        return this.mGLMapEngine.isIndoorGridsInScreen(this.mMapTiles, this.mDataSource);
    }

    protected boolean isNeedReturn() {
        return this.mDataSource == 9;
    }

    protected boolean processHttpResponse(HttpURLConnection httpURLConnection) {
        String string = httpURLConnection.getContentType();
        if (!TextUtils.isEmpty((CharSequence)string) && (string.contains("application/json") || string.contains("application/xml"))) {
            this.mGLMapEngine.setParamater(this.mEngineID, 1026, 0, 0, 0, 0);
            return true;
        }
        return false;
    }

    private void processReceivedIndoorData() {
        if (this.mNextImgDataLength == 0) {
            if (this.mReceivedDataSize >= 6) {
                this.mNextImgDataLength = GLConvertUtil.getInt2(this.mReceivedDataBuffer, 0);
                this.processReceivedIndoorData();
            }
        } else if (this.mReceivedDataSize >= this.mNextImgDataLength) {
            this.processReceivedIndoorTileDataV4(this.mReceivedDataBuffer, 0, this.mNextImgDataLength);
            if (null != this.mReceivedDataBuffer) {
                GLConvertUtil.moveArray(this.mReceivedDataBuffer, this.mNextImgDataLength, this.mReceivedDataBuffer, 0, this.mReceivedDataSize - this.mNextImgDataLength);
                this.mReceivedDataSize -= this.mNextImgDataLength;
                this.mNextImgDataLength = 0;
                this.processReceivedIndoorData();
            }
        }
    }

    protected void processReceivedIndoorTileDataV4(byte[] byArray, int n2, int n3) {
        try {
            boolean bl2;
            int n4 = n2;
            n4 = n2 += 4;
            byte by2 = byArray[n2++];
            if (by2 > 10) {
                return;
            }
            String string = "";
            short s2 = 0;
            if (by2 > 0 && n2 + by2 - 1 < n3) {
                string = new String(byArray, n2, (int)by2, "utf-8");
            }
            n2 += by2;
            if (!this.mGLMapEngine.isMapEngineValid() || n3 <= n4) {
                return;
            }
            s2 = GLConvertUtil.getShort2(byArray, n2);
            if (this.mGLMapEngine.putMapData(this.mEngineID, byArray, n4, n3 - n4, this.mDataSource, 0)) {
                string = string + "-" + s2;
            }
            boolean bl3 = bl2 = !this.mGLMapEngine.isIndoorGridInScreen(this.mDataSource, string, s2);
            if (bl2) {
                super.doCancel();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private String getIndoorRequestParams() {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        String string3 = ";";
        for (int i2 = 0; i2 < this.mMapTiles.size(); ++i2) {
            string2 = ((MapSourceGridData)this.mMapTiles.get(i2)).getGridName();
            int n2 = ((MapSourceGridData)this.mMapTiles.get((int)i2)).mIndoorIndex;
            int n3 = ((MapSourceGridData)this.mMapTiles.get((int)i2)).mIndoorVersion;
            if (TextUtils.isEmpty((CharSequence)string2) || super.isContainIllegal(string2) || !GLMapUtil.isAssic(string2)) continue;
            stringBuffer.append(string2 + string3);
            stringBuffer2.append(n2 + string3);
            stringBuffer3.append(n3 + string3);
        }
        String string4 = stringBuffer.toString();
        if (!TextUtils.isEmpty((CharSequence)string4) && (string4.endsWith(string3) || string4.endsWith(" "))) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = stringBuffer2.toString())) && (string2.endsWith(string3) || string2.endsWith(" "))) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (!TextUtils.isEmpty((CharSequence)(string = stringBuffer3.toString())) && (string.endsWith(string3) || string.endsWith(" "))) {
            string = string.substring(0, string.length() - 1);
        }
        StringBuffer stringBuffer4 = new StringBuffer();
        try {
            stringBuffer4.append("from=AMAP_ENGINE_INDOOR_V4&").append("poiid=" + URLEncoder.encode(string4, "UTF-8") + "&").append("floor=" + URLEncoder.encode(string2, "UTF-8") + "&").append("version=" + URLEncoder.encode(string, "UTF-8") + "&").append("sign=" + this.getIndoorMD5Params(string4) + "&").append("language=zh_CN&output=bin&channel=amap7&servicetype=unify&").append("zoomlevel=" + (int)this.mGLMapEngine.getMapZoomer(this.mEngineID));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return stringBuffer4.toString();
    }

    private String getIndoorMD5Params(String string) {
        return GLMD5Util.getStringMD5(INDOOR_CHANNEL + string + INDOOR_SIGN_KEY).toUpperCase();
    }

    public boolean switchFloorFailed() {
        if (null != this.mMapTiles && this.mMapTiles.size() > 0) {
            int n2 = this.mMapTiles.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                MapSourceGridData mapSourceGridData = (MapSourceGridData)this.mMapTiles.get(i2);
                if (null == mapSourceGridData || mapSourceGridData.mIndoorVersion != 0 || mapSourceGridData.mIndoorIndex == -9999) continue;
                return true;
            }
        }
        return false;
    }
}

