/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.maploader;

import android.text.TextUtils;
import com.amap.api.mapcore.util.cx;
import com.amap.api.mapcore.util.o;
import com.autonavi.ae.gmap.GLMapEngine;
import com.autonavi.ae.gmap.maploader.BaseMapLoader;
import com.autonavi.ae.gmap.maploader.MapSourceGridData;
import com.autonavi.ae.gmap.utils.GLConvertUtil;
import com.autonavi.ae.gmap.utils.GLMapUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class NormalMapLoader
extends BaseMapLoader {
    private int mMapLevel = 0;
    private int mMapMode = 0;
    private int mMapModeState = 0;

    public NormalMapLoader(int n2, GLMapEngine gLMapEngine, int n3) {
        super(n2);
        this.mGLMapEngine = gLMapEngine;
        this.mDataSource = n3;
        this.mCreateTime = System.currentTimeMillis();
    }

    protected String getMapAddress() {
        return this.mGLMapEngine.getMapSvrAddress();
    }

    protected String getMapServerPath() {
        String string = null;
        switch (this.mDataSource) {
            case 4: {
                string = "/ws/mps/rtt?";
                break;
            }
            case 3: {
                string = "/ws/mps/smap?";
                break;
            }
            case 0: 
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                string = "/ws/mps/vmap?";
                break;
            }
            case 2: 
            case 6: {
                string = "/amapsrv/MPS?";
                break;
            }
        }
        return string;
    }

    protected String getGridParams() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = ";";
        for (int i2 = 0; i2 < this.mMapTiles.size(); ++i2) {
            string = ((MapSourceGridData)this.mMapTiles.get(i2)).getGridName();
            if (TextUtils.isEmpty((CharSequence)string) || super.isContainIllegal(string) || !GLMapUtil.isAssic(string)) continue;
            if (this.mDataSource == 4 && ((MapSourceGridData)this.mMapTiles.get((int)i2)).mObj != null) {
                String string3 = (String)((MapSourceGridData)this.mMapTiles.get((int)i2)).mObj;
                try {
                    string = string + "-" + URLEncoder.encode(string3, "utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    continue;
                }
            }
            stringBuffer.append(string + string2);
        }
        String string4 = stringBuffer.toString();
        if (TextUtils.isEmpty((CharSequence)string4)) {
            return null;
        }
        while (string4.endsWith(string2) || string4.endsWith(" ")) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        string = null;
        switch (this.mDataSource) {
            case 15: {
                string = "type=2&mesh=" + string4 + this.getMapParams();
                break;
            }
            case 0: {
                string = "type=20&mesh=" + string4 + this.getMapParams();
                break;
            }
            case 1: {
                string = "type=11&mesh=" + string4 + this.getMapParams();
                break;
            }
            case 7: {
                string = "type=1&mesh=" + string4 + this.getMapParams();
                break;
            }
            case 8: {
                string = "type=4&mesh=" + string4 + this.getMapParams();
                break;
            }
            case 9: {
                string = "type=40&mesh=" + string4 + this.getMapParams();
                break;
            }
            case 2: {
                string = "t=BMPBM&mesh=" + string4;
                break;
            }
            case 3: {
                string = "mesh=" + string4 + this.getMapParams();
                break;
            }
            case 4: {
                string = "v=6.0.0&bver=2&mesh=" + string4 + "&diu=" + cx.a(o.a);
                break;
            }
            case 6: {
                string = "t=VMMV3&type=mod&cp=0&mid=" + string4;
                break;
            }
        }
        string = string + "&channel=amapapi";
        return string;
    }

    protected boolean processReceivedDataHeader() {
        try {
            if (this.mReceivedDataSize > 7) {
                int n2 = 0;
                int n3 = GLConvertUtil.getInt(this.mReceivedDataBuffer, n2);
                if (n3 != 0) {
                    this.doCancel();
                    return false;
                }
                n2 += 4;
                this.mReceivedDataSize -= (n2 += 4);
                if (this.mReceivedDataSize > 0) {
                    GLConvertUtil.moveArray(this.mReceivedDataBuffer, n2, this.mReceivedDataBuffer, 0, this.mReceivedDataSize);
                }
                this.mNextImgDataLength = 0;
                this.isReceivedHeader = true;
                if (this.mDataSource == 0 || this.mDataSource == 1 || this.mDataSource == 8 || this.mDataSource == 7 || this.mDataSource == 15) {
                    super.processReceivedDataV4();
                } else {
                    super.processReceivedData();
                }
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    protected void processReceivedDataByType() {
        try {
            if (this.mDataSource == 0 || this.mDataSource == 1 || this.mDataSource == 8 || this.mDataSource == 7 || this.mDataSource == 15) {
                super.processReceivedDataV4();
            } else {
                super.processReceivedData();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void processReceivedVersion() {
        try {
            if (this.mDataSource == 9) {
                super.processReceivedVersionData(this.mReceivedDataBuffer, 0, this.mReceivedDataSize);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isRequestValid() {
        return this.mGLMapEngine.isGridsInScreen(this.mEngineID, this.mMapTiles, this.mDataSource);
    }

    protected boolean isNeedReturn() {
        return this.mDataSource == 9;
    }

    protected void processReceivedTileData(byte[] byArray, int n2, int n3) {
        try {
            if (0 == n2) {
                super.processReceivedTileData(byArray, n2, n3);
            } else if (this.mDataSource == 2 || this.mDataSource == 3) {
                this.processReceivedTileDataBmp(byArray, n2, n3);
            } else if (this.mDataSource == 4) {
                this.processReceivedTileDataVTmc(byArray, n2, n3);
            } else if (this.mDataSource == 6) {
                this.processReceivedModels(byArray, n2, n3);
            } else {
                super.processReceivedTileData(byArray, n2, n3);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void processReceivedTileDataBmp(byte[] byArray, int n2, int n3) {
        try {
            int n4 = n2;
            n2 += 4;
            byte by2 = byArray[n2++];
            String string = "";
            if (by2 > 0 && n2 + by2 - 1 < n3) {
                string = new String(byArray, n2, (int)by2, "utf-8");
            }
            n2 += by2;
            if (!this.mGLMapEngine.isMapEngineValid() || n3 <= n4) {
                return;
            }
            if (this.mGLMapEngine.putMapData(this.mEngineID, byArray, n4, n3 - n4, this.mDataSource, 0)) {
                // empty if block
            }
            int n5 = this.mGLMapEngine.GetCurrentGrideNameLen(this.mEngineID);
            boolean bl2 = true;
            if (n5 >= string.length()) {
                boolean bl3 = bl2 = !this.mGLMapEngine.isGridsInScreen(this.mEngineID, this.mMapTiles, this.mDataSource);
            }
            if (bl2) {
                super.doCancel();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void processReceivedTileDataVTmc(byte[] byArray, int n2, int n3) {
        try {
            int n4 = n2;
            n2 += 4;
            byte by2 = byArray[n2++];
            if (n2 + by2 > byArray.length || n2 > byArray.length - 1 || by2 < 0) {
                return;
            }
            String string = new String(byArray, n2, (int)by2, "utf-8");
            n2 += by2;
            byte by3 = byArray[n2++];
            n2 += by3;
            n2 += 4;
            if (!this.mGLMapEngine.isMapEngineValid() || n3 <= n4) {
                return;
            }
            byte[] byArray2 = new byte[n3 - n4];
            System.arraycopy(byArray, n4, byArray2, 0, n3 - n4);
            this.mGLMapEngine.putMapTMCData(this.mEngineID, this.mDataSource, byArray2, string, false);
            int n5 = this.mGLMapEngine.GetCurrentGrideNameLen(this.mEngineID);
            boolean bl2 = true;
            if (n5 >= string.length()) {
                boolean bl3 = bl2 = !this.mGLMapEngine.isGridsInScreen(this.mEngineID, this.mMapTiles, this.mDataSource);
            }
            if (bl2) {
                super.doCancel();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void processReceivedModels(byte[] byArray, int n2, int n3) {
        try {
            int n4 = n2;
            byte by2 = byArray[n2++];
            if (by2 < 0) {
                return;
            }
            String string = new String(byArray, n2, (int)by2, "utf-8");
            if (!this.mGLMapEngine.isMapEngineValid() || n3 <= n4) {
                return;
            }
            this.mGLMapEngine.putMapData(this.mEngineID, byArray, n4, n3 - n4, this.mDataSource, 0);
            int n5 = this.mGLMapEngine.GetCurrentGrideNameLen(this.mEngineID);
            boolean bl2 = true;
            if (n5 >= string.length()) {
                boolean bl3 = bl2 = !this.mGLMapEngine.isGridsInScreen(this.mEngineID, this.mMapTiles, this.mDataSource);
            }
            if (bl2) {
                super.doCancel();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setMapParams(int n2, int n3, int n4) {
        this.mMapLevel = n2;
        this.mMapMode = n3;
        this.mMapModeState = n4;
    }

    public String getMapParams() {
        return "&zoom=" + this.mMapLevel + "&mode=" + this.mMapMode + "&state=" + this.mMapModeState;
    }
}

