/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.maploader;

import com.autonavi.ae.gmap.maploader.VMapDataRecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VMapDataCache {
    private static final int MAXSIZE = 400;
    private Map<String, VMapDataRecoder> mMapDataHs = new HashMap<String, VMapDataRecoder>();
    private List<String> mMapDataList = new ArrayList<String>();
    private Map<String, VMapDataRecoder> mCancelMapDataHs = new HashMap<String, VMapDataRecoder>();
    private List<String> mCancelMapDataList = new ArrayList<String>();
    private static VMapDataCache mMapDataCacheInstance;

    public static VMapDataCache getInstance() {
        if (mMapDataCacheInstance == null) {
            mMapDataCacheInstance = new VMapDataCache();
        }
        return mMapDataCacheInstance;
    }

    public synchronized void reset() {
        this.mMapDataHs.clear();
        this.mMapDataList.clear();
        this.mCancelMapDataHs.clear();
        this.mCancelMapDataList.clear();
    }

    public int getSize() {
        return this.mMapDataHs.size();
    }

    private String getKey(String string, int n2) {
        return string + "-" + n2;
    }

    public synchronized VMapDataRecoder getRecoder(String string, int n2) {
        VMapDataRecoder vMapDataRecoder = this.mMapDataHs.get(this.getKey(string, n2));
        if (vMapDataRecoder != null) {
            ++vMapDataRecoder.mTimes;
        }
        return vMapDataRecoder;
    }

    public synchronized VMapDataRecoder getCancelRecoder(String string, int n2) {
        VMapDataRecoder vMapDataRecoder = this.mCancelMapDataHs.get(this.getKey(string, n2));
        if (vMapDataRecoder != null && System.currentTimeMillis() / 1000L - (long)vMapDataRecoder.mCreateTime > 10L) {
            return null;
        }
        return vMapDataRecoder;
    }

    public synchronized VMapDataRecoder putRecoder(byte[] byArray, String string, int n2) {
        VMapDataRecoder vMapDataRecoder = new VMapDataRecoder(string, n2);
        if (vMapDataRecoder.mGridName == null) {
            return null;
        }
        if (this.mMapDataHs.size() > 400) {
            this.mMapDataHs.remove(this.mMapDataList.get(0));
            this.mMapDataList.remove(0);
        }
        this.mMapDataHs.put(this.getKey(string, n2), vMapDataRecoder);
        this.mMapDataList.add(this.getKey(string, n2));
        return vMapDataRecoder;
    }

    public synchronized VMapDataRecoder putCancelRecoder(byte[] byArray, String string, int n2) {
        if (this.getRecoder(string, n2) != null) {
            return null;
        }
        VMapDataRecoder vMapDataRecoder = new VMapDataRecoder(string, n2);
        if (vMapDataRecoder.mGridName == null) {
            return null;
        }
        if (this.mCancelMapDataHs.size() > 400) {
            this.mCancelMapDataHs.remove(this.mMapDataList.get(0));
            this.mCancelMapDataList.remove(0);
        }
        this.mCancelMapDataHs.put(this.getKey(string, n2), vMapDataRecoder);
        this.mCancelMapDataList.add(this.getKey(string, n2));
        return vMapDataRecoder;
    }
}

