/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Environment;
import android.os.storage.StorageManager;
import android.text.TextUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class GLFileUtil {
    public static void copyAssetsFile(Context context, String string, String string2) {
        try {
            File file = new File(string2);
            if (null != file && file.exists()) {
                return;
            }
            InputStream inputStream = context.getAssets().open(string);
            int n2 = inputStream.available();
            if (n2 == 0) {
                return;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[1024];
            int n3 = inputStream.read(byArray);
            while (n3 > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n3);
                n3 = inputStream.read(byArray);
            }
            fileOutputStream.flush();
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Context context, String string, File file) throws Exception {
        file.delete();
        InputStream inputStream = context.getAssets().open(string);
        byte[] byArray = new byte[inputStream.available()];
        try {
            inputStream.read(byArray);
        }
        finally {
            GLFileUtil.closeQuietly(inputStream);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(byArray);
        }
        finally {
            GLFileUtil.closeQuietly(fileOutputStream);
        }
    }

    public static void deleteFile(File file) {
        if (file == null) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (file.isDirectory() && fileArray != null) {
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                GLFileUtil.deleteFile(fileArray[i2]);
            }
        }
        file.delete();
    }

    public static String getCurrentOfflineDataStorage(Context context) {
        String string = "offline_data_storage";
        return context.getSharedPreferences("base_path", 0).getString("offline_data_storage", "");
    }

    public static boolean checkPathIsCanUse(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            File file = new File(string);
            return file.exists() && file.isDirectory() && file.canWrite() && file.canRead();
        }
        return false;
    }

    public static String getMapBaseStorage(Context context) {
        File file;
        SharedPreferences sharedPreferences;
        String string;
        int n2 = Build.VERSION.SDK_INT;
        String string2 = "map_base_path";
        if (n2 > 18) {
            string2 = "map_base_path_v44";
        }
        if ((string = (sharedPreferences = context.getSharedPreferences("base_path", 0)).getString(string2, "")) != null && string.length() > 2 && (file = new File(string)).isDirectory()) {
            if (file.canWrite()) {
                GLFileUtil.createNoMediaFileIfNotExist(string);
                return string;
            }
            string = GLFileUtil.getCacheDir(context).toString();
            if (string != null && string.length() > 2 && (file = new File(string)).isDirectory()) {
                return string;
            }
        }
        if ((string = GLFileUtil.getExternalStroragePath(context)) != null && string.length() > 2 && (file = new File(string)).isDirectory()) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(string2, string);
            if (Build.VERSION.SDK_INT >= 9) {
                editor.apply();
            } else {
                editor.commit();
            }
            GLFileUtil.createNoMediaFileIfNotExist(string);
            return string;
        }
        string = GLFileUtil.getCacheDir(context).toString();
        if (string != null && string.length() > 2 && (file = new File(string)).isDirectory()) {
            return string;
        }
        return string;
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=19)
    public static String getExternalStroragePath(Context context) {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 12) {
            try {
                StorageManager storageManager = (StorageManager)context.getSystemService("storage");
                Method method = StorageManager.class.getMethod("getVolumeList", new Class[0]);
                Method method2 = StorageManager.class.getMethod("getVolumeState", String.class);
                Object[] objectArray = (Object[])method.invoke((Object)storageManager, new Object[0]);
                String string = null;
                String string2 = null;
                Boolean bl2 = false;
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = null;
                for (Object object : objectArray) {
                    Method method3 = object.getClass().getMethod("getPath", new Class[0]);
                    Method method4 = object.getClass().getMethod("isRemovable", new Class[0]);
                    string2 = (String)method3.invoke(object, new Object[0]);
                    string = (String)method2.invoke((Object)storageManager, method3.invoke(object, new Object[0]));
                    bl2 = (Boolean)method4.invoke(object, new Object[0]);
                    if (string2.toLowerCase(Locale.US).contains("private")) continue;
                    if (bl2.booleanValue()) {
                        string3 = string2;
                        string5 = string;
                        if (null == string3 || null == string5 || !string5.equals("mounted")) continue;
                        if (n2 <= 18) {
                            string7 = string3;
                            break;
                        }
                        try {
                            string7 = string2;
                            File[] fileArray = context.getExternalFilesDirs(null);
                            if (fileArray == null || fileArray.length <= 0) break;
                            for (File file : fileArray) {
                                String string8;
                                if (null == file || TextUtils.isEmpty((CharSequence)(string8 = file.getAbsolutePath())) || !string8.contains(string2)) continue;
                                string7 = string8;
                            }
                            break;
                        }
                        catch (Throwable throwable) {
                            string7 = string3;
                            break;
                        }
                    }
                    string4 = string2;
                    string6 = string;
                }
                if (n2 <= 18) {
                    if (null == string7 && null != string4 && null != string6 && string6.equals("mounted")) {
                        string7 = string4;
                    }
                    return string7;
                }
                if (null != string4 && null != string6 && string6.equals("mounted")) {
                    string7 = string4;
                }
                return string7;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        File file = null;
        boolean bl3 = Environment.getExternalStorageState().equals("mounted");
        if (bl3) {
            file = Environment.getExternalStorageDirectory();
            return file.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void writeDatasToFile(String string, byte[] byArray) {
        block8: {
            FileOutputStream fileOutputStream;
            ReentrantReadWriteLock.WriteLock writeLock;
            block7: {
                ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
                writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                fileOutputStream = null;
                if (byArray != null && byArray.length != 0) break block7;
                writeLock.unlock();
                GLFileUtil.closeQuietly(fileOutputStream);
                return;
            }
            try {
                File file = new File(string);
                File file2 = file.getParentFile();
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                fileOutputStream = new FileOutputStream(file);
                ((OutputStream)fileOutputStream).write(byArray);
                fileOutputStream.flush();
                writeLock.unlock();
            }
            catch (Exception exception) {
                writeLock.unlock();
                GLFileUtil.closeQuietly(fileOutputStream);
                break block8;
                catch (Throwable throwable) {
                    writeLock.unlock();
                    GLFileUtil.closeQuietly(fileOutputStream);
                    throw throwable;
                }
            }
            GLFileUtil.closeQuietly(fileOutputStream);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileContents(String string) {
        block6: {
            byte[] byArray;
            File file;
            FileInputStream fileInputStream;
            block5: {
                fileInputStream = null;
                file = new File(string);
                if (file.exists()) break block5;
                byte[] byArray2 = null;
                GLFileUtil.closeQuietly(fileInputStream);
                return byArray2;
            }
            try {
                fileInputStream = new FileInputStream(file);
                byte[] byArray3 = new byte[1024];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n2 = 0;
                while ((n2 = fileInputStream.read(byArray3)) != -1) {
                    byteArrayOutputStream.write(byArray3, 0, n2);
                }
                byteArrayOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                GLFileUtil.closeQuietly(fileInputStream);
                break block6;
            }
            catch (Throwable throwable) {
                GLFileUtil.closeQuietly(fileInputStream);
                throw throwable;
            }
            GLFileUtil.closeQuietly(fileInputStream);
            return byArray;
        }
        return null;
    }

    public static void createNoMediaFileIfNotExist(String string) {
        try {
            long l2;
            long l3;
            String string2 = string;
            File file = new File(string2 + "/autonavi/.nomedia");
            if (!file.exists()) {
                file.createNewFile();
            }
            if ((l3 = file.lastModified()) > (l2 = 0L)) {
                file.setLastModified(l2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String getAppSDCardFileDir() {
        File file;
        File file2 = null;
        boolean bl2 = Environment.getExternalStorageState().equals("mounted");
        if (bl2 && !(file2 = new File(file = Environment.getExternalStorageDirectory(), "autonavi")).exists()) {
            file2.mkdir();
        }
        if (file2 == null) {
            return null;
        }
        return file2.toString();
    }

    public static File getCacheDir(Context context) {
        File file = context.getCacheDir();
        if (file == null) {
            file = context.getDir("cache", 0);
        }
        if (file == null) {
            file = new File("/data/data/" + context.getPackageName() + "/app_cache");
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static File getFilesDir(Context context) {
        File file = context.getFilesDir();
        if (file == null) {
            file = context.getDir("files", 0);
        }
        if (file == null) {
            file = new File("/data/data/" + context.getPackageName() + "/app_files");
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }
}

