/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import com.autonavi.ae.utils.NaviUtils;
import com.autonavi.amap.mapcore.FileUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

@SuppressLint(value={"NewApi"})
public class AEUtil {
    public static final boolean IS_AE = true;
    private static final String TAG;
    public static final String CONFIGNAME = "GNaviConfig.xml";
    public static final String RESZIPNAME = "res.zip";
    private static String currentPath;
    private static final int BUFFER = 1024;

    public static void init(Context context) {
        File file;
        currentPath = FileUtil.getMapBaseStorage(context);
        File file2 = new File(currentPath);
        if (!file2.exists()) {
            file2.mkdir();
        }
        if ((file = new File(currentPath, CONFIGNAME)).exists() && file.isFile() && file.length() > 0L) {
            int n2 = NaviUtils.nativeSetConfigFile(currentPath, currentPath + CONFIGNAME);
        } else {
            byte[] byArray = AEUtil.readAssetsFile("ae/GNaviConfig.xml", context);
            if (null != byArray && byArray.length > 0) {
                String string = AEUtil.getString(byArray, "utf-8");
                int n3 = NaviUtils.nativeSetConfigMem(currentPath, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadEngineRes(String string, Context context) {
        boolean bl2;
        File file = new File(string, "res");
        if (file.exists() && file.isDirectory() || file.mkdirs()) {
            // empty if block
        }
        if (!(bl2 = AEUtil.checkEngineRes(file))) {
            InputStream inputStream = null;
            try {
                inputStream = context.getAssets().open("ae/res.zip");
                AEUtil.decompress(inputStream, file.getAbsolutePath());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                outOfMemoryError.printStackTrace();
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
    }

    private static boolean checkEngineRes(File file) {
        try {
            File[] fileArray = file.listFiles();
            return null != fileArray && fileArray.length >= 4;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static String getEngineVersion() {
        return "n/a";
    }

    public static String getNaviRouteVersion() {
        return "n/a";
    }

    public static String getPosVersion() {
        return "n/a";
    }

    public static String getMapVersion() {
        return "n/a";
    }

    private static String getDataVersion() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAssetsFile(String string, Context context) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byte[] byArray;
            int n2;
            inputStream = context.getAssets().open(string);
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n2 = inputStream.read(byArray2, 0, 1024)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
            byte[] byArray3 = byArray = byteArrayOutputStream.toByteArray();
            return byArray3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void createNoMediaFileIfNotExist(String string) {
        try {
            long l2;
            long l3;
            String string2 = string;
            File file = new File(string2 + "/autonavi/.nomedia");
            if (!file.exists()) {
                file.createNewFile();
            }
            if ((l3 = file.lastModified()) > (l2 = 0L)) {
                file.setLastModified(l2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static File getCacheDir(Context context) {
        File file = context.getCacheDir();
        if (file == null) {
            file = context.getDir("cache", 0);
        }
        if (file == null) {
            file = new File("/data/data/" + context.getPackageName() + "/app_cache");
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static String getString(byte[] byArray, String string) {
        if (byArray == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        return AEUtil.getString(byArray, 0, byArray.length, string);
    }

    public static String getString(byte[] byArray, int n2, int n3, String string) {
        if (byArray == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return new String(byArray, n2, n3, string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static void decompress(InputStream inputStream, String string) throws Exception {
        AEUtil.decompress(inputStream, string, 0L, null);
    }

    private static void decompress(InputStream inputStream, String string, long l2, ZipCompressProgressListener zipCompressProgressListener) throws Exception {
        CheckedInputStream checkedInputStream = new CheckedInputStream(inputStream, new CRC32());
        ZipInputStream zipInputStream = new ZipInputStream(checkedInputStream);
        AEUtil.decompress(null, new File(string), zipInputStream, l2, zipCompressProgressListener, null);
        zipInputStream.close();
        checkedInputStream.close();
    }

    private static void decompress(File file, File file2, ZipInputStream zipInputStream, long l2, ZipCompressProgressListener zipCompressProgressListener, UnZipFileBrake unZipFileBrake) throws Exception {
        ZipEntry zipEntry = null;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (unZipFileBrake != null && unZipFileBrake.mIsAborted) {
                zipInputStream.closeEntry();
                return;
            }
            String string = zipEntry.getName();
            if (TextUtils.isEmpty((CharSequence)string) || string.contains("../")) {
                bl2 = true;
                break;
            }
            String string2 = file2.getPath() + File.separator + string;
            File file3 = new File(string2);
            AEUtil.fileProber(file3);
            if (zipEntry.isDirectory()) {
                file3.mkdirs();
            } else {
                n3 = AEUtil.decompressFile(file3, zipInputStream, n2, l2, zipCompressProgressListener, unZipFileBrake);
                n2 += n3;
            }
            zipInputStream.closeEntry();
        }
        if (bl2) {
            try {
                if (null != file) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void fileProber(File file) {
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            AEUtil.fileProber(file2);
            file2.mkdir();
        }
    }

    private static int decompressFile(File file, ZipInputStream zipInputStream, long l2, long l3, ZipCompressProgressListener zipCompressProgressListener, UnZipFileBrake unZipFileBrake) throws Exception {
        int n2;
        int n3 = 0;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        byte[] byArray = new byte[1024];
        while ((n2 = zipInputStream.read(byArray, 0, 1024)) != -1) {
            if (unZipFileBrake != null && unZipFileBrake.mIsAborted) {
                bufferedOutputStream.close();
                return n3;
            }
            bufferedOutputStream.write(byArray, 0, n2);
            n3 += n2;
            if (l3 <= 0L || zipCompressProgressListener == null) continue;
            long l4 = (l2 + (long)n3) * 100L / l3;
            if (unZipFileBrake != null && unZipFileBrake.mIsAborted) continue;
            zipCompressProgressListener.onFinishProgress(l4);
        }
        bufferedOutputStream.close();
        return n3;
    }

    static {
        System.loadLibrary("GNaviUtils");
        System.loadLibrary("GNaviData");
        System.loadLibrary("GNaviSearch");
        System.loadLibrary("RoadLineRebuildAPI");
        System.loadLibrary("GNaviMap");
        System.loadLibrary("GNaviMapex");
        TAG = AEUtil.class.getSimpleName();
        currentPath = null;
    }

    public static class UnZipFileBrake {
        public boolean mIsAborted = false;
    }

    public static interface ZipCompressProgressListener {
        public void onFinishProgress(long var1);
    }
}

