/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import android.graphics.Point;
import com.autonavi.amap.mapcore.DPoint;

public class VirtualEarthProjection {
    public static final int MAXZOOMLEVEL = 20;
    public static final int PixelsPerTile = 256;
    public static final double MinLatitude = -85.0511287798;
    public static final double MaxLatitude = 85.0511287798;
    public static final double MinLongitude = -180.0;
    public static final double MaxLongitude = 180.0;
    public static final int EarthRadiusInMeters = 6378137;
    public static final int TileSplitLevel = 0;
    public static final double EarthCircumferenceInMeters = 4.007501668557849E7;

    public static double Clip(double d2, double d3, double d4) {
        return Math.min(Math.max(d2, d3), d4);
    }

    public static Point LatLongToPixels(int n2, int n3, int n4) {
        return VirtualEarthProjection.LatLongToPixels((double)n3 / 3600000.0, (double)n2 / 3600000.0, n4);
    }

    public static Point LatLongToPixels(double d2, double d3, int n2) {
        Point point = new Point();
        d2 = VirtualEarthProjection.Clip(d2, -85.0511287798, 85.0511287798) * Math.PI / 180.0;
        d3 = VirtualEarthProjection.Clip(d3, -180.0, 180.0) * Math.PI / 180.0;
        double d4 = Math.sin(d2);
        double d5 = 6378137.0 * d3;
        double d6 = Math.log((1.0 + d4) / (1.0 - d4));
        double d7 = 3189068.0 * d6;
        long l2 = 256L << n2;
        double d8 = 4.007501668557849E7 / (double)l2;
        point.x = (int)VirtualEarthProjection.Clip((2.0037508342789244E7 + d5) / d8 + 0.5, 0.0, l2 - 1L);
        long l3 = (long)(2.0037508342789244E7 - d7);
        point.y = (int)VirtualEarthProjection.Clip((double)l3 / d8 + 0.5, 0.0, l2 - 1L);
        return point;
    }

    public static DPoint PixelsToLatLong(long l2, long l3, int n2) {
        DPoint dPoint = new DPoint();
        double d2 = 4.007501668557849E7 / (double)((1 << n2) * 256);
        double d3 = (double)l2 * d2 - 2.0037508342789244E7;
        double d4 = 2.0037508342789244E7 - (double)l3 * d2;
        dPoint.y = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-d4 / 6378137.0));
        dPoint.y *= 57.29577951308232;
        dPoint.x = d3 / 6378137.0;
        dPoint.x *= 57.29577951308232;
        return dPoint;
    }
}

