/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.directorywalker;

import com.thoughtworks.qdox.directorywalker.FileVisitor;
import com.thoughtworks.qdox.directorywalker.Filter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class DirectoryScanner {
    private File file;
    private Collection filters = new HashSet();

    public DirectoryScanner(File file) {
        this.file = file;
    }

    public File[] scan() {
        final ArrayList results = new ArrayList();
        this.walk(new FileVisitor(){

            public void visitFile(File file) {
                results.add(file);
            }
        }, this.file);
        File[] resultsArray = new File[results.size()];
        results.toArray(resultsArray);
        return resultsArray;
    }

    private void walk(FileVisitor visitor, File current) {
        if (current.isDirectory()) {
            File[] currentFiles = current.listFiles();
            for (int i2 = 0; i2 < currentFiles.length; ++i2) {
                this.walk(visitor, currentFiles[i2]);
            }
        } else {
            Iterator iterator = this.filters.iterator();
            while (iterator.hasNext()) {
                Filter filter = (Filter)iterator.next();
                if (filter.filter(current)) continue;
                return;
            }
            visitor.visitFile(current);
        }
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void scan(FileVisitor fileVisitor) {
        this.walk(fileVisitor, this.file);
    }
}

