/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.JavaClassContext;
import com.thoughtworks.qdox.model.AbstractInheritableJavaEntity;
import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.IndentBuffer;
import com.thoughtworks.qdox.model.JavaClassParent;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaMethodDelegate;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.model.TypeVariable;
import com.thoughtworks.qdox.model.util.OrderedMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaClass
extends AbstractInheritableJavaEntity
implements JavaClassParent {
    private static Type OBJECT = new Type("java.lang.Object");
    private static Type ENUM = new Type("java.lang.Enum");
    private static Type ANNOTATION = new Type("java.lang.annotation.Annotation");
    private List methods = new LinkedList();
    private JavaMethod[] methodsArray;
    private List fields = new LinkedList();
    private JavaField[] fieldsArray;
    private List classes = new LinkedList();
    private JavaClass[] classesArray;
    private boolean interfce;
    private boolean isEnum;
    private boolean isAnnotation;
    private Type type;
    private Type superClass;
    private Type[] implementz = new Type[0];
    private TypeVariable[] typeParameters = TypeVariable.EMPTY_ARRAY;
    private JavaClassContext context;
    private JavaPackage javaPackage;
    private JavaSource source;

    public JavaClass() {
    }

    public JavaClass(String name) {
        this.setName(name);
    }

    public void setJavaClassContext(JavaClassContext context) {
        this.context = context;
        OBJECT = context.getClassByName("java.lang.Object").asType();
    }

    public boolean isInterface() {
        return this.interfce;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public Type getSuperClass() {
        boolean iAmJavaLangObject = OBJECT.equals(this.asType());
        if (this.isEnum) {
            return ENUM;
        }
        if (!(this.interfce || this.isAnnotation || this.superClass != null || iAmJavaLangObject)) {
            return OBJECT;
        }
        return this.superClass;
    }

    public JavaClass getSuperJavaClass() {
        if (this.getSuperClass() != null) {
            return this.getSuperClass().getJavaClass();
        }
        return null;
    }

    public Type[] getImplements() {
        return this.implementz;
    }

    public JavaClass[] getImplementedInterfaces() {
        Type[] type = this.getImplements();
        JavaClass[] result = new JavaClass[type.length];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = type[i2].getJavaClass();
        }
        return result;
    }

    protected void writeBody(IndentBuffer result) {
        this.writeAccessibilityModifier(result);
        this.writeNonAccessibilityModifiers(result);
        result.write(this.isEnum ? "enum " : (this.interfce ? "interface " : (this.isAnnotation ? "@interface " : "class ")));
        result.write(this.name);
        if (this.superClass != null) {
            result.write(" extends ");
            result.write(this.superClass.getValue());
        }
        if (this.implementz.length > 0) {
            result.write(this.interfce ? " extends " : " implements ");
            for (int i2 = 0; i2 < this.implementz.length; ++i2) {
                if (i2 > 0) {
                    result.write(", ");
                }
                result.write(this.implementz[i2].getValue());
            }
        }
        result.write(" {");
        result.newline();
        result.indent();
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            JavaField javaField = (JavaField)iterator.next();
            result.newline();
            javaField.write(result);
        }
        iterator = this.methods.iterator();
        while (iterator.hasNext()) {
            JavaMethod javaMethod = (JavaMethod)iterator.next();
            result.newline();
            javaMethod.write(result);
        }
        iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            result.newline();
            javaClass.write(result);
        }
        result.deindent();
        result.newline();
        result.write('}');
        result.newline();
    }

    public void setInterface(boolean interfce) {
        this.interfce = interfce;
    }

    public void setEnum(boolean isEnum) {
        this.isEnum = isEnum;
    }

    public void setAnnotation(boolean isAnnotation) {
        this.isAnnotation = isAnnotation;
    }

    public void addMethod(JavaMethod meth) {
        meth.setParentClass(this);
        this.methods.add(meth);
        this.methodsArray = null;
    }

    public void setSuperClass(Type type) {
        if (this.isEnum) {
            throw new IllegalArgumentException("enums cannot extend other classes");
        }
        this.superClass = type;
    }

    public void setImplementz(Type[] implementz) {
        this.implementz = implementz;
    }

    public TypeVariable[] getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(TypeVariable[] typeParameters) {
        this.typeParameters = typeParameters;
    }

    public void addField(JavaField javaField) {
        javaField.setParentClass(this);
        this.fields.add(javaField);
        this.fieldsArray = null;
    }

    public void setJavaPackage(JavaPackage javaPackage) {
        this.javaPackage = javaPackage;
    }

    public void setSource(JavaSource source) {
        this.source = source;
    }

    public JavaSource getParentSource() {
        return this.getParentClass() != null ? this.getParentClass().getParentSource() : this.source;
    }

    public JavaSource getSource() {
        return this.getParentSource();
    }

    public JavaPackage getPackage() {
        return this.getParentSource() != null ? this.getParentSource().getPackage() : this.javaPackage;
    }

    public JavaClassParent getParent() {
        JavaClassParent result = this.getParentClass();
        if (result == null) {
            result = this.getParentSource();
        }
        return result;
    }

    public String getPackageName() {
        JavaPackage javaPackage = this.getPackage();
        return javaPackage != null && javaPackage.getName() != null ? javaPackage.getName() : "";
    }

    public String getFullyQualifiedName() {
        return (this.getParentClass() != null ? this.getParentClass().getClassNamePrefix() : (this.getPackage() != null ? this.getPackage().getName() + "." : "")) + this.getName();
    }

    public boolean isInner() {
        return this.getParentClass() != null;
    }

    public String resolveType(String typeName) {
        JavaClass[] innerClasses = this.getNestedClasses();
        for (int i2 = 0; i2 < innerClasses.length; ++i2) {
            if (!innerClasses[i2].getName().equals(typeName)) continue;
            return innerClasses[i2].getFullyQualifiedName();
        }
        return this.getParent().resolveType(typeName);
    }

    public JavaClassContext getJavaClassContext() {
        return this.getParent().getJavaClassContext();
    }

    public String getClassNamePrefix() {
        return this.getFullyQualifiedName() + "$";
    }

    public Type asType() {
        if (this.type == null) {
            this.type = new Type(this.getFullyQualifiedName(), 0, this);
        }
        return this.type;
    }

    public JavaMethod[] getMethods() {
        if (this.methodsArray == null) {
            this.methodsArray = new JavaMethod[this.methods.size()];
            this.methods.toArray(this.methodsArray);
        }
        return this.methodsArray;
    }

    public JavaMethod[] getMethods(boolean superclasses) {
        if (superclasses) {
            HashSet signatures = new HashSet();
            ArrayList methods = new ArrayList();
            this.addMethodsFromSuperclassAndInterfaces(signatures, methods, this);
            return methods.toArray(new JavaMethod[methods.size()]);
        }
        return this.getMethods();
    }

    private void addMethodsFromSuperclassAndInterfaces(Set signatures, List methodList, JavaClass callingClazz) {
        JavaMethod[] methods = callingClazz.getMethods();
        this.addNewMethods(signatures, methodList, methods);
        JavaClass superclass = callingClazz.getSuperJavaClass();
        if (superclass != null && superclass != callingClazz) {
            callingClazz.addMethodsFromSuperclassAndInterfaces(signatures, methodList, superclass);
        }
        JavaClass[] implementz = callingClazz.getImplementedInterfaces();
        for (int i2 = 0; i2 < implementz.length; ++i2) {
            if (implementz[i2] == null) continue;
            callingClazz.addMethodsFromSuperclassAndInterfaces(signatures, methodList, implementz[i2]);
        }
    }

    private void addNewMethods(Set signatures, List methodList, JavaMethod[] methods) {
        for (int i2 = 0; i2 < methods.length; ++i2) {
            String signature;
            JavaMethod method = methods[i2];
            if (method.isPrivate() || signatures.contains(signature = method.getDeclarationSignature(false))) continue;
            methodList.add(new JavaMethodDelegate(this, method));
            signatures.add(signature);
        }
    }

    public JavaMethod getMethodBySignature(String name, Type[] parameterTypes) {
        return this.getMethod(name, parameterTypes, false);
    }

    public JavaMethod getMethod(String name, Type[] parameterTypes, boolean varArgs) {
        JavaMethod[] methods = this.getMethods();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            if (!methods[i2].signatureMatches(name, parameterTypes, varArgs)) continue;
            return methods[i2];
        }
        return null;
    }

    public JavaMethod getMethodBySignature(String name, Type[] parameterTypes, boolean superclasses) {
        return this.getMethodBySignature(name, parameterTypes, superclasses, false);
    }

    public JavaMethod getMethodBySignature(String name, Type[] parameterTypes, boolean superclasses, boolean varArg) {
        JavaMethod[] result = this.getMethodsBySignature(name, parameterTypes, superclasses, varArg);
        return result.length > 0 ? result[0] : null;
    }

    public JavaMethod[] getMethodsBySignature(String name, Type[] parameterTypes, boolean superclasses) {
        return this.getMethodsBySignature(name, parameterTypes, superclasses, false);
    }

    public JavaMethod[] getMethodsBySignature(String name, Type[] parameterTypes, boolean superclasses, boolean varArg) {
        ArrayList<JavaMethod> result = new ArrayList<JavaMethod>();
        JavaMethod methodInThisClass = this.getMethod(name, parameterTypes, varArg);
        if (methodInThisClass != null) {
            result.add(methodInThisClass);
        }
        if (superclasses) {
            JavaMethod method;
            JavaClass superclass = this.getSuperJavaClass();
            if (superclass != null && (method = superclass.getMethodBySignature(name, parameterTypes, true, varArg)) != null && !method.isPrivate()) {
                result.add(new JavaMethodDelegate(this, method));
            }
            JavaClass[] implementz = this.getImplementedInterfaces();
            for (int i2 = 0; i2 < implementz.length; ++i2) {
                JavaMethod method2 = implementz[i2].getMethodBySignature(name, parameterTypes, true, varArg);
                if (method2 == null) continue;
                result.add(new JavaMethodDelegate(this, method2));
            }
        }
        return result.toArray(new JavaMethod[result.size()]);
    }

    public JavaField[] getFields() {
        if (this.fieldsArray == null) {
            this.fieldsArray = new JavaField[this.fields.size()];
            this.fields.toArray(this.fieldsArray);
        }
        return this.fieldsArray;
    }

    public JavaField getFieldByName(String name) {
        JavaField[] fields = this.getFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            if (!fields[i2].getName().equals(name)) continue;
            return fields[i2];
        }
        return null;
    }

    public void addClass(JavaClass cls) {
        cls.setParentClass(this);
        this.classes.add(cls);
        this.classesArray = null;
    }

    public JavaClass[] getClasses() {
        return this.getNestedClasses();
    }

    public JavaClass[] getNestedClasses() {
        if (this.classesArray == null) {
            this.classesArray = new JavaClass[this.classes.size()];
            this.classes.toArray(this.classesArray);
        }
        return this.classesArray;
    }

    public JavaClass getNestedClassByName(String name) {
        JavaClass[] classes = this.getNestedClasses();
        int separatorIndex = name.indexOf(46);
        String directInnerClassName = separatorIndex > 0 ? name.substring(0, separatorIndex) : name;
        for (int i2 = 0; i2 < classes.length; ++i2) {
            JavaClass jClass = classes[i2];
            if (!jClass.getName().equals(directInnerClassName)) continue;
            if (separatorIndex > 0) {
                return jClass.getNestedClassByName(name.substring(separatorIndex + 1));
            }
            return jClass;
        }
        return null;
    }

    public JavaClass[] getInnerClasses() {
        return this.getNestedClasses();
    }

    public JavaClass getInnerClassByName(String name) {
        return this.getNestedClassByName(name);
    }

    public boolean isA(String fullClassName) {
        Type type = new Type(fullClassName, 0, this);
        return this.asType().isA(type);
    }

    public boolean isA(JavaClass javaClass) {
        return this.asType().isA(javaClass.asType());
    }

    public BeanProperty[] getBeanProperties() {
        return this.getBeanProperties(false);
    }

    public BeanProperty[] getBeanProperties(boolean superclasses) {
        Map beanPropertyMap = this.getBeanPropertyMap(superclasses);
        Collection beanPropertyCollection = beanPropertyMap.values();
        return beanPropertyCollection.toArray(new BeanProperty[beanPropertyCollection.size()]);
    }

    private Map getBeanPropertyMap(boolean superclasses) {
        JavaMethod[] methods = this.getMethods(superclasses);
        OrderedMap beanPropertyMap = new OrderedMap();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            BeanProperty beanProperty;
            String propertyName;
            JavaMethod method = methods[i2];
            if (method.isPropertyAccessor()) {
                propertyName = method.getPropertyName();
                beanProperty = this.getOrCreateProperty(beanPropertyMap, propertyName);
                beanProperty.setAccessor(method);
                beanProperty.setType(method.getPropertyType());
                continue;
            }
            if (!method.isPropertyMutator()) continue;
            propertyName = method.getPropertyName();
            beanProperty = this.getOrCreateProperty(beanPropertyMap, propertyName);
            beanProperty.setMutator(method);
            beanProperty.setType(method.getPropertyType());
        }
        return beanPropertyMap;
    }

    private BeanProperty getOrCreateProperty(Map beanPropertyMap, String propertyName) {
        BeanProperty result = (BeanProperty)beanPropertyMap.get(propertyName);
        if (result == null) {
            result = new BeanProperty(propertyName);
            beanPropertyMap.put(propertyName, result);
        }
        return result;
    }

    public BeanProperty getBeanProperty(String propertyName) {
        return this.getBeanProperty(propertyName, false);
    }

    public BeanProperty getBeanProperty(String propertyName, boolean superclasses) {
        return (BeanProperty)this.getBeanPropertyMap(superclasses).get(propertyName);
    }

    public JavaClass[] getDerivedClasses() {
        ArrayList<JavaClass> result = new ArrayList<JavaClass>();
        JavaClass[] classes = this.context.getClasses();
        for (int i2 = 0; i2 < classes.length; ++i2) {
            JavaClass clazz = classes[i2];
            if (!clazz.isA(this) || clazz == this) continue;
            result.add(clazz);
        }
        return result.toArray(new JavaClass[result.size()]);
    }

    public DocletTag[] getTagsByName(String name, boolean superclasses) {
        ArrayList result = new ArrayList();
        this.addTagsRecursive(result, this, name, superclasses);
        return result.toArray(new DocletTag[result.size()]);
    }

    private void addTagsRecursive(List result, JavaClass javaClass, String name, boolean superclasses) {
        DocletTag[] tags = javaClass.getTagsByName(name);
        this.addNewTags(result, tags);
        if (superclasses) {
            JavaClass superclass = javaClass.getSuperJavaClass();
            if (superclass != null && superclass != javaClass) {
                this.addTagsRecursive(result, superclass, name, superclasses);
            }
            JavaClass[] implementz = javaClass.getImplementedInterfaces();
            for (int h = 0; h < implementz.length; ++h) {
                if (implementz[h] == null) continue;
                this.addTagsRecursive(result, implementz[h], name, superclasses);
            }
        }
    }

    private void addNewTags(List list, DocletTag[] tags) {
        for (int i2 = 0; i2 < tags.length; ++i2) {
            DocletTag superTag = tags[i2];
            if (list.contains(superTag)) continue;
            list.add(superTag);
        }
    }

    public int compareTo(Object o) {
        return this.getFullyQualifiedName().compareTo(((JavaClass)o).getFullyQualifiedName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.asType().isPrimitive() || Type.VOID.equals(this.asType())) {
            sb.append(this.asType().getValue());
        } else {
            sb.append(this.isInterface() ? "interface" : "class");
            sb.append(" ");
            sb.append(this.getFullyQualifiedName());
        }
        return sb.toString();
    }
}

