/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.collections.Lists;
import org.testng.internal.EclipseInterface;

public class Assert {
    public static final String ARRAY_MISMATCH_TEMPLATE = "arrays differ firstly at element [%d]; expected value is <%s> but was <%s>. %s";

    protected Assert() {
    }

    public static void assertTrue(boolean bl, String string) {
        if (!bl) {
            Assert.failNotEquals(bl, Boolean.TRUE, string);
        }
    }

    public static void assertTrue(boolean bl) {
        Assert.assertTrue(bl, null);
    }

    public static void assertFalse(boolean bl, String string) {
        if (bl) {
            Assert.failNotEquals(bl, Boolean.FALSE, string);
        }
    }

    public static void assertFalse(boolean bl) {
        Assert.assertFalse(bl, null);
    }

    public static void fail(String string, Throwable throwable) {
        AssertionError assertionError = new AssertionError((Object)string);
        ((Throwable)((Object)assertionError)).initCause(throwable);
        throw assertionError;
    }

    public static void fail(String string) {
        throw new AssertionError((Object)string);
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void assertEquals(Object object, Object object2, String string) {
        if (object2 != null && object2.getClass().isArray()) {
            Assert.assertArrayEquals(object, object2, string);
            return;
        }
        Assert.assertEqualsImpl(object, object2, string);
    }

    private static void assertEqualsImpl(Object object, Object object2, String string) {
        if (object2 == null && object == null) {
            return;
        }
        if (object2 == null ^ object == null) {
            Assert.failNotEquals(object, object2, string);
        }
        if (object2.equals(object) && object.equals(object2)) {
            return;
        }
        Assert.failNotEquals(object, object2, string);
    }

    private static void assertArrayEquals(Object object, Object object2, String string) {
        int n;
        if (object2 == object) {
            return;
        }
        if (null == object2) {
            Assert.fail("expected a null array, but not null found. " + string);
        }
        if (null == object) {
            Assert.fail("expected not null array, but null found. " + string);
        }
        if (!object.getClass().isArray()) {
            Assert.failNotEquals(object, object2, string);
        }
        if ((n = Array.getLength(object2)) != Array.getLength(object)) {
            Assert.failNotEquals(Array.getLength(object), n, string == null ? "" : string + " (Array lengths are not the same)");
        }
        for (int j = 0; j < n; ++j) {
            Object object3 = Array.get(object, j);
            Object object4 = Array.get(object2, j);
            try {
                Assert.assertEquals(object3, object4);
                continue;
            }
            catch (AssertionError assertionError) {
                Assert.failNotEquals(object, object2, string == null ? "" : string + " (values at index " + j + " are not the same)");
            }
        }
    }

    public static void assertEquals(byte[] byArray, byte[] byArray2) {
        Assert.assertEquals(byArray, byArray2, "");
    }

    public static void assertEquals(byte[] byArray, byte[] byArray2, String string) {
        if (Assert.checkRefEqualityAndLength(byArray, byArray2, string)) {
            return;
        }
        for (int j = 0; j < byArray2.length; ++j) {
            if (byArray2[j] == byArray[j]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, j, Byte.toString(byArray2[j]), Byte.toString(byArray[j]), string));
        }
    }

    public static void assertEquals(short[] sArray, short[] sArray2) {
        Assert.assertEquals(sArray, sArray2, "");
    }

    public static void assertEquals(short[] sArray, short[] sArray2, String string) {
        if (Assert.checkRefEqualityAndLength(sArray, sArray2, string)) {
            return;
        }
        for (int j = 0; j < sArray2.length; ++j) {
            if (sArray2[j] == sArray[j]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, j, Short.toString(sArray2[j]), Short.toString(sArray[j]), string));
        }
    }

    public static void assertEquals(int[] nArray, int[] nArray2) {
        Assert.assertEquals(nArray, nArray2, "");
    }

    public static void assertEquals(int[] nArray, int[] nArray2, String string) {
        if (Assert.checkRefEqualityAndLength(nArray, nArray2, string)) {
            return;
        }
        for (int j = 0; j < nArray2.length; ++j) {
            if (nArray2[j] == nArray[j]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, j, Integer.toString(nArray2[j]), Integer.toString(nArray[j]), string));
        }
    }

    public static void assertEquals(boolean[] blArray, boolean[] blArray2) {
        Assert.assertEquals(blArray, blArray2, "");
    }

    public static void assertEquals(boolean[] blArray, boolean[] blArray2, String string) {
        if (Assert.checkRefEqualityAndLength(blArray, blArray2, string)) {
            return;
        }
        for (int j = 0; j < blArray2.length; ++j) {
            if (blArray2[j] == blArray[j]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, j, Boolean.toString(blArray2[j]), Boolean.toString(blArray[j]), string));
        }
    }

    public static void assertEquals(char[] cArray, char[] cArray2) {
        Assert.assertEquals(cArray, cArray2, "");
    }

    public static void assertEquals(char[] cArray, char[] cArray2, String string) {
        if (Assert.checkRefEqualityAndLength(cArray, cArray2, string)) {
            return;
        }
        for (int j = 0; j < cArray2.length; ++j) {
            if (cArray2[j] == cArray[j]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, j, Character.toString(cArray2[j]), Character.toString(cArray[j]), string));
        }
    }

    public static void assertEquals(float[] fArray, float[] fArray2) {
        Assert.assertEquals(fArray, fArray2, "");
    }

    public static void assertEquals(float[] fArray, float[] fArray2, String string) {
        if (Assert.checkRefEqualityAndLength(fArray, fArray2, string)) {
            return;
        }
        for (int j = 0; j < fArray2.length; ++j) {
            if (fArray2[j] == fArray[j]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, j, Float.toString(fArray2[j]), Float.toString(fArray[j]), string));
        }
    }

    public static void assertEquals(double[] dArray, double[] dArray2) {
        Assert.assertEquals(dArray, dArray2, "");
    }

    public static void assertEquals(double[] dArray, double[] dArray2, String string) {
        if (Assert.checkRefEqualityAndLength(dArray, dArray2, string)) {
            return;
        }
        for (int j = 0; j < dArray2.length; ++j) {
            if (dArray2[j] == dArray[j]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, j, Double.toString(dArray2[j]), Double.toString(dArray[j]), string));
        }
    }

    public static void assertEquals(long[] lArray, long[] lArray2) {
        Assert.assertEquals(lArray, lArray2, "");
    }

    public static void assertEquals(long[] lArray, long[] lArray2, String string) {
        if (Assert.checkRefEqualityAndLength(lArray, lArray2, string)) {
            return;
        }
        for (int j = 0; j < lArray2.length; ++j) {
            if (lArray2[j] == lArray[j]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, j, Long.toString(lArray2[j]), Long.toString(lArray[j]), string));
        }
    }

    private static boolean checkRefEqualityAndLength(Object object, Object object2, String string) {
        if (object2 == object) {
            return true;
        }
        if (null == object2) {
            Assert.fail("expectedArray a null array, but not null found. " + string);
        }
        if (null == object) {
            Assert.fail("expectedArray not null array, but null found. " + string);
        }
        Assert.assertEquals(Array.getLength(object), Array.getLength(object2), "arrays don't have the same size. " + string);
        return false;
    }

    public static void assertEquals(Object object, Object object2) {
        Assert.assertEquals(object, object2, null);
    }

    public static void assertEquals(String string, String string2, String string3) {
        Assert.assertEquals((Object)string, (Object)string2, string3);
    }

    public static void assertEquals(String string, String string2) {
        Assert.assertEquals(string, string2, null);
    }

    public static void assertEquals(double d, double d2, double d3, String string) {
        if (Double.isInfinite(d2)) {
            if (d2 != d) {
                Assert.failNotEquals(d, d2, string);
            }
        } else if (Double.isNaN(d2)) {
            if (!Double.isNaN(d)) {
                Assert.failNotEquals(d, d2, string);
            }
        } else if (!(Math.abs(d2 - d) <= d3)) {
            Assert.failNotEquals(d, d2, string);
        }
    }

    public static void assertEquals(double d, double d2, double d3) {
        Assert.assertEquals(d, d2, d3, null);
    }

    public static void assertEquals(float f, float f2, float f3, String string) {
        if (Float.isInfinite(f2)) {
            if (f2 != f) {
                Assert.failNotEquals(Float.valueOf(f), Float.valueOf(f2), string);
            }
        } else if (!(Math.abs(f2 - f) <= f3)) {
            Assert.failNotEquals(Float.valueOf(f), Float.valueOf(f2), string);
        }
    }

    public static void assertEquals(float f, float f2, float f3) {
        Assert.assertEquals(f, f2, f3, null);
    }

    public static void assertEquals(long l, long l2, String string) {
        Assert.assertEquals((Object)l, (Object)l2, string);
    }

    public static void assertEquals(long l, long l2) {
        Assert.assertEquals(l, l2, null);
    }

    public static void assertEquals(boolean bl, boolean bl2, String string) {
        Assert.assertEquals((Object)bl, (Object)bl2, string);
    }

    public static void assertEquals(boolean bl, boolean bl2) {
        Assert.assertEquals(bl, bl2, null);
    }

    public static void assertEquals(byte by, byte by2, String string) {
        Assert.assertEquals((Object)by, (Object)by2, string);
    }

    public static void assertEquals(byte by, byte by2) {
        Assert.assertEquals(by, by2, null);
    }

    public static void assertEquals(char c, char c2, String string) {
        Assert.assertEquals(Character.valueOf(c), Character.valueOf(c2), string);
    }

    public static void assertEquals(char c, char c2) {
        Assert.assertEquals(c, c2, null);
    }

    public static void assertEquals(short s, short s2, String string) {
        Assert.assertEquals((Object)s, (Object)s2, string);
    }

    public static void assertEquals(short s, short s2) {
        Assert.assertEquals(s, s2, null);
    }

    public static void assertEquals(int n, int n2, String string) {
        Assert.assertEquals((Object)n, (Object)n2, string);
    }

    public static void assertEquals(int n, int n2) {
        Assert.assertEquals(n, n2, null);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(object, null);
    }

    public static void assertNotNull(Object object, String string) {
        if (object == null) {
            String string2 = "";
            if (string != null) {
                string2 = string + " ";
            }
            Assert.fail(string2 + "expected object to not be null");
        }
        Assert.assertTrue(object != null, string);
    }

    public static void assertNull(Object object) {
        Assert.assertNull(object, null);
    }

    public static void assertNull(Object object, String string) {
        if (object != null) {
            Assert.failNotSame(object, null, string);
        }
    }

    public static void assertSame(Object object, Object object2, String string) {
        if (object2 == object) {
            return;
        }
        Assert.failNotSame(object, object2, string);
    }

    public static void assertSame(Object object, Object object2) {
        Assert.assertSame(object, object2, null);
    }

    public static void assertNotSame(Object object, Object object2, String string) {
        if (object2 == object) {
            Assert.failSame(object, object2, string);
        }
    }

    public static void assertNotSame(Object object, Object object2) {
        Assert.assertNotSame(object, object2, null);
    }

    private static void failSame(Object object, Object object2, String string) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        Assert.fail(string2 + EclipseInterface.ASSERT_LEFT2 + object2 + EclipseInterface.ASSERT_MIDDLE + object + EclipseInterface.ASSERT_RIGHT);
    }

    private static void failNotSame(Object object, Object object2, String string) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        Assert.fail(string2 + EclipseInterface.ASSERT_LEFT + object2 + EclipseInterface.ASSERT_MIDDLE + object + EclipseInterface.ASSERT_RIGHT);
    }

    private static void failNotEquals(Object object, Object object2, String string) {
        Assert.fail(Assert.format(object, object2, string));
    }

    static String format(Object object, Object object2, String string) {
        String string2 = "";
        if (null != string) {
            string2 = string + " ";
        }
        return string2 + EclipseInterface.ASSERT_LEFT + object2 + EclipseInterface.ASSERT_MIDDLE + object + EclipseInterface.ASSERT_RIGHT;
    }

    public static void assertEquals(Collection<?> collection, Collection<?> collection2) {
        Assert.assertEquals(collection, collection2, null);
    }

    public static void assertEquals(Collection<?> collection, Collection<?> collection2, String string) {
        if (collection == collection2) {
            return;
        }
        if (collection == null || collection2 == null) {
            if (string != null) {
                Assert.fail(string);
            } else {
                Assert.fail("Collections not equal: expected: " + collection2 + " and actual: " + collection);
            }
        }
        Assert.assertEquals(collection.size(), collection2.size(), (string == null ? "" : string + ": ") + "lists don't have the same size");
        Iterator<?> iterator = collection.iterator();
        Iterator<?> iterator2 = collection2.iterator();
        int n = -1;
        while (iterator.hasNext() && iterator2.hasNext()) {
            Object obj = iterator2.next();
            Object obj2 = iterator.next();
            String string2 = "Lists differ at element [" + ++n + "]: " + obj + " != " + obj2;
            String string3 = string == null ? string2 : string + ": " + string2;
            Assert.assertEqualsImpl(obj2, obj, string3);
        }
    }

    public static void assertEquals(Iterator<?> iterator, Iterator<?> iterator2) {
        Assert.assertEquals(iterator, iterator2, null);
    }

    public static void assertEquals(Iterator<?> iterator, Iterator<?> iterator2, String string) {
        Object object;
        String string2;
        if (iterator == iterator2) {
            return;
        }
        if (iterator == null || iterator2 == null) {
            String string3 = string != null ? string : "Iterators not equal: expected: " + iterator2 + " and actual: " + iterator;
            Assert.fail(string3);
        }
        int n = -1;
        while (iterator.hasNext() && iterator2.hasNext()) {
            string2 = iterator2.next();
            object = iterator.next();
            String string4 = "Iterators differ at element [" + ++n + "]: " + string2 + " != " + object;
            String string5 = string == null ? string4 : string + ": " + string4;
            Assert.assertEqualsImpl(object, string2, string5);
        }
        if (iterator.hasNext()) {
            string2 = "Actual iterator returned more elements than the expected iterator.";
            object = string == null ? string2 : string + ": " + string2;
            Assert.fail(object);
        } else if (iterator2.hasNext()) {
            string2 = "Expected iterator returned more elements than the actual iterator.";
            object = string == null ? string2 : string + ": " + string2;
            Assert.fail(object);
        }
    }

    public static void assertEquals(Iterable<?> iterable, Iterable<?> iterable2) {
        Assert.assertEquals(iterable, iterable2, null);
    }

    public static void assertEquals(Iterable<?> iterable, Iterable<?> iterable2, String string) {
        if (iterable == iterable2) {
            return;
        }
        if (iterable == null || iterable2 == null) {
            if (string != null) {
                Assert.fail(string);
            } else {
                Assert.fail("Iterables not equal: expected: " + iterable2 + " and actual: " + iterable);
            }
        }
        Iterator<?> iterator = iterable.iterator();
        Iterator<?> iterator2 = iterable2.iterator();
        Assert.assertEquals(iterator, iterator2, string);
    }

    public static void assertEquals(Object[] objectArray, Object[] objectArray2, String string) {
        if (objectArray == objectArray2) {
            return;
        }
        if (objectArray == null && objectArray2 != null || objectArray != null && objectArray2 == null) {
            if (string != null) {
                Assert.fail(string);
            } else {
                Assert.fail("Arrays not equal: " + Arrays.toString(objectArray2) + " and " + Arrays.toString(objectArray));
            }
        }
        Assert.assertEquals(Arrays.asList(objectArray), Arrays.asList(objectArray2), string);
    }

    public static void assertEqualsNoOrder(Object[] objectArray, Object[] objectArray2, String string) {
        if (objectArray == objectArray2) {
            return;
        }
        if (objectArray == null && objectArray2 != null || objectArray != null && objectArray2 == null) {
            Assert.failAssertNoEqual("Arrays not equal: " + Arrays.toString(objectArray2) + " and " + Arrays.toString(objectArray), string);
        }
        if (objectArray.length != objectArray2.length) {
            Assert.failAssertNoEqual("Arrays do not have the same size:" + objectArray.length + " != " + objectArray2.length, string);
        }
        List list = Lists.newArrayList();
        for (Object object : objectArray) {
            list.add(object);
        }
        for (Object object : objectArray2) {
            list.remove(object);
        }
        if (list.size() != 0) {
            Assert.failAssertNoEqual("Arrays not equal: " + Arrays.toString(objectArray2) + " and " + Arrays.toString(objectArray), string);
        }
    }

    private static void failAssertNoEqual(String string, String string2) {
        if (string2 != null) {
            Assert.fail(string2);
        } else {
            Assert.fail(string);
        }
    }

    public static void assertEquals(Object[] objectArray, Object[] objectArray2) {
        Assert.assertEquals(objectArray, objectArray2, null);
    }

    public static void assertEqualsNoOrder(Object[] objectArray, Object[] objectArray2) {
        Assert.assertEqualsNoOrder(objectArray, objectArray2, null);
    }

    public static void assertEquals(Set<?> set, Set<?> set2) {
        Assert.assertEquals(set, set2, null);
    }

    public static void assertEquals(Set<?> set, Set<?> set2, String string) {
        if (set == set2) {
            return;
        }
        if (set == null || set2 == null) {
            if (string == null) {
                Assert.fail("Sets not equal: expected: " + set2 + " and actual: " + set);
            } else {
                Assert.failNotEquals(set, set2, string);
            }
        }
        if (!set.equals(set2)) {
            if (string == null) {
                Assert.fail("Sets differ: expected " + set2 + " but got " + set);
            } else {
                Assert.failNotEquals(set, set2, string);
            }
        }
    }

    public static void assertEqualsDeep(Set<?> set, Set<?> set2, String string) {
        if (set == set2) {
            return;
        }
        if (set == null || set2 == null) {
            if (string == null) {
                Assert.fail("Sets not equal: expected: " + set2 + " and actual: " + set);
            } else {
                Assert.failNotEquals(set, set2, string);
            }
        }
        Iterator<?> iterator = set.iterator();
        for (Object obj : set2) {
            if (!iterator.hasNext()) {
                Assert.fail("Sets not equal: expected: " + set2 + " and actual: " + set);
            }
            Object obj2 = iterator.next();
            if (obj.getClass().isArray()) {
                Assert.assertArrayEquals(obj2, obj, string);
                continue;
            }
            Assert.assertEqualsImpl(obj2, obj, string);
        }
    }

    public static void assertEquals(Map<?, ?> map, Map<?, ?> map2, String string) {
        if (map == map2) {
            return;
        }
        if (map == null || map2 == null) {
            Assert.fail("Maps not equal: expected: " + map2 + " and actual: " + map);
        }
        if (map.size() != map2.size()) {
            Assert.fail("Maps do not have the same size:" + map.size() + " != " + map2.size());
        }
        Set<Map.Entry<?, ?>> set = map.entrySet();
        Iterator<Map.Entry<?, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry;
            Map.Entry<?, ?> entry2 = entry = iterator.next();
            Object obj = entry2.getKey();
            Object obj2 = entry2.getValue();
            Object obj3 = map2.get(obj);
            String string2 = string != null ? string : "Maps do not match for key:" + obj + " actual:" + obj2 + " expected:" + obj3;
            Assert.assertEqualsImpl(obj2, obj3, string2);
        }
    }

    public static void assertEqualsDeep(Map<?, ?> map, Map<?, ?> map2) {
        Assert.assertEqualsDeep(map, map2, null);
    }

    public static void assertEqualsDeep(Map<?, ?> map, Map<?, ?> map2, String string) {
        if (map == map2) {
            return;
        }
        if (map == null || map2 == null) {
            Assert.fail("Maps not equal: expected: " + map2 + " and actual: " + map);
        }
        if (map.size() != map2.size()) {
            Assert.fail("Maps do not have the same size:" + map.size() + " != " + map2.size());
        }
        Set<Map.Entry<?, ?>> set = map.entrySet();
        Iterator<Map.Entry<?, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            Map.Entry<?, ?> entry;
            Map.Entry<?, ?> entry2 = entry = iterator.next();
            Object obj = entry2.getKey();
            Object obj2 = entry2.getValue();
            Object obj3 = map2.get(obj);
            String string3 = string2 = string != null ? string : "Maps do not match for key:" + obj + " actual:" + obj2 + " expected:" + obj3;
            if (obj3.getClass().isArray()) {
                Assert.assertArrayEquals(obj2, obj3, string2);
                continue;
            }
            Assert.assertEqualsImpl(obj2, obj3, string2);
        }
    }

    public static void assertNotEquals(Object object, Object object2, String string) {
        boolean bl;
        try {
            Assert.assertEquals(object, object2);
            bl = true;
        }
        catch (AssertionError assertionError) {
            bl = false;
        }
        if (bl) {
            Assert.fail(string);
        }
    }

    public static void assertNotEquals(Object object, Object object2) {
        Assert.assertNotEquals(object, object2, null);
    }

    static void assertNotEquals(String string, String string2, String string3) {
        Assert.assertNotEquals((Object)string, (Object)string2, string3);
    }

    static void assertNotEquals(String string, String string2) {
        Assert.assertNotEquals(string, string2, null);
    }

    static void assertNotEquals(long l, long l2, String string) {
        Assert.assertNotEquals((Object)l, (Object)l2, string);
    }

    static void assertNotEquals(long l, long l2) {
        Assert.assertNotEquals(l, l2, null);
    }

    static void assertNotEquals(boolean bl, boolean bl2, String string) {
        Assert.assertNotEquals((Object)bl, (Object)bl2, string);
    }

    static void assertNotEquals(boolean bl, boolean bl2) {
        Assert.assertNotEquals(bl, bl2, null);
    }

    static void assertNotEquals(byte by, byte by2, String string) {
        Assert.assertNotEquals((Object)by, (Object)by2, string);
    }

    static void assertNotEquals(byte by, byte by2) {
        Assert.assertNotEquals(by, by2, null);
    }

    static void assertNotEquals(char c, char c2, String string) {
        Assert.assertNotEquals(Character.valueOf(c), Character.valueOf(c2), string);
    }

    static void assertNotEquals(char c, char c2) {
        Assert.assertNotEquals(c, c2, null);
    }

    static void assertNotEquals(short s, short s2, String string) {
        Assert.assertNotEquals((Object)s, (Object)s2, string);
    }

    static void assertNotEquals(short s, short s2) {
        Assert.assertNotEquals(s, s2, null);
    }

    static void assertNotEquals(int n, int n2, String string) {
        Assert.assertNotEquals((Object)n, (Object)n2, string);
    }

    static void assertNotEquals(int n, int n2) {
        Assert.assertNotEquals(n, n2, null);
    }

    public static void assertNotEquals(float f, float f2, float f3, String string) {
        boolean bl;
        try {
            Assert.assertEquals(f, f2, f3, string);
            bl = true;
        }
        catch (AssertionError assertionError) {
            bl = false;
        }
        if (bl) {
            Assert.fail(string);
        }
    }

    public static void assertNotEquals(float f, float f2, float f3) {
        Assert.assertNotEquals(f, f2, f3, null);
    }

    public static void assertNotEquals(double d, double d2, double d3, String string) {
        boolean bl;
        try {
            Assert.assertEquals(d, d2, d3, string);
            bl = true;
        }
        catch (AssertionError assertionError) {
            bl = false;
        }
        if (bl) {
            Assert.fail(string);
        }
    }

    public static void assertNotEquals(Set<?> set, Set<?> set2) {
        Assert.assertNotEquals(set, set2, null);
    }

    public static void assertNotEquals(Set<?> set, Set<?> set2, String string) {
        boolean bl;
        try {
            Assert.assertEquals(set, set2, string);
            bl = true;
        }
        catch (AssertionError assertionError) {
            bl = false;
        }
        if (bl) {
            Assert.fail(string);
        }
    }

    public static void assertNotEqualsDeep(Set<?> set, Set<?> set2) {
        Assert.assertNotEqualsDeep(set, set2, null);
    }

    public static void assertNotEqualsDeep(Set<?> set, Set<?> set2, String string) {
        boolean bl;
        try {
            Assert.assertEqualsDeep(set, set2, string);
            bl = true;
        }
        catch (AssertionError assertionError) {
            bl = false;
        }
        if (bl) {
            Assert.fail(string);
        }
    }

    public static void assertNotEquals(Map<?, ?> map, Map<?, ?> map2) {
        Assert.assertNotEquals(map, map2, null);
    }

    public static void assertNotEquals(Map<?, ?> map, Map<?, ?> map2, String string) {
        boolean bl;
        try {
            Assert.assertEquals(map, map2, string);
            bl = true;
        }
        catch (AssertionError assertionError) {
            bl = false;
        }
        if (bl) {
            Assert.fail(string);
        }
    }

    public static void assertNotEqualsDeep(Map<?, ?> map, Map<?, ?> map2) {
        Assert.assertNotEqualsDeep(map, map2, null);
    }

    public static void assertNotEqualsDeep(Map<?, ?> map, Map<?, ?> map2, String string) {
        boolean bl;
        try {
            Assert.assertEqualsDeep(map, map2, string);
            bl = true;
        }
        catch (AssertionError assertionError) {
            bl = false;
        }
        if (bl) {
            Assert.fail(string);
        }
    }

    public static void assertNotEquals(double d, double d2, double d3) {
        Assert.assertNotEquals(d, d2, d3, null);
    }

    public static void assertThrows(ThrowingRunnable throwingRunnable) {
        Assert.assertThrows(Throwable.class, throwingRunnable);
    }

    public static <T extends Throwable> void assertThrows(Class<T> clazz, ThrowingRunnable throwingRunnable) {
        Assert.expectThrows(clazz, throwingRunnable);
    }

    public static <T extends Throwable> T expectThrows(Class<T> clazz, ThrowingRunnable throwingRunnable) {
        try {
            throwingRunnable.run();
        }
        catch (Throwable throwable) {
            if (clazz.isInstance(throwable)) {
                return (T)((Throwable)clazz.cast(throwable));
            }
            String string = String.format("Expected %s to be thrown, but %s was thrown", clazz.getSimpleName(), throwable.getClass().getSimpleName());
            throw new AssertionError(string, throwable);
        }
        String string = String.format("Expected %s to be thrown, but nothing was thrown", clazz.getSimpleName());
        throw new AssertionError((Object)string);
    }

    public static interface ThrowingRunnable {
        public void run() throws Throwable;
    }
}

