/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import org.testng.IClass;
import org.testng.ISuite;
import org.testng.ITest;
import org.testng.ITestContext;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.ClassHelper;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

public class ClassImpl
implements IClass {
    private final Class<?> m_class;
    private Object m_defaultInstance = null;
    private final IAnnotationFinder m_annotationFinder;
    private List<Object> m_instances = Lists.newArrayList();
    private final Map<Class<?>, IClass> m_classes;
    private int m_instanceCount;
    private long[] m_instanceHashCodes;
    private final Object m_instance;
    private final ITestObjectFactory m_objectFactory;
    private String m_testName = null;
    private final XmlClass m_xmlClass;
    private final ITestContext m_testContext;
    private final boolean m_hasParentModule;

    @Deprecated
    public ClassImpl(ITestContext iTestContext, Class<?> clazz, XmlClass xmlClass, Object object, Map<Class<?>, IClass> map, XmlTest xmlTest, IAnnotationFinder iAnnotationFinder, ITestObjectFactory iTestObjectFactory) {
        this(iTestContext, clazz, xmlClass, object, map, iAnnotationFinder, iTestObjectFactory);
    }

    public ClassImpl(ITestContext iTestContext, Class<?> clazz, XmlClass xmlClass, Object object, Map<Class<?>, IClass> map, IAnnotationFinder iAnnotationFinder, ITestObjectFactory iTestObjectFactory) {
        ITestAnnotation iTestAnnotation;
        this.m_testContext = iTestContext;
        this.m_class = clazz;
        this.m_classes = map;
        this.m_xmlClass = xmlClass;
        this.m_annotationFinder = iAnnotationFinder;
        this.m_instance = object;
        this.m_objectFactory = iTestObjectFactory;
        if (object instanceof ITest) {
            this.m_testName = ((ITest)object).getTestName();
        }
        if (this.m_testName == null && (iTestAnnotation = this.m_annotationFinder.findAnnotation(clazz, ITestAnnotation.class)) != null && !iTestAnnotation.getTestName().isEmpty()) {
            this.m_testName = iTestAnnotation.getTestName();
        }
        this.m_hasParentModule = Utils.isStringNotEmpty(this.m_testContext.getSuite().getParentModule());
    }

    @Override
    public String getTestName() {
        return this.m_testName;
    }

    @Override
    public String getName() {
        return this.m_class.getName();
    }

    public Class getRealClass() {
        return this.m_class;
    }

    @Override
    @Deprecated
    public int getInstanceCount() {
        return this.m_instanceCount;
    }

    @Override
    public long[] getInstanceHashCodes() {
        return this.m_instanceHashCodes;
    }

    @Override
    public XmlTest getXmlTest() {
        return this.m_testContext.getCurrentXmlTest();
    }

    @Override
    public XmlClass getXmlClass() {
        return this.m_xmlClass;
    }

    private Object getDefaultInstance() {
        if (this.m_defaultInstance == null) {
            Object object;
            this.m_defaultInstance = this.m_instance != null ? this.m_instance : ((object = this.getInstanceFromGuice()) != null ? object : ClassHelper.createInstance(this.m_class, this.m_classes, this.m_testContext.getCurrentXmlTest(), this.m_annotationFinder, this.m_objectFactory));
        }
        return this.m_defaultInstance;
    }

    private Object getInstanceFromGuice() {
        Injector injector = this.m_testContext.getInjector(this);
        if (injector == null) {
            return null;
        }
        return injector.getInstance(this.m_class);
    }

    public Injector getParentInjector() {
        ISuite iSuite = this.m_testContext.getSuite();
        Injector injector = iSuite.getParentInjector();
        if (injector == null) {
            String string = iSuite.getGuiceStage();
            Stage stage = Utils.isStringNotEmpty(string) ? Stage.valueOf((String)string) : Stage.DEVELOPMENT;
            if (this.m_hasParentModule) {
                Class<Module> clazz = ClassHelper.forName(iSuite.getParentModule());
                if (clazz == null) {
                    throw new TestNGException("Cannot load parent Guice module class: " + iSuite.getParentModule());
                }
                Module module = this.newModule(clazz);
                injector = Guice.createInjector((Stage)stage, (Module[])new Module[]{module});
            } else {
                injector = Guice.createInjector((Stage)stage, (Module[])new Module[0]);
            }
            iSuite.setParentInjector(injector);
        }
        return injector;
    }

    private Module newModule(Class<Module> clazz) {
        try {
            Constructor<Module> constructor = clazz.getDeclaredConstructor(ITestContext.class);
            return ClassHelper.newInstance(constructor, this.m_testContext);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return ClassHelper.newInstance(clazz);
        }
    }

    @Override
    public Object[] getInstances(boolean bl) {
        Object[] objectArray = new Object[]{};
        if (this.m_testContext.getCurrentXmlTest().isJUnit()) {
            if (bl) {
                objectArray = new Object[]{ClassHelper.createInstance(this.m_class, this.m_classes, this.m_testContext.getCurrentXmlTest(), this.m_annotationFinder, this.m_objectFactory)};
            }
        } else {
            Object object = this.getDefaultInstance();
            if (object != null) {
                objectArray = new Object[]{object};
            }
        }
        if (this.m_instances.size() > 0) {
            objectArray = this.m_instances.toArray(new Object[this.m_instances.size()]);
        }
        this.m_instanceCount = this.m_instances.size();
        this.m_instanceHashCodes = new long[this.m_instanceCount];
        for (int j = 0; j < this.m_instanceCount; ++j) {
            this.m_instanceHashCodes[j] = this.m_instances.get(j).hashCode();
        }
        return objectArray;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("class", this.m_class.getName()).toString();
    }

    @Override
    public void addInstance(Object object) {
        this.m_instances.add(object);
    }
}

