/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.testng.IConfigurationListener;
import org.testng.IInvokedMethodListener;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokedMethod;
import org.testng.internal.TestResult;
import org.testng.junit.IJUnitTestRunner;
import org.testng.junit.JUnit4TestClass;
import org.testng.junit.JUnit4TestMethod;

public class JUnit4TestRunner
implements IJUnitTestRunner {
    private ITestResultNotifier m_parentRunner;
    private List<ITestNGMethod> m_methods = Lists.newArrayList();
    private List<ITestListener> m_listeners = Lists.newArrayList();
    private Collection<IInvokedMethodListener> m_invokeListeners = Lists.newArrayList();
    private Map<Description, ITestResult> m_findedMethods = new WeakHashMap<Description, ITestResult>();

    public JUnit4TestRunner() {
    }

    public JUnit4TestRunner(ITestResultNotifier iTestResultNotifier) {
        this.m_parentRunner = iTestResultNotifier;
        this.m_listeners = this.m_parentRunner.getTestListeners();
    }

    @Override
    public List<ITestNGMethod> getTestMethods() {
        return this.m_methods;
    }

    @Override
    public void setTestResultNotifier(ITestResultNotifier iTestResultNotifier) {
        this.m_parentRunner = iTestResultNotifier;
        this.m_listeners = this.m_parentRunner.getTestListeners();
    }

    @Override
    public void setInvokedMethodListeners(Collection<IInvokedMethodListener> collection) {
        this.m_invokeListeners = collection;
    }

    @Override
    public void run(Class clazz, String ... stringArray) {
        this.start(clazz, stringArray);
    }

    public Result start(Class clazz, final String ... stringArray) {
        try {
            JUnitCore jUnitCore = new JUnitCore();
            jUnitCore.addListener(new RL());
            Request request = Request.aClass(clazz);
            return jUnitCore.run(request.filterWith(new Filter(){

                @Override
                public boolean shouldRun(Description description) {
                    if (description == null) {
                        return false;
                    }
                    if (stringArray.length == 0) {
                        if (description.getTestClass() != null) {
                            ITestResult iTestResult = JUnit4TestRunner.this.createTestResult(description);
                            JUnit4TestRunner.this.m_findedMethods.put(description, iTestResult);
                        }
                        return true;
                    }
                    for (String string : stringArray) {
                        Pattern pattern = Pattern.compile(string);
                        if (!pattern.matcher(description.getMethodName()).matches()) continue;
                        ITestResult iTestResult = JUnit4TestRunner.this.createTestResult(description);
                        JUnit4TestRunner.this.m_findedMethods.put(description, iTestResult);
                        return true;
                    }
                    return false;
                }

                @Override
                public String describe() {
                    return "TestNG method filter";
                }
            }));
        }
        catch (Throwable throwable) {
            throw new TestNGException("Failure in JUnit mode for class " + clazz.getName(), throwable);
        }
    }

    private ITestResult createTestResult(Description description) {
        JUnit4TestClass jUnit4TestClass = new JUnit4TestClass(description);
        JUnit4TestMethod jUnit4TestMethod = new JUnit4TestMethod(jUnit4TestClass, description);
        TestResult testResult = new TestResult(jUnit4TestClass, description, jUnit4TestMethod, null, Calendar.getInstance().getTimeInMillis(), 0L, null);
        InvokedMethod invokedMethod = new InvokedMethod(testResult.getTestClass(), testResult.getMethod(), testResult.getStartMillis(), testResult);
        this.m_parentRunner.addInvokedMethod(invokedMethod);
        for (IInvokedMethodListener iInvokedMethodListener : this.m_invokeListeners) {
            iInvokedMethodListener.beforeInvocation(invokedMethod, testResult);
        }
        return testResult;
    }

    private static boolean isAssumptionFailed(Failure failure) {
        Throwable throwable = failure.getException();
        if (throwable == null) {
            return false;
        }
        return "org.junit.internal.AssumptionViolatedException".equals(throwable.getClass().getCanonicalName());
    }

    private class RL
    extends RunListener {
        private List<Description> notified = new LinkedList<Description>();

        private RL() {
        }

        @Override
        public void testAssumptionFailure(Failure failure) {
            this.notified.add(failure.getDescription());
            ITestResult iTestResult = (ITestResult)JUnit4TestRunner.this.m_findedMethods.get(failure.getDescription());
            this.validate(iTestResult, failure.getDescription());
            this.runAfterInvocationListeners(iTestResult);
            iTestResult.setStatus(3);
            iTestResult.setEndMillis(Calendar.getInstance().getTimeInMillis());
            iTestResult.setThrowable(failure.getException());
            JUnit4TestRunner.this.m_parentRunner.addSkippedTest(iTestResult.getMethod(), iTestResult);
            for (ITestListener iTestListener : JUnit4TestRunner.this.m_listeners) {
                iTestListener.onTestSkipped(iTestResult);
            }
        }

        @Override
        public void testFailure(Failure failure) throws Exception {
            if (failure == null) {
                return;
            }
            if (JUnit4TestRunner.isAssumptionFailed(failure)) {
                this.testAssumptionFailure(failure);
                return;
            }
            this.notified.add(failure.getDescription());
            ITestResult iTestResult = (ITestResult)JUnit4TestRunner.this.m_findedMethods.get(failure.getDescription());
            if (iTestResult == null) {
                iTestResult = JUnit4TestRunner.this.createTestResult(failure.getDescription());
                this.runAfterInvocationListeners(iTestResult);
                iTestResult.setStatus(2);
                iTestResult.setEndMillis(Calendar.getInstance().getTimeInMillis());
                iTestResult.setThrowable(failure.getException());
                for (IConfigurationListener object : JUnit4TestRunner.this.m_parentRunner.getConfigurationListeners()) {
                    object.onConfigurationFailure(iTestResult);
                }
                for (Description description : failure.getDescription().getChildren()) {
                    this.testIgnored(description);
                }
            } else {
                this.runAfterInvocationListeners(iTestResult);
                iTestResult.setStatus(2);
                iTestResult.setEndMillis(Calendar.getInstance().getTimeInMillis());
                iTestResult.setThrowable(failure.getException());
                JUnit4TestRunner.this.m_parentRunner.addFailedTest(iTestResult.getMethod(), iTestResult);
                for (ITestListener iTestListener : JUnit4TestRunner.this.m_listeners) {
                    iTestListener.onTestFailure(iTestResult);
                }
            }
        }

        @Override
        public void testFinished(Description description) throws Exception {
            ITestResult iTestResult = (ITestResult)JUnit4TestRunner.this.m_findedMethods.get(description);
            this.validate(iTestResult, description);
            this.runAfterInvocationListeners(iTestResult);
            if (!this.notified.contains(description)) {
                iTestResult.setStatus(1);
                iTestResult.setEndMillis(Calendar.getInstance().getTimeInMillis());
                JUnit4TestRunner.this.m_parentRunner.addPassedTest(iTestResult.getMethod(), iTestResult);
                for (ITestListener iTestListener : JUnit4TestRunner.this.m_listeners) {
                    iTestListener.onTestSuccess(iTestResult);
                }
            }
            JUnit4TestRunner.this.m_methods.add(iTestResult.getMethod());
        }

        @Override
        public void testIgnored(Description description) throws Exception {
            if (!this.notified.contains(description)) {
                this.notified.add(description);
                ITestResult iTestResult = (ITestResult)JUnit4TestRunner.this.m_findedMethods.get(description);
                this.validate(iTestResult, description);
                this.runAfterInvocationListeners(iTestResult);
                iTestResult.setStatus(3);
                iTestResult.setEndMillis(iTestResult.getStartMillis());
                JUnit4TestRunner.this.m_parentRunner.addSkippedTest(iTestResult.getMethod(), iTestResult);
                JUnit4TestRunner.this.m_methods.add(iTestResult.getMethod());
                for (ITestListener iTestListener : JUnit4TestRunner.this.m_listeners) {
                    iTestListener.onTestSkipped(iTestResult);
                }
            }
        }

        @Override
        public void testRunFinished(Result result) throws Exception {
        }

        @Override
        public void testRunStarted(Description description) throws Exception {
        }

        @Override
        public void testStarted(Description description) throws Exception {
            ITestResult iTestResult = (ITestResult)JUnit4TestRunner.this.m_findedMethods.get(description);
            this.validate(iTestResult, description);
            for (ITestListener iTestListener : JUnit4TestRunner.this.m_listeners) {
                iTestListener.onTestStart(iTestResult);
            }
        }

        private void runAfterInvocationListeners(ITestResult iTestResult) {
            InvokedMethod invokedMethod = new InvokedMethod(iTestResult.getTestClass(), iTestResult.getMethod(), iTestResult.getEndMillis(), iTestResult);
            for (IInvokedMethodListener iInvokedMethodListener : JUnit4TestRunner.this.m_invokeListeners) {
                iInvokedMethodListener.afterInvocation(invokedMethod, iTestResult);
            }
        }

        private void validate(ITestResult iTestResult, Description description) {
            if (iTestResult == null) {
                throw new TestNGException(this.stringify(description));
            }
        }

        private String stringify(Description description) {
            return description.getClassName() + "." + description.getMethodName() + "()";
        }
    }
}

