/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Random;
import org.testng.reporters.Files;
import org.testng.reporters.IBuffer;

public class FileStringBuffer
implements IBuffer {
    private static int MAX = 100000;
    private static final boolean VERBOSE = System.getProperty("fileStringBuffer") != null;
    private File m_file;
    private StringBuilder m_sb = new StringBuilder();
    private final int m_maxCharacters;

    public FileStringBuffer() {
        this(MAX);
    }

    public FileStringBuffer(int n) {
        this.m_maxCharacters = n;
    }

    @Override
    public FileStringBuffer append(CharSequence charSequence) {
        if (charSequence == null) {
            throw new IllegalArgumentException("CharSequence (Argument 0 of FileStringBuffer#append) should not be null");
        }
        if (this.m_sb.length() > this.m_maxCharacters) {
            this.flushToFile();
        }
        if (charSequence.length() < MAX) {
            this.m_sb.append(charSequence);
        } else {
            this.flushToFile();
            try (FileWriter fileWriter = new FileWriter(this.m_file, true);){
                FileStringBuffer.copy(new StringReader(charSequence.toString()), fileWriter);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this;
    }

    @Override
    public void toWriter(Writer writer) {
        block16: {
            if (writer == null) {
                throw new IllegalArgumentException("Writer (Argument 0 of FileStringBuffer#toWriter) should not be null");
            }
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(writer);
                if (this.m_file == null) {
                    bufferedWriter.write(this.m_sb.toString());
                    bufferedWriter.close();
                    break block16;
                }
                this.flushToFile();
                try (FileReader fileReader = new FileReader(this.m_file);){
                    FileStringBuffer.copy(fileReader, bufferedWriter);
                }
                bufferedWriter.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static void copy(Reader reader, Writer writer) throws IOException {
        int n;
        char[] cArray = new char[MAX];
        while ((n = reader.read(cArray)) >= 0) {
            writer.write(cArray, 0, n);
        }
    }

    private void flushToFile() {
        if (this.m_sb.length() == 0) {
            return;
        }
        if (this.m_file == null) {
            try {
                this.m_file = File.createTempFile("testng", "fileStringBuffer");
                this.m_file.deleteOnExit();
                FileStringBuffer.p("Created temp file " + this.m_file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        FileStringBuffer.p("Size " + this.m_sb.length() + ", flushing to " + this.m_file);
        try (FileWriter fileWriter = new FileWriter(this.m_file, true);){
            fileWriter.append(this.m_sb);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.m_sb = new StringBuilder();
    }

    private static void p(String string) {
        if (VERBOSE) {
            System.out.println("[FileStringBuffer] " + string);
        }
    }

    public String toString() {
        String string = null;
        if (this.m_file != null) {
            this.flushToFile();
            try {
                string = Files.readFile(this.m_file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            string = this.m_sb.toString();
        }
        return string;
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        String string = "abcdefghijklmnopqrstuvwxyz";
        FileStringBuffer fileStringBuffer = new FileStringBuffer(10);
        StringBuilder stringBuilder = new StringBuilder();
        Random random = new Random();
        for (int j = 0; j < 1000; ++j) {
            int n = Math.abs(random.nextInt() % 26);
            int n2 = Math.abs(random.nextInt() % (26 - n));
            object = string.substring(n, n + n2);
            FileStringBuffer.p("... Appending " + (String)object);
            fileStringBuffer.append((CharSequence)object);
            stringBuilder.append((String)object);
        }
        File file = new File("/tmp/expected");
        file.delete();
        Object object2 = new FileWriter(file);
        Object object3 = null;
        try {
            ((OutputStreamWriter)object2).append(stringBuilder);
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            if (object2 != null) {
                if (object3 != null) {
                    try {
                        ((OutputStreamWriter)object2).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object3).addSuppressed(throwable);
                    }
                } else {
                    ((OutputStreamWriter)object2).close();
                }
            }
        }
        object2 = new File("/tmp/actual");
        ((File)object2).delete();
        object3 = new FileWriter((File)object2);
        object = null;
        try {
            fileStringBuffer.toWriter((Writer)object3);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (object3 != null) {
                if (object != null) {
                    try {
                        ((OutputStreamWriter)object3).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((OutputStreamWriter)object3).close();
                }
            }
        }
    }
}

