/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml.dom;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.collections.Pair;
import org.testng.xml.XmlDefine;
import org.testng.xml.XmlGroups;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.testng.xml.dom.ITagFactory;
import org.testng.xml.dom.ITagSetter;
import org.testng.xml.dom.ParentSetter;
import org.testng.xml.dom.Reflect;
import org.testng.xml.dom.TagContent;
import org.testng.xml.dom.TestNGTagFactory;
import org.testng.xml.dom.Wrapper;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XDom {
    private Document m_document;
    private ITagFactory m_tagFactory;

    public XDom(ITagFactory iTagFactory, Document document) throws XPathExpressionException, InstantiationException, IllegalAccessException {
        this.m_tagFactory = iTagFactory;
        this.m_document = document;
    }

    public Object parse() throws XPathExpressionException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        Object object = null;
        NodeList nodeList = this.m_document.getChildNodes();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Node node = nodeList.item(j);
            if (node.getAttributes() == null) continue;
            String string = node.getNodeName();
            System.out.println("Node name:" + string);
            Class<?> clazz = this.m_tagFactory.getClassForTag(string);
            if (clazz == null) {
                throw new RuntimeException("No class found for tag " + string);
            }
            object = clazz.newInstance();
            this.populateAttributes(node, object);
            if (ITagSetter.class.isAssignableFrom(object.getClass())) {
                throw new RuntimeException("TAG SETTER");
            }
            this.populateChildren(node, object);
        }
        return object;
    }

    public void populateChildren(Node node, Object object) throws InstantiationException, IllegalAccessException, XPathExpressionException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        this.p("populateChildren: " + node.getLocalName());
        NodeList nodeList = node.getChildNodes();
        ListMultiMap<String, Object> listMultiMap = Maps.newListMultiMap();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Class<?> clazz;
            Node node2 = nodeList.item(j);
            if (node2.getAttributes() == null) continue;
            String string = node2.getNodeName();
            if ("suite-files".equals(string)) {
                System.out.println("BREAK");
            }
            if ((clazz = this.m_tagFactory.getClassForTag(string)) == null) {
                System.out.println("Warning: No class found for tag " + string);
                boolean bl = this.invokeOnSetter(object, (Element)node2, string, null);
                System.out.println("  found setter:" + bl);
                continue;
            }
            Object object2 = this.instantiateElement(clazz, object);
            if (ITagSetter.class.isAssignableFrom(object2.getClass())) {
                System.out.println("Tag setter:" + object);
                ((ITagSetter)object2).setProperty(string, object, node2);
            } else {
                listMultiMap.put(string, object2);
                this.populateAttributes(node2, object2);
                this.populateContent(node2, object2);
            }
            boolean bl = this.invokeOnSetter(object, (Element)node2, string, object2);
            this.populateChildren(node2, object2);
        }
    }

    private Object instantiateElement(Class<?> clazz, Object object) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object var3_3 = null;
        Method method = this.findMethodAnnotatedWith(clazz, ParentSetter.class);
        if (method != null) {
            var3_3 = clazz.newInstance();
            method.invoke(var3_3, object);
        } else {
            try {
                var3_3 = clazz.getConstructor(object.getClass()).newInstance(object);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                var3_3 = clazz.newInstance();
            }
        }
        return var3_3;
    }

    private Method findMethodAnnotatedWith(Class<?> clazz, Class<? extends Annotation> clazz2) {
        for (Method method : clazz.getMethods()) {
            if (method.getAnnotation(clazz2) == null) continue;
            return method;
        }
        return null;
    }

    private void populateContent(Node node, Object object) {
        for (int j = 0; j < node.getChildNodes().getLength(); ++j) {
            Node node2 = node.getChildNodes().item(j);
            if (!(node2 instanceof Text)) continue;
            this.setText(object, (Text)node2);
        }
    }

    private void setText(Object object, Text text) {
        List<Pair<Method, Wrapper>> list = Reflect.findMethodsWithAnnotation(object.getClass(), TagContent.class, object);
        for (Pair<Method, Wrapper> pair : list) {
            try {
                pair.first().invoke(object, text.getTextContent());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | DOMException exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean invokeOnSetter(Object object, Element element, String string, Object object2) {
        Pair<Method, Wrapper> pair = Reflect.findSetterForTag(object.getClass(), string, object2);
        List<Object> list = null;
        if (pair != null) {
            Method method = pair.first();
            try {
                if (pair.second() != null) {
                    list = pair.second().getParameters(element);
                } else {
                    list = Lists.newArrayList();
                    list.add(new Object[]{object2});
                }
                for (Object[] objectArray : list) {
                    method.invoke(object, objectArray);
                }
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("Parameters: " + list);
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        }
        return false;
    }

    private void populateAttributes(Node node, Object object) throws XPathExpressionException {
        for (int j = 0; j < node.getAttributes().getLength(); ++j) {
            Node node2 = node.getAttributes().item(j);
            this.setProperty(object, node2.getLocalName(), node2.getNodeValue());
        }
    }

    private void setProperty(Object object, String string, Object object2) {
        block6: {
            Pair<Method, Wrapper> pair = Reflect.findSetterForTag(object.getClass(), string, object2);
            if (pair != null) {
                Method method = pair.first();
                try {
                    Class<?> clazz = method.getParameterTypes()[0];
                    if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                        method.invoke(object, Boolean.parseBoolean(object2.toString()));
                        break block6;
                    }
                    if (clazz == Integer.class || clazz == Integer.TYPE) {
                        method.invoke(object, Integer.parseInt(object2.toString()));
                        break block6;
                    }
                    method.invoke(object, object2);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    exception.printStackTrace();
                }
            } else {
                this.e("Couldn't find setter method for property" + string + " on " + object.getClass());
            }
        }
    }

    private void p(String string) {
        System.out.println("[XDom] " + string);
    }

    private void e(String string) {
        System.out.println("[XDom] [Error] " + string);
    }

    public static void main(String[] stringArray) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        FileInputStream fileInputStream = new FileInputStream(new File(System.getProperty("user.home") + "/java/testng/src/test/resources/testng-all.xml"));
        Document document = documentBuilder.parse(fileInputStream);
        XmlSuite xmlSuite = (XmlSuite)new XDom(new TestNGTagFactory(), document).parse();
        XDom.test(xmlSuite);
        System.out.println(xmlSuite.toXml());
    }

    private static void test(XmlSuite xmlSuite) {
        Assert.assertEquals("TestNG", xmlSuite.getName());
        Assert.assertEquals(xmlSuite.getDataProviderThreadCount(), 3);
        Assert.assertEquals(xmlSuite.getThreadCount(), 2);
        Object object = xmlSuite.getMethodSelectors();
        Assert.assertEquals(object.size(), 2);
        Object object2 = object.get(0);
        Assert.assertEquals(((XmlMethodSelector)object2).getLanguage(), "javascript");
        Assert.assertEquals(((XmlMethodSelector)object2).getExpression(), "foo()");
        Object object3 = object.get(1);
        Assert.assertEquals(((XmlMethodSelector)object3).getClassName(), "SelectorClass");
        Assert.assertEquals(((XmlMethodSelector)object3).getPriority(), 3);
        object = xmlSuite.getSuiteFiles();
        Assert.assertEquals(object, Arrays.asList("./junit-suite.xml"));
        object = xmlSuite.getParameters();
        Assert.assertEquals(object.size(), 2);
        Assert.assertEquals((String)object.get("suiteParameter"), "suiteParameterValue");
        Assert.assertEquals((String)object.get("first-name"), "Cedric");
        Assert.assertEquals(xmlSuite.getIncludedGroups(), Arrays.asList("includeThisGroup"));
        Assert.assertEquals(xmlSuite.getExcludedGroups(), Arrays.asList("excludeThisGroup"));
        object = xmlSuite.getGroups();
        object2 = ((XmlGroups)object).getDefines();
        Assert.assertEquals(object2.size(), 1);
        object3 = (XmlDefine)object2.get(0);
        Assert.assertEquals(((XmlDefine)object3).getName(), "bigSuite");
        Assert.assertEquals(((XmlDefine)object3).getIncludes(), Arrays.asList("suite1", "suite2"));
        Assert.assertEquals(xmlSuite.getPackageNames(), Arrays.asList("com.example1", "com.example2"));
        Assert.assertEquals(xmlSuite.getListeners(), Arrays.asList("com.beust.Listener1", "com.beust.Listener2"));
        Assert.assertEquals(xmlSuite.getTests().size(), 3);
        for (int j = 0; j < xmlSuite.getTests().size(); ++j) {
            if (!"Nopackage".equals(xmlSuite.getTests().get(j).getName())) continue;
            XDom.testNoPackage(xmlSuite.getTests().get(j));
        }
    }

    private static void testNoPackage(XmlTest xmlTest) {
        Assert.assertEquals(xmlTest.getThreadCount(), 42);
        Assert.assertTrue(xmlTest.getAllowReturnValues());
        Map<String, List<String>> map = xmlTest.getMetaGroups();
        Assert.assertEquals((Collection)map.get("evenodd"), Arrays.asList("even", "odd"));
        Assert.assertEquals(xmlTest.getIncludedGroups(), Arrays.asList("nopackage", "includeThisGroup"));
        Assert.assertEquals(xmlTest.getExcludedGroups(), Arrays.asList("excludeThisGroup"));
        Map<String, String> map2 = xmlTest.getXmlDependencyGroups();
        Assert.assertEquals(map2.size(), 2);
        Assert.assertEquals(map2.get("e"), "f");
        Assert.assertEquals(map2.get("g"), "h");
    }
}

