/*
 * Decompiled with CFR 0.152.
 */
package com.appsamurai.storyly.reactnative.verticalFeed;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import androidx.core.content.ContextCompat;
import com.appsamurai.storyly.StorylyLayoutDirection;
import com.appsamurai.storyly.config.StorylyProductConfig;
import com.appsamurai.storyly.config.StorylyShareConfig;
import com.appsamurai.storyly.config.styling.story.a;
import com.appsamurai.storyly.data.managers.product.STRCart;
import com.appsamurai.storyly.data.managers.product.STRProductItem;
import com.appsamurai.storyly.reactnative.STStorylyDataConverterKt;
import com.appsamurai.storyly.reactnative.verticalFeed.STVerticalFeedView;
import com.appsamurai.storyly.verticalfeed.StorylyVerticalFeedGroupOrder;
import com.appsamurai.storyly.verticalfeed.StorylyVerticalFeedInit;
import com.appsamurai.storyly.verticalfeed.StorylyVerticalFeedView;
import com.appsamurai.storyly.verticalfeed.VFPlayMode;
import com.appsamurai.storyly.verticalfeed.config.StorylyVerticalFeedConfig;
import com.appsamurai.storyly.verticalfeed.config.bar.StorylyVerticalFeedBarStyling;
import com.appsamurai.storyly.verticalfeed.config.customization.StorylyVerticalFeedCustomization;
import com.appsamurai.storyly.verticalfeed.config.group.StorylyVerticalFeedGroupStyling;
import com.appsamurai.storyly.verticalfeed.core.STRVerticalFeedView;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 =2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001=B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00060\u000fH\u0016J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00170\u000fH\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010\"\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010$\u001a\u0004\u0018\u00010\u0010H\u0002J\"\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u00062\b\u0010)\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u0006H\u0016J\u0018\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020\u00022\u0006\u0010/\u001a\u000200H\u0007J\u0010\u00101\u001a\u00020&2\u0006\u00102\u001a\u000203H\u0003J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u0002002\u0006\u00107\u001a\u000205H\u0002J\u0018\u00108\u001a\u0002052\u0006\u00106\u001a\u0002002\u0006\u00107\u001a\u000205H\u0002J \u00109\u001a\u0002052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u00106\u001a\u0002002\u0006\u00107\u001a\u000205H\u0002J \u0010:\u001a\u0002052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u00106\u001a\u0002002\u0006\u00107\u001a\u000205H\u0002J\u0018\u0010;\u001a\u0002052\u0006\u00106\u001a\u0002002\u0006\u00107\u001a\u000205H\u0002J\u0018\u0010<\u001a\u0002052\u0006\u00106\u001a\u0002002\u0006\u00107\u001a\u000205H\u0002\u00a8\u0006>"}, d2={"Lcom/appsamurai/storyly/reactnative/verticalFeed/STVerticalFeedManager;", "Lcom/facebook/react/uimanager/ViewGroupManager;", "Lcom/appsamurai/storyly/reactnative/verticalFeed/STVerticalFeedView;", "()V", "convertColorArray", "", "", "colors", "Lcom/facebook/react/bridge/ReadableArray;", "createViewInstance", "reactContext", "Lcom/facebook/react/uimanager/ThemedReactContext;", "dpToPixel", "dpValue", "getCommandsMap", "", "", "getDrawable", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "name", "getExportedCustomDirectEventTypeConstants", "", "getName", "getPlayMode", "Lcom/appsamurai/storyly/verticalfeed/VFPlayMode;", "playMode", "getStorylyGroupOrder", "Lcom/appsamurai/storyly/verticalfeed/StorylyVerticalFeedGroupOrder;", "groupOrder", "getStorylyLayoutDirection", "Lcom/appsamurai/storyly/StorylyLayoutDirection;", "layoutDirection", "getTypeface", "Landroid/graphics/Typeface;", "fontName", "receiveCommand", "", "root", "commandId", "args", "removeViewAt", "parent", "index", "setPropStoryly", "view", "storylyBundle", "Lcom/facebook/react/bridge/ReadableMap;", "stFrameworkSet", "config", "Lcom/appsamurai/storyly/verticalfeed/config/StorylyVerticalFeedConfig;", "stProductConfig", "Lcom/appsamurai/storyly/verticalfeed/config/StorylyVerticalFeedConfig$Builder;", "json", "configBuilder", "stShareConfig", "stVerticalFeedCustomization", "stVerticalFeedGroupStyling", "stVerticalFeedInit", "stVerticalFeedItemBarStyling", "Companion", "storyly-react-native_debug"})
public final class STVerticalFeedManager
extends ViewGroupManager<STVerticalFeedView> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String REACT_CLASS = "STVerticalFeed";
    @NotNull
    private static final String COMMAND_REFRESH_NAME = "refresh";
    private static final int COMMAND_REFRESH_CODE = 1;
    @NotNull
    private static final String COMMAND_OPEN_NAME = "open";
    private static final int COMMAND_OPEN_CODE = 4;
    @NotNull
    private static final String COMMAND_OPEN_WITH_ID_NAME = "openWithId";
    private static final int COMMAND_OPEN_WITH_ID_CODE = 5;
    @NotNull
    private static final String COMMAND_HYDRATE_PRODUCT_NAME = "hydrateProducts";
    private static final int COMMAND_HYDRATE_PRODUCT_CODE = 6;
    @NotNull
    private static final String COMMAND_UPDATE_CART_NAME = "updateCart";
    private static final int COMMAND_UPDATE_CART_CODE = 7;
    @NotNull
    private static final String COMMAND_APPROVE_CART_CHANGE_NAME = "approveCartChange";
    private static final int COMMAND_APPROVE_CART_CHANGE_CODE = 8;
    @NotNull
    private static final String COMMAND_REJECT_CART_CHANGE_NAME = "rejectCartChange";
    private static final int COMMAND_REJECT_CART_CHANGE_CODE = 9;
    @NotNull
    private static final String COMMAND_RESUME_STORY_NAME = "resumeStory";
    private static final int COMMAND_RESUME_STORY_CODE = 10;
    @NotNull
    private static final String COMMAND_PAUSE_STORY_NAME = "pauseStory";
    private static final int COMMAND_PAUSE_STORY_CODE = 11;
    @NotNull
    private static final String COMMAND_CLOSE_STORY_NAME = "closeStory";
    private static final int COMMAND_CLOSE_STORY_CODE = 12;
    @NotNull
    private static final String COMMAND_APPROVE_WISHLIST_CHANGE_NAME = "approveWishlistChange";
    private static final int COMMAND_APPROVE_WISHLIST_CHANGE_CODE = 13;
    @NotNull
    private static final String COMMAND_REJECT_WISHLIST_CHANGE_NAME = "rejectWishlistChange";
    private static final int COMMAND_REJECT_WISHLIST_CHANGE_CODE = 14;
    @NotNull
    private static final String COMMAND_HYDRATE_WISHLIST_NAME = "hydrateWishlist";
    private static final int COMMAND_HYDRATE_WISHLIST_CODE = 15;
    @NotNull
    public static final String EVENT_STORYLY_LOADED = "onStorylyLoaded";
    @NotNull
    public static final String EVENT_STORYLY_LOAD_FAILED = "onStorylyLoadFailed";
    @NotNull
    public static final String EVENT_STORYLY_EVENT = "onStorylyEvent";
    @NotNull
    public static final String EVENT_STORYLY_ACTION_CLICKED = "onStorylyActionClicked";
    @NotNull
    public static final String EVENT_STORYLY_VERTICAL_FEED_PRESENTED = "onStorylyStoryPresented";
    @NotNull
    public static final String EVENT_STORYLY_VERTICAL_FEED_PRESENT_FAILED = "onStorylyStoryPresentFailed";
    @NotNull
    public static final String EVENT_STORYLY_VERTICAL_FEED_DISMISSED = "onStorylyStoryDismissed";
    @NotNull
    public static final String EVENT_STORYLY_USER_INTERACTED = "onStorylyUserInteracted";
    @NotNull
    public static final String EVENT_STORYLY_ON_HYDRATION = "onStorylyProductHydration";
    @NotNull
    public static final String EVENT_STORYLY_ON_CART_UPDATED = "onStorylyCartUpdated";
    @NotNull
    public static final String EVENT_STORYLY_ON_WISHLIST_UPDATED = "onStorylyWishlistUpdated";
    @NotNull
    public static final String EVENT_STORYLY_PRODUCT_EVENT = "onStorylyProductEvent";
    @NotNull
    public static final String EVENT_ON_CREATE_CUSTOM_VIEW = "onCreateCustomView";
    @NotNull
    public static final String EVENT_ON_UPDATE_CUSTOM_VIEW = "onUpdateCustomView";

    @NotNull
    public String getName() {
        return REACT_CLASS;
    }

    @NotNull
    protected STVerticalFeedView createViewInstance(@NotNull ThemedReactContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)reactContext, (String)"reactContext");
        return new STVerticalFeedView((Context)reactContext);
    }

    public void removeViewAt(@NotNull STVerticalFeedView parent, int index) {
        Intrinsics.checkNotNullParameter((Object)((Object)parent), (String)"parent");
    }

    @NotNull
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        MapBuilder.Builder builder = MapBuilder.builder();
        Object object = new String[]{EVENT_STORYLY_LOADED, EVENT_STORYLY_LOAD_FAILED, EVENT_STORYLY_EVENT, EVENT_STORYLY_ACTION_CLICKED, EVENT_STORYLY_VERTICAL_FEED_PRESENTED, EVENT_STORYLY_VERTICAL_FEED_PRESENT_FAILED, EVENT_STORYLY_VERTICAL_FEED_DISMISSED, EVENT_STORYLY_USER_INTERACTED, EVENT_ON_CREATE_CUSTOM_VIEW, EVENT_ON_UPDATE_CUSTOM_VIEW, EVENT_STORYLY_ON_HYDRATION, EVENT_STORYLY_ON_CART_UPDATED, EVENT_STORYLY_ON_WISHLIST_UPDATED, EVENT_STORYLY_PRODUCT_EVENT};
        String[] $this$forEach$iv = object;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            builder.put((Object)it, (Object)MapBuilder.of((Object)"registrationName", (Object)it));
        }
        object = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder.build()");
        return object;
    }

    @NotNull
    public Map<String, Integer> getCommandsMap() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)COMMAND_REFRESH_NAME, (Object)1), TuplesKt.to((Object)COMMAND_OPEN_NAME, (Object)4), TuplesKt.to((Object)COMMAND_OPEN_WITH_ID_NAME, (Object)5), TuplesKt.to((Object)COMMAND_HYDRATE_PRODUCT_NAME, (Object)6), TuplesKt.to((Object)COMMAND_HYDRATE_WISHLIST_NAME, (Object)15), TuplesKt.to((Object)COMMAND_UPDATE_CART_NAME, (Object)7), TuplesKt.to((Object)COMMAND_APPROVE_CART_CHANGE_NAME, (Object)8), TuplesKt.to((Object)COMMAND_REJECT_CART_CHANGE_NAME, (Object)9), TuplesKt.to((Object)COMMAND_RESUME_STORY_NAME, (Object)10), TuplesKt.to((Object)COMMAND_PAUSE_STORY_NAME, (Object)11), TuplesKt.to((Object)COMMAND_CLOSE_STORY_NAME, (Object)12), TuplesKt.to((Object)COMMAND_APPROVE_WISHLIST_CHANGE_NAME, (Object)13), TuplesKt.to((Object)COMMAND_REJECT_WISHLIST_CHANGE_NAME, (Object)14)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    public void receiveCommand(@NotNull STVerticalFeedView root, int commandId, @Nullable ReadableArray args) {
        Intrinsics.checkNotNullParameter((Object)((Object)root), (String)"root");
        int n = commandId;
        switch (n) {
            case 1: {
                StorylyVerticalFeedView storylyVerticalFeedView = root.getVerticalFeedView$storyly_react_native_debug();
                if (storylyVerticalFeedView == null) break;
                storylyVerticalFeedView.refresh();
                break;
            }
            case 4: {
                String string2;
                ReadableArray readableArray = args;
                String string3 = string2 = readableArray == null ? null : readableArray.getString(0);
                if (string2 == null) {
                    return;
                }
                String payloadStr = string2;
                string2 = root.getVerticalFeedView$storyly_react_native_debug();
                if (string2 == null) break;
                readableArray = Uri.parse((String)payloadStr);
                Intrinsics.checkNotNullExpressionValue((Object)readableArray, (String)"parse(payloadStr)");
                string2.open((Uri)readableArray);
                break;
            }
            case 6: {
                void $this$mapTo$iv$iv;
                List payloadStr;
                ReadableArray readableArray;
                ReadableArray readableArray2 = args;
                List list = readableArray2 == null ? null : ((readableArray = readableArray2.getArray(0)) == null ? null : readableArray.toArrayList());
                List list2 = payloadStr = list instanceof List ? (List)list : null;
                if (payloadStr == null) break;
                List it = list = payloadStr;
                boolean bl = false;
                Iterable $this$map$iv = it;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    Map map = (Map)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    STRProductItem sTRProductItem = STStorylyDataConverterKt.createSTRProductItem((Map<String, ? extends Object>)it2);
                    collection.add(sTRProductItem);
                }
                List productItems = (List)destination$iv$iv;
                $this$map$iv = root.getVerticalFeedView$storyly_react_native_debug();
                if ($this$map$iv == null) break;
                $this$map$iv.hydrateProducts(productItems);
                break;
            }
            case 15: {
                List payloadStr;
                ReadableArray bl;
                Object it = args;
                List list = it == null ? null : ((bl = it.getArray(0)) == null ? null : bl.toArrayList());
                List list3 = payloadStr = list instanceof List ? (List)list : null;
                if (payloadStr == null) break;
                list = payloadStr;
                it = list;
                boolean bl3 = false;
                Iterable $this$map$iv = (Iterable)it;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Map it2 = (Map)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    STRProductItem sTRProductItem = STStorylyDataConverterKt.createSTRProductItem(it2);
                    collection.add(sTRProductItem);
                }
                List productItems = (List)destination$iv$iv;
                $this$map$iv = root.getVerticalFeedView$storyly_react_native_debug();
                if ($this$map$iv == null) break;
                $this$map$iv.hydrateWishlist(productItems);
                break;
            }
            case 7: {
                Map payloadStr;
                ReadableMap bl3;
                Object it = args;
                Map map = it == null ? null : ((bl3 = it.getMap(0)) == null ? null : bl3.toHashMap());
                Map map2 = payloadStr = map instanceof Map ? (Map)map : null;
                if (payloadStr == null) break;
                map = payloadStr;
                it = map;
                boolean bl = false;
                STRCart cart = STStorylyDataConverterKt.createSTRCart((Map<String, ? extends Object>)it);
                StorylyVerticalFeedView $i$f$map = root.getVerticalFeedView$storyly_react_native_debug();
                if ($i$f$map == null) break;
                $i$f$map.updateCart(cart);
                break;
            }
            case 8: {
                String string4;
                Object it = args;
                String string5 = string4 = it == null ? null : it.getString(0);
                if (string4 == null) {
                    return;
                }
                String responseId = string4;
                if (args.size() > 1) {
                    Object object;
                    ReadableMap cart = args.getMap(1);
                    HashMap bl = cart == null ? null : cart.toHashMap();
                    Map map = it = bl instanceof Map ? (Map)bl : null;
                    if (it == null) {
                        object = null;
                    } else {
                        HashMap it3 = bl = it;
                        boolean bl5 = false;
                        root.approveCartChange$storyly_react_native_debug(responseId, STStorylyDataConverterKt.createSTRCart(it3));
                        object = string4 = Unit.INSTANCE;
                    }
                    if (string4 != null) break;
                    it = this;
                    STVerticalFeedManager $this$receiveCommand_u24lambda_u2d7 = (STVerticalFeedManager)((Object)it);
                    boolean bl6 = false;
                    STVerticalFeedView.approveCartChange$storyly_react_native_debug$default(root, responseId, null, 2, null);
                    break;
                }
                STVerticalFeedView.approveCartChange$storyly_react_native_debug$default(root, responseId, null, 2, null);
                break;
            }
            case 9: {
                String string6;
                String string7;
                Object it = args;
                String string8 = string7 = it == null ? null : it.getString(0);
                if (string7 == null) {
                    return;
                }
                String responseId = string7;
                if (args.size() > 1) {
                    String $this$receiveCommand_u24lambda_u2d7 = args.getString(1);
                    it = $this$receiveCommand_u24lambda_u2d7 == null ? "" : $this$receiveCommand_u24lambda_u2d7;
                    string6 = it;
                } else {
                    string6 = "";
                }
                String failMessage = string6;
                root.rejectCartChange$storyly_react_native_debug(responseId, failMessage);
                break;
            }
            case 13: {
                String failMessage;
                Object it = args;
                String string9 = failMessage = it == null ? null : it.getString(0);
                if (failMessage == null) {
                    return;
                }
                String responseId = failMessage;
                if (args.size() > 1) {
                    Object object;
                    ReadableMap bl6 = args.getMap(1);
                    HashMap $this$receiveCommand_u24lambda_u2d7 = bl6 == null ? null : bl6.toHashMap();
                    Map map = it = $this$receiveCommand_u24lambda_u2d7 instanceof Map ? (Map)$this$receiveCommand_u24lambda_u2d7 : null;
                    if (it == null) {
                        object = null;
                    } else {
                        HashMap it4 = $this$receiveCommand_u24lambda_u2d7 = it;
                        boolean bl = false;
                        root.approveWishlistChange$storyly_react_native_debug(responseId, STStorylyDataConverterKt.createSTRProductItem(it4));
                        object = failMessage = Unit.INSTANCE;
                    }
                    if (failMessage != null) break;
                    it = this;
                    STVerticalFeedManager $this$receiveCommand_u24lambda_u2d9 = (STVerticalFeedManager)((Object)it);
                    boolean bl = false;
                    STVerticalFeedView.approveWishlistChange$storyly_react_native_debug$default(root, responseId, null, 2, null);
                    break;
                }
                STVerticalFeedView.approveWishlistChange$storyly_react_native_debug$default(root, responseId, null, 2, null);
                break;
            }
            case 14: {
                String string10;
                String failMessage;
                Object it = args;
                String string11 = failMessage = it == null ? null : it.getString(0);
                if (failMessage == null) {
                    return;
                }
                String responseId = failMessage;
                if (args.size() > 1) {
                    String string12 = args.getString(1);
                    it = string12 == null ? "" : string12;
                    string10 = it;
                } else {
                    string10 = "";
                }
                failMessage = string10;
                root.rejectWishlistChange$storyly_react_native_debug(responseId, failMessage);
                break;
            }
            case 5: {
                String failMessage;
                ReadableArray it = args;
                String string13 = failMessage = it == null ? null : it.getString(0);
                if (failMessage == null) {
                    return;
                }
                String groupId = failMessage;
                String itemId = args.size() > 1 ? args.getString(1) : null;
                String playMode = args.size() > 2 ? args.getString(2) : null;
                StorylyVerticalFeedView storylyVerticalFeedView = root.getVerticalFeedView$storyly_react_native_debug();
                if (storylyVerticalFeedView == null) break;
                storylyVerticalFeedView.open(groupId, itemId, this.getPlayMode(playMode));
                break;
            }
            case 10: {
                StorylyVerticalFeedView storylyVerticalFeedView = root.getVerticalFeedView$storyly_react_native_debug();
                if (storylyVerticalFeedView == null) break;
                STRVerticalFeedView.resumeStory$default((STRVerticalFeedView)((STRVerticalFeedView)storylyVerticalFeedView), null, (int)1, null);
                break;
            }
            case 11: {
                StorylyVerticalFeedView storylyVerticalFeedView = root.getVerticalFeedView$storyly_react_native_debug();
                if (storylyVerticalFeedView == null) break;
                STRVerticalFeedView.pauseStory$default((STRVerticalFeedView)((STRVerticalFeedView)storylyVerticalFeedView), null, (int)1, null);
                break;
            }
            case 12: {
                StorylyVerticalFeedView storylyVerticalFeedView = root.getVerticalFeedView$storyly_react_native_debug();
                if (storylyVerticalFeedView == null) break;
                STRVerticalFeedView.closeStory$default((STRVerticalFeedView)((STRVerticalFeedView)storylyVerticalFeedView), null, (int)1, null);
            }
        }
    }

    private final VFPlayMode getPlayMode(String playMode) {
        String string2 = playMode;
        return Intrinsics.areEqual((Object)string2, (Object)"feed-group") ? VFPlayMode.FeedGroup : (Intrinsics.areEqual((Object)string2, (Object)"feed") ? VFPlayMode.Feed : VFPlayMode.Default);
    }

    /*
     * WARNING - void declaration
     */
    @ReactProp(name="storyly")
    public final void setPropStoryly(@NotNull STVerticalFeedView view, @NotNull ReadableMap storylyBundle) {
        void $this$setPropStoryly_u24lambda_u2d10;
        StorylyVerticalFeedView storylyVerticalFeedView;
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Intrinsics.checkNotNullParameter((Object)storylyBundle, (String)"storylyBundle");
        String string2 = Intrinsics.stringPlus((String)"STR:STVerticalFeedManager:setPropStoryly:", (Object)storylyBundle);
        System.out.println((Object)string2);
        Object object = storylyBundle.getMap("storylyInit");
        if (object == null) {
            return;
        }
        ReadableMap readableMap = object;
        ReadableMap storylyInitJson = readableMap;
        String string3 = storylyInitJson.getString("storylyId");
        if (string3 == null) {
            return;
        }
        Object storylyId = object = string3;
        ReadableMap readableMap2 = storylyBundle.getMap("verticalFeedGroupStyling");
        if (readableMap2 == null) {
            return;
        }
        String storyGroupStylingJson = string3 = readableMap2;
        ReadableMap readableMap3 = storylyBundle.getMap("verticalFeedBarStyling");
        if (readableMap3 == null) {
            return;
        }
        ReadableMap storyBarStylingJson = readableMap2 = readableMap3;
        ReadableMap readableMap4 = storylyBundle.getMap("verticalFeedCustomization");
        if (readableMap4 == null) {
            return;
        }
        ReadableMap storyStylingJson = readableMap3 = readableMap4;
        ReadableMap readableMap5 = storylyBundle.getMap("verticalFeedItemShareConfig");
        if (readableMap5 == null) {
            return;
        }
        ReadableMap storyShareConfig = readableMap4 = readableMap5;
        ReadableMap readableMap6 = storylyBundle.getMap("verticalFeedItemProductConfig");
        if (readableMap6 == null) {
            return;
        }
        ReadableMap storyProductConfig = readableMap5 = readableMap6;
        StorylyVerticalFeedConfig.Builder storylyConfigBuilder = new StorylyVerticalFeedConfig.Builder();
        storylyConfigBuilder = this.stVerticalFeedInit(storylyInitJson, storylyConfigBuilder);
        readableMap6 = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)readableMap6, (String)"view.context");
        storylyConfigBuilder = this.stVerticalFeedGroupStyling((Context)readableMap6, (ReadableMap)storyGroupStylingJson, storylyConfigBuilder);
        storylyConfigBuilder = this.stVerticalFeedItemBarStyling(storyBarStylingJson, storylyConfigBuilder);
        readableMap6 = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)readableMap6, (String)"view.context");
        storylyConfigBuilder = this.stVerticalFeedCustomization((Context)readableMap6, storyStylingJson, storylyConfigBuilder);
        storylyConfigBuilder = this.stShareConfig(storyShareConfig, storylyConfigBuilder);
        storylyConfigBuilder = this.stProductConfig(storyProductConfig, storylyConfigBuilder);
        StorylyVerticalFeedConfig storylyConfig = storylyConfigBuilder.build();
        this.stFrameworkSet(storylyConfig);
        StorylyVerticalFeedView storylyVerticalFeedView2 = storylyVerticalFeedView = new StorylyVerticalFeedView(view.getActivity$storyly_react_native_debug(), null, 0, 6, null);
        STVerticalFeedView sTVerticalFeedView = view;
        boolean bl = false;
        $this$setPropStoryly_u24lambda_u2d10.setStorylyVerticalFeedInit(new StorylyVerticalFeedInit((String)storylyId, storylyConfig));
        Unit unit = Unit.INSTANCE;
        sTVerticalFeedView.setVerticalFeedView$storyly_react_native_debug(storylyVerticalFeedView);
    }

    @SuppressLint(value={"RestrictedApi"})
    private final void stFrameworkSet(StorylyVerticalFeedConfig config) {
        config.setFramework("rn");
    }

    private final StorylyVerticalFeedConfig.Builder stVerticalFeedInit(ReadableMap json, StorylyVerticalFeedConfig.Builder configBuilder) {
        Object object;
        Set set;
        Object object2;
        Cloneable cloneable;
        ReadableArray readableArray;
        if (json.hasKey("storylySegments")) {
            readableArray = json.getArray("storylySegments");
            cloneable = readableArray == null ? null : readableArray.toArrayList();
            Object object3 = object2 = cloneable instanceof ArrayList ? cloneable : null;
            set = object2 == null ? null : CollectionsKt.toSet((Iterable)((Iterable)object2));
        } else {
            set = null;
        }
        StorylyVerticalFeedConfig.Builder builder = (StorylyVerticalFeedConfig.Builder)((StorylyVerticalFeedConfig.Builder)((StorylyVerticalFeedConfig.Builder)configBuilder.setLabels(set)).setCustomParameter(json.hasKey("customParameter") ? json.getString("customParameter") : null)).setTestMode(json.hasKey("storylyIsTestMode") ? json.getBoolean("storylyIsTestMode") : false);
        if (json.hasKey("userProperty")) {
            readableArray = json.getMap("userProperty");
            cloneable = readableArray == null ? null : readableArray.toHashMap();
            Object object4 = object2 = cloneable instanceof Map ? (Map)((Object)cloneable) : null;
            object = object2 == null ? MapsKt.emptyMap() : object2;
        } else {
            object = MapsKt.emptyMap();
        }
        return (StorylyVerticalFeedConfig.Builder)((StorylyVerticalFeedConfig.Builder)((StorylyVerticalFeedConfig.Builder)builder.setUserData((Map)object)).setLayoutDirection(this.getStorylyLayoutDirection(json.getString("storylyLayoutDirection")))).setLocale(json.hasKey("storylyLocale") ? json.getString("storylyLocale") : null);
    }

    private final StorylyVerticalFeedConfig.Builder stVerticalFeedGroupStyling(Context context, ReadableMap json, StorylyVerticalFeedConfig.Builder configBuilder) {
        Drawable it;
        Drawable drawable2;
        Drawable drawable3;
        StorylyVerticalFeedGroupStyling.Builder groupStylingBuilder = null;
        groupStylingBuilder = new StorylyVerticalFeedGroupStyling.Builder();
        if (json.hasKey("iconBackgroundColor")) {
            groupStylingBuilder = groupStylingBuilder.setIconBackgroundColor(json.getInt("iconBackgroundColor"));
        }
        if (json.hasKey("iconHeight")) {
            groupStylingBuilder = groupStylingBuilder.setIconHeight(json.getInt("iconHeight"));
        }
        if (json.hasKey("iconCornerRadius")) {
            groupStylingBuilder = groupStylingBuilder.setIconCornerRadius(json.getInt("iconCornerRadius"));
        }
        if (json.hasKey("titleTextSize")) {
            groupStylingBuilder = groupStylingBuilder.setTitleTextSize(new Pair((Object)0, (Object)json.getInt("titleTextSize")));
        }
        if (json.hasKey("titleVisible")) {
            groupStylingBuilder = groupStylingBuilder.setTitleVisibility(json.getBoolean("titleVisible"));
        }
        if (json.hasKey("textTypeface")) {
            groupStylingBuilder = groupStylingBuilder.setTypeface(this.getTypeface(context, json.getString("textTypeface")));
        }
        if (json.hasKey("textColor")) {
            groupStylingBuilder = groupStylingBuilder.setTextColor(json.getInt("textColor"));
        }
        if (json.hasKey("typeIndicatorVisible")) {
            groupStylingBuilder = groupStylingBuilder.setTypeIndicatorVisibility(json.getBoolean("typeIndicatorVisible"));
        }
        if (json.hasKey("groupOrder")) {
            groupStylingBuilder = groupStylingBuilder.setGroupOrder(this.getStorylyGroupOrder(json.getString("groupOrder")));
        }
        if (json.hasKey("minLikeCountToShowIcon")) {
            groupStylingBuilder = groupStylingBuilder.setMinLikeCountToShowIcon(json.getInt("minLikeCountToShowIcon"));
        }
        if (json.hasKey("minImpressionCountToShowIcon")) {
            groupStylingBuilder = groupStylingBuilder.setMinImpressionCountToShowIcon(json.getInt("minImpressionCountToShowIcon"));
        }
        if ((drawable3 = this.getDrawable(context, json.hasKey("impressionIcon") ? json.getString("impressionIcon") : null)) != null) {
            it = drawable2 = drawable3;
            boolean bl = false;
            groupStylingBuilder = groupStylingBuilder.setImpressionIcon(it);
        }
        drawable3 = this.getDrawable(context, json.hasKey("likeIcon") ? json.getString("likeIcon") : null);
        if (drawable3 != null) {
            it = drawable2 = drawable3;
            boolean bl = false;
            groupStylingBuilder = groupStylingBuilder.setLikeIcon(it);
        }
        return configBuilder.setVerticalFeedGroupStyling(groupStylingBuilder.build());
    }

    private final StorylyVerticalFeedConfig.Builder stVerticalFeedItemBarStyling(ReadableMap json, StorylyVerticalFeedConfig.Builder configBuilder) {
        return configBuilder.setVerticalFeedBarStyling(new StorylyVerticalFeedBarStyling.Builder().setSection(json.hasKey("sections") ? json.getInt("sections") : 2).setHorizontalEdgePadding(json.hasKey("horizontalEdgePadding") ? json.getInt("horizontalEdgePadding") : this.dpToPixel(4)).setVerticalEdgePadding(json.hasKey("verticalEdgePadding") ? json.getInt("verticalEdgePadding") : this.dpToPixel(4)).setHorizontalPaddingBetweenItems(json.hasKey("horizontalPaddingBetweenItems") ? json.getInt("horizontalPaddingBetweenItems") : this.dpToPixel(8)).setVerticalPaddingBetweenItems(json.hasKey("verticalPaddingBetweenItems") ? json.getInt("verticalPaddingBetweenItems") : this.dpToPixel(8)).build());
    }

    private final StorylyVerticalFeedConfig.Builder stShareConfig(ReadableMap json, StorylyVerticalFeedConfig.Builder configBuilder) {
        String it;
        String string2;
        StorylyShareConfig.Builder shareConfigBuilder = null;
        shareConfigBuilder = new StorylyShareConfig.Builder();
        String string3 = json.getString("storylyShareUrl");
        if (string3 != null) {
            it = string2 = string3;
            boolean bl = false;
            shareConfigBuilder = shareConfigBuilder.setShareUrl(it);
        }
        string3 = json.getString("storylyFacebookAppID");
        if (string3 != null) {
            it = string2 = string3;
            boolean bl = false;
            shareConfigBuilder = shareConfigBuilder.setFacebookAppID(it);
        }
        return (StorylyVerticalFeedConfig.Builder)configBuilder.setShareConfig(shareConfigBuilder.build());
    }

    /*
     * WARNING - void declaration
     */
    private final StorylyVerticalFeedConfig.Builder stProductConfig(ReadableMap json, StorylyVerticalFeedConfig.Builder configBuilder) {
        Map map;
        ReadableMap readableMap;
        StorylyProductConfig.Builder storyProductConfig = null;
        storyProductConfig = new StorylyProductConfig.Builder();
        if (json.hasKey("isFallbackEnabled")) {
            storyProductConfig = storyProductConfig.setFallbackAvailability(json.getBoolean("isFallbackEnabled"));
        }
        if (json.hasKey("isCartEnabled")) {
            storyProductConfig = storyProductConfig.setCartAvailability(json.getBoolean("isCartEnabled"));
        }
        Map map2 = (readableMap = json.getMap("productFeed")) == null ? null : readableMap.toHashMap();
        Map map3 = map = map2 instanceof Map ? (Map)map2 : null;
        if (map != null) {
            void $this$mapValuesTo$iv$iv;
            Map productFeed = map2 = map;
            boolean bl = false;
            Map $this$mapValues$iv = productFeed;
            boolean $i$f$mapValues = false;
            Map map4 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                List list;
                void entry;
                void it$iv$iv;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map5 = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map6 = map5;
                boolean bl3 = false;
                List list2 = (List)entry.getValue();
                if (list2 == null) {
                    list = null;
                } else {
                    void $this$mapTo$iv$iv;
                    List list3;
                    List productList = list3 = list2;
                    boolean bl4 = false;
                    Iterable $this$map$iv = productList;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Map map7 = (Map)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl5 = false;
                        STRProductItem sTRProductItem = STStorylyDataConverterKt.createSTRProductItem((Map<String, ? extends Object>)it);
                        collection.add(sTRProductItem);
                    }
                    list = (List)destination$iv$iv2;
                }
                List list4 = list;
                List list5 = list4 == null ? CollectionsKt.emptyList() : list4;
                map6.put(k, list5);
            }
            Map feed = destination$iv$iv;
            storyProductConfig = storyProductConfig.setProductFeed(feed);
        }
        return (StorylyVerticalFeedConfig.Builder)configBuilder.setProductConfig(storyProductConfig.build());
    }

    private final StorylyVerticalFeedConfig.Builder stVerticalFeedCustomization(Context context, ReadableMap json, StorylyVerticalFeedConfig.Builder configBuilder) {
        ReadableArray readableArray;
        StorylyVerticalFeedCustomization.Builder storyStylingBuilder = null;
        storyStylingBuilder = new StorylyVerticalFeedCustomization.Builder();
        if (json.hasKey("titleFont")) {
            readableArray = storyStylingBuilder.setTitleTypeface(this.getTypeface(context, json.getString("titleFont")));
            Intrinsics.checkNotNullExpressionValue((Object)readableArray, (String)"storyStylingBuilder.setT\u2026.getString(\"titleFont\")))");
            storyStylingBuilder = readableArray;
        }
        if (json.hasKey("interactiveFont")) {
            readableArray = storyStylingBuilder.setInteractiveTypeface(this.getTypeface(context, json.getString("interactiveFont")));
            Intrinsics.checkNotNullExpressionValue((Object)readableArray, (String)"storyStylingBuilder.setI\u2026ring(\"interactiveFont\")))");
            storyStylingBuilder = readableArray;
        }
        if ((readableArray = json.getArray("progressBarColor")) != null) {
            ReadableArray readableArray2;
            ReadableArray it = readableArray2 = readableArray;
            boolean bl = false;
            a.a a2 = storyStylingBuilder.setProgressBarColor(this.convertColorArray(it));
            Intrinsics.checkNotNullExpressionValue((Object)a2, (String)"storyStylingBuilder.setP\u2026or(convertColorArray(it))");
            storyStylingBuilder = a2;
        }
        if (json.hasKey("isTitleVisible")) {
            readableArray = storyStylingBuilder.setTitleVisibility(json.getBoolean("isTitleVisible"));
            Intrinsics.checkNotNullExpressionValue((Object)readableArray, (String)"storyStylingBuilder.setT\u2026oolean(\"isTitleVisible\"))");
            storyStylingBuilder = readableArray;
        }
        if (json.hasKey("isProgressBarVisible")) {
            readableArray = storyStylingBuilder.setTitleVisibility(json.getBoolean("isProgressBarVisible"));
            Intrinsics.checkNotNullExpressionValue((Object)readableArray, (String)"storyStylingBuilder.setT\u2026(\"isProgressBarVisible\"))");
            storyStylingBuilder = readableArray;
        }
        if (json.hasKey("isCloseButtonVisible")) {
            readableArray = storyStylingBuilder.setCloseButtonVisibility(json.getBoolean("isCloseButtonVisible"));
            Intrinsics.checkNotNullExpressionValue((Object)readableArray, (String)"storyStylingBuilder.setC\u2026(\"isCloseButtonVisible\"))");
            storyStylingBuilder = readableArray;
        }
        if (json.hasKey("isLikeButtonVisible")) {
            storyStylingBuilder = storyStylingBuilder.setLikeButtonVisibility(json.getBoolean("isLikeButtonVisible"));
        }
        if (json.hasKey("isShareButtonVisible")) {
            storyStylingBuilder = storyStylingBuilder.setShareButtonVisibility(json.getBoolean("isShareButtonVisible"));
        }
        readableArray = storyStylingBuilder.setCloseButtonIcon(this.getDrawable(context, json.hasKey("closeButtonIcon") ? json.getString("closeButtonIcon") : null));
        Intrinsics.checkNotNullExpressionValue((Object)readableArray, (String)"storyStylingBuilder.setC\u2026eButtonIcon\") else null))");
        storyStylingBuilder = readableArray;
        readableArray = storyStylingBuilder.setShareButtonIcon(this.getDrawable(context, json.hasKey("shareButtonIcon") ? json.getString("shareButtonIcon") : null));
        Intrinsics.checkNotNullExpressionValue((Object)readableArray, (String)"storyStylingBuilder.setS\u2026eButtonIcon\") else null))");
        storyStylingBuilder = readableArray;
        readableArray = storyStylingBuilder.setShareButtonIcon(this.getDrawable(context, json.hasKey("likeButtonIcon") ? json.getString("likeButtonIcon") : null));
        Intrinsics.checkNotNullExpressionValue((Object)readableArray, (String)"storyStylingBuilder.setS\u2026eButtonIcon\") else null))");
        storyStylingBuilder = readableArray;
        return configBuilder.setVerticalFeedStyling(storyStylingBuilder.build());
    }

    private final StorylyLayoutDirection getStorylyLayoutDirection(String layoutDirection) {
        String string2 = layoutDirection;
        return Intrinsics.areEqual((Object)string2, (Object)"ltr") ? StorylyLayoutDirection.LTR : (Intrinsics.areEqual((Object)string2, (Object)"rtl") ? StorylyLayoutDirection.RTL : StorylyLayoutDirection.LTR);
    }

    private final StorylyVerticalFeedGroupOrder getStorylyGroupOrder(String groupOrder) {
        String string2 = groupOrder;
        return Intrinsics.areEqual((Object)string2, (Object)"bySeenState") ? StorylyVerticalFeedGroupOrder.BySeenState : StorylyVerticalFeedGroupOrder.Static;
    }

    private final List<Integer> convertColorArray(ReadableArray colors) {
        ArrayList<Integer> colorsNative = new ArrayList<Integer>();
        int n = 0;
        int n2 = colors.size();
        if (n < n2) {
            do {
                int i = n++;
                colorsNative.add(colors.getInt(i));
            } while (n < n2);
        }
        return colorsNative;
    }

    private final int dpToPixel(int dpValue) {
        return (int)((float)dpValue * ((float)Resources.getSystem().getDisplayMetrics().densityDpi / (float)160));
    }

    private final Typeface getTypeface(Context context, String fontName) {
        String string2 = fontName;
        if (string2 == null) {
            Typeface typeface = Typeface.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)typeface, (String)"DEFAULT");
            return typeface;
        }
        try {
            string2 = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)fontName);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            Typeface.c\u2026sets, fontName)\n        }");
        }
        catch (Exception _) {
            Typeface typeface = Typeface.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)typeface, (String)"{\n            Typeface.DEFAULT\n        }");
            string2 = typeface;
        }
        return string2;
    }

    private final Drawable getDrawable(Context context, String name) {
        String string2 = name;
        if (string2 == null) {
            return null;
        }
        int id2 = context.getResources().getIdentifier(name, "drawable", context.getPackageName());
        return ContextCompat.getDrawable((Context)context, (int)id2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b(\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/appsamurai/storyly/reactnative/verticalFeed/STVerticalFeedManager$Companion;", "", "()V", "COMMAND_APPROVE_CART_CHANGE_CODE", "", "COMMAND_APPROVE_CART_CHANGE_NAME", "", "COMMAND_APPROVE_WISHLIST_CHANGE_CODE", "COMMAND_APPROVE_WISHLIST_CHANGE_NAME", "COMMAND_CLOSE_STORY_CODE", "COMMAND_CLOSE_STORY_NAME", "COMMAND_HYDRATE_PRODUCT_CODE", "COMMAND_HYDRATE_PRODUCT_NAME", "COMMAND_HYDRATE_WISHLIST_CODE", "COMMAND_HYDRATE_WISHLIST_NAME", "COMMAND_OPEN_CODE", "COMMAND_OPEN_NAME", "COMMAND_OPEN_WITH_ID_CODE", "COMMAND_OPEN_WITH_ID_NAME", "COMMAND_PAUSE_STORY_CODE", "COMMAND_PAUSE_STORY_NAME", "COMMAND_REFRESH_CODE", "COMMAND_REFRESH_NAME", "COMMAND_REJECT_CART_CHANGE_CODE", "COMMAND_REJECT_CART_CHANGE_NAME", "COMMAND_REJECT_WISHLIST_CHANGE_CODE", "COMMAND_REJECT_WISHLIST_CHANGE_NAME", "COMMAND_RESUME_STORY_CODE", "COMMAND_RESUME_STORY_NAME", "COMMAND_UPDATE_CART_CODE", "COMMAND_UPDATE_CART_NAME", "EVENT_ON_CREATE_CUSTOM_VIEW", "EVENT_ON_UPDATE_CUSTOM_VIEW", "EVENT_STORYLY_ACTION_CLICKED", "EVENT_STORYLY_EVENT", "EVENT_STORYLY_LOADED", "EVENT_STORYLY_LOAD_FAILED", "EVENT_STORYLY_ON_CART_UPDATED", "EVENT_STORYLY_ON_HYDRATION", "EVENT_STORYLY_ON_WISHLIST_UPDATED", "EVENT_STORYLY_PRODUCT_EVENT", "EVENT_STORYLY_USER_INTERACTED", "EVENT_STORYLY_VERTICAL_FEED_DISMISSED", "EVENT_STORYLY_VERTICAL_FEED_PRESENTED", "EVENT_STORYLY_VERTICAL_FEED_PRESENT_FAILED", "REACT_CLASS", "storyly-react-native_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

