/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.OverlayAnalystNative;
import com.supermap.analyst.spatialanalyst.OverlayAnalystParameter;
import com.supermap.analyst.spatialanalyst.e;
import com.supermap.analyst.spatialanalyst.f;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandle;
import com.supermap.data.Recordset;

public class OverlayAnalyst {
    private OverlayAnalyst() {
    }

    public static boolean clip(DatasetVector datasetVector, DatasetVector datasetVector2, DatasetVector datasetVector3, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = e.a((InternalHandle)datasetVector);
        if (datasetVector2 == null || e.a((InternalHandle)datasetVector2) == 0L) {
            String string = f.a("clipDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = e.a((InternalHandle)datasetVector2);
        if (datasetVector3 == null || e.a((InternalHandle)datasetVector3) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = e.a((InternalHandle)datasetVector3);
        if (datasetVector2.getType() != DatasetType.REGION) {
            String string = f.a("clipDataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != DatasetType.POINT && datasetVector.getType() != DatasetType.LINE && datasetVector.getType() != DatasetType.REGION) {
            String string = f.a("dataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector3.getType() != datasetVector.getType()) {
            String string = f.a("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.equals(datasetVector2) || l == l2) {
            String string = f.a("", "OverlayAnalyst_SourceDatasetAndOperationDatasetShouldBeDifferent", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (overlayAnalystParameter != null) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_DatasetClip(l, l2, l3, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean clip(Recordset recordset, Recordset recordset2, DatasetVector datasetVector, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (recordset == null || e.a((InternalHandle)recordset) == 0L) {
            String string = f.a("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = e.a((InternalHandle)recordset);
        if (recordset2 == null || e.a((InternalHandle)recordset2) == 0L) {
            String string = f.a("clipRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = e.a((InternalHandle)recordset2);
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = e.a((InternalHandle)datasetVector);
        if (recordset2.getDataset().getType() != DatasetType.REGION) {
            String string = f.a("clipRecordset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset.getDataset().getType() != DatasetType.POINT && recordset.getDataset().getType() != DatasetType.LINE && recordset.getDataset().getType() != DatasetType.REGION) {
            String string = f.a("recordset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != recordset.getDataset().getType()) {
            String string = f.a("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (null != overlayAnalystParameter) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_RecordsetClip(l, l2, l3, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean clip(DatasetVector datasetVector, Geometry[] geometryArray, DatasetVector datasetVector2, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (geometryArray == null) {
            String string = f.a("clipGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = geometryArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            if (geometryArray[i].getType() != GeometryType.GEOREGION) {
                String string = f.a("clipGeometries", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = e.a((InternalHandle)geometryArray[i]);
            if (l == 0L) {
                String string = f.a("clipGeometries", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            lArray[i] = l;
        }
        if (datasetVector.getType() != DatasetType.POINT && datasetVector.getType() != DatasetType.LINE && datasetVector.getType() != DatasetType.REGION) {
            String string = f.a("dataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector2 == null || e.a((InternalHandle)datasetVector2) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (datasetVector2.getType() != datasetVector.getType()) {
            String string = f.a("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (overlayAnalystParameter != null) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        long l = e.a((InternalHandle)datasetVector);
        long l2 = e.a((InternalHandle)datasetVector2);
        boolean bl = OverlayAnalystNative.jni_GeometryClip(l, lArray, l2, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean erase(DatasetVector datasetVector, DatasetVector datasetVector2, DatasetVector datasetVector3, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = e.a((InternalHandle)datasetVector);
        if (datasetVector2 == null || e.a((InternalHandle)datasetVector2) == 0L) {
            String string = f.a("eraseDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = e.a((InternalHandle)datasetVector2);
        if (datasetVector3 == null || e.a((InternalHandle)datasetVector3) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = e.a((InternalHandle)datasetVector3);
        if (datasetVector2.getType() != DatasetType.REGION) {
            String string = f.a("eraseDataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != DatasetType.POINT && datasetVector.getType() != DatasetType.LINE && datasetVector.getType() != DatasetType.REGION) {
            String string = f.a("dataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector3.getType() != datasetVector.getType()) {
            String string = f.a("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.equals(datasetVector2) || l == l2) {
            String string = f.a("", "OverlayAnalyst_SourceDatasetAndOperationDatasetShouldBeDifferent", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (null != overlayAnalystParameter) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_DatasetErase(l, l2, l3, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean erase(Recordset recordset, Recordset recordset2, DatasetVector datasetVector, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (recordset == null || e.a((InternalHandle)recordset) == 0L) {
            String string = f.a("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = e.a((InternalHandle)recordset);
        if (recordset2 == null || e.a((InternalHandle)recordset2) == 0L) {
            String string = f.a("eraseRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = e.a((InternalHandle)recordset2);
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = e.a((InternalHandle)datasetVector);
        if (recordset2.getDataset().getType() != DatasetType.REGION) {
            String string = f.a("eraseRecordset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset.getDataset().getType() != DatasetType.POINT && recordset.getDataset().getType() != DatasetType.LINE && recordset.getDataset().getType() != DatasetType.REGION) {
            String string = f.a("recordset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != recordset.getDataset().getType()) {
            String string = f.a("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (null != overlayAnalystParameter) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_RecordsetErase(l, l2, l3, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean erase(DatasetVector datasetVector, Geometry[] geometryArray, DatasetVector datasetVector2, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (geometryArray == null) {
            String string = f.a("eraseGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = geometryArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            if (geometryArray[i].getType() != GeometryType.GEOREGION) {
                String string = f.a("eraseGeometries", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = e.a((InternalHandle)geometryArray[i]);
            if (l == 0L) {
                String string = f.a("eraseGeometries", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            lArray[i] = l;
        }
        if (datasetVector.getType() != DatasetType.POINT && datasetVector.getType() != DatasetType.LINE && datasetVector.getType() != DatasetType.REGION) {
            String string = f.a("dataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector2 == null || e.a((InternalHandle)datasetVector2) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (datasetVector2.getType() != datasetVector.getType()) {
            String string = f.a("resultDataset", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (null != overlayAnalystParameter) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        long l = e.a((InternalHandle)datasetVector);
        long l2 = e.a((InternalHandle)datasetVector2);
        boolean bl = OverlayAnalystNative.jni_GeometryErase(l, lArray, l2, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean identity(DatasetVector datasetVector, DatasetVector datasetVector2, DatasetVector datasetVector3, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = e.a((InternalHandle)datasetVector);
        if (datasetVector2 == null || e.a((InternalHandle)datasetVector2) == 0L) {
            String string = f.a("identityDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = e.a((InternalHandle)datasetVector2);
        if (datasetVector3 == null || e.a((InternalHandle)datasetVector3) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = e.a((InternalHandle)datasetVector3);
        if (datasetVector2.getType() != DatasetType.REGION) {
            String string = f.a("identityDataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != DatasetType.POINT && datasetVector.getType() != DatasetType.LINE && datasetVector.getType() != DatasetType.REGION) {
            String string = f.a("dataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector3.getType() != datasetVector.getType()) {
            String string = f.a("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.equals(datasetVector2) || l == l2) {
            String string = f.a("", "OverlayAnalyst_SourceDatasetAndOperationDatasetShouldBeDifferent", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (null != overlayAnalystParameter) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_DatasetIdentity(l, l2, l3, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean identity(Recordset recordset, Recordset recordset2, DatasetVector datasetVector, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (recordset == null || e.a((InternalHandle)recordset) == 0L) {
            String string = f.a("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = e.a((InternalHandle)recordset);
        if (recordset2 == null || e.a((InternalHandle)recordset2) == 0L) {
            String string = f.a("identityRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = e.a((InternalHandle)recordset2);
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = e.a((InternalHandle)datasetVector);
        if (recordset2.getDataset().getType() != DatasetType.REGION) {
            String string = f.a("identityRecordset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset.getDataset().getType() != DatasetType.POINT && recordset.getDataset().getType() != DatasetType.LINE && recordset.getDataset().getType() != DatasetType.REGION) {
            String string = f.a("recordset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != recordset.getDataset().getType()) {
            String string = f.a("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (null != overlayAnalystParameter) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_RecordsetIdentity(l, l2, l3, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean identity(DatasetVector datasetVector, Geometry[] geometryArray, DatasetVector datasetVector2, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (geometryArray == null) {
            String string = f.a("identityGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = geometryArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            if (geometryArray[i].getType() != GeometryType.GEOREGION) {
                String string = f.a("identityGeometries", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = e.a((InternalHandle)geometryArray[i]);
            if (l == 0L) {
                String string = f.a("identityGeometries", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            lArray[i] = l;
        }
        if (datasetVector.getType() != DatasetType.POINT && datasetVector.getType() != DatasetType.LINE && datasetVector.getType() != DatasetType.REGION) {
            String string = f.a("dataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector2 == null || e.a((InternalHandle)datasetVector2) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (datasetVector2.getType() != datasetVector.getType()) {
            String string = f.a("resultDataset", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (null != overlayAnalystParameter) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        long l = e.a((InternalHandle)datasetVector);
        long l2 = e.a((InternalHandle)datasetVector2);
        boolean bl = OverlayAnalystNative.jni_GeometryIdentity(l, lArray, l2, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean intersect(DatasetVector datasetVector, DatasetVector datasetVector2, DatasetVector datasetVector3, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = e.a((InternalHandle)datasetVector);
        if (datasetVector2 == null || e.a((InternalHandle)datasetVector2) == 0L) {
            String string = f.a("intersectDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = e.a((InternalHandle)datasetVector2);
        if (datasetVector3 == null || e.a((InternalHandle)datasetVector3) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = e.a((InternalHandle)datasetVector3);
        if (datasetVector2.getType() != DatasetType.REGION) {
            String string = f.a("intersectDataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != DatasetType.POINT && datasetVector.getType() != DatasetType.LINE && datasetVector.getType() != DatasetType.REGION) {
            String string = f.a("dataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector3.getType() != datasetVector.getType()) {
            String string = f.a("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.equals(datasetVector2) || l == l2) {
            String string = f.a("", "OverlayAnalyst_SourceDatasetAndOperationDatasetShouldBeDifferent", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (null != overlayAnalystParameter) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_DatasetIntersect(l, l2, l3, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean intersect(Recordset recordset, Recordset recordset2, DatasetVector datasetVector, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (recordset == null || e.a((InternalHandle)recordset) == 0L) {
            String string = f.a("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = e.a((InternalHandle)recordset);
        if (recordset2 == null || e.a((InternalHandle)recordset2) == 0L) {
            String string = f.a("intersectRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = e.a((InternalHandle)recordset2);
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = e.a((InternalHandle)datasetVector);
        if (recordset2.getDataset().getType() != DatasetType.REGION) {
            String string = f.a("intersectRecordset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset.getDataset().getType() != DatasetType.POINT && recordset.getDataset().getType() != DatasetType.LINE && recordset.getDataset().getType() != DatasetType.REGION) {
            String string = f.a("recordset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != recordset.getDataset().getType()) {
            String string = f.a("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (null != overlayAnalystParameter) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_RecordsetIntersect(l, l2, l3, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean intersect(DatasetVector datasetVector, Geometry[] geometryArray, DatasetVector datasetVector2, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (geometryArray == null) {
            String string = f.a("intersectGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = geometryArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            if (geometryArray[i].getType() != GeometryType.GEOREGION) {
                String string = f.a("intersectGeometries", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = e.a((InternalHandle)geometryArray[i]);
            if (l == 0L) {
                String string = f.a("intersectGeometries", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            lArray[i] = l;
        }
        if (datasetVector.getType() != DatasetType.POINT && datasetVector.getType() != DatasetType.LINE && datasetVector.getType() != DatasetType.REGION) {
            String string = f.a("dataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector2 == null || e.a((InternalHandle)datasetVector2) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (datasetVector2.getType() != datasetVector.getType()) {
            String string = f.a("resultDataset", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (overlayAnalystParameter != null) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        long l = e.a((InternalHandle)datasetVector);
        long l2 = e.a((InternalHandle)datasetVector2);
        boolean bl = OverlayAnalystNative.jni_GeometryIntersect(l, lArray, l2, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean xOR(DatasetVector datasetVector, DatasetVector datasetVector2, DatasetVector datasetVector3, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = e.a((InternalHandle)datasetVector);
        if (datasetVector2 == null || e.a((InternalHandle)datasetVector2) == 0L) {
            String string = f.a("xORDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = e.a((InternalHandle)datasetVector2);
        if (datasetVector3 == null || e.a((InternalHandle)datasetVector3) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = e.a((InternalHandle)datasetVector3);
        if (datasetVector.getType() != DatasetType.REGION) {
            String string = f.a("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector2.getType() != DatasetType.REGION) {
            String string = f.a("xORDataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector3.getType() != datasetVector.getType()) {
            String string = f.a("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.equals(datasetVector2) || l == l2) {
            String string = f.a("", "OverlayAnalyst_SourceDatasetAndOperationDatasetShouldBeDifferent", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (null != overlayAnalystParameter) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_DatasetXOR(l, l2, l3, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean xOR(Recordset recordset, Recordset recordset2, DatasetVector datasetVector, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (recordset == null || e.a((InternalHandle)recordset) == 0L) {
            String string = f.a("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = e.a((InternalHandle)recordset);
        if (recordset2 == null || e.a((InternalHandle)recordset2) == 0L) {
            String string = f.a("xORRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = e.a((InternalHandle)recordset2);
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = e.a((InternalHandle)datasetVector);
        if (recordset.getDataset().getType() != DatasetType.REGION) {
            String string = f.a("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset2.getDataset().getType() != DatasetType.REGION) {
            String string = f.a("xORRecordset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != recordset.getDataset().getType()) {
            String string = f.a("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (overlayAnalystParameter != null) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_RecordsetXOR(l, l2, l3, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean xOR(DatasetVector datasetVector, Geometry[] geometryArray, DatasetVector datasetVector2, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (geometryArray == null) {
            String string = f.a("xorGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = geometryArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            if (geometryArray[i].getType() != GeometryType.GEOREGION) {
                String string = f.a("xorGeometries", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = e.a((InternalHandle)geometryArray[i]);
            if (l == 0L) {
                String string = f.a("xorGeometries", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            lArray[i] = l;
        }
        if (datasetVector.getType() != DatasetType.REGION) {
            String string = f.a("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector2 == null || e.a((InternalHandle)datasetVector2) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (datasetVector2.getType() != datasetVector.getType()) {
            String string = f.a("resultDataset", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (overlayAnalystParameter != null) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        long l = e.a((InternalHandle)datasetVector);
        long l2 = e.a((InternalHandle)datasetVector2);
        boolean bl = OverlayAnalystNative.jni_GeometryXOR(l, lArray, l2, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean union(DatasetVector datasetVector, DatasetVector datasetVector2, DatasetVector datasetVector3, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = e.a((InternalHandle)datasetVector);
        if (datasetVector2 == null || e.a((InternalHandle)datasetVector2) == 0L) {
            String string = f.a("unionDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = e.a((InternalHandle)datasetVector2);
        if (datasetVector3 == null || e.a((InternalHandle)datasetVector3) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = e.a((InternalHandle)datasetVector3);
        if (datasetVector.getType() != DatasetType.REGION) {
            String string = f.a("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector2.getType() != DatasetType.REGION) {
            String string = f.a("unionDataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector3.getType() != datasetVector.getType()) {
            String string = f.a("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.equals(datasetVector2) || l == l2) {
            String string = f.a("", "OverlayAnalyst_SourceDatasetAndOperationDatasetShouldBeDifferent", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (null != overlayAnalystParameter) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_DatasetUnion(l, l2, l3, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean union(Recordset recordset, Recordset recordset2, DatasetVector datasetVector, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (recordset == null || e.a((InternalHandle)recordset) == 0L) {
            String string = f.a("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = e.a((InternalHandle)recordset);
        if (recordset2 == null || e.a((InternalHandle)recordset2) == 0L) {
            String string = f.a("unionRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = e.a((InternalHandle)recordset2);
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = e.a((InternalHandle)datasetVector);
        if (recordset.getDataset().getType() != DatasetType.REGION) {
            String string = f.a("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset2.getDataset().getType() != DatasetType.REGION) {
            String string = f.a("unionRecordset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != recordset.getDataset().getType()) {
            String string = f.a("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (null != overlayAnalystParameter) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_RecordsetUnion(l, l2, l3, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean union(DatasetVector datasetVector, Geometry[] geometryArray, DatasetVector datasetVector2, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (geometryArray == null) {
            String string = f.a("unionGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = geometryArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            if (geometryArray[i].getType() != GeometryType.GEOREGION) {
                String string = f.a("unionGeometries", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = e.a((InternalHandle)geometryArray[i]);
            if (l == 0L) {
                String string = f.a("unionGeometries", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            lArray[i] = l;
        }
        if (datasetVector.getType() != DatasetType.REGION) {
            String string = f.a("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector2 == null || e.a((InternalHandle)datasetVector2) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (datasetVector2.getType() != datasetVector.getType()) {
            String string = f.a("resultDataset", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (overlayAnalystParameter != null) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        long l = e.a((InternalHandle)datasetVector);
        long l2 = e.a((InternalHandle)datasetVector2);
        boolean bl = OverlayAnalystNative.jni_GeometryUnion(l, lArray, l2, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean update(DatasetVector datasetVector, DatasetVector datasetVector2, DatasetVector datasetVector3, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = e.a((InternalHandle)datasetVector);
        if (datasetVector2 == null || e.a((InternalHandle)datasetVector2) == 0L) {
            String string = f.a("updateDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = e.a((InternalHandle)datasetVector2);
        if (datasetVector3 == null || e.a((InternalHandle)datasetVector3) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = e.a((InternalHandle)datasetVector3);
        if (datasetVector.getType() != DatasetType.REGION) {
            String string = f.a("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector2.getType() != DatasetType.REGION) {
            String string = f.a("updateDataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector3.getType() != datasetVector.getType()) {
            String string = f.a("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.equals(datasetVector2) || l == l2) {
            String string = f.a("", "OverlayAnalyst_SourceDatasetAndOperationDatasetShouldBeDifferent", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (null != overlayAnalystParameter) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_DatasetUpdate(l, l2, l3, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean update(Recordset recordset, Recordset recordset2, DatasetVector datasetVector, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (recordset == null || e.a((InternalHandle)recordset) == 0L) {
            String string = f.a("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = e.a((InternalHandle)recordset);
        if (recordset == null || e.a((InternalHandle)recordset2) == 0L) {
            String string = f.a("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = e.a((InternalHandle)recordset2);
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = e.a((InternalHandle)datasetVector);
        if (recordset.getDataset().getType() != DatasetType.REGION) {
            String string = f.a("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset2.getDataset().getType() != DatasetType.REGION) {
            String string = f.a("updateRecordset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != recordset.getDataset().getType()) {
            String string = f.a("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (null != overlayAnalystParameter) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_RecordsetUpdate(l, l2, l3, stringArray, stringArray2, d2);
        return bl;
    }

    public static boolean update(DatasetVector datasetVector, Geometry[] geometryArray, DatasetVector datasetVector2, OverlayAnalystParameter overlayAnalystParameter) {
        OverlayAnalyst.verifyLicense();
        if (datasetVector == null || e.a((InternalHandle)datasetVector) == 0L) {
            String string = f.a("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (geometryArray == null) {
            String string = f.a("updateGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = geometryArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            if (geometryArray[i].getType() != GeometryType.GEOREGION) {
                String string = f.a("updateGeometries", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = e.a((InternalHandle)geometryArray[i]);
            if (l == 0L) {
                String string = f.a("updateGeometries", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            lArray[i] = l;
        }
        if (datasetVector.getType() != DatasetType.REGION) {
            String string = f.a("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector2 == null || e.a((InternalHandle)datasetVector2) == 0L) {
            String string = f.a("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (datasetVector2.getType() != datasetVector.getType()) {
            String string = f.a("resultDataset", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d2 = 1.0E-10;
        if (overlayAnalystParameter != null) {
            stringArray = overlayAnalystParameter.getSourceRetainedFields();
            stringArray2 = overlayAnalystParameter.getOperationRetainedFields();
            d2 = overlayAnalystParameter.getTolerance();
        }
        long l = e.a((InternalHandle)datasetVector);
        long l2 = e.a((InternalHandle)datasetVector2);
        boolean bl = OverlayAnalystNative.jni_GeometryUpdate(l, lArray, l2, stringArray, stringArray2, d2);
        return bl;
    }

    private static void verifyLicense() {
    }
}

