/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.charts.BarChart;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.charts.HorizontalBarChart;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.BarLineScatterCandleBubbleData;
import com.github.mikephil.charting.data.BaseDataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.highlight.ChartHighlighter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BarLineScatterCandleBubbleDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarLineScatterCandleBubbleDataSet;
import com.github.mikephil.charting.jobs.AnimatedMoveViewJob;
import com.github.mikephil.charting.jobs.AnimatedZoomJob;
import com.github.mikephil.charting.jobs.MoveViewJob;
import com.github.mikephil.charting.jobs.ZoomJob;
import com.github.mikephil.charting.listener.BarLineChartTouchListener;
import com.github.mikephil.charting.listener.OnChartHighLightListener;
import com.github.mikephil.charting.listener.OnDrawListener;
import com.github.mikephil.charting.renderer.XAxisRenderer;
import com.github.mikephil.charting.renderer.YAxisRenderer;
import com.github.mikephil.charting.utils.PointD;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@SuppressLint(value={"RtlHardcoded"})
public abstract class BarLineChartBase<T extends BarLineScatterCandleBubbleData<? extends IBarLineScatterCandleBubbleDataSet<? extends Entry>>>
extends Chart<T>
implements BarLineScatterCandleBubbleDataProvider {
    protected int mMaxVisibleCount = 100;
    private boolean a;
    private Integer a;
    private Integer b;
    protected boolean mPinchZoomEnabled = false;
    protected boolean mDoubleTapToZoomEnabled = true;
    protected boolean mHighlightPerDragEnabled = true;
    private boolean b;
    private boolean c = true;
    private boolean d = true;
    protected Paint mGridBackgroundPaint;
    protected Paint mBorderPaint;
    protected boolean mDrawGridBackground = false;
    protected boolean mDrawBorders = false;
    protected float mMinOffset = 15.0f;
    protected boolean mKeepPositionOnRotation = false;
    protected OnDrawListener mDrawListener;
    protected YAxis mAxisLeft;
    protected YAxis mAxisRight;
    protected XAxis mXAxis;
    protected YAxisRenderer mAxisRendererLeft;
    protected YAxisRenderer mAxisRendererRight;
    protected Transformer mLeftAxisTransformer;
    protected Transformer mRightAxisTransformer;
    protected XAxisRenderer mXAxisRenderer;
    private long a = 0L;
    private long b;
    public static String mStr = null;
    private boolean e = false;
    private int b = -1;

    public BarLineChartBase(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    public BarLineChartBase(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public BarLineChartBase(Context context) {
        super(context);
    }

    @Override
    protected void init() {
        super.init();
        this.mAxisLeft = new YAxis(YAxis.AxisDependency.LEFT);
        this.mAxisRight = new YAxis(YAxis.AxisDependency.RIGHT);
        this.mXAxis = new XAxis();
        this.mLeftAxisTransformer = new Transformer(this.mViewPortHandler);
        this.mRightAxisTransformer = new Transformer(this.mViewPortHandler);
        this.mAxisRendererLeft = new YAxisRenderer(this.mViewPortHandler, this.mAxisLeft, this.mLeftAxisTransformer);
        this.mAxisRendererRight = new YAxisRenderer(this.mViewPortHandler, this.mAxisRight, this.mRightAxisTransformer);
        this.mXAxisRenderer = new XAxisRenderer(this.mViewPortHandler, this.mXAxis, this.mLeftAxisTransformer);
        this.setHighlighter(new ChartHighlighter<BarLineChartBase>(this));
        this.mChartTouchListener = new BarLineChartTouchListener(this, this.mViewPortHandler.getMatrixTouch());
        this.mGridBackgroundPaint = new Paint();
        this.mGridBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mGridBackgroundPaint.setColor(Color.rgb((int)240, (int)240, (int)240));
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setColor(-16777216);
        this.mBorderPaint.setStrokeWidth(Utils.convertDpToPixel(1.0f));
    }

    @Override
    protected void onDraw(Canvas canvas) {
        int n;
        super.onDraw(canvas);
        if (this.mData == null) {
            return;
        }
        long l = System.currentTimeMillis();
        this.calcModulus();
        this.mXAxisRenderer.calcXBounds(this, this.mXAxis.mAxisLabelModulus);
        this.mRenderer.calcXBounds(this, this.mXAxis.mAxisLabelModulus);
        this.drawGridBackground(canvas);
        if (this.mAxisLeft.isEnabled()) {
            this.mAxisRendererLeft.computeAxis(this.mAxisLeft.mAxisMinimum, this.mAxisLeft.mAxisMaximum);
        }
        if (this.mAxisRight.isEnabled()) {
            this.mAxisRendererRight.computeAxis(this.mAxisRight.mAxisMinimum, this.mAxisRight.mAxisMaximum);
        }
        this.mXAxisRenderer.renderAxisLine(canvas);
        this.mAxisRendererLeft.renderAxisLine(canvas);
        this.mAxisRendererRight.renderAxisLine(canvas);
        if (this.a) {
            n = this.getLowestVisibleXIndex();
            int n2 = this.getHighestVisibleXIndex();
            if (this.a == null || this.a != n || this.b == null || this.b != n2) {
                this.calcMinMax();
                this.calculateOffsets();
                this.a = n;
                this.b = n2;
            }
        }
        n = canvas.save();
        canvas.clipRect(this.mViewPortHandler.getContentRect());
        this.mXAxisRenderer.renderGridLines(canvas);
        this.mAxisRendererLeft.renderGridLines(canvas);
        this.mAxisRendererRight.renderGridLines(canvas);
        this.mXAxisRenderer.renderIndexMarkLines(canvas);
        this.mAxisRendererLeft.renderIndexMarkLines(canvas);
        if (this.mXAxis.isDrawLimitLinesBehindDataEnabled()) {
            this.mXAxisRenderer.renderLimitLines(canvas);
        }
        if (this.mAxisLeft.isDrawLimitLinesBehindDataEnabled()) {
            this.mAxisRendererLeft.renderLimitLines(canvas);
        }
        if (this.mAxisRight.isDrawLimitLinesBehindDataEnabled()) {
            this.mAxisRendererRight.renderLimitLines(canvas);
        }
        this.mRenderer.drawData(canvas);
        if (!this.mXAxis.isDrawLimitLinesBehindDataEnabled()) {
            this.mXAxisRenderer.renderLimitLines(canvas);
        }
        if (!this.mAxisLeft.isDrawLimitLinesBehindDataEnabled()) {
            this.mAxisRendererLeft.renderLimitLines(canvas);
        }
        if (!this.mAxisRight.isDrawLimitLinesBehindDataEnabled()) {
            this.mAxisRendererRight.renderLimitLines(canvas);
        }
        if (this.valuesToHighlight()) {
            this.mRenderer.drawHighlighted(canvas, this.mIndicesToHighlight);
        }
        canvas.restoreToCount(n);
        this.mRenderer.drawExtras(canvas);
        this.mXAxisRenderer.renderAxisLabels(canvas);
        this.mAxisRendererLeft.renderAxisLabels(canvas);
        this.mAxisRendererRight.renderAxisLabels(canvas);
        this.mRenderer.drawValues(canvas);
        this.mLegendRenderer.renderLegend(canvas);
        this.drawMarkers(canvas);
        this.drawDescription(canvas);
        if (this.mLogEnabled) {
            long l2 = System.currentTimeMillis() - l;
            this.a += l2;
            ++this.b;
            long l3 = this.a / this.b;
            Log.i((String)"MPAndroidChart", (String)("Drawtime: " + l2 + " ms, average: " + l3 + " ms, cycles: " + this.b));
        }
    }

    public void resetTracking() {
        this.a = 0L;
        this.b = 0L;
    }

    protected void prepareValuePxMatrix() {
        if (this.mLogEnabled) {
            Log.i((String)"MPAndroidChart", (String)("Preparing Value-Px Matrix, xmin: " + this.mXChartMin + ", xmax: " + this.mXChartMax + ", xdelta: " + this.mDeltaX));
        }
        this.mRightAxisTransformer.prepareMatrixValuePx(this.mXChartMin, this.mDeltaX, this.mAxisRight.mAxisRange, this.mAxisRight.mAxisMinimum);
        this.mLeftAxisTransformer.prepareMatrixValuePx(this.mXChartMin, this.mDeltaX, this.mAxisLeft.mAxisRange, this.mAxisLeft.mAxisMinimum);
    }

    protected void prepareOffsetMatrix() {
        this.mRightAxisTransformer.prepareMatrixOffset(this.mAxisRight.isInverted());
        this.mLeftAxisTransformer.prepareMatrixOffset(this.mAxisLeft.isInverted());
    }

    @Override
    public void notifyDataSetChanged() {
        if (this.mData == null) {
            if (this.mLogEnabled) {
                Log.i((String)"MPAndroidChart", (String)"Preparing... DATA NOT SET.");
            }
            return;
        }
        if (this.mLogEnabled) {
            Log.i((String)"MPAndroidChart", (String)"Preparing...");
        }
        if (this.mRenderer != null) {
            this.mRenderer.initBuffers();
        }
        this.calcMinMax();
        this.mAxisRendererLeft.computeAxis(this.mAxisLeft.mAxisMinimum, this.mAxisLeft.mAxisMaximum);
        this.mAxisRendererRight.computeAxis(this.mAxisRight.mAxisMinimum, this.mAxisRight.mAxisMaximum);
        this.mXAxisRenderer.computeAxis(((BarLineScatterCandleBubbleData)this.mData).getXValMaximumLength(), ((BarLineScatterCandleBubbleData)this.mData).getXVals());
        if (this.mLegend != null) {
            this.mLegendRenderer.computeLegend(this.mData);
        }
        this.calculateOffsets();
    }

    @Override
    protected void calcMinMax() {
        if (this.a) {
            ((BarLineScatterCandleBubbleData)this.mData).calcMinMax(this.getLowestVisibleXIndex(), this.getHighestVisibleXIndex());
        }
        float f = !Float.isNaN(this.mAxisLeft.getAxisMinValue()) ? this.mAxisLeft.getAxisMinValue() : ((BarLineScatterCandleBubbleData)this.mData).getYMin(YAxis.AxisDependency.LEFT);
        float f2 = !Float.isNaN(this.mAxisLeft.getAxisMaxValue()) ? this.mAxisLeft.getAxisMaxValue() : ((BarLineScatterCandleBubbleData)this.mData).getYMax(YAxis.AxisDependency.LEFT);
        float f3 = !Float.isNaN(this.mAxisRight.getAxisMinValue()) ? this.mAxisRight.getAxisMinValue() : ((BarLineScatterCandleBubbleData)this.mData).getYMin(YAxis.AxisDependency.RIGHT);
        float f4 = !Float.isNaN(this.mAxisRight.getAxisMaxValue()) ? this.mAxisRight.getAxisMaxValue() : ((BarLineScatterCandleBubbleData)this.mData).getYMax(YAxis.AxisDependency.RIGHT);
        float f5 = Math.abs(f2 - f);
        float f6 = Math.abs(f4 - f3);
        if (f5 == 0.0f) {
            f2 += 1.0f;
            f -= 1.0f;
        }
        if (f6 == 0.0f) {
            f4 += 1.0f;
            f3 -= 1.0f;
        }
        float f7 = f5 / 100.0f * this.mAxisLeft.getSpaceTop();
        float f8 = f6 / 100.0f * this.mAxisRight.getSpaceTop();
        float f9 = f5 / 100.0f * this.mAxisLeft.getSpaceBottom();
        float f10 = f6 / 100.0f * this.mAxisRight.getSpaceBottom();
        this.mXChartMax = ((BarLineScatterCandleBubbleData)this.mData).getXVals().size() - 1;
        this.mDeltaX = Math.abs(this.mXChartMax - this.mXChartMin);
        this.mAxisLeft.mAxisMinimum = !Float.isNaN(this.mAxisLeft.getAxisMinValue()) ? this.mAxisLeft.getAxisMinValue() : f - f9;
        this.mAxisLeft.mAxisMaximum = !Float.isNaN(this.mAxisLeft.getAxisMaxValue()) ? this.mAxisLeft.getAxisMaxValue() : f2 + f7;
        this.mAxisRight.mAxisMinimum = !Float.isNaN(this.mAxisRight.getAxisMinValue()) ? this.mAxisRight.getAxisMinValue() : f3 - f10;
        this.mAxisRight.mAxisMaximum = !Float.isNaN(this.mAxisRight.getAxisMaxValue()) ? this.mAxisRight.getAxisMaxValue() : f4 + f8;
        this.mAxisLeft.mAxisRange = Math.abs(this.mAxisLeft.mAxisMaximum - this.mAxisLeft.mAxisMinimum);
        this.mAxisRight.mAxisRange = Math.abs(this.mAxisRight.mAxisMaximum - this.mAxisRight.mAxisMinimum);
    }

    @Override
    public void calculateOffsets() {
        if (!this.e) {
            float f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            if (this.mLegend != null && this.mLegend.isEnabled()) {
                if (this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART || this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART_CENTER) {
                    f3 += Math.min(this.mLegend.mNeededWidth, this.mViewPortHandler.getChartWidth() * this.mLegend.getMaxSizePercent()) + this.mLegend.getXOffset() * 2.0f;
                } else if (this.mLegend.getPosition() == Legend.LegendPosition.LEFT_OF_CHART || this.mLegend.getPosition() == Legend.LegendPosition.LEFT_OF_CHART_CENTER) {
                    f2 += Math.min(this.mLegend.mNeededWidth, this.mViewPortHandler.getChartWidth() * this.mLegend.getMaxSizePercent()) + this.mLegend.getXOffset() * 2.0f;
                } else if (this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_LEFT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_RIGHT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_CENTER) {
                    f = this.mLegend.mTextHeightMax;
                    f5 += Math.min(this.mLegend.mNeededHeight + f, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent());
                } else if (this.mLegend.getPosition() == Legend.LegendPosition.ABOVE_CHART_LEFT || this.mLegend.getPosition() == Legend.LegendPosition.ABOVE_CHART_RIGHT || this.mLegend.getPosition() == Legend.LegendPosition.ABOVE_CHART_CENTER) {
                    f = this.mLegend.mTextHeightMax;
                    f4 += Math.min(this.mLegend.mNeededHeight + f, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent());
                }
            }
            if (this.mAxisLeft.needsOffset()) {
                f2 += this.mAxisLeft.getRequiredWidthSpace(this.mAxisRendererLeft.getPaintAxisLabels());
            }
            if (this.mAxisRight.needsOffset()) {
                f3 += this.mAxisRight.getRequiredWidthSpace(this.mAxisRendererRight.getPaintAxisLabels());
            }
            if (this.mXAxis.isEnabled() && this.mXAxis.isDrawLabelsEnabled()) {
                f = (float)this.mXAxis.mLabelRotatedHeight + this.mXAxis.getYOffset();
                if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM) {
                    f5 += f;
                } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP) {
                    f4 += f;
                } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
                    f5 += f;
                    f4 += f;
                }
            }
            f = Utils.convertDpToPixel(this.mMinOffset);
            this.mViewPortHandler.restrainViewPort(Math.max(f, f2 += this.getExtraLeftOffset()), Math.max(f, f4 += this.getExtraTopOffset()), Math.max(f, f3 += this.getExtraRightOffset()), Math.max(f, f5 += this.getExtraBottomOffset()));
            if (this.mLogEnabled) {
                Log.i((String)"MPAndroidChart", (String)("offsetLeft: " + f2 + ", offsetTop: " + f4 + ", offsetRight: " + f3 + ", offsetBottom: " + f5));
                Log.i((String)"MPAndroidChart", (String)("Content: " + this.mViewPortHandler.getContentRect().toString()));
            }
        }
        this.prepareOffsetMatrix();
        this.prepareValuePxMatrix();
    }

    protected void calcModulus() {
        if (this.mXAxis == null || !this.mXAxis.isEnabled()) {
            return;
        }
        if (!this.mXAxis.isAxisModulusCustom()) {
            float[] fArray = new float[9];
            this.mViewPortHandler.getMatrixTouch().getValues(fArray);
            float f = fArray[0];
            f = f == 0.0f ? 1.0f : f;
            this.mXAxis.mAxisLabelModulus = (int)Math.ceil((float)(((BarLineScatterCandleBubbleData)this.mData).getXValCount() * this.mXAxis.mLabelRotatedWidth) / (this.mViewPortHandler.contentWidth() * f));
            mStr = " : " + ((BarLineScatterCandleBubbleData)this.mData).getXValCount() + " : " + this.mXAxis.mLabelRotatedWidth + " : " + this.mViewPortHandler.contentWidth() + " : " + fArray[0];
        }
        if (this.mLogEnabled) {
            Log.i((String)"MPAndroidChart", (String)("X-Axis modulus: " + this.mXAxis.mAxisLabelModulus + ", x-axis label width: " + this.mXAxis.mLabelWidth + ", x-axis label rotated width: " + this.mXAxis.mLabelRotatedWidth + ", content width: " + this.mViewPortHandler.contentWidth()));
        }
        if (this.mXAxis.mAxisLabelModulus < 1) {
            this.mXAxis.mAxisLabelModulus = 1;
        }
    }

    @Override
    protected float[] getMarkerPosition(Entry entry, Highlight highlight) {
        Object object;
        int n = highlight.getDataSetIndex();
        float f = entry.getXIndex();
        float f2 = entry.getVal();
        if (this instanceof BarChart) {
            object = (BarData)this.mData;
            float f3 = ((BarData)object).getGroupSpace();
            int n2 = ((BarLineScatterCandleBubbleData)this.mData).getDataSetCount();
            int n3 = entry.getXIndex();
            if (this instanceof HorizontalBarChart) {
                float f4;
                f2 = f4 = (float)(n3 + n3 * (n2 - 1) + n) + f3 * (float)n3 + f3 / 2.0f;
                BarEntry barEntry = (BarEntry)entry;
                f = barEntry.getVals() != null ? highlight.getRange().to : entry.getVal();
                f *= this.mAnimator.getPhaseY();
            } else {
                float f5;
                f = f5 = (float)(n3 + n3 * (n2 - 1) + n) + f3 * (float)n3 + f3 / 2.0f;
                BarEntry barEntry = (BarEntry)entry;
                f2 = barEntry.getVals() != null ? highlight.getRange().to : entry.getVal();
                f2 *= this.mAnimator.getPhaseY();
            }
        } else {
            f2 *= this.mAnimator.getPhaseY();
        }
        object = new float[]{f, f2};
        this.getTransformer(((IBarLineScatterCandleBubbleDataSet)((BarLineScatterCandleBubbleData)this.mData).getDataSetByIndex(n)).getAxisDependency()).pointValuesToPixel((float[])object);
        return object;
    }

    protected void drawGridBackground(Canvas canvas) {
        if (this.mDrawGridBackground) {
            canvas.drawRect(this.mViewPortHandler.getContentRect(), this.mGridBackgroundPaint);
        }
        if (this.mDrawBorders) {
            canvas.drawRect(this.mViewPortHandler.getContentRect(), this.mBorderPaint);
        }
    }

    @Override
    public Transformer getTransformer(YAxis.AxisDependency axisDependency) {
        if (axisDependency == YAxis.AxisDependency.LEFT) {
            return this.mLeftAxisTransformer;
        }
        return this.mRightAxisTransformer;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        super.onTouchEvent(motionEvent);
        if (this.mChartTouchListener == null || this.mData == null) {
            return false;
        }
        if (!this.mTouchEnabled) {
            return false;
        }
        return this.mChartTouchListener.onTouch((View)this, motionEvent);
    }

    public void computeScroll() {
        if (this.mChartTouchListener instanceof BarLineChartTouchListener) {
            ((BarLineChartTouchListener)this.mChartTouchListener).computeScroll();
        }
    }

    public void zoomIn() {
        PointF pointF = this.mViewPortHandler.getContentCenter();
        Matrix matrix = this.mViewPortHandler.zoomIn(pointF.x, -pointF.y);
        this.mViewPortHandler.refresh(matrix, (View)this, false);
        this.calculateOffsets();
        this.postInvalidate();
    }

    public void zoomOut() {
        PointF pointF = this.mViewPortHandler.getContentCenter();
        Matrix matrix = this.mViewPortHandler.zoomOut(pointF.x, -pointF.y);
        this.mViewPortHandler.refresh(matrix, (View)this, false);
        this.calculateOffsets();
        this.postInvalidate();
    }

    public void zoom(float f, float f2, float f3, float f4) {
        Matrix matrix = this.mViewPortHandler.zoom(f, f2, f3, -f4);
        this.mViewPortHandler.refresh(matrix, (View)this, false);
        this.calculateOffsets();
        this.postInvalidate();
    }

    public void zoom(float f, float f2, float f3, float f4, YAxis.AxisDependency axisDependency) {
        ZoomJob zoomJob = new ZoomJob(this.mViewPortHandler, f, f2, f3, f4, this.getTransformer(axisDependency), axisDependency, (View)this);
        this.addViewportJob(zoomJob);
    }

    @TargetApi(value=11)
    public void zoomAndCenterAnimated(float f, float f2, float f3, float f4, YAxis.AxisDependency axisDependency, long l) {
        if (Build.VERSION.SDK_INT >= 11) {
            PointD pointD = this.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), axisDependency);
            AnimatedZoomJob animatedZoomJob = new AnimatedZoomJob(this.mViewPortHandler, (View)this, this.getTransformer(axisDependency), this.getAxis(axisDependency), this.mXAxis.getValues().size(), f, f2, this.mViewPortHandler.getScaleX(), this.mViewPortHandler.getScaleY(), f3, f4, (float)pointD.x, (float)pointD.y, l);
            this.addViewportJob(animatedZoomJob);
        } else {
            Log.e((String)"MPAndroidChart", (String)"Unable to execute zoomAndCenterAnimated(...) on API level < 11");
        }
    }

    public void fitScreen() {
        Matrix matrix = this.mViewPortHandler.fitScreen();
        this.mViewPortHandler.refresh(matrix, (View)this, false);
        this.calculateOffsets();
        this.postInvalidate();
    }

    public void setScaleMinima(float f, float f2) {
        this.mViewPortHandler.setMinimumScaleX(f);
        this.mViewPortHandler.setMinimumScaleY(f2);
    }

    public void setVisibleXRangeMaximum(float f) {
        float f2 = this.mDeltaX / f;
        this.mViewPortHandler.setMinimumScaleX(f2);
    }

    public void setVisibleXRangeMinimum(float f) {
        float f2 = this.mDeltaX / f;
        this.mViewPortHandler.setMaximumScaleX(f2);
    }

    public void setVisibleXRange(float f, float f2) {
        float f3 = this.mDeltaX / f;
        float f4 = this.mDeltaX / f2;
        this.mViewPortHandler.setMinMaxScaleX(f4, f3);
    }

    public void setVisibleYRangeMaximum(float f, YAxis.AxisDependency axisDependency) {
        float f2 = this.getDeltaY(axisDependency) / f;
        this.mViewPortHandler.setMinimumScaleY(f2);
    }

    public void moveViewToX(float f) {
        MoveViewJob moveViewJob = new MoveViewJob(this.mViewPortHandler, f, 0.0f, this.getTransformer(YAxis.AxisDependency.LEFT), (View)this);
        this.addViewportJob(moveViewJob);
    }

    public void moveViewToY(float f, YAxis.AxisDependency axisDependency) {
        float f2 = this.getDeltaY(axisDependency) / this.mViewPortHandler.getScaleY();
        MoveViewJob moveViewJob = new MoveViewJob(this.mViewPortHandler, 0.0f, f + f2 / 2.0f, this.getTransformer(axisDependency), (View)this);
        this.addViewportJob(moveViewJob);
    }

    public void moveViewTo(float f, float f2, YAxis.AxisDependency axisDependency) {
        float f3 = this.getDeltaY(axisDependency) / this.mViewPortHandler.getScaleY();
        MoveViewJob moveViewJob = new MoveViewJob(this.mViewPortHandler, f, f2 + f3 / 2.0f, this.getTransformer(axisDependency), (View)this);
        this.addViewportJob(moveViewJob);
    }

    @TargetApi(value=11)
    public void moveViewToAnimated(float f, float f2, YAxis.AxisDependency axisDependency, long l) {
        if (Build.VERSION.SDK_INT >= 11) {
            PointD pointD = this.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), axisDependency);
            float f3 = this.getDeltaY(axisDependency) / this.mViewPortHandler.getScaleY();
            AnimatedMoveViewJob animatedMoveViewJob = new AnimatedMoveViewJob(this.mViewPortHandler, f, f2 + f3 / 2.0f, this.getTransformer(axisDependency), (View)this, (float)pointD.x, (float)pointD.y, l);
            this.addViewportJob(animatedMoveViewJob);
        } else {
            Log.e((String)"MPAndroidChart", (String)"Unable to execute moveViewToAnimated(...) on API level < 11");
        }
    }

    public void centerViewTo(float f, float f2, YAxis.AxisDependency axisDependency) {
        float f3 = this.getDeltaY(axisDependency) / this.mViewPortHandler.getScaleY();
        float f4 = (float)this.getXAxis().getValues().size() / this.mViewPortHandler.getScaleX();
        MoveViewJob moveViewJob = new MoveViewJob(this.mViewPortHandler, f - f4 / 2.0f, f2 + f3 / 2.0f, this.getTransformer(axisDependency), (View)this);
        this.addViewportJob(moveViewJob);
    }

    @TargetApi(value=11)
    public void centerViewToAnimated(float f, float f2, YAxis.AxisDependency axisDependency, long l) {
        if (Build.VERSION.SDK_INT >= 11) {
            PointD pointD = this.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), axisDependency);
            float f3 = this.getDeltaY(axisDependency) / this.mViewPortHandler.getScaleY();
            float f4 = (float)this.getXAxis().getValues().size() / this.mViewPortHandler.getScaleX();
            AnimatedMoveViewJob animatedMoveViewJob = new AnimatedMoveViewJob(this.mViewPortHandler, f - f4 / 2.0f, f2 + f3 / 2.0f, this.getTransformer(axisDependency), (View)this, (float)pointD.x, (float)pointD.y, l);
            this.addViewportJob(animatedMoveViewJob);
        } else {
            Log.e((String)"MPAndroidChart", (String)"Unable to execute centerViewToAnimated(...) on API level < 11");
        }
    }

    public void setViewPortOffsets(final float f, final float f2, final float f3, final float f4) {
        this.e = true;
        this.post(new Runnable(){

            @Override
            public void run() {
                BarLineChartBase.this.mViewPortHandler.restrainViewPort(f, f2, f3, f4);
                BarLineChartBase.this.prepareOffsetMatrix();
                BarLineChartBase.this.prepareValuePxMatrix();
            }
        });
    }

    public void resetViewPortOffsets() {
        this.e = false;
        this.calculateOffsets();
    }

    public float getDeltaY(YAxis.AxisDependency axisDependency) {
        if (axisDependency == YAxis.AxisDependency.LEFT) {
            return this.mAxisLeft.mAxisRange;
        }
        return this.mAxisRight.mAxisRange;
    }

    public void setOnDrawListener(OnDrawListener onDrawListener) {
        this.mDrawListener = onDrawListener;
    }

    public OnDrawListener getDrawListener() {
        return this.mDrawListener;
    }

    public PointF getPosition(Entry entry, YAxis.AxisDependency axisDependency) {
        if (entry == null) {
            return null;
        }
        float[] fArray = new float[]{entry.getXIndex(), entry.getVal()};
        this.getTransformer(axisDependency).pointValuesToPixel(fArray);
        return new PointF(fArray[0], fArray[1]);
    }

    public void setMaxVisibleValueCount(int n) {
        this.mMaxVisibleCount = n;
    }

    @Override
    public int getMaxVisibleCount() {
        return this.mMaxVisibleCount;
    }

    public void setHighlightPerDragEnabled(boolean bl) {
        this.mHighlightPerDragEnabled = bl;
    }

    public boolean isHighlightPerDragEnabled() {
        return this.mHighlightPerDragEnabled;
    }

    public void setGridBackgroundColor(int n) {
        this.mGridBackgroundPaint.setColor(n);
    }

    public void setDragEnabled(boolean bl) {
        this.b = bl;
    }

    public boolean isDragEnabled() {
        return this.b;
    }

    public void setScaleEnabled(boolean bl) {
        this.c = bl;
        this.d = bl;
    }

    public void setScaleXEnabled(boolean bl) {
        this.c = bl;
    }

    public void setScaleYEnabled(boolean bl) {
        this.d = bl;
    }

    public boolean isScaleXEnabled() {
        return this.c;
    }

    public boolean isScaleYEnabled() {
        return this.d;
    }

    public void setDoubleTapToZoomEnabled(boolean bl) {
        this.mDoubleTapToZoomEnabled = bl;
    }

    public boolean isDoubleTapToZoomEnabled() {
        return this.mDoubleTapToZoomEnabled;
    }

    public void setDrawGridBackground(boolean bl) {
        this.mDrawGridBackground = bl;
    }

    public void setDrawBorders(boolean bl) {
        this.mDrawBorders = bl;
    }

    public void setBorderWidth(float f) {
        this.mBorderPaint.setStrokeWidth(Utils.convertDpToPixel(f));
    }

    public void setBorderColor(int n) {
        this.mBorderPaint.setColor(n);
    }

    public float getMinOffset() {
        return this.mMinOffset;
    }

    public void setMinOffset(float f) {
        this.mMinOffset = f;
    }

    public boolean isKeepPositionOnRotation() {
        return this.mKeepPositionOnRotation;
    }

    public void setKeepPositionOnRotation(boolean bl) {
        this.mKeepPositionOnRotation = bl;
    }

    public Highlight getHighlightByTouchPoint(float f, float f2) {
        if (this.mData == null) {
            Log.e((String)"MPAndroidChart", (String)"Can't select by touch. No data set.");
            return null;
        }
        return this.getHighlighter().getLineHighlight(f, f2);
    }

    public PointD getValuesByTouchPoint(float f, float f2, YAxis.AxisDependency axisDependency) {
        float[] fArray = new float[]{f, f2};
        this.getTransformer(axisDependency).pixelsToValue(fArray);
        double d = fArray[0];
        double d2 = fArray[1];
        return new PointD(d, d2);
    }

    public PointD getPixelsForValues(float f, float f2, YAxis.AxisDependency axisDependency) {
        float[] fArray = new float[]{f, f2};
        this.getTransformer(axisDependency).pointValuesToPixel(fArray);
        return new PointD(fArray[0], fArray[1]);
    }

    public float getYValueByTouchPoint(float f, float f2, YAxis.AxisDependency axisDependency) {
        return (float)this.getValuesByTouchPoint((float)f, (float)f2, (YAxis.AxisDependency)axisDependency).y;
    }

    public Entry getEntryByTouchPoint(float f, float f2) {
        Highlight highlight = this.getHighlightByTouchPoint(f, f2);
        if (highlight != null) {
            return ((BarLineScatterCandleBubbleData)this.mData).getEntryForHighlight(highlight);
        }
        return null;
    }

    public IBarLineScatterCandleBubbleDataSet getDataSetByTouchPoint(float f, float f2) {
        Highlight highlight = this.getHighlightByTouchPoint(f, f2);
        if (highlight != null) {
            if (highlight.getXIndex() == -1) {
                int n = ((BarLineScatterCandleBubbleData)this.mData).getDataSetCount();
                BaseDataSet baseDataSet = null;
                int n2 = 0;
                while (n2 < n) {
                    baseDataSet = (BaseDataSet)((BarLineScatterCandleBubbleData)this.mData).getDataSetByIndex(n2);
                    if (baseDataSet.isNeedHighLight() && n2 == highlight.getDataSetIndex()) {
                        baseDataSet.setNeedHightLight(false);
                        this.b = -1;
                    } else if (!baseDataSet.isNeedHighLight() && n2 == highlight.getDataSetIndex()) {
                        baseDataSet.setNeedHightLight(true);
                        this.b = n2;
                    } else {
                        baseDataSet.setNeedHightLight(false);
                    }
                    ++n2;
                }
                return null;
            }
            int n = ((BarLineScatterCandleBubbleData)this.mData).getDataSetCount();
            BaseDataSet baseDataSet = null;
            int n3 = 0;
            while (n3 < n) {
                baseDataSet = (BaseDataSet)((BarLineScatterCandleBubbleData)this.mData).getDataSetByIndex(n3);
                if (!baseDataSet.isNeedHighLight() || n3 != highlight.getDataSetIndex()) {
                    baseDataSet.setNeedHightLight(false);
                }
                ++n3;
            }
            return (IBarLineScatterCandleBubbleDataSet)((BarLineScatterCandleBubbleData)this.mData).getDataSetByIndex(highlight.getDataSetIndex());
        }
        int n = ((BarLineScatterCandleBubbleData)this.mData).getDataSetCount();
        BaseDataSet baseDataSet = null;
        int n4 = 0;
        while (n4 < n) {
            baseDataSet = (BaseDataSet)((BarLineScatterCandleBubbleData)this.mData).getDataSetByIndex(n4);
            baseDataSet.setNeedHightLight(false);
            this.b = -1;
            ++n4;
        }
        return null;
    }

    @Override
    public int getLowestVisibleXIndex() {
        float[] fArray = new float[]{this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom()};
        this.getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(fArray);
        return fArray[0] <= 0.0f ? 0 : (int)(fArray[0] + 1.0f);
    }

    @Override
    public int getHighestVisibleXIndex() {
        float[] fArray = new float[]{this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom()};
        this.getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(fArray);
        return fArray[0] >= (float)((BarLineScatterCandleBubbleData)this.mData).getXValCount() ? ((BarLineScatterCandleBubbleData)this.mData).getXValCount() - 1 : (int)fArray[0];
    }

    public float getScaleX() {
        if (this.mViewPortHandler == null) {
            return 1.0f;
        }
        return this.mViewPortHandler.getScaleX();
    }

    public float getScaleY() {
        if (this.mViewPortHandler == null) {
            return 1.0f;
        }
        return this.mViewPortHandler.getScaleY();
    }

    public boolean isFullyZoomedOut() {
        return this.mViewPortHandler.isFullyZoomedOut();
    }

    public YAxis getAxisLeft() {
        return this.mAxisLeft;
    }

    public YAxis getAxisRight() {
        return this.mAxisRight;
    }

    public YAxis getAxis(YAxis.AxisDependency axisDependency) {
        if (axisDependency == YAxis.AxisDependency.LEFT) {
            return this.mAxisLeft;
        }
        return this.mAxisRight;
    }

    @Override
    public boolean isInverted(YAxis.AxisDependency axisDependency) {
        return this.getAxis(axisDependency).isInverted();
    }

    public XAxis getXAxis() {
        return this.mXAxis;
    }

    public void setPinchZoom(boolean bl) {
        this.mPinchZoomEnabled = bl;
    }

    public boolean isPinchZoomEnabled() {
        return this.mPinchZoomEnabled;
    }

    public void setDragOffsetX(float f) {
        this.mViewPortHandler.setDragOffsetX(f);
    }

    public void setDragOffsetY(float f) {
        this.mViewPortHandler.setDragOffsetY(f);
    }

    public boolean hasNoDragOffset() {
        return this.mViewPortHandler.hasNoDragOffset();
    }

    public XAxisRenderer getRendererXAxis() {
        return this.mXAxisRenderer;
    }

    public void setXAxisRenderer(XAxisRenderer xAxisRenderer) {
        this.mXAxisRenderer = xAxisRenderer;
    }

    public YAxisRenderer getRendererLeftYAxis() {
        return this.mAxisRendererLeft;
    }

    public void setRendererLeftYAxis(YAxisRenderer yAxisRenderer) {
        this.mAxisRendererLeft = yAxisRenderer;
    }

    public YAxisRenderer getRendererRightYAxis() {
        return this.mAxisRendererRight;
    }

    public void setRendererRightYAxis(YAxisRenderer yAxisRenderer) {
        this.mAxisRendererRight = yAxisRenderer;
    }

    @Override
    public float getYChartMax() {
        return Math.max(this.mAxisLeft.mAxisMaximum, this.mAxisRight.mAxisMaximum);
    }

    @Override
    public float getYChartMin() {
        return Math.min(this.mAxisLeft.mAxisMinimum, this.mAxisRight.mAxisMinimum);
    }

    public boolean isAnyAxisInverted() {
        if (this.mAxisLeft.isInverted()) {
            return true;
        }
        return this.mAxisRight.isInverted();
    }

    public void setAutoScaleMinMaxEnabled(boolean bl) {
        this.a = bl;
    }

    public boolean isAutoScaleMinMaxEnabled() {
        return this.a;
    }

    @Override
    public void setPaint(Paint paint, int n) {
        super.setPaint(paint, n);
        switch (n) {
            case 4: {
                this.mGridBackgroundPaint = paint;
            }
        }
    }

    @Override
    public Paint getPaint(int n) {
        Paint paint = super.getPaint(n);
        if (paint != null) {
            return paint;
        }
        switch (n) {
            case 4: {
                return this.mGridBackgroundPaint;
            }
        }
        return null;
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        float[] fArray = new float[]{this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop()};
        this.getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(fArray);
        super.onSizeChanged(n, n2, n3, n4);
        if (this.mKeepPositionOnRotation) {
            this.getTransformer(YAxis.AxisDependency.LEFT).pointValuesToPixel(fArray);
            this.mViewPortHandler.centerViewPort(fArray, (View)this);
        }
    }

    public int getHighLightInddex() {
        return this.b;
    }

    public void addChartHighLightListener(OnChartHighLightListener onChartHighLightListener) {
        if (this.mChartTouchListener != null) {
            this.mChartTouchListener.addChartHighLightListener(onChartHighLightListener);
        }
    }

    public void highLight(Highlight highlight, boolean bl) {
        int n = ((BarLineScatterCandleBubbleData)this.mData).getDataSetCount();
        if (this.mData instanceof LineData) {
            LineDataSet lineDataSet = null;
            int n2 = 0;
            while (n2 < n) {
                lineDataSet = (LineDataSet)((BarLineScatterCandleBubbleData)this.mData).getDataSetByIndex(n2);
                if (highlight == null) {
                    lineDataSet.setNeedHightLight(false);
                    this.b = -1;
                } else if (lineDataSet.isNeedHighLight() && n2 == highlight.getDataSetIndex()) {
                    lineDataSet.setNeedHightLight(false);
                    this.b = -1;
                } else if (!lineDataSet.isNeedHighLight() && n2 == highlight.getDataSetIndex()) {
                    lineDataSet.setNeedHightLight(true);
                    this.b = n2;
                } else {
                    lineDataSet.setNeedHightLight(false);
                }
                ++n2;
            }
            this.invalidate();
        }
        boolean cfr_ignored_0 = this.mData instanceof BarData;
        if (bl) {
            this.mChartTouchListener.callOnChartItemHighLightListeners(highlight);
        }
    }
}

