/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import com.github.mikephil.charting.charts.BarChart;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.HorizontalBarHighlighter;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.renderer.HorizontalBarChartRenderer;
import com.github.mikephil.charting.renderer.XAxisRendererHorizontalBarChart;
import com.github.mikephil.charting.renderer.YAxisRendererHorizontalBarChart;
import com.github.mikephil.charting.utils.TransformerHorizontalBarChart;
import com.github.mikephil.charting.utils.Utils;

public class HorizontalBarChart
extends BarChart {
    public HorizontalBarChart(Context context) {
        super(context);
    }

    public HorizontalBarChart(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public HorizontalBarChart(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    @Override
    protected void init() {
        super.init();
        this.mLeftAxisTransformer = new TransformerHorizontalBarChart(this.mViewPortHandler);
        this.mRightAxisTransformer = new TransformerHorizontalBarChart(this.mViewPortHandler);
        this.mRenderer = new HorizontalBarChartRenderer(this, this.mAnimator, this.mViewPortHandler);
        this.setHighlighter(new HorizontalBarHighlighter(this));
        this.mAxisRendererLeft = new YAxisRendererHorizontalBarChart(this.mViewPortHandler, this.mAxisLeft, this.mLeftAxisTransformer);
        this.mAxisRendererRight = new YAxisRendererHorizontalBarChart(this.mViewPortHandler, this.mAxisRight, this.mRightAxisTransformer);
        this.mXAxisRenderer = new XAxisRendererHorizontalBarChart(this.mViewPortHandler, this.mXAxis, this.mLeftAxisTransformer, this);
    }

    @Override
    public void calculateOffsets() {
        float f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (this.mLegend != null && this.mLegend.isEnabled()) {
            if (this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART || this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART_CENTER) {
                f3 += Math.min(this.mLegend.mNeededWidth, this.mViewPortHandler.getChartWidth() * this.mLegend.getMaxSizePercent()) + this.mLegend.getXOffset() * 2.0f;
            } else if (this.mLegend.getPosition() == Legend.LegendPosition.LEFT_OF_CHART || this.mLegend.getPosition() == Legend.LegendPosition.LEFT_OF_CHART_CENTER) {
                f2 += Math.min(this.mLegend.mNeededWidth, this.mViewPortHandler.getChartWidth() * this.mLegend.getMaxSizePercent()) + this.mLegend.getXOffset() * 2.0f;
            } else if (this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_LEFT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_RIGHT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_CENTER) {
                f = this.mLegend.mTextHeightMax;
                f5 += Math.min(this.mLegend.mNeededHeight + f, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent());
            } else if (this.mLegend.getPosition() == Legend.LegendPosition.ABOVE_CHART_LEFT || this.mLegend.getPosition() == Legend.LegendPosition.ABOVE_CHART_RIGHT || this.mLegend.getPosition() == Legend.LegendPosition.ABOVE_CHART_CENTER) {
                f = this.mLegend.mTextHeightMax * 2.0f;
                f4 += Math.min(this.mLegend.mNeededHeight + f, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent());
            }
        }
        if (this.mAxisLeft.needsOffset()) {
            f4 += this.mAxisLeft.getRequiredHeightSpace(this.mAxisRendererLeft.getPaintAxisLabels());
        }
        if (this.mAxisRight.needsOffset()) {
            f5 += this.mAxisRight.getRequiredHeightSpace(this.mAxisRendererRight.getPaintAxisLabels());
        }
        f = this.mXAxis.mLabelRotatedWidth;
        if (this.mXAxis.isEnabled()) {
            if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM) {
                f2 += f;
            } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP) {
                f3 += f;
            } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
                f2 += f;
                f3 += f;
            }
        }
        float f6 = Utils.convertDpToPixel(this.mMinOffset);
        this.mViewPortHandler.restrainViewPort(Math.max(f6, f2 += this.getExtraLeftOffset()), Math.max(f6, f4 += this.getExtraTopOffset()), Math.max(f6, f3 += this.getExtraRightOffset()), Math.max(f6, f5 += this.getExtraBottomOffset()));
        if (this.mLogEnabled) {
            Log.i((String)"MPAndroidChart", (String)("offsetLeft: " + f2 + ", offsetTop: " + f4 + ", offsetRight: " + f3 + ", offsetBottom: " + f5));
            Log.i((String)"MPAndroidChart", (String)("Content: " + this.mViewPortHandler.getContentRect().toString()));
        }
        this.prepareOffsetMatrix();
        this.prepareValuePxMatrix();
    }

    @Override
    protected void prepareValuePxMatrix() {
        this.mRightAxisTransformer.prepareMatrixValuePx(this.mAxisRight.mAxisMinimum, this.mAxisRight.mAxisRange, this.mDeltaX, this.mXChartMin);
        this.mLeftAxisTransformer.prepareMatrixValuePx(this.mAxisLeft.mAxisMinimum, this.mAxisLeft.mAxisRange, this.mDeltaX, this.mXChartMin);
    }

    @Override
    protected void calcModulus() {
        float[] fArray = new float[9];
        this.mViewPortHandler.getMatrixTouch().getValues(fArray);
        this.mXAxis.mAxisLabelModulus = (int)Math.ceil((float)(((BarData)this.mData).getXValCount() * this.mXAxis.mLabelRotatedHeight) / (this.mViewPortHandler.contentHeight() * fArray[4]));
        if (this.mXAxis.mAxisLabelModulus < 1) {
            this.mXAxis.mAxisLabelModulus = 1;
        }
    }

    @Override
    public RectF getBarBounds(BarEntry barEntry) {
        IBarDataSet iBarDataSet = (IBarDataSet)((BarData)this.mData).getDataSetForEntry(barEntry);
        if (iBarDataSet == null) {
            return null;
        }
        float f = iBarDataSet.getBarSpace();
        float f2 = barEntry.getVal();
        float f3 = barEntry.getXIndex();
        float f4 = f / 2.0f;
        float f5 = f3 - 0.5f + f4;
        float f6 = f3 + 0.5f - f4;
        float f7 = f2 >= 0.0f ? f2 : 0.0f;
        float f8 = f2 <= 0.0f ? f2 : 0.0f;
        RectF rectF = new RectF(f7, f5, f8, f6);
        this.getTransformer(iBarDataSet.getAxisDependency()).rectValueToPixel(rectF);
        return rectF;
    }

    @Override
    public PointF getPosition(Entry entry, YAxis.AxisDependency axisDependency) {
        if (entry == null) {
            return null;
        }
        float[] fArray = new float[]{entry.getVal(), entry.getXIndex()};
        this.getTransformer(axisDependency).pointValuesToPixel(fArray);
        return new PointF(fArray[0], fArray[1]);
    }

    @Override
    public Highlight getHighlightByTouchPoint(float f, float f2) {
        if (this.mData == null) {
            Log.e((String)"MPAndroidChart", (String)"Can't select by touch. No data set.");
            return null;
        }
        return this.getHighlighter().getHighlight(f2, f);
    }

    @Override
    public int getLowestVisibleXIndex() {
        float f = ((BarData)this.mData).getDataSetCount();
        float f2 = f <= 1.0f ? 1.0f : f + ((BarData)this.mData).getGroupSpace();
        float[] fArray = new float[]{this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom()};
        this.getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(fArray);
        return (int)((fArray[1] <= 0.0f ? 0.0f : fArray[1] / f2) + 1.0f);
    }

    @Override
    public int getHighestVisibleXIndex() {
        float f = ((BarData)this.mData).getDataSetCount();
        float f2 = f <= 1.0f ? 1.0f : f + ((BarData)this.mData).getGroupSpace();
        float[] fArray = new float[]{this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop()};
        this.getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(fArray);
        return (int)(fArray[1] >= this.getXChartMax() ? this.getXChartMax() / f2 : fArray[1] / f2);
    }
}

