/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.animation.Easing;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.listener.OnChartHighLightListener;
import com.github.mikephil.charting.listener.PieRadarChartTouchListener;
import com.github.mikephil.charting.utils.SelectionDetail;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public abstract class PieRadarChartBase<T extends ChartData<? extends IDataSet<? extends Entry>>>
extends Chart<T> {
    private float b = 270.0f;
    private float c = 270.0f;
    protected boolean mRotateEnabled = true;
    protected float mMinOffset = 0.0f;

    public PieRadarChartBase(Context context) {
        super(context);
    }

    public PieRadarChartBase(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public PieRadarChartBase(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    @Override
    protected void init() {
        super.init();
        this.mChartTouchListener = new PieRadarChartTouchListener(this);
    }

    @Override
    protected void calcMinMax() {
        this.mDeltaX = this.mData.getXVals().size() - 1;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mTouchEnabled && this.mChartTouchListener != null) {
            return this.mChartTouchListener.onTouch((View)this, motionEvent);
        }
        return super.onTouchEvent(motionEvent);
    }

    public void computeScroll() {
        if (this.mChartTouchListener instanceof PieRadarChartTouchListener) {
            ((PieRadarChartTouchListener)this.mChartTouchListener).computeScroll();
        }
    }

    @Override
    public void notifyDataSetChanged() {
        if (this.mData == null) {
            return;
        }
        this.calcMinMax();
        if (this.mLegend != null) {
            this.mLegendRenderer.computeLegend(this.mData);
        }
        this.calculateOffsets();
    }

    @Override
    public void calculateOffsets() {
        XAxis xAxis;
        float f;
        float f2;
        float f3;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (this.mLegend != null && this.mLegend.isEnabled()) {
            PointF pointF;
            float f8;
            f3 = Math.min(this.mLegend.mNeededWidth, this.mViewPortHandler.getChartWidth() * this.mLegend.getMaxSizePercent()) + this.mLegend.getFormSize() + this.mLegend.getFormToTextSpace();
            if (this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART_CENTER) {
                f8 = Utils.convertDpToPixel(13.0f);
                f5 = f3 + f8;
            } else if (this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART) {
                f8 = Utils.convertDpToPixel(8.0f);
                f2 = f3 + f8;
                f = this.mLegend.mNeededHeight + this.mLegend.mTextHeightMax;
                pointF = this.getCenter();
                PointF pointF2 = new PointF((float)this.getWidth() - f2 + 15.0f, f + 15.0f);
                float f9 = this.distanceToCenter(pointF2.x, pointF2.y);
                PointF pointF3 = this.getPosition(pointF, this.getRadius(), this.getAngleForPoint(pointF2.x, pointF2.y));
                float f10 = this.distanceToCenter(pointF3.x, pointF3.y);
                float f11 = Utils.convertDpToPixel(5.0f);
                if (f9 < f10) {
                    float f12 = f10 - f9;
                    f5 = f11 + f12;
                }
                if (pointF2.y >= pointF.y && (float)this.getHeight() - f2 > (float)this.getWidth()) {
                    f5 = f2;
                }
            } else if (this.mLegend.getPosition() == Legend.LegendPosition.LEFT_OF_CHART_CENTER) {
                f8 = Utils.convertDpToPixel(13.0f);
                f4 = f3 + f8;
            } else if (this.mLegend.getPosition() == Legend.LegendPosition.LEFT_OF_CHART) {
                f8 = Utils.convertDpToPixel(8.0f);
                f2 = f3 + f8;
                f = this.mLegend.mNeededHeight + this.mLegend.mTextHeightMax;
                pointF = this.getCenter();
                PointF pointF4 = new PointF(f2 - 15.0f, f + 15.0f);
                float f13 = this.distanceToCenter(pointF4.x, pointF4.y);
                PointF pointF5 = this.getPosition(pointF, this.getRadius(), this.getAngleForPoint(pointF4.x, pointF4.y));
                float f14 = this.distanceToCenter(pointF5.x, pointF5.y);
                float f15 = Utils.convertDpToPixel(5.0f);
                if (f13 < f14) {
                    float f16 = f14 - f13;
                    f4 = f15 + f16;
                }
                if (pointF4.y >= pointF.y && (float)this.getHeight() - f2 > (float)this.getWidth()) {
                    f4 = f2;
                }
            } else if (this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_LEFT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_RIGHT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_CENTER) {
                f8 = this.getRequiredLegendOffset();
                f6 = Math.min(this.mLegend.mNeededHeight + f8, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent());
            } else if (this.mLegend.getPosition() == Legend.LegendPosition.ABOVE_CHART_LEFT || this.mLegend.getPosition() == Legend.LegendPosition.ABOVE_CHART_RIGHT || this.mLegend.getPosition() == Legend.LegendPosition.ABOVE_CHART_CENTER) {
                f8 = this.getRequiredLegendOffset();
                f7 = Math.min(this.mLegend.mNeededHeight + f8, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent());
            }
            f4 += this.getRequiredBaseOffset();
            f5 += this.getRequiredBaseOffset();
            f7 += this.getRequiredBaseOffset();
        }
        f3 = Utils.convertDpToPixel(this.mMinOffset);
        if (this instanceof RadarChart && (xAxis = ((RadarChart)this).getXAxis()).isEnabled() && xAxis.isDrawLabelsEnabled()) {
            f3 = Math.max(f3, (float)xAxis.mLabelRotatedWidth);
        }
        float f17 = Math.max(f3, f4 += this.getExtraLeftOffset());
        f2 = Math.max(f3, f7 += this.getExtraTopOffset());
        f = Math.max(f3, f5 += this.getExtraRightOffset());
        float f18 = Math.max(f3, Math.max(this.getRequiredBaseOffset(), f6 += this.getExtraBottomOffset()));
        this.mViewPortHandler.restrainViewPort(f17, f2, f, f18);
        if (this.mLogEnabled) {
            Log.i((String)"MPAndroidChart", (String)("offsetLeft: " + f17 + ", offsetTop: " + f2 + ", offsetRight: " + f + ", offsetBottom: " + f18));
        }
    }

    public float getAngleForPoint(float f, float f2) {
        PointF pointF = this.getCenterOffsets();
        double d = f - pointF.x;
        double d2 = f2 - pointF.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = Math.acos(d2 / d3);
        float f3 = (float)Math.toDegrees(d4);
        if (f > pointF.x) {
            f3 = 360.0f - f3;
        }
        if ((f3 += 90.0f) > 360.0f) {
            f3 -= 360.0f;
        }
        return f3;
    }

    protected PointF getPosition(PointF pointF, float f, float f2) {
        PointF pointF2 = new PointF((float)((double)pointF.x + (double)f * Math.cos(Math.toRadians(f2))), (float)((double)pointF.y + (double)f * Math.sin(Math.toRadians(f2))));
        return pointF2;
    }

    public float distanceToCenter(float f, float f2) {
        PointF pointF = this.getCenterOffsets();
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        f4 = f > pointF.x ? f - pointF.x : pointF.x - f;
        f5 = f2 > pointF.y ? f2 - pointF.y : pointF.y - f2;
        f3 = (float)Math.sqrt(Math.pow(f4, 2.0) + Math.pow(f5, 2.0));
        return f3;
    }

    public abstract int getIndexForAngle(float var1);

    public void setRotationAngle(float f) {
        this.c = f;
        this.b = Utils.getNormalizedAngle(this.c);
    }

    public float getRawRotationAngle() {
        return this.c;
    }

    public float getRotationAngle() {
        return this.b;
    }

    public void setRotationEnabled(boolean bl) {
        this.mRotateEnabled = bl;
    }

    public boolean isRotationEnabled() {
        return this.mRotateEnabled;
    }

    public float getMinOffset() {
        return this.mMinOffset;
    }

    public void setMinOffset(float f) {
        this.mMinOffset = f;
    }

    public float getDiameter() {
        RectF rectF = this.mViewPortHandler.getContentRect();
        return Math.min(rectF.width(), rectF.height());
    }

    public abstract float getRadius();

    protected abstract float getRequiredLegendOffset();

    protected abstract float getRequiredBaseOffset();

    @Override
    public float getYChartMax() {
        return 0.0f;
    }

    @Override
    public float getYChartMin() {
        return 0.0f;
    }

    public List<SelectionDetail> getSelectionDetailsAtIndex(int n) {
        ArrayList<SelectionDetail> arrayList = new ArrayList<SelectionDetail>();
        int n2 = 0;
        while (n2 < this.mData.getDataSetCount()) {
            Object t = this.mData.getDataSetByIndex(n2);
            float f = t.getYValForXIndex(n);
            if (f != Float.NaN) {
                arrayList.add(new SelectionDetail(f, n2, (IDataSet)t));
            }
            ++n2;
        }
        return arrayList;
    }

    @SuppressLint(value={"NewApi"})
    public void spin(int n, float f, float f2, Easing.EasingOption easingOption) {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        this.setRotationAngle(f);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this, (String)"rotationAngle", (float[])new float[]{f, f2});
        objectAnimator.setDuration((long)n);
        objectAnimator.setInterpolator((TimeInterpolator)Easing.getEasingFunctionFromOption(easingOption));
        objectAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                PieRadarChartBase.this.postInvalidate();
            }
        });
        objectAnimator.start();
    }

    public void addChartHighLightListener(OnChartHighLightListener onChartHighLightListener) {
        if (this.mChartTouchListener != null) {
            this.mChartTouchListener.addChartHighLightListener(onChartHighLightListener);
        }
    }

    public void highLight(Highlight highlight) {
        this.mChartTouchListener.highLight(highlight);
    }

    public void highLightChartItem(Highlight highlight) {
        this.mChartTouchListener.performHighlight(highlight, null);
    }
}

