/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.github.mikephil.charting.charts.PieRadarChartBase;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.RadarData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.renderer.RadarChartRenderer;
import com.github.mikephil.charting.renderer.XAxisRendererRadarChart;
import com.github.mikephil.charting.renderer.YAxisRendererRadarChart;
import com.github.mikephil.charting.utils.Utils;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class RadarChart
extends PieRadarChartBase<RadarData> {
    private float b;
    private float c;
    private int b = Color.rgb((int)122, (int)122, (int)122);
    private int c = Color.rgb((int)122, (int)122, (int)122);
    private int d = 150;
    private boolean a;
    private int e = 0;
    private YAxis a;
    private XAxis a = true;
    protected YAxisRendererRadarChart mYAxisRenderer;
    protected XAxisRendererRadarChart mXAxisRenderer;

    public RadarChart(Context context) {
        super(context);
    }

    public RadarChart(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public RadarChart(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    @Override
    protected void init() {
        super.init();
        this.a = new YAxis(YAxis.AxisDependency.LEFT);
        this.a = new XAxis();
        this.a.setSpaceBetweenLabels(0);
        this.b = Utils.convertDpToPixel(1.5f);
        this.c = Utils.convertDpToPixel(0.75f);
        this.mRenderer = new RadarChartRenderer(this, this.mAnimator, this.mViewPortHandler);
        this.mYAxisRenderer = new YAxisRendererRadarChart(this.mViewPortHandler, this.a, this);
        this.mXAxisRenderer = new XAxisRendererRadarChart(this.mViewPortHandler, this.a, this);
    }

    @Override
    protected void calcMinMax() {
        super.calcMinMax();
        float f = !Float.isNaN(this.a.getAxisMinValue()) ? this.a.getAxisMinValue() : ((RadarData)this.mData).getYMin(YAxis.AxisDependency.LEFT);
        float f2 = !Float.isNaN(this.a.getAxisMaxValue()) ? this.a.getAxisMaxValue() : ((RadarData)this.mData).getYMax(YAxis.AxisDependency.LEFT);
        this.mXChartMax = ((RadarData)this.mData).getXVals().size() - 1;
        this.mDeltaX = Math.abs(this.mXChartMax - this.mXChartMin);
        float f3 = Math.abs(f2 - f);
        float f4 = f3 / 100.0f * this.a.getSpaceTop();
        float f5 = f3 / 100.0f * this.a.getSpaceBottom();
        this.mXChartMax = ((RadarData)this.mData).getXVals().size() - 1;
        this.mDeltaX = Math.abs(this.mXChartMax - this.mXChartMin);
        this.a.mAxisMinimum = !Float.isNaN(this.a.getAxisMinValue()) ? this.a.getAxisMinValue() : f - f5;
        this.a.mAxisMaximum = !Float.isNaN(this.a.getAxisMaxValue()) ? this.a.getAxisMaxValue() : f2 + f4;
        this.a.mAxisRange = Math.abs(this.a.mAxisMaximum - this.a.mAxisMinimum);
    }

    @Override
    protected float[] getMarkerPosition(Entry entry, Highlight highlight) {
        float f = this.getSliceAngle() * (float)entry.getXIndex() + this.getRotationAngle();
        float f2 = entry.getVal() * this.getFactor();
        PointF pointF = this.getCenterOffsets();
        PointF pointF2 = new PointF((float)((double)pointF.x + (double)f2 * Math.cos(Math.toRadians(f))), (float)((double)pointF.y + (double)f2 * Math.sin(Math.toRadians(f))));
        return new float[]{pointF2.x, pointF2.y};
    }

    @Override
    public void notifyDataSetChanged() {
        if (this.mData == null) {
            return;
        }
        this.calcMinMax();
        this.mYAxisRenderer.computeAxis(this.a.mAxisMinimum, this.a.mAxisMaximum);
        this.mXAxisRenderer.computeAxis(((RadarData)this.mData).getXValMaximumLength(), ((RadarData)this.mData).getXVals());
        if (this.mLegend != null && !this.mLegend.isLegendCustom()) {
            this.mLegendRenderer.computeLegend(this.mData);
        }
        this.calculateOffsets();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mData == null) {
            return;
        }
        this.mXAxisRenderer.renderAxisLabels(canvas);
        if (this.a) {
            this.mRenderer.drawExtras(canvas);
        }
        this.mYAxisRenderer.renderLimitLines(canvas);
        this.mRenderer.drawData(canvas);
        if (this.valuesToHighlight()) {
            this.mRenderer.drawHighlighted(canvas, this.mIndicesToHighlight);
        }
        this.mYAxisRenderer.renderAxisLabels(canvas);
        this.mRenderer.drawValues(canvas);
        this.mLegendRenderer.renderLegend(canvas);
        this.drawDescription(canvas);
        this.drawMarkers(canvas);
    }

    public float getFactor() {
        RectF rectF = this.mViewPortHandler.getContentRect();
        return Math.min(rectF.width() / 2.0f, rectF.height() / 2.0f) / this.a.mAxisRange;
    }

    public float getSliceAngle() {
        return 360.0f / (float)((RadarData)this.mData).getXValCount();
    }

    @Override
    public int getIndexForAngle(float f) {
        float f2 = Utils.getNormalizedAngle(f - this.getRotationAngle());
        float f3 = this.getSliceAngle();
        int n = 0;
        while (n < ((RadarData)this.mData).getXValCount()) {
            if (f3 * (float)(n + 1) - f3 / 2.0f > f2) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public YAxis getYAxis() {
        return this.a;
    }

    public XAxis getXAxis() {
        return this.a;
    }

    public void setWebLineWidth(float f) {
        this.b = Utils.convertDpToPixel(f);
    }

    public float getWebLineWidth() {
        return this.b;
    }

    public void setWebLineWidthInner(float f) {
        this.c = Utils.convertDpToPixel(f);
    }

    public float getWebLineWidthInner() {
        return this.c;
    }

    public void setWebAlpha(int n) {
        this.d = n;
    }

    public int getWebAlpha() {
        return this.d;
    }

    public void setWebColor(int n) {
        this.b = n;
    }

    public int getWebColor() {
        return this.b;
    }

    public void setWebColorInner(int n) {
        this.c = n;
    }

    public int getWebColorInner() {
        return this.c;
    }

    public void setDrawWeb(boolean bl) {
        this.a = bl;
    }

    public void setSkipWebLineCount(int n) {
        this.e = Math.max(0, n);
    }

    public int getSkipWebLineCount() {
        return this.e;
    }

    @Override
    protected float getRequiredLegendOffset() {
        return this.mLegendRenderer.getLabelPaint().getTextSize() * 4.0f;
    }

    @Override
    protected float getRequiredBaseOffset() {
        return this.a.isEnabled() && this.a.isDrawLabelsEnabled() ? (float)this.a.mLabelRotatedWidth : Utils.convertDpToPixel(10.0f);
    }

    @Override
    public float getRadius() {
        RectF rectF = this.mViewPortHandler.getContentRect();
        return Math.min(rectF.width() / 2.0f, rectF.height() / 2.0f);
    }

    @Override
    public float getYChartMax() {
        return this.a.mAxisMaximum;
    }

    @Override
    public float getYChartMin() {
        return this.a.mAxisMinimum;
    }

    public float getYRange() {
        return this.a.mAxisRange;
    }
}

