/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.highlight;

import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BarLineScatterCandleBubbleDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.utils.SelectionDetail;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class ChartHighlighter<T extends BarLineScatterCandleBubbleDataProvider> {
    protected T mChart;

    public ChartHighlighter(T t) {
        this.mChart = t;
    }

    public Highlight getHighlight(float f, float f2) {
        int n = this.getXIndex(f);
        if (n == -2147483647) {
            return null;
        }
        int n2 = this.getDataSetIndex(n, f, f2);
        if (n2 == -2147483647) {
            return null;
        }
        return new Highlight(n, n2);
    }

    protected int getXIndex(float f) {
        float[] fArray = new float[2];
        fArray[0] = f;
        this.mChart.getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(fArray);
        return Math.round(fArray[0]);
    }

    protected int getDataSetIndex(int n, float f, float f2) {
        float f3;
        List<SelectionDetail> list = this.getSelectionDetailsAtIndex(n);
        float f4 = Utils.getMinimumDistance(list, f2, YAxis.AxisDependency.LEFT);
        YAxis.AxisDependency axisDependency = f4 < (f3 = Utils.getMinimumDistance(list, f2, YAxis.AxisDependency.RIGHT)) ? YAxis.AxisDependency.LEFT : YAxis.AxisDependency.RIGHT;
        int n2 = Utils.getClosestDataSetIndex(list, f2, axisDependency);
        return n2;
    }

    protected List<SelectionDetail> getSelectionDetailsAtIndex(int n) {
        ArrayList<SelectionDetail> arrayList = new ArrayList<SelectionDetail>();
        float[] fArray = new float[2];
        int n2 = 0;
        while (n2 < this.mChart.getData().getDataSetCount()) {
            float f;
            Object t = this.mChart.getData().getDataSetByIndex(n2);
            if (t.isHighlightEnabled() && (f = t.getYValForXIndex(n)) != Float.NaN) {
                fArray[1] = f;
                this.mChart.getTransformer(t.getAxisDependency()).pointValuesToPixel(fArray);
                if (!Float.isNaN(fArray[1])) {
                    arrayList.add(new SelectionDetail(fArray[1], n2, (IDataSet)t));
                }
            }
            ++n2;
        }
        return arrayList;
    }

    public Highlight getLineHighlight(float f, float f2) {
        int n = this.getXIndex(f);
        List<SelectionDetail> list = this.getSelectionDetailsAtIndex(n);
        int n2 = list.size();
        if (n2 <= 0) {
            return null;
        }
        if (n2 >= 1) {
            int n3 = -1;
            double d = -1.0;
            double d2 = -1.0;
            float[] fArray = new float[2];
            double d3 = 20.0;
            double d4 = 16.0;
            fArray[0] = n;
            this.mChart.getTransformer(this.mChart.getData().getDataSetByIndex(0).getAxisDependency()).pointValuesToPixel(fArray);
            double d5 = fArray[0];
            double d6 = Math.abs((double)f - d5);
            if (d6 < d3) {
                int n4 = 0;
                while (n4 < n2) {
                    d2 = Math.abs(f2 - list.get((int)n4).val);
                    if (d == -1.0) {
                        n3 = n4;
                        d = d2;
                    } else if (d2 < d) {
                        n3 = n4;
                        d = d2;
                    }
                    ++n4;
                }
                if (d < d3) {
                    return new Highlight(n, n3);
                }
            }
            List<SelectionDetail> list2 = null;
            int n5 = this.mChart.getData().getXValCount();
            if ((double)f - d5 < 0.0 && n > 0 || n >= n5) {
                list2 = this.getSelectionDetailsAtIndex(n - 1);
                fArray[0] = n - 1;
            } else {
                list2 = this.getSelectionDetailsAtIndex(n + 1);
                fArray[0] = n + 1;
            }
            this.mChart.getTransformer(this.mChart.getData().getDataSetByIndex(0).getAxisDependency()).pointValuesToPixel(fArray);
            double d7 = fArray[0];
            if (!(d5 <= d7 && (double)f - d5 > 0.0 && d7 - (double)f > 0.0 || d5 > d7 && (double)f - d7 > 0.0 && d5 - (double)f > 0.0)) {
                return null;
            }
            double d8 = -1.0;
            double d9 = -1.0;
            double d10 = -1.0;
            double d11 = -1.0;
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            double d12 = 0.0;
            double d13 = 0.0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n2) {
                dArray[0] = (double)f - d5;
                dArray[1] = f2 - list.get((int)n7).val;
                dArray2[0] = d5 - d7;
                dArray2[1] = list.get((int)n7).val - list2.get((int)n7).val;
                if (list.get((int)n7).val <= list2.get((int)n7).val && dArray[1] + d4 >= 0.0 && (double)(list2.get((int)n7).val - f2) + d4 >= 0.0 || list.get((int)n7).val > list2.get((int)n7).val && d4 - dArray[1] >= 0.0 && (double)(f2 - list2.get((int)n7).val) + d4 >= 0.0) {
                    d12 = dArray2[1] / dArray2[0];
                    d10 = Math.sqrt(Math.abs(dArray[0] * dArray[0] + dArray[1] * dArray[1]));
                    d11 = Math.sqrt(Math.abs(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1]));
                    d13 = dArray[0] * dArray2[0] + dArray[1] * dArray2[1];
                    d9 = Math.abs(d10 * Math.sin(Math.acos(d13 / (d10 * d11))));
                    if (d8 == -1.0) {
                        d8 = d9;
                        n6 = n7;
                    } else if (d9 < d8) {
                        d8 = d9;
                        n6 = n7;
                    }
                }
                ++n7;
            }
            if (d8 < d4 && d8 > 0.0) {
                return new Highlight(-1, n6);
            }
            return null;
        }
        return null;
    }
}

