/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.jobs;

import android.graphics.Matrix;
import android.view.View;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.jobs.ViewPortJob;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.ViewPortHandler;

public class ZoomJob
extends ViewPortJob {
    protected float scaleX;
    protected float scaleY;
    protected YAxis.AxisDependency axisDependency;

    public ZoomJob(ViewPortHandler viewPortHandler, float f, float f2, float f3, float f4, Transformer transformer, YAxis.AxisDependency axisDependency, View view) {
        super(viewPortHandler, f3, f4, transformer, view);
        this.scaleX = f;
        this.scaleY = f2;
        this.axisDependency = axisDependency;
    }

    @Override
    public void run() {
        Matrix matrix = this.mViewPortHandler.zoom(this.scaleX, this.scaleY);
        this.mViewPortHandler.refresh(matrix, this.view, false);
        float f = ((BarLineChartBase)this.view).getDeltaY(this.axisDependency) / this.mViewPortHandler.getScaleY();
        float f2 = (float)((BarLineChartBase)this.view).getXAxis().getValues().size() / this.mViewPortHandler.getScaleX();
        this.pts[0] = this.xValue - f2 / 2.0f;
        this.pts[1] = this.yValue + f / 2.0f;
        this.mTrans.pointValuesToPixel(this.pts);
        matrix = this.mViewPortHandler.translate(this.pts);
        this.mViewPortHandler.refresh(matrix, this.view, false);
        ((BarLineChartBase)this.view).calculateOffsets();
        this.view.postInvalidate();
    }
}

