/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.listener;

import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.listener.OnChartGestureListener;
import com.github.mikephil.charting.listener.OnChartHighLightListener;
import java.util.ArrayList;

public abstract class ChartTouchListener<T extends Chart<?>>
extends GestureDetector.SimpleOnGestureListener
implements View.OnTouchListener {
    protected ChartGesture mLastGesture = ChartGesture.NONE;
    protected static final int NONE = 0;
    protected static final int DRAG = 1;
    protected static final int X_ZOOM = 2;
    protected static final int Y_ZOOM = 3;
    protected static final int PINCH_ZOOM = 4;
    protected static final int POST_ZOOM = 5;
    protected static final int ROTATE = 6;
    protected int mTouchMode = 0;
    protected Highlight mLastHighlighted;
    protected GestureDetector mGestureDetector;
    protected T mChart;
    private ArrayList<OnChartHighLightListener> a;

    public ChartTouchListener(T t) {
        this.mChart = t;
        this.mGestureDetector = new GestureDetector(t.getContext(), (GestureDetector.OnGestureListener)this);
        this.a = new ArrayList();
    }

    public void startAction(MotionEvent motionEvent) {
        OnChartGestureListener onChartGestureListener = ((Chart)this.mChart).getOnChartGestureListener();
        if (onChartGestureListener != null) {
            onChartGestureListener.onChartGestureStart(motionEvent, this.mLastGesture);
        }
    }

    public void endAction(MotionEvent motionEvent) {
        OnChartGestureListener onChartGestureListener = ((Chart)this.mChart).getOnChartGestureListener();
        if (onChartGestureListener != null) {
            onChartGestureListener.onChartGestureEnd(motionEvent, this.mLastGesture);
        }
    }

    public void setLastHighlighted(Highlight highlight) {
        this.mLastHighlighted = highlight;
    }

    public int getTouchMode() {
        return this.mTouchMode;
    }

    public ChartGesture getLastGesture() {
        return this.mLastGesture;
    }

    public void performHighlight(Highlight highlight, MotionEvent motionEvent) {
        if (highlight == null || highlight.equalTo(this.mLastHighlighted)) {
            ((Chart)this.mChart).highlightTouch(null);
            this.mLastHighlighted = null;
        } else {
            this.mLastHighlighted = highlight;
            ((Chart)this.mChart).highlightTouch(highlight);
        }
    }

    protected static float distance(float f, float f2, float f3, float f4) {
        float f5 = f - f2;
        float f6 = f3 - f4;
        return (float)Math.sqrt(f5 * f5 + f6 * f6);
    }

    public void addChartHighLightListener(OnChartHighLightListener onChartHighLightListener) {
        if (this.a != null && onChartHighLightListener != null) {
            this.a.add(onChartHighLightListener);
        }
    }

    public void highLight(Highlight highlight) {
        this.performHighlight(highlight, null);
        this.callOnChartItemHighLightListeners(highlight);
    }

    public void callOnChartItemHighLightListeners(Highlight highlight) {
        int n = 0;
        while (n < this.a.size()) {
            if (highlight != null) {
                this.a.get(n).onChartHighLighted(highlight.getDataSetIndex(), highlight.getXIndex());
            } else {
                this.a.get(n).onChartHighLighted(-1, -1);
            }
            ++n;
        }
    }

    public static enum ChartGesture {
        NONE,
        DRAG,
        X_ZOOM,
        Y_ZOOM,
        PINCH_ZOOM,
        ROTATE,
        SINGLE_TAP,
        DOUBLE_TAP,
        LONG_PRESS,
        FLING;

    }
}

