/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class BarChartRenderer
extends DataRenderer {
    protected BarDataProvider mChart;
    protected RectF mBarRect = new RectF();
    protected BarBuffer[] mBarBuffers;
    protected Paint mShadowPaint;

    public BarChartRenderer(BarDataProvider barDataProvider, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        super(chartAnimator, viewPortHandler);
        this.mChart = barDataProvider;
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setStyle(Paint.Style.FILL);
        this.mHighlightPaint.setColor(Color.rgb((int)0, (int)0, (int)0));
        this.mHighlightPaint.setAlpha(120);
        this.mShadowPaint = new Paint(1);
        this.mShadowPaint.setStyle(Paint.Style.FILL);
    }

    @Override
    public void initBuffers() {
        BarData barData = this.mChart.getBarData();
        this.mBarBuffers = new BarBuffer[barData.getDataSetCount()];
        int n = 0;
        while (n < this.mBarBuffers.length) {
            IBarDataSet iBarDataSet = (IBarDataSet)barData.getDataSetByIndex(n);
            this.mBarBuffers[n] = new BarBuffer(iBarDataSet.getEntryCount() * 4 * (iBarDataSet.isStacked() ? iBarDataSet.getStackSize() : 1), barData.getGroupSpace(), barData.getDataSetCount(), iBarDataSet.isStacked());
            ++n;
        }
    }

    @Override
    public void drawData(Canvas canvas) {
        BarData barData = this.mChart.getBarData();
        int n = 0;
        while (n < barData.getDataSetCount()) {
            IBarDataSet iBarDataSet = (IBarDataSet)barData.getDataSetByIndex(n);
            if (iBarDataSet.isVisible() && iBarDataSet.getEntryCount() > 0) {
                this.drawDataSet(canvas, iBarDataSet, n);
            }
            ++n;
        }
    }

    protected void drawDataSet(Canvas canvas, IBarDataSet iBarDataSet, int n) {
        int n2;
        Transformer transformer = this.mChart.getTransformer(iBarDataSet.getAxisDependency());
        this.mShadowPaint.setColor(iBarDataSet.getBarShadowColor());
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        BarBuffer barBuffer = this.mBarBuffers[n];
        barBuffer.setPhases(f, f2);
        barBuffer.setBarSpace(iBarDataSet.getBarSpace());
        barBuffer.setDataSet(n);
        barBuffer.setInverted(this.mChart.isInverted(iBarDataSet.getAxisDependency()));
        barBuffer.feed(iBarDataSet);
        transformer.pointValuesToPixel(barBuffer.buffer);
        if (this.mChart.isDrawBarShadowEnabled()) {
            n2 = 0;
            while (n2 < barBuffer.size()) {
                if (this.mViewPortHandler.isInBoundsLeft(barBuffer.buffer[n2 + 2])) {
                    if (!this.mViewPortHandler.isInBoundsRight(barBuffer.buffer[n2])) break;
                    canvas.drawRect(barBuffer.buffer[n2], this.mViewPortHandler.contentTop(), barBuffer.buffer[n2 + 2], this.mViewPortHandler.contentBottom(), this.mShadowPaint);
                }
                n2 += 4;
            }
        }
        if (iBarDataSet.getColors().size() > 1) {
            n2 = 0;
            while (n2 < barBuffer.size()) {
                if (this.mViewPortHandler.isInBoundsLeft(barBuffer.buffer[n2 + 2])) {
                    if (!this.mViewPortHandler.isInBoundsRight(barBuffer.buffer[n2])) break;
                    this.mRenderPaint.setColor(iBarDataSet.getColor(n2 / 4));
                    canvas.drawRect(barBuffer.buffer[n2], barBuffer.buffer[n2 + 1], barBuffer.buffer[n2 + 2], barBuffer.buffer[n2 + 3], this.mRenderPaint);
                }
                n2 += 4;
            }
        } else {
            this.mRenderPaint.setColor(iBarDataSet.getColor());
            n2 = 0;
            while (n2 < barBuffer.size()) {
                if (this.mViewPortHandler.isInBoundsLeft(barBuffer.buffer[n2 + 2])) {
                    if (!this.mViewPortHandler.isInBoundsRight(barBuffer.buffer[n2])) break;
                    canvas.drawRect(barBuffer.buffer[n2], barBuffer.buffer[n2 + 1], barBuffer.buffer[n2 + 2], barBuffer.buffer[n2 + 3], this.mRenderPaint);
                }
                n2 += 4;
            }
        }
    }

    protected void prepareBarHighlight(float f, float f2, float f3, float f4, Transformer transformer) {
        float f5 = 0.5f;
        float f6 = f - f5 + f4;
        float f7 = f + f5 - f4;
        float f8 = f2;
        float f9 = f3;
        this.mBarRect.set(f6, f8, f7, f9);
        transformer.rectValueToPixel(this.mBarRect, this.mAnimator.getPhaseY());
    }

    @Override
    public void drawValues(Canvas canvas) {
        if (this.passesCheck() && this.mChart.isDrawValueEnable()) {
            List list = this.mChart.getBarData().getDataSets();
            float f = Utils.convertDpToPixel(4.5f);
            float f2 = 0.0f;
            float f3 = 0.0f;
            boolean bl = this.mChart.isDrawValueAboveBarEnabled();
            int n = 0;
            while (n < this.mChart.getBarData().getDataSetCount()) {
                IBarDataSet iBarDataSet = (IBarDataSet)list.get(n);
                if (iBarDataSet.isDrawValuesEnabled() && iBarDataSet.getEntryCount() != 0) {
                    BarEntry barEntry;
                    int n2;
                    this.applyValueTextStyle(iBarDataSet);
                    boolean bl2 = this.mChart.isInverted(iBarDataSet.getAxisDependency());
                    float f4 = Utils.calcTextHeight(this.mValuePaint, "8");
                    f2 = bl ? -f : f4 + f;
                    float f5 = f3 = bl ? f4 + f : -f;
                    if (bl2) {
                        f2 = -f2 - f4;
                        f3 = -f3 - f4;
                    }
                    Transformer transformer = this.mChart.getTransformer(iBarDataSet.getAxisDependency());
                    float[] fArray = this.getTransformedValues(transformer, iBarDataSet, n);
                    if (!iBarDataSet.isStacked()) {
                        n2 = 0;
                        while ((float)n2 < (float)fArray.length * this.mAnimator.getPhaseX()) {
                            if (this.mViewPortHandler.isInBoundsRight(fArray[n2])) {
                                if (this.mViewPortHandler.isInBoundsY(fArray[n2 + 1]) && this.mViewPortHandler.isInBoundsLeft(fArray[n2])) {
                                    barEntry = (BarEntry)iBarDataSet.getEntryForIndex(n2 / 2);
                                    float f6 = barEntry.getVal();
                                    this.drawValue(canvas, iBarDataSet.getValueFormatter(), f6, barEntry, n, fArray[n2], fArray[n2 + 1] + (f6 >= 0.0f ? f2 : f3), iBarDataSet.getValueTextColor(n2 / 2));
                                }
                                n2 += 2;
                                continue;
                            }
                            break;
                        }
                    } else {
                        n2 = 0;
                        while ((float)n2 < (float)(fArray.length - 1) * this.mAnimator.getPhaseX()) {
                            barEntry = (BarEntry)iBarDataSet.getEntryForIndex(n2 / 2);
                            float[] fArray2 = barEntry.getVals();
                            if (fArray2 == null) {
                                if (!this.mViewPortHandler.isInBoundsRight(fArray[n2])) break;
                                if (this.mViewPortHandler.isInBoundsY(fArray[n2 + 1]) && this.mViewPortHandler.isInBoundsLeft(fArray[n2])) {
                                    this.drawValue(canvas, iBarDataSet.getValueFormatter(), barEntry.getVal(), barEntry, n, fArray[n2], fArray[n2 + 1] + (barEntry.getVal() >= 0.0f ? f2 : f3), iBarDataSet.getValueTextColor(n2 / 2));
                                }
                            } else {
                                float f7;
                                int n3 = iBarDataSet.getValueTextColor(n2 / 2);
                                float[] fArray3 = new float[fArray2.length * 2];
                                float f8 = 0.0f;
                                float f9 = -barEntry.getNegativeSum();
                                int n4 = 0;
                                int n5 = 0;
                                while (n4 < fArray3.length) {
                                    float f10;
                                    f7 = fArray2[n5];
                                    if (f7 >= 0.0f) {
                                        f10 = f8 += f7;
                                    } else {
                                        f10 = f9;
                                        f9 -= f7;
                                    }
                                    fArray3[n4 + 1] = f10 * this.mAnimator.getPhaseY();
                                    n4 += 2;
                                    ++n5;
                                }
                                transformer.pointValuesToPixel(fArray3);
                                n4 = 0;
                                while (n4 < fArray3.length) {
                                    float f11 = fArray[n2];
                                    f7 = fArray3[n4 + 1] + (fArray2[n4 / 2] >= 0.0f ? f2 : f3);
                                    if (!this.mViewPortHandler.isInBoundsRight(f11)) break;
                                    if (this.mViewPortHandler.isInBoundsY(f7) && this.mViewPortHandler.isInBoundsLeft(f11)) {
                                        this.drawValue(canvas, iBarDataSet.getValueFormatter(), fArray2[n4 / 2], barEntry, n, f11, f7, n3);
                                    }
                                    n4 += 2;
                                }
                            }
                            n2 += 2;
                        }
                    }
                }
                ++n;
            }
        }
    }

    @Override
    public void drawHighlighted(Canvas canvas, Highlight[] highlightArray) {
        int n = this.mChart.getBarData().getDataSetCount();
        int n2 = 0;
        while (n2 < highlightArray.length) {
            Highlight highlight = highlightArray[n2];
            int n3 = highlight.getXIndex();
            int n4 = highlight.getDataSetIndex();
            IBarDataSet iBarDataSet = (IBarDataSet)this.mChart.getBarData().getDataSetByIndex(n4);
            if (iBarDataSet != null && iBarDataSet.isHighlightEnabled()) {
                BarEntry barEntry;
                float f = iBarDataSet.getBarSpace() / 2.0f;
                Transformer transformer = this.mChart.getTransformer(iBarDataSet.getAxisDependency());
                this.mHighlightPaint.setColor(iBarDataSet.getHighLightColor());
                this.mHighlightPaint.setAlpha(iBarDataSet.getHighLightAlpha());
                if (n3 >= 0 && (float)n3 < this.mChart.getXChartMax() * this.mAnimator.getPhaseX() / (float)n && (barEntry = (BarEntry)iBarDataSet.getEntryForXIndex(n3)) != null && barEntry.getXIndex() == n3) {
                    float f2;
                    float f3;
                    float f4 = this.mChart.getBarData().getGroupSpace();
                    boolean bl = highlight.getStackIndex() >= 0;
                    float f5 = (float)(n3 * n + n4) + f4 / 2.0f + f4 * (float)n3;
                    if (bl) {
                        f3 = highlight.getRange().from;
                        f2 = highlight.getRange().to;
                    } else {
                        f3 = barEntry.getVal();
                        f2 = 0.0f;
                    }
                    this.prepareBarHighlight(f5, f3, f2, f, transformer);
                    canvas.drawRect(this.mBarRect, this.mHighlightPaint);
                    if (this.mChart.isDrawHighlightArrowEnabled()) {
                        this.mHighlightPaint.setAlpha(255);
                        float f6 = this.mAnimator.getPhaseY() * 0.07f;
                        float[] fArray = new float[9];
                        transformer.getPixelToValueMatrix().getValues(fArray);
                        float f7 = Math.abs(fArray[4] / fArray[0]);
                        float f8 = iBarDataSet.getBarSpace() / 2.0f;
                        float f9 = f8 * f7;
                        float f10 = (f3 > -f2 ? f3 : f3) * this.mAnimator.getPhaseY();
                        Path path = new Path();
                        path.moveTo(f5 + 0.4f, f10 + f6);
                        path.lineTo(f5 + 0.4f + f8, f10 + f6 - f9);
                        path.lineTo(f5 + 0.4f + f8, f10 + f6 + f9);
                        transformer.pathValueToPixel(path);
                        canvas.drawPath(path, this.mHighlightPaint);
                    }
                }
            }
            ++n2;
        }
    }

    public float[] getTransformedValues(Transformer transformer, IBarDataSet iBarDataSet, int n) {
        return transformer.generateTransformedValuesBarChart(iBarDataSet, n, this.mChart.getBarData(), this.mAnimator.getPhaseY());
    }

    protected boolean passesCheck() {
        return (float)this.mChart.getBarData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleX();
    }

    @Override
    public void drawExtras(Canvas canvas) {
    }
}

