/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.CandleData;
import com.github.mikephil.charting.data.CandleEntry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.CandleDataProvider;
import com.github.mikephil.charting.interfaces.datasets.ICandleDataSet;
import com.github.mikephil.charting.renderer.LineScatterCandleRadarRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class CandleStickChartRenderer
extends LineScatterCandleRadarRenderer {
    protected CandleDataProvider mChart;
    private float[] a = new float[8];
    private float[] b = new float[4];
    private float[] c = new float[4];
    private float[] d = new float[4];
    private float[] e = new float[4];

    public CandleStickChartRenderer(CandleDataProvider candleDataProvider, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        super(chartAnimator, viewPortHandler);
        this.mChart = candleDataProvider;
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas canvas) {
        CandleData candleData = this.mChart.getCandleData();
        for (ICandleDataSet iCandleDataSet : candleData.getDataSets()) {
            if (!iCandleDataSet.isVisible() || iCandleDataSet.getEntryCount() <= 0) continue;
            this.drawDataSet(canvas, iCandleDataSet);
        }
    }

    protected void drawDataSet(Canvas canvas, ICandleDataSet iCandleDataSet) {
        Transformer transformer = this.mChart.getTransformer(iCandleDataSet.getAxisDependency());
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        float f3 = iCandleDataSet.getBarSpace();
        boolean bl = iCandleDataSet.getShowCandleBar();
        int n = Math.max(this.mMinX, 0);
        int n2 = Math.min(this.mMaxX + 1, iCandleDataSet.getEntryCount());
        this.mRenderPaint.setStrokeWidth(iCandleDataSet.getShadowWidth());
        int n3 = n;
        int n4 = (int)Math.ceil((float)(n2 - n) * f + (float)n);
        while (n3 < n4) {
            CandleEntry candleEntry = (CandleEntry)iCandleDataSet.getEntryForIndex(n3);
            int n5 = candleEntry.getXIndex();
            if (n5 >= n && n5 < n2) {
                float f4 = candleEntry.getOpen();
                float f5 = candleEntry.getClose();
                float f6 = candleEntry.getHigh();
                float f7 = candleEntry.getLow();
                if (bl) {
                    this.a[0] = n5;
                    this.a[2] = n5;
                    this.a[4] = n5;
                    this.a[6] = n5;
                    if (f4 > f5) {
                        this.a[1] = f6 * f2;
                        this.a[3] = f4 * f2;
                        this.a[5] = f7 * f2;
                        this.a[7] = f5 * f2;
                    } else if (f4 < f5) {
                        this.a[1] = f6 * f2;
                        this.a[3] = f5 * f2;
                        this.a[5] = f7 * f2;
                        this.a[7] = f4 * f2;
                    } else {
                        this.a[1] = f6 * f2;
                        this.a[3] = f4 * f2;
                        this.a[5] = f7 * f2;
                        this.a[7] = this.a[3];
                    }
                    transformer.pointValuesToPixel(this.a);
                    if (iCandleDataSet.getShadowColorSameAsCandle()) {
                        if (f4 > f5) {
                            this.mRenderPaint.setColor(iCandleDataSet.getDecreasingColor() == -1 ? iCandleDataSet.getColor(n3) : iCandleDataSet.getDecreasingColor());
                        } else if (f4 < f5) {
                            this.mRenderPaint.setColor(iCandleDataSet.getIncreasingColor() == -1 ? iCandleDataSet.getColor(n3) : iCandleDataSet.getIncreasingColor());
                        } else {
                            this.mRenderPaint.setColor(iCandleDataSet.getNeutralColor() == -1 ? iCandleDataSet.getColor(n3) : iCandleDataSet.getNeutralColor());
                        }
                    } else {
                        this.mRenderPaint.setColor(iCandleDataSet.getShadowColor() == -1 ? iCandleDataSet.getColor(n3) : iCandleDataSet.getShadowColor());
                    }
                    this.mRenderPaint.setStyle(Paint.Style.STROKE);
                    canvas.drawLines(this.a, this.mRenderPaint);
                    this.b[0] = (float)n5 - 0.5f + f3;
                    this.b[1] = f5 * f2;
                    this.b[2] = (float)n5 + 0.5f - f3;
                    this.b[3] = f4 * f2;
                    transformer.pointValuesToPixel(this.b);
                    if (f4 > f5) {
                        if (iCandleDataSet.getDecreasingColor() == -1) {
                            this.mRenderPaint.setColor(iCandleDataSet.getColor(n3));
                        } else {
                            this.mRenderPaint.setColor(iCandleDataSet.getDecreasingColor());
                        }
                        this.mRenderPaint.setStyle(iCandleDataSet.getDecreasingPaintStyle());
                        canvas.drawRect(this.b[0], this.b[3], this.b[2], this.b[1], this.mRenderPaint);
                    } else if (f4 < f5) {
                        if (iCandleDataSet.getIncreasingColor() == -1) {
                            this.mRenderPaint.setColor(iCandleDataSet.getColor(n3));
                        } else {
                            this.mRenderPaint.setColor(iCandleDataSet.getIncreasingColor());
                        }
                        this.mRenderPaint.setStyle(iCandleDataSet.getIncreasingPaintStyle());
                        canvas.drawRect(this.b[0], this.b[1], this.b[2], this.b[3], this.mRenderPaint);
                    } else {
                        if (iCandleDataSet.getNeutralColor() == -1) {
                            this.mRenderPaint.setColor(iCandleDataSet.getColor(n3));
                        } else {
                            this.mRenderPaint.setColor(iCandleDataSet.getNeutralColor());
                        }
                        canvas.drawLine(this.b[0], this.b[1], this.b[2], this.b[3], this.mRenderPaint);
                    }
                } else {
                    this.c[0] = n5;
                    this.c[1] = f6 * f2;
                    this.c[2] = n5;
                    this.c[3] = f7 * f2;
                    this.d[0] = (float)n5 - 0.5f + f3;
                    this.d[1] = f4 * f2;
                    this.d[2] = n5;
                    this.d[3] = f4 * f2;
                    this.e[0] = (float)n5 + 0.5f - f3;
                    this.e[1] = f5 * f2;
                    this.e[2] = n5;
                    this.e[3] = f5 * f2;
                    transformer.pointValuesToPixel(this.c);
                    transformer.pointValuesToPixel(this.d);
                    transformer.pointValuesToPixel(this.e);
                    int n6 = f4 > f5 ? (iCandleDataSet.getDecreasingColor() == -1 ? iCandleDataSet.getColor(n3) : iCandleDataSet.getDecreasingColor()) : (f4 < f5 ? (iCandleDataSet.getIncreasingColor() == -1 ? iCandleDataSet.getColor(n3) : iCandleDataSet.getIncreasingColor()) : (iCandleDataSet.getNeutralColor() == -1 ? iCandleDataSet.getColor(n3) : iCandleDataSet.getNeutralColor()));
                    this.mRenderPaint.setColor(n6);
                    canvas.drawLine(this.c[0], this.c[1], this.c[2], this.c[3], this.mRenderPaint);
                    canvas.drawLine(this.d[0], this.d[1], this.d[2], this.d[3], this.mRenderPaint);
                    canvas.drawLine(this.e[0], this.e[1], this.e[2], this.e[3], this.mRenderPaint);
                }
            }
            ++n3;
        }
    }

    @Override
    public void drawValues(Canvas canvas) {
        if ((float)this.mChart.getCandleData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleX()) {
            List list = this.mChart.getCandleData().getDataSets();
            int n = 0;
            while (n < list.size()) {
                ICandleDataSet iCandleDataSet = (ICandleDataSet)list.get(n);
                if (iCandleDataSet.isDrawValuesEnabled() && iCandleDataSet.getEntryCount() != 0) {
                    this.applyValueTextStyle(iCandleDataSet);
                    Transformer transformer = this.mChart.getTransformer(iCandleDataSet.getAxisDependency());
                    int n2 = Math.max(this.mMinX, 0);
                    int n3 = Math.min(this.mMaxX + 1, iCandleDataSet.getEntryCount());
                    float[] fArray = transformer.generateTransformedValuesCandle(iCandleDataSet, this.mAnimator.getPhaseX(), this.mAnimator.getPhaseY(), n2, n3);
                    float f = Utils.convertDpToPixel(5.0f);
                    int n4 = 0;
                    while (n4 < fArray.length) {
                        float f2 = fArray[n4];
                        float f3 = fArray[n4 + 1];
                        if (!this.mViewPortHandler.isInBoundsRight(f2)) break;
                        if (this.mViewPortHandler.isInBoundsLeft(f2) && this.mViewPortHandler.isInBoundsY(f3)) {
                            CandleEntry candleEntry = (CandleEntry)iCandleDataSet.getEntryForIndex(n4 / 2 + n2);
                            this.drawValue(canvas, iCandleDataSet.getValueFormatter(), candleEntry.getHigh(), candleEntry, n, f2, f3 - f, iCandleDataSet.getValueTextColor(n4 / 2));
                        }
                        n4 += 2;
                    }
                }
                ++n;
            }
        }
    }

    @Override
    public void drawExtras(Canvas canvas) {
    }

    @Override
    public void drawHighlighted(Canvas canvas, Highlight[] highlightArray) {
        int n = 0;
        while (n < highlightArray.length) {
            CandleEntry candleEntry;
            int n2 = highlightArray[n].getXIndex();
            ICandleDataSet iCandleDataSet = (ICandleDataSet)this.mChart.getCandleData().getDataSetByIndex(highlightArray[n].getDataSetIndex());
            if (iCandleDataSet != null && iCandleDataSet.isHighlightEnabled() && (candleEntry = (CandleEntry)iCandleDataSet.getEntryForXIndex(n2)) != null && candleEntry.getXIndex() == n2) {
                float f = candleEntry.getLow() * this.mAnimator.getPhaseY();
                float f2 = candleEntry.getHigh() * this.mAnimator.getPhaseY();
                float f3 = (f + f2) / 2.0f;
                float f4 = this.mChart.getYChartMin();
                float f5 = this.mChart.getYChartMax();
                float[] fArray = new float[]{n2, f3};
                this.mChart.getTransformer(iCandleDataSet.getAxisDependency()).pointValuesToPixel(fArray);
                this.drawHighlightLines(canvas, fArray, iCandleDataSet);
            }
            ++n;
        }
    }
}

