/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.interfaces.datasets.ICandleDataSet;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.interfaces.datasets.IPieDataSet;
import com.github.mikephil.charting.renderer.Renderer;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LegendRenderer
extends Renderer {
    protected Paint mLegendLabelPaint;
    protected Paint mLegendFormPaint;
    protected Legend mLegend;

    public LegendRenderer(ViewPortHandler viewPortHandler, Legend legend) {
        super(viewPortHandler);
        this.mLegend = legend;
        this.mLegendLabelPaint = new Paint(1);
        this.mLegendLabelPaint.setTextSize(Utils.convertDpToPixel(9.0f));
        this.mLegendLabelPaint.setTextAlign(Paint.Align.LEFT);
        this.mLegendFormPaint = new Paint(1);
        this.mLegendFormPaint.setStyle(Paint.Style.FILL);
        this.mLegendFormPaint.setStrokeWidth(3.0f);
    }

    public Paint getLabelPaint() {
        return this.mLegendLabelPaint;
    }

    public Paint getFormPaint() {
        return this.mLegendFormPaint;
    }

    public void computeLegend(ChartData<?> chartData) {
        Typeface typeface;
        if (!this.mLegend.isLegendCustom()) {
            typeface = new ArrayList();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n = 0;
            while (n < chartData.getDataSetCount()) {
                int n2;
                Object object;
                Object obj = chartData.getDataSetByIndex(n);
                List<Integer> list = obj.getColors();
                int n3 = obj.getEntryCount();
                if (obj instanceof IBarDataSet && ((IBarDataSet)obj).isStacked()) {
                    IBarDataSet iBarDataSet = (IBarDataSet)obj;
                    object = iBarDataSet.getStackLabels();
                    n2 = 0;
                    while (n2 < list.size() && n2 < iBarDataSet.getStackSize()) {
                        typeface.add(object[n2 % ((String[])object).length]);
                        arrayList.add(list.get(n2));
                        ++n2;
                    }
                    if (iBarDataSet.getLabel() != null) {
                        arrayList.add(-2);
                        typeface.add(iBarDataSet.getLabel());
                    }
                } else if (obj instanceof IPieDataSet) {
                    List<String> list2 = chartData.getXVals();
                    object = (String[])obj;
                    n2 = 0;
                    while (n2 < list.size() && n2 < n3 && n2 < list2.size()) {
                        typeface.add(list2.get(n2));
                        arrayList.add(list.get(n2));
                        ++n2;
                    }
                    if (object.getLabel() != null) {
                        arrayList.add(-2);
                        typeface.add(object.getLabel());
                    }
                } else if (obj instanceof ICandleDataSet && ((ICandleDataSet)obj).getDecreasingColor() != -1) {
                    arrayList.add(((ICandleDataSet)obj).getDecreasingColor());
                    arrayList.add(((ICandleDataSet)obj).getIncreasingColor());
                    typeface.add(null);
                    typeface.add(obj.getLabel());
                } else {
                    int n4 = 0;
                    while (n4 < list.size() && n4 < n3) {
                        if (n4 < list.size() - 1 && n4 < n3 - 1) {
                            typeface.add(null);
                        } else {
                            object = ((IDataSet)chartData.getDataSetByIndex(n)).getLabel();
                            typeface.add(object);
                        }
                        arrayList.add(list.get(n4));
                        ++n4;
                    }
                }
                ++n;
            }
            if (this.mLegend.getExtraColors() != null && this.mLegend.getExtraLabels() != null) {
                int[] nArray = this.mLegend.getExtraColors();
                int n5 = nArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    n = nArray[n6];
                    arrayList.add(n);
                    ++n6;
                }
                Collections.addAll(typeface, this.mLegend.getExtraLabels());
            }
            this.mLegend.setComputedColors(arrayList);
            this.mLegend.setComputedLabels((List<String>)typeface);
        }
        if ((typeface = this.mLegend.getTypeface()) != null) {
            this.mLegendLabelPaint.setTypeface(typeface);
        }
        this.mLegendLabelPaint.setTextSize(this.mLegend.getTextSize());
        this.mLegendLabelPaint.setColor(this.mLegend.getTextColor());
        this.mLegend.calculateDimensions(this.mLegendLabelPaint, this.mViewPortHandler);
    }

    public void renderLegend(Canvas canvas) {
        if (!this.mLegend.isEnabled()) {
            return;
        }
        Typeface typeface = this.mLegend.getTypeface();
        if (typeface != null) {
            this.mLegendLabelPaint.setTypeface(typeface);
        }
        this.mLegendLabelPaint.setTextSize(this.mLegend.getTextSize());
        this.mLegendLabelPaint.setColor(this.mLegend.getTextColor());
        float f = Utils.getLineHeight(this.mLegendLabelPaint);
        float f2 = Utils.getLineSpacing(this.mLegendLabelPaint) + this.mLegend.getYEntrySpace();
        float f3 = f - (float)Utils.calcTextHeight(this.mLegendLabelPaint, "ABC") / 2.0f;
        float f4 = Utils.calcTextHeight(this.mLegendLabelPaint, "ABC");
        String[] stringArray = this.mLegend.getLabels();
        int[] nArray = this.mLegend.getColors();
        float f5 = this.mLegend.getFormToTextSpace();
        float f6 = this.mLegend.getXEntrySpace();
        Legend.LegendDirection legendDirection = this.mLegend.getDirection();
        float f7 = this.mLegend.getFormSize();
        float f8 = this.mLegend.getStackSpace();
        float f9 = this.mLegend.getYOffset();
        float f10 = this.mLegend.getXOffset();
        Legend.LegendPosition legendPosition = this.mLegend.getPosition();
        switch (legendPosition) {
            case BELOW_CHART_LEFT: 
            case BELOW_CHART_RIGHT: 
            case BELOW_CHART_CENTER: 
            case ABOVE_CHART_LEFT: 
            case ABOVE_CHART_RIGHT: 
            case ABOVE_CHART_CENTER: {
                float f11;
                float f12 = this.mViewPortHandler.contentWidth();
                if (legendPosition == Legend.LegendPosition.BELOW_CHART_LEFT || legendPosition == Legend.LegendPosition.ABOVE_CHART_LEFT) {
                    f11 = this.mViewPortHandler.contentLeft() + f10;
                    if (legendDirection == Legend.LegendDirection.RIGHT_TO_LEFT) {
                        f11 += this.mLegend.mNeededWidth;
                    }
                } else if (legendPosition == Legend.LegendPosition.BELOW_CHART_RIGHT || legendPosition == Legend.LegendPosition.ABOVE_CHART_RIGHT) {
                    f11 = this.mViewPortHandler.contentRight() - f10;
                    if (legendDirection == Legend.LegendDirection.LEFT_TO_RIGHT) {
                        f11 -= this.mLegend.mNeededWidth;
                    }
                } else {
                    f11 = this.mViewPortHandler.contentLeft() + f12 / 2.0f;
                }
                FSize[] fSizeArray = this.mLegend.getCalculatedLineSizes();
                FSize[] fSizeArray2 = this.mLegend.getCalculatedLabelSizes();
                Boolean[] booleanArray = this.mLegend.getCalculatedLabelBreakPoints();
                float f13 = f11;
                float f14 = legendPosition == Legend.LegendPosition.ABOVE_CHART_LEFT || legendPosition == Legend.LegendPosition.ABOVE_CHART_RIGHT || legendPosition == Legend.LegendPosition.ABOVE_CHART_CENTER ? 0.0f : this.mViewPortHandler.getChartHeight() - f9 - this.mLegend.mNeededHeight;
                int n = 0;
                int n2 = 0;
                int n3 = stringArray.length;
                while (n2 < n3) {
                    boolean bl;
                    if (n2 < booleanArray.length && booleanArray[n2].booleanValue()) {
                        f13 = f11;
                        f14 += f + f2;
                    }
                    if (f13 == f11 && legendPosition == Legend.LegendPosition.BELOW_CHART_CENTER && n < fSizeArray.length) {
                        f13 += (legendDirection == Legend.LegendDirection.RIGHT_TO_LEFT ? fSizeArray[n].width : -fSizeArray[n].width) / 2.0f;
                        ++n;
                    }
                    boolean bl2 = nArray[n2] != -2;
                    boolean bl3 = bl = stringArray[n2] == null;
                    if (bl2) {
                        if (legendDirection == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            f13 -= f7;
                        }
                        this.drawForm(canvas, f13, f14 + f3, n2, this.mLegend);
                        if (legendDirection == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            f13 += f7;
                        }
                    }
                    if (!bl) {
                        if (bl2) {
                            f13 += legendDirection == Legend.LegendDirection.RIGHT_TO_LEFT ? -f5 : f5;
                        }
                        if (legendDirection == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            f13 -= fSizeArray2[n2].width;
                        }
                        this.drawLabel(canvas, f13, f14 + f, stringArray[n2]);
                        if (legendDirection == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            f13 += fSizeArray2[n2].width;
                        }
                        f13 += legendDirection == Legend.LegendDirection.RIGHT_TO_LEFT ? -f6 : f6;
                    } else {
                        f13 += legendDirection == Legend.LegendDirection.RIGHT_TO_LEFT ? -f8 : f8;
                    }
                    ++n2;
                }
                break;
            }
            case RIGHT_OF_CHART: 
            case RIGHT_OF_CHART_CENTER: 
            case RIGHT_OF_CHART_INSIDE: 
            case LEFT_OF_CHART: 
            case LEFT_OF_CHART_CENTER: 
            case LEFT_OF_CHART_INSIDE: 
            case PIECHART_CENTER: {
                int n;
                float f15;
                float f16;
                float f17 = 0.0f;
                boolean bl = false;
                if (legendPosition == Legend.LegendPosition.PIECHART_CENTER) {
                    f16 = this.mViewPortHandler.getChartWidth() / 2.0f + (legendDirection == Legend.LegendDirection.LEFT_TO_RIGHT ? -this.mLegend.mTextWidthMax / 2.0f : this.mLegend.mTextWidthMax / 2.0f);
                    f15 = this.mViewPortHandler.getChartHeight() / 2.0f - this.mLegend.mNeededHeight / 2.0f + this.mLegend.getYOffset();
                } else {
                    int n4 = n = legendPosition != Legend.LegendPosition.RIGHT_OF_CHART && legendPosition != Legend.LegendPosition.RIGHT_OF_CHART_CENTER && legendPosition != Legend.LegendPosition.RIGHT_OF_CHART_INSIDE ? 0 : 1;
                    if (n != 0) {
                        f16 = this.mViewPortHandler.getChartWidth() - f10;
                        if (legendDirection == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            f16 -= this.mLegend.mTextWidthMax;
                        }
                    } else {
                        f16 = f10;
                        if (legendDirection == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            f16 += this.mLegend.mTextWidthMax;
                        }
                    }
                    f15 = legendPosition == Legend.LegendPosition.RIGHT_OF_CHART || legendPosition == Legend.LegendPosition.LEFT_OF_CHART ? this.mViewPortHandler.contentTop() + f9 : (legendPosition == Legend.LegendPosition.RIGHT_OF_CHART_CENTER || legendPosition == Legend.LegendPosition.LEFT_OF_CHART_CENTER ? this.mViewPortHandler.getChartHeight() / 2.0f - this.mLegend.mNeededHeight / 2.0f : this.mViewPortHandler.contentTop() + f9);
                }
                n = 0;
                while (n < stringArray.length) {
                    Boolean bl4 = nArray[n] != -2;
                    float f18 = f16;
                    if (bl4.booleanValue()) {
                        f18 = legendDirection == Legend.LegendDirection.LEFT_TO_RIGHT ? (f18 += f17) : (f18 -= f7 - f17);
                        this.drawForm(canvas, f18, f15 + f3, n, this.mLegend);
                        if (legendDirection == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            f18 += f7;
                        }
                    }
                    if (stringArray[n] != null) {
                        if (bl4.booleanValue() && !bl) {
                            f18 += legendDirection == Legend.LegendDirection.LEFT_TO_RIGHT ? f5 : -f5;
                        } else if (bl) {
                            f18 = f16;
                        }
                        if (legendDirection == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            f18 -= (float)Utils.calcTextWidth(this.mLegendLabelPaint, stringArray[n]);
                        }
                        if (!bl) {
                            this.drawLabel(canvas, f18, f15 + f, stringArray[n]);
                        } else {
                            this.drawLabel(canvas, f18, (f15 += f + f2) + f, stringArray[n]);
                        }
                        f15 += f + f2;
                        f17 = 0.0f;
                    } else {
                        f17 += f7 + f8;
                        bl = true;
                    }
                    ++n;
                }
                break;
            }
        }
    }

    protected void drawForm(Canvas canvas, float f, float f2, int n, Legend legend) {
        if (legend.getColors()[n] == -2) {
            return;
        }
        this.mLegendFormPaint.setColor(legend.getColors()[n]);
        float f3 = legend.getFormSize();
        float f4 = f3 / 2.0f;
        switch (legend.getForm()) {
            case CIRCLE: {
                canvas.drawCircle(f + f4, f2, f4, this.mLegendFormPaint);
                break;
            }
            case SQUARE: {
                canvas.drawRect(f, f2 - f4, f + f3, f2 + f4, this.mLegendFormPaint);
                break;
            }
            case LINE: {
                canvas.drawLine(f, f2, f + f3, f2, this.mLegendFormPaint);
            }
        }
    }

    protected void drawLabel(Canvas canvas, float f, float f2, String string) {
        canvas.drawText(string, f, f2, this.mLegendLabelPaint);
    }
}

