/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.charts.PieChart;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.PieData;
import com.github.mikephil.charting.formatter.ValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IPieDataSet;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.lang.ref.WeakReference;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class PieChartRenderer
extends DataRenderer {
    protected PieChart mChart;
    protected Paint mHolePaint;
    protected Paint mTransparentCirclePaint;
    private TextPaint a;
    private StaticLayout a;
    private CharSequence a;
    private RectF a;
    private RectF[] a;
    protected WeakReference<Bitmap> mDrawBitmap;
    protected Canvas mBitmapCanvas;
    private Path a = new Path();
    private RectF b;
    private Path b = new Path();

    public PieChartRenderer(PieChart pieChart, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        super(chartAnimator, viewPortHandler);
        this.mChart = pieChart;
        this.mHolePaint = new Paint(1);
        this.mHolePaint.setColor(-1);
        this.mHolePaint.setStyle(Paint.Style.FILL);
        this.mTransparentCirclePaint = new Paint(1);
        this.mTransparentCirclePaint.setColor(-1);
        this.mTransparentCirclePaint.setStyle(Paint.Style.FILL);
        this.mTransparentCirclePaint.setAlpha(105);
        this.a = new TextPaint(1);
        this.a.setColor(-16777216);
        this.a.setTextSize(Utils.convertDpToPixel(12.0f));
        this.mValuePaint.setTextSize(Utils.convertDpToPixel(13.0f));
        this.mValuePaint.setColor(-1);
        this.mValuePaint.setTextAlign(Paint.Align.CENTER);
    }

    public Paint getPaintHole() {
        return this.mHolePaint;
    }

    public Paint getPaintTransparentCircle() {
        return this.mTransparentCirclePaint;
    }

    public TextPaint getPaintCenterText() {
        return this.a;
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas canvas) {
        int n = (int)this.mViewPortHandler.getChartWidth();
        int n2 = (int)this.mViewPortHandler.getChartHeight();
        if (this.mDrawBitmap == null || ((Bitmap)this.mDrawBitmap.get()).getWidth() != n || ((Bitmap)this.mDrawBitmap.get()).getHeight() != n2) {
            if (n > 0 && n2 > 0) {
                this.mDrawBitmap = new WeakReference<Bitmap>(Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_4444));
                this.mBitmapCanvas = new Canvas((Bitmap)this.mDrawBitmap.get());
            } else {
                return;
            }
        }
        ((Bitmap)this.mDrawBitmap.get()).eraseColor(0);
        PieData pieData = (PieData)this.mChart.getData();
        for (IPieDataSet iPieDataSet : pieData.getDataSets()) {
            if (!iPieDataSet.isVisible() || iPieDataSet.getEntryCount() <= 0) continue;
            this.drawDataSet(canvas, iPieDataSet);
        }
    }

    protected float calculateMinimumRadiusForSpacedSlice(PointF pointF, float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f5 + f6 / 2.0f;
        float f8 = pointF.x + f * (float)Math.cos((f5 + f6) * ((float)Math.PI / 180));
        float f9 = pointF.y + f * (float)Math.sin((f5 + f6) * ((float)Math.PI / 180));
        float f10 = pointF.x + f * (float)Math.cos(f7 * ((float)Math.PI / 180));
        float f11 = pointF.y + f * (float)Math.sin(f7 * ((float)Math.PI / 180));
        double d = Math.sqrt(Math.pow(f8 - f3, 2.0) + Math.pow(f9 - f4, 2.0));
        float f12 = (float)(d / 2.0 * Math.tan((180.0 - (double)f2) / 2.0 * (Math.PI / 180)));
        float f13 = f - f12;
        f13 = (float)((double)f13 - Math.sqrt(Math.pow(f10 - (f8 + f3) / 2.0f, 2.0) + Math.pow(f11 - (f9 + f4) / 2.0f, 2.0)));
        return f13;
    }

    protected void drawDataSet(Canvas canvas, IPieDataSet iPieDataSet) {
        float f = 0.0f;
        float f2 = this.mChart.getRotationAngle();
        float f3 = this.mAnimator.getPhaseX();
        float f4 = this.mAnimator.getPhaseY();
        RectF rectF = this.mChart.getCircleBox();
        int n = iPieDataSet.getEntryCount();
        float[] fArray = this.mChart.getDrawAngles();
        PointF pointF = this.mChart.getCenterCircleBox();
        float f5 = this.mChart.getRadius();
        boolean bl = this.mChart.isDrawHoleEnabled() && !this.mChart.isDrawSlicesUnderHoleEnabled();
        float f6 = bl ? f5 * (this.mChart.getHoleRadius() / 100.0f) : 0.0f;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if ((double)Math.abs(((Entry)iPieDataSet.getEntryForIndex(n3)).getVal()) > 1.0E-6) {
                ++n2;
            }
            ++n3;
        }
        float f7 = n2 <= 1 ? 0.0f : iPieDataSet.getSliceSpace();
        int n4 = 0;
        while (n4 < n) {
            float f8 = fArray[n4];
            float f9 = f6;
            Object t = iPieDataSet.getEntryForIndex(n4);
            if ((double)Math.abs(((Entry)t).getVal()) > 1.0E-6 && !this.mChart.needsHighlight(((Entry)t).getXIndex(), ((PieData)this.mChart.getData()).getIndexOfDataSet(iPieDataSet))) {
                float f10;
                float f11;
                float f12;
                float f13;
                this.mRenderPaint.setColor(iPieDataSet.getColor(n4));
                float f14 = n2 == 1 ? 0.0f : f7 / ((float)Math.PI / 180 * f5);
                float f15 = f2 + (f + f14 / 2.0f) * f4;
                float f16 = (f8 - f14) * f4;
                if (f16 < 0.0f) {
                    f16 = 0.0f;
                }
                this.a.reset();
                float f17 = 0.0f;
                float f18 = 0.0f;
                if (f16 % 360.0f == 0.0f) {
                    this.a.addCircle(pointF.x, pointF.y, f5, Path.Direction.CW);
                } else {
                    f17 = pointF.x + f5 * (float)Math.cos(f15 * ((float)Math.PI / 180));
                    f18 = pointF.y + f5 * (float)Math.sin(f15 * ((float)Math.PI / 180));
                    this.a.moveTo(f17, f18);
                    this.a.arcTo(rectF, f15, f16);
                }
                this.b.set(pointF.x - f9, pointF.y - f9, pointF.x + f9, pointF.y + f9);
                if (bl && (f9 > 0.0f || f7 > 0.0f)) {
                    if (f7 > 0.0f) {
                        f13 = this.calculateMinimumRadiusForSpacedSlice(pointF, f5, f8 * f4, f17, f18, f15, f16);
                        if (f13 < 0.0f) {
                            f13 = -f13;
                        }
                        f9 = Math.max(f9, f13);
                    }
                    f13 = n2 == 1 || f9 == 0.0f ? 0.0f : f7 / ((float)Math.PI / 180 * f9);
                    f12 = f2 + (f + f13 / 2.0f) * f4;
                    f11 = (f8 - f13) * f4;
                    if (f11 < 0.0f) {
                        f11 = 0.0f;
                    }
                    f10 = f12 + f11;
                    if (f16 % 360.0f == 0.0f) {
                        this.a.addCircle(pointF.x, pointF.y, f9, Path.Direction.CCW);
                    } else {
                        this.a.lineTo(pointF.x + f9 * (float)Math.cos(f10 * ((float)Math.PI / 180)), pointF.y + f9 * (float)Math.sin(f10 * ((float)Math.PI / 180)));
                        this.a.arcTo(this.b, f10, -f11);
                    }
                } else if (f16 % 360.0f != 0.0f) {
                    if (f7 > 0.0f) {
                        f13 = f15 + f16 / 2.0f;
                        f12 = this.calculateMinimumRadiusForSpacedSlice(pointF, f5, f8 * f4, f17, f18, f15, f16);
                        f11 = pointF.x + f12 * (float)Math.cos(f13 * ((float)Math.PI / 180));
                        f10 = pointF.y + f12 * (float)Math.sin(f13 * ((float)Math.PI / 180));
                        this.a.lineTo(f11, f10);
                    } else {
                        this.a.lineTo(pointF.x, pointF.y);
                    }
                }
                this.a.close();
                this.mBitmapCanvas.drawPath(this.a, this.mRenderPaint);
            }
            f += f8 * f3;
            ++n4;
        }
    }

    @Override
    public void drawValues(Canvas canvas) {
        PointF pointF = this.mChart.getCenterCircleBox();
        float f = this.mChart.getRadius();
        float f2 = this.mChart.getRotationAngle();
        float[] fArray = this.mChart.getDrawAngles();
        float[] fArray2 = this.mChart.getAbsoluteAngles();
        float f3 = this.mAnimator.getPhaseX();
        float f4 = this.mAnimator.getPhaseY();
        float f5 = f / 10.0f * 3.6f;
        if (this.mChart.isDrawHoleEnabled()) {
            f5 = (f - f / 100.0f * this.mChart.getHoleRadius()) / 2.0f;
        }
        f -= f5;
        PieData pieData = (PieData)this.mChart.getData();
        List list = pieData.getDataSets();
        float f6 = pieData.getYValueSum();
        boolean bl = this.mChart.isDrawSliceTextEnabled();
        int n = 0;
        int n2 = 0;
        while (n2 < list.size()) {
            IPieDataSet iPieDataSet = (IPieDataSet)list.get(n2);
            if (iPieDataSet.isDrawValuesEnabled() || bl) {
                this.applyValueTextStyle(iPieDataSet);
                float f7 = (float)Utils.calcTextHeight(this.mValuePaint, "Q") + Utils.convertDpToPixel(4.0f);
                int n3 = iPieDataSet.getEntryCount();
                int n4 = 0;
                int n5 = Math.min((int)Math.ceil((float)n3 * f3), n3);
                while (n4 < n5) {
                    Object t = iPieDataSet.getEntryForIndex(n4);
                    float f8 = n == 0 ? 0.0f : fArray2[n - 1] * f3;
                    float f9 = fArray[n];
                    float f10 = iPieDataSet.getSliceSpace();
                    float f11 = f10 / ((float)Math.PI / 180 * f);
                    float f12 = (f9 - f11 / 2.0f) / 2.0f;
                    float f13 = (float)((double)f * Math.cos(Math.toRadians(f2 + (f8 += f12))) + (double)pointF.x);
                    float f14 = (float)((double)f * Math.sin(Math.toRadians(f2 + f8)) + (double)pointF.y);
                    float f15 = this.mChart.isUsePercentValuesEnabled() ? ((Entry)t).getVal() / f6 * 100.0f : ((Entry)t).getVal();
                    ValueFormatter valueFormatter = iPieDataSet.getValueFormatter();
                    boolean bl2 = iPieDataSet.isDrawValuesEnabled();
                    if (bl && bl2) {
                        this.drawValue(canvas, valueFormatter, f15, (Entry)t, 0, f13, f14, iPieDataSet.getValueTextColor(n4));
                        if (n4 < pieData.getXValCount()) {
                            canvas.drawText(pieData.getXVals().get(n4), f13, f14 + f7, this.mValuePaint);
                        }
                    } else if (bl) {
                        if (n4 < pieData.getXValCount()) {
                            this.mValuePaint.setColor(iPieDataSet.getValueTextColor(n4));
                            canvas.drawText(pieData.getXVals().get(n4), f13, f14 + f7 / 2.0f, this.mValuePaint);
                        }
                    } else if (bl2) {
                        this.drawValue(canvas, valueFormatter, f15, (Entry)t, 0, f13, f14 + f7 / 2.0f, iPieDataSet.getValueTextColor(n4));
                    }
                    ++n;
                    ++n4;
                }
            }
            ++n2;
        }
    }

    @Override
    public void drawExtras(Canvas canvas) {
        if (this.mDrawBitmap == null) {
            return;
        }
        this.drawHole(canvas);
        canvas.drawBitmap((Bitmap)this.mDrawBitmap.get(), 0.0f, 0.0f, null);
        this.drawCenterText(canvas);
    }

    protected void drawHole(Canvas canvas) {
        if (this.mChart.isDrawHoleEnabled()) {
            float f = this.mChart.getRadius();
            float f2 = f * (this.mChart.getHoleRadius() / 100.0f);
            PointF pointF = this.mChart.getCenterCircleBox();
            if (Color.alpha((int)this.mHolePaint.getColor()) > 0) {
                this.mBitmapCanvas.drawCircle(pointF.x, pointF.y, f2, this.mHolePaint);
            }
            if (Color.alpha((int)this.mTransparentCirclePaint.getColor()) > 0 && this.mChart.getTransparentCircleRadius() > this.mChart.getHoleRadius()) {
                int n = this.mTransparentCirclePaint.getAlpha();
                float f3 = f * (this.mChart.getTransparentCircleRadius() / 100.0f);
                this.mTransparentCirclePaint.setAlpha((int)((float)n * this.mAnimator.getPhaseX() * this.mAnimator.getPhaseY()));
                this.b.reset();
                this.b.addCircle(pointF.x, pointF.y, f3, Path.Direction.CW);
                this.b.addCircle(pointF.x, pointF.y, f2, Path.Direction.CCW);
                this.mBitmapCanvas.drawPath(this.b, this.mTransparentCirclePaint);
                this.mTransparentCirclePaint.setAlpha(n);
            }
        }
    }

    protected void drawCenterText(Canvas canvas) {
        CharSequence charSequence = this.mChart.getCenterText();
        if (this.mChart.isDrawCenterTextEnabled() && charSequence != null) {
            float f;
            PointF pointF = this.mChart.getCenterCircleBox();
            float f2 = this.mChart.isDrawHoleEnabled() && !this.mChart.isDrawSlicesUnderHoleEnabled() ? this.mChart.getRadius() * (this.mChart.getHoleRadius() / 100.0f) : this.mChart.getRadius();
            RectF rectF = this.a[0];
            rectF.left = pointF.x - f2;
            rectF.top = pointF.y - f2;
            rectF.right = pointF.x + f2;
            rectF.bottom = pointF.y + f2;
            RectF rectF2 = this.a[1];
            rectF2.set(rectF);
            float f3 = this.mChart.getCenterTextRadiusPercent() / 100.0f;
            if ((double)f3 > 0.0) {
                rectF2.inset((rectF2.width() - rectF2.width() * f3) / 2.0f, (rectF2.height() - rectF2.height() * f3) / 2.0f);
            }
            if (!charSequence.equals(this.a) || !rectF2.equals((Object)this.a)) {
                this.a.set(rectF2);
                this.a = charSequence;
                f = this.a.width();
                this.a = new StaticLayout(charSequence, 0, charSequence.length(), this.a, (int)Math.max(Math.ceil(f), 1.0), Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
            }
            f = this.a.getHeight();
            canvas.save();
            if (Build.VERSION.SDK_INT >= 18) {
                Path path = new Path();
                path.addOval(rectF, Path.Direction.CW);
                canvas.clipPath(path);
            }
            canvas.translate(rectF2.left, rectF2.top + (rectF2.height() - f) / 2.0f);
            this.a.draw(canvas);
            canvas.restore();
        }
    }

    @Override
    public void drawHighlighted(Canvas canvas, Highlight[] highlightArray) {
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        float f3 = this.mChart.getRotationAngle();
        float[] fArray = this.mChart.getDrawAngles();
        float[] fArray2 = this.mChart.getAbsoluteAngles();
        PointF pointF = this.mChart.getCenterCircleBox();
        float f4 = this.mChart.getRadius();
        boolean bl = this.mChart.isDrawHoleEnabled() && !this.mChart.isDrawSlicesUnderHoleEnabled();
        float f5 = bl ? f4 * (this.mChart.getHoleRadius() / 100.0f) : 0.0f;
        RectF rectF = new RectF();
        int n = 0;
        while (n < highlightArray.length) {
            IPieDataSet iPieDataSet;
            int n2 = highlightArray[n].getXIndex();
            if (n2 < fArray.length && (iPieDataSet = ((PieData)this.mChart.getData()).getDataSetByIndex(highlightArray[n].getDataSetIndex())) != null && iPieDataSet.isHighlightEnabled()) {
                float f6;
                float f7;
                float f8;
                int n3 = iPieDataSet.getEntryCount();
                int n4 = 0;
                int n5 = 0;
                while (n5 < n3) {
                    if ((double)Math.abs(((Entry)iPieDataSet.getEntryForIndex(n5)).getVal()) > 1.0E-6) {
                        ++n4;
                    }
                    ++n5;
                }
                float f9 = n2 == 0 ? 0.0f : fArray2[n2 - 1] * f;
                float f10 = n4 <= 1 ? 0.0f : iPieDataSet.getSliceSpace();
                float f11 = fArray[n2];
                float f12 = f5;
                float f13 = iPieDataSet.getSelectionShift();
                float f14 = f4 + f13;
                rectF.set(this.mChart.getCircleBox());
                rectF.inset(-f13, -f13);
                this.mRenderPaint.setColor(iPieDataSet.getColor(n2));
                float f15 = n4 == 1 ? 0.0f : f10 / ((float)Math.PI / 180 * f4);
                float f16 = n4 == 1 ? 0.0f : f10 / ((float)Math.PI / 180 * f14);
                float f17 = f3 + (f9 + f15 / 2.0f) * f2;
                float f18 = (f11 - f15) * f2;
                if (f18 < 0.0f) {
                    f18 = 0.0f;
                }
                float f19 = f3 + (f9 + f16 / 2.0f) * f2;
                float f20 = (f11 - f16) * f2;
                if (f20 < 0.0f) {
                    f20 = 0.0f;
                }
                this.a.reset();
                if (f18 % 360.0f == 0.0f) {
                    this.a.addCircle(pointF.x, pointF.y, f14, Path.Direction.CW);
                } else {
                    this.a.moveTo(pointF.x + f14 * (float)Math.cos(f19 * ((float)Math.PI / 180)), pointF.y + f14 * (float)Math.sin(f19 * ((float)Math.PI / 180)));
                    this.a.arcTo(rectF, f19, f20);
                }
                float f21 = 0.0f;
                if (f10 > 0.0f) {
                    f21 = this.calculateMinimumRadiusForSpacedSlice(pointF, f4, f11 * f2, pointF.x + f4 * (float)Math.cos(f17 * ((float)Math.PI / 180)), pointF.y + f4 * (float)Math.sin(f17 * ((float)Math.PI / 180)), f17, f18);
                }
                this.b.set(pointF.x - f12, pointF.y - f12, pointF.x + f12, pointF.y + f12);
                if (bl && (f12 > 0.0f || f10 > 0.0f)) {
                    if (f10 > 0.0f) {
                        f8 = f21;
                        if (f8 < 0.0f) {
                            f8 = -f8;
                        }
                        f12 = Math.max(f12, f8);
                    }
                    f8 = n4 == 1 || f12 == 0.0f ? 0.0f : f10 / ((float)Math.PI / 180 * f12);
                    f7 = f3 + (f9 + f8 / 2.0f) * f2;
                    f6 = (f11 - f8) * f2;
                    if (f6 < 0.0f) {
                        f6 = 0.0f;
                    }
                    float f22 = f7 + f6;
                    if (f18 % 360.0f == 0.0f) {
                        this.a.addCircle(pointF.x, pointF.y, f12, Path.Direction.CCW);
                    } else {
                        this.a.lineTo(pointF.x + f12 * (float)Math.cos(f22 * ((float)Math.PI / 180)), pointF.y + f12 * (float)Math.sin(f22 * ((float)Math.PI / 180)));
                        this.a.arcTo(this.b, f22, -f6);
                    }
                } else if (f18 % 360.0f != 0.0f) {
                    if ((double)f10 > 0.0) {
                        f8 = f17 + f18 / 2.0f;
                        f7 = pointF.x + f21 * (float)Math.cos(f8 * ((float)Math.PI / 180));
                        f6 = pointF.y + f21 * (float)Math.sin(f8 * ((float)Math.PI / 180));
                        this.a.lineTo(f7, f6);
                    } else {
                        this.a.lineTo(pointF.x, pointF.y);
                    }
                }
                this.a.close();
                this.mBitmapCanvas.drawPath(this.a, this.mRenderPaint);
            }
            ++n;
        }
    }

    protected void drawRoundedSlices(Canvas canvas) {
        if (!this.mChart.isDrawRoundedSlicesEnabled()) {
            return;
        }
        IPieDataSet iPieDataSet = ((PieData)this.mChart.getData()).getDataSet();
        if (!iPieDataSet.isVisible()) {
            return;
        }
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        PointF pointF = this.mChart.getCenterCircleBox();
        float f3 = this.mChart.getRadius();
        float f4 = (f3 - f3 * this.mChart.getHoleRadius() / 100.0f) / 2.0f;
        float[] fArray = this.mChart.getDrawAngles();
        float f5 = this.mChart.getRotationAngle();
        int n = 0;
        while (n < iPieDataSet.getEntryCount()) {
            float f6 = fArray[n];
            Object t = iPieDataSet.getEntryForIndex(n);
            if ((double)Math.abs(((Entry)t).getVal()) > 1.0E-6) {
                float f7 = (float)((double)(f3 - f4) * Math.cos(Math.toRadians((f5 + f6) * f2)) + (double)pointF.x);
                float f8 = (float)((double)(f3 - f4) * Math.sin(Math.toRadians((f5 + f6) * f2)) + (double)pointF.y);
                this.mRenderPaint.setColor(iPieDataSet.getColor(n));
                this.mBitmapCanvas.drawCircle(f7, f8, f4, this.mRenderPaint);
            }
            f5 += f6 * f;
            ++n;
        }
    }

    public void releaseBitmap() {
        if (this.mDrawBitmap != null) {
            ((Bitmap)this.mDrawBitmap.get()).recycle();
            this.mDrawBitmap.clear();
            this.mDrawBitmap = null;
        }
    }
}

