/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.ScatterBuffer;
import com.github.mikephil.charting.charts.ScatterChart;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.ScatterDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IScatterDataSet;
import com.github.mikephil.charting.renderer.LineScatterCandleRadarRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class ScatterChartRenderer
extends LineScatterCandleRadarRenderer {
    protected ScatterDataProvider mChart;
    protected ScatterBuffer[] mScatterBuffers;

    public ScatterChartRenderer(ScatterDataProvider scatterDataProvider, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        super(chartAnimator, viewPortHandler);
        this.mChart = scatterDataProvider;
    }

    @Override
    public void initBuffers() {
        ScatterData scatterData = this.mChart.getScatterData();
        this.mScatterBuffers = new ScatterBuffer[scatterData.getDataSetCount()];
        int n = 0;
        while (n < this.mScatterBuffers.length) {
            IScatterDataSet iScatterDataSet = (IScatterDataSet)scatterData.getDataSetByIndex(n);
            this.mScatterBuffers[n] = new ScatterBuffer(iScatterDataSet.getEntryCount() * 2);
            ++n;
        }
    }

    @Override
    public void drawData(Canvas canvas) {
        ScatterData scatterData = this.mChart.getScatterData();
        for (IScatterDataSet iScatterDataSet : scatterData.getDataSets()) {
            if (!iScatterDataSet.isVisible()) continue;
            this.drawDataSet(canvas, iScatterDataSet);
        }
    }

    protected void drawDataSet(Canvas canvas, IScatterDataSet iScatterDataSet) {
        Transformer transformer = this.mChart.getTransformer(iScatterDataSet.getAxisDependency());
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        float f3 = Utils.convertDpToPixel(iScatterDataSet.getScatterShapeSize());
        float f4 = f3 / 2.0f;
        float f5 = Utils.convertDpToPixel(iScatterDataSet.getScatterShapeHoleRadius());
        float f6 = f5 * 2.0f;
        int n = iScatterDataSet.getScatterShapeHoleColor();
        float f7 = (f3 - f6) / 2.0f;
        float f8 = f7 / 2.0f;
        ScatterChart.ScatterShape scatterShape = iScatterDataSet.getScatterShape();
        ScatterBuffer scatterBuffer = this.mScatterBuffers[this.mChart.getScatterData().getIndexOfDataSet(iScatterDataSet)];
        scatterBuffer.setPhases(f, f2);
        scatterBuffer.feed(iScatterDataSet);
        transformer.pointValuesToPixel(scatterBuffer.buffer);
        block0 : switch (scatterShape) {
            case SQUARE: {
                int n2 = 0;
                while (n2 < scatterBuffer.size()) {
                    if (!this.mViewPortHandler.isInBoundsRight(scatterBuffer.buffer[n2])) break block0;
                    if (this.mViewPortHandler.isInBoundsLeft(scatterBuffer.buffer[n2]) && this.mViewPortHandler.isInBoundsY(scatterBuffer.buffer[n2 + 1])) {
                        this.mRenderPaint.setColor(iScatterDataSet.getColor(n2 / 2));
                        if ((double)f6 > 0.0) {
                            this.mRenderPaint.setStyle(Paint.Style.STROKE);
                            this.mRenderPaint.setStrokeWidth(f7);
                            canvas.drawRect(scatterBuffer.buffer[n2] - f5 - f8, scatterBuffer.buffer[n2 + 1] - f5 - f8, scatterBuffer.buffer[n2] + f5 + f8, scatterBuffer.buffer[n2 + 1] + f5 + f8, this.mRenderPaint);
                            if (n != -1) {
                                this.mRenderPaint.setStyle(Paint.Style.FILL);
                                this.mRenderPaint.setColor(n);
                                canvas.drawRect(scatterBuffer.buffer[n2] - f5, scatterBuffer.buffer[n2 + 1] - f5, scatterBuffer.buffer[n2] + f5, scatterBuffer.buffer[n2 + 1] + f5, this.mRenderPaint);
                            }
                        } else {
                            this.mRenderPaint.setStyle(Paint.Style.FILL);
                            canvas.drawRect(scatterBuffer.buffer[n2] - f4, scatterBuffer.buffer[n2 + 1] - f4, scatterBuffer.buffer[n2] + f4, scatterBuffer.buffer[n2 + 1] + f4, this.mRenderPaint);
                        }
                    }
                    n2 += 2;
                }
                break;
            }
            case CIRCLE: {
                int n3 = 0;
                while (n3 < scatterBuffer.size()) {
                    if (!this.mViewPortHandler.isInBoundsRight(scatterBuffer.buffer[n3])) break block0;
                    if (this.mViewPortHandler.isInBoundsLeft(scatterBuffer.buffer[n3]) && this.mViewPortHandler.isInBoundsY(scatterBuffer.buffer[n3 + 1])) {
                        this.mRenderPaint.setColor(iScatterDataSet.getColor(n3 / 2));
                        if ((double)f6 > 0.0) {
                            this.mRenderPaint.setStyle(Paint.Style.STROKE);
                            this.mRenderPaint.setStrokeWidth(f7);
                            canvas.drawCircle(scatterBuffer.buffer[n3], scatterBuffer.buffer[n3 + 1], f5 + f8, this.mRenderPaint);
                            if (n != -1) {
                                this.mRenderPaint.setStyle(Paint.Style.FILL);
                                this.mRenderPaint.setColor(n);
                                canvas.drawCircle(scatterBuffer.buffer[n3], scatterBuffer.buffer[n3 + 1], f5, this.mRenderPaint);
                            }
                        } else {
                            this.mRenderPaint.setStyle(Paint.Style.FILL);
                            canvas.drawCircle(scatterBuffer.buffer[n3], scatterBuffer.buffer[n3 + 1], f4, this.mRenderPaint);
                        }
                    }
                    n3 += 2;
                }
                break;
            }
            case TRIANGLE: {
                this.mRenderPaint.setStyle(Paint.Style.FILL);
                Path path = new Path();
                int n4 = 0;
                while (n4 < scatterBuffer.size()) {
                    if (!this.mViewPortHandler.isInBoundsRight(scatterBuffer.buffer[n4])) break block0;
                    if (this.mViewPortHandler.isInBoundsLeft(scatterBuffer.buffer[n4]) && this.mViewPortHandler.isInBoundsY(scatterBuffer.buffer[n4 + 1])) {
                        this.mRenderPaint.setColor(iScatterDataSet.getColor(n4 / 2));
                        path.moveTo(scatterBuffer.buffer[n4], scatterBuffer.buffer[n4 + 1] - f4);
                        path.lineTo(scatterBuffer.buffer[n4] + f4, scatterBuffer.buffer[n4 + 1] + f4);
                        path.lineTo(scatterBuffer.buffer[n4] - f4, scatterBuffer.buffer[n4 + 1] + f4);
                        if ((double)f6 > 0.0) {
                            path.lineTo(scatterBuffer.buffer[n4], scatterBuffer.buffer[n4 + 1] - f4);
                            path.moveTo(scatterBuffer.buffer[n4] - f4 + f7, scatterBuffer.buffer[n4 + 1] + f4 - f7);
                            path.lineTo(scatterBuffer.buffer[n4] + f4 - f7, scatterBuffer.buffer[n4 + 1] + f4 - f7);
                            path.lineTo(scatterBuffer.buffer[n4], scatterBuffer.buffer[n4 + 1] - f4 + f7);
                            path.lineTo(scatterBuffer.buffer[n4] - f4 + f7, scatterBuffer.buffer[n4 + 1] + f4 - f7);
                        }
                        path.close();
                        canvas.drawPath(path, this.mRenderPaint);
                        path.reset();
                        if ((double)f6 > 0.0 && n != -1) {
                            this.mRenderPaint.setColor(n);
                            path.moveTo(scatterBuffer.buffer[n4], scatterBuffer.buffer[n4 + 1] - f4 + f7);
                            path.lineTo(scatterBuffer.buffer[n4] + f4 - f7, scatterBuffer.buffer[n4 + 1] + f4 - f7);
                            path.lineTo(scatterBuffer.buffer[n4] - f4 + f7, scatterBuffer.buffer[n4 + 1] + f4 - f7);
                            path.close();
                            canvas.drawPath(path, this.mRenderPaint);
                            path.reset();
                        }
                    }
                    n4 += 2;
                }
                break;
            }
            case CROSS: {
                this.mRenderPaint.setStyle(Paint.Style.STROKE);
                this.mRenderPaint.setStrokeWidth(Utils.convertDpToPixel(1.0f));
                int n5 = 0;
                while (n5 < scatterBuffer.size()) {
                    if (!this.mViewPortHandler.isInBoundsRight(scatterBuffer.buffer[n5])) break block0;
                    if (this.mViewPortHandler.isInBoundsLeft(scatterBuffer.buffer[n5]) && this.mViewPortHandler.isInBoundsY(scatterBuffer.buffer[n5 + 1])) {
                        this.mRenderPaint.setColor(iScatterDataSet.getColor(n5 / 2));
                        canvas.drawLine(scatterBuffer.buffer[n5] - f4, scatterBuffer.buffer[n5 + 1], scatterBuffer.buffer[n5] + f4, scatterBuffer.buffer[n5 + 1], this.mRenderPaint);
                        canvas.drawLine(scatterBuffer.buffer[n5], scatterBuffer.buffer[n5 + 1] - f4, scatterBuffer.buffer[n5], scatterBuffer.buffer[n5 + 1] + f4, this.mRenderPaint);
                    }
                    n5 += 2;
                }
                break;
            }
            case X: {
                this.mRenderPaint.setStyle(Paint.Style.STROKE);
                this.mRenderPaint.setStrokeWidth(Utils.convertDpToPixel(1.0f));
                int n6 = 0;
                while (n6 < scatterBuffer.size()) {
                    if (!this.mViewPortHandler.isInBoundsRight(scatterBuffer.buffer[n6])) break block0;
                    if (this.mViewPortHandler.isInBoundsLeft(scatterBuffer.buffer[n6]) && this.mViewPortHandler.isInBoundsY(scatterBuffer.buffer[n6 + 1])) {
                        this.mRenderPaint.setColor(iScatterDataSet.getColor(n6 / 2));
                        canvas.drawLine(scatterBuffer.buffer[n6] - f4, scatterBuffer.buffer[n6 + 1] - f4, scatterBuffer.buffer[n6] + f4, scatterBuffer.buffer[n6 + 1] + f4, this.mRenderPaint);
                        canvas.drawLine(scatterBuffer.buffer[n6] + f4, scatterBuffer.buffer[n6 + 1] - f4, scatterBuffer.buffer[n6] - f4, scatterBuffer.buffer[n6 + 1] + f4, this.mRenderPaint);
                    }
                    n6 += 2;
                }
                break;
            }
        }
    }

    @Override
    public void drawValues(Canvas canvas) {
        if ((float)this.mChart.getScatterData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleX()) {
            List list = this.mChart.getScatterData().getDataSets();
            int n = 0;
            while (n < this.mChart.getScatterData().getDataSetCount()) {
                IScatterDataSet iScatterDataSet = (IScatterDataSet)list.get(n);
                if (iScatterDataSet.isDrawValuesEnabled() && iScatterDataSet.getEntryCount() != 0) {
                    this.applyValueTextStyle(iScatterDataSet);
                    float[] fArray = this.mChart.getTransformer(iScatterDataSet.getAxisDependency()).generateTransformedValuesScatter(iScatterDataSet, this.mAnimator.getPhaseY());
                    float f = Utils.convertDpToPixel(iScatterDataSet.getScatterShapeSize());
                    int n2 = 0;
                    while ((float)n2 < (float)fArray.length * this.mAnimator.getPhaseX()) {
                        if (!this.mViewPortHandler.isInBoundsRight(fArray[n2])) break;
                        if (this.mViewPortHandler.isInBoundsLeft(fArray[n2]) && this.mViewPortHandler.isInBoundsY(fArray[n2 + 1])) {
                            Object t = iScatterDataSet.getEntryForIndex(n2 / 2);
                            this.drawValue(canvas, iScatterDataSet.getValueFormatter(), ((Entry)t).getVal(), (Entry)t, n, fArray[n2], fArray[n2 + 1] - f, iScatterDataSet.getValueTextColor(n2 / 2));
                        }
                        n2 += 2;
                    }
                }
                ++n;
            }
        }
    }

    @Override
    public void drawExtras(Canvas canvas) {
    }

    @Override
    public void drawHighlighted(Canvas canvas, Highlight[] highlightArray) {
        int n = 0;
        while (n < highlightArray.length) {
            float f;
            int n2;
            IScatterDataSet iScatterDataSet = (IScatterDataSet)this.mChart.getScatterData().getDataSetByIndex(highlightArray[n].getDataSetIndex());
            if (iScatterDataSet != null && iScatterDataSet.isHighlightEnabled() && !((float)(n2 = highlightArray[n].getXIndex()) > this.mChart.getXChartMax() * this.mAnimator.getPhaseX()) && (f = iScatterDataSet.getYValForXIndex(n2)) != Float.NaN) {
                float f2 = f * this.mAnimator.getPhaseY();
                float[] fArray = new float[]{n2, f2};
                this.mChart.getTransformer(iScatterDataSet.getAxisDependency()).pointValuesToPixel(fArray);
                this.drawHighlightLines(canvas, fArray, iScatterDataSet);
            }
            ++n;
        }
    }
}

