/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.renderer.AxisRenderer;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class XAxisRenderer
extends AxisRenderer {
    protected XAxis mXAxis;
    float[] a;
    private Path a = new Path();

    public XAxisRenderer(ViewPortHandler viewPortHandler, XAxis xAxis, Transformer transformer) {
        super(viewPortHandler, transformer);
        this.mXAxis = xAxis;
        this.mAxisLabelPaint.setColor(-16777216);
        this.mAxisLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mAxisLabelPaint.setTextSize(Utils.convertDpToPixel(10.0f));
    }

    public void computeAxis(float f, List<String> list) {
        this.mAxisLabelPaint.setTypeface(this.mXAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mXAxis.getTextSize());
        StringBuilder stringBuilder = new StringBuilder();
        int n = Math.round(f);
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append('h');
            ++n2;
        }
        FSize fSize = Utils.calcTextSize(this.mAxisLabelPaint, stringBuilder.toString());
        float f2 = fSize.width;
        float f3 = Utils.calcTextHeight(this.mAxisLabelPaint, "Q");
        FSize fSize2 = Utils.getSizeOfRotatedRectangleByDegrees(f2, f3, this.mXAxis.getLabelRotationAngle());
        StringBuilder stringBuilder2 = new StringBuilder();
        int n3 = this.mXAxis.getSpaceBetweenLabels();
        int n4 = 0;
        while (n4 < n3) {
            stringBuilder2.append('h');
            ++n4;
        }
        FSize fSize3 = Utils.calcTextSize(this.mAxisLabelPaint, stringBuilder2.toString());
        this.mXAxis.mLabelWidth = Math.round(f2 + fSize3.width);
        this.mXAxis.mLabelHeight = Math.round(f3);
        this.mXAxis.mLabelRotatedWidth = Math.round(fSize2.width + fSize3.width);
        this.mXAxis.mLabelRotatedHeight = Math.round(fSize2.height);
        this.mXAxis.setValues(list);
    }

    @Override
    public void renderAxisLabels(Canvas canvas) {
        if (!this.mXAxis.isEnabled() || !this.mXAxis.isDrawLabelsEnabled()) {
            return;
        }
        float f = this.mXAxis.getYOffset();
        this.mAxisLabelPaint.setTypeface(this.mXAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mXAxis.getTextSize());
        this.mAxisLabelPaint.setColor(this.mXAxis.getTextColor());
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP) {
            this.drawLabels(canvas, this.mViewPortHandler.contentTop() - f, new PointF(0.5f, 1.0f));
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP_INSIDE) {
            this.drawLabels(canvas, this.mViewPortHandler.contentTop() + f + (float)this.mXAxis.mLabelRotatedHeight, new PointF(0.5f, 1.0f));
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM) {
            this.drawLabels(canvas, this.mViewPortHandler.contentBottom() + f, new PointF(0.5f, 0.0f));
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE) {
            this.drawLabels(canvas, this.mViewPortHandler.contentBottom() - f - (float)this.mXAxis.mLabelRotatedHeight, new PointF(0.5f, 0.0f));
        } else {
            this.drawLabels(canvas, this.mViewPortHandler.contentTop() - f, new PointF(0.5f, 1.0f));
            this.drawLabels(canvas, this.mViewPortHandler.contentBottom() + f, new PointF(0.5f, 0.0f));
        }
    }

    @Override
    public void renderAxisLine(Canvas canvas) {
        if (!this.mXAxis.isDrawAxisLineEnabled() || !this.mXAxis.isEnabled()) {
            return;
        }
        this.mAxisLinePaint.setColor(this.mXAxis.getAxisLineColor());
        this.mAxisLinePaint.setStrokeWidth(this.mXAxis.getAxisLineWidth());
        float[] fArray = new float[8];
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP || this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP_INSIDE || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            canvas.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentTop(), this.mAxisLinePaint);
            fArray[0] = this.mViewPortHandler.contentRight() - 6.0f;
            fArray[1] = this.mViewPortHandler.contentTop() - 4.0f;
            fArray[2] = this.mViewPortHandler.contentRight();
            fArray[3] = this.mViewPortHandler.contentTop();
            fArray[4] = this.mViewPortHandler.contentRight();
            fArray[5] = this.mViewPortHandler.contentTop();
            fArray[6] = this.mViewPortHandler.contentRight() - 6.0f;
            fArray[7] = this.mViewPortHandler.contentTop() + 4.0f;
        }
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            canvas.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
            fArray[0] = this.mViewPortHandler.contentRight() - 6.0f;
            fArray[1] = this.mViewPortHandler.contentBottom() - 4.0f;
            fArray[2] = this.mViewPortHandler.contentRight();
            fArray[3] = this.mViewPortHandler.contentBottom();
            fArray[4] = this.mViewPortHandler.contentRight();
            fArray[5] = this.mViewPortHandler.contentBottom();
            fArray[6] = this.mViewPortHandler.contentRight() - 6.0f;
            fArray[7] = this.mViewPortHandler.contentBottom() + 4.0f;
        }
        this.mAxisLinePaint.setAntiAlias(true);
        canvas.drawLines(fArray, this.mAxisLinePaint);
    }

    protected void drawLabels(Canvas canvas, float f, PointF pointF) {
        float f2 = this.mXAxis.getLabelRotationAngle();
        float[] fArray = new float[]{0.0f, 0.0f};
        int n = this.mMinX;
        while (n <= this.mMaxX) {
            fArray[0] = n;
            this.mTrans.pointValuesToPixel(fArray);
            if (this.mViewPortHandler.isInBoundsX(fArray[0])) {
                String string = this.mXAxis.getValues().get(n);
                if (this.mXAxis.isAvoidFirstLastClippingEnabled()) {
                    float f3;
                    if (n == this.mXAxis.getValues().size() - 1 && this.mXAxis.getValues().size() > 1) {
                        f3 = Utils.calcTextWidth(this.mAxisLabelPaint, string);
                        if (f3 > this.mViewPortHandler.offsetRight() * 2.0f && fArray[0] + f3 > this.mViewPortHandler.getChartWidth()) {
                            fArray[0] = fArray[0] - f3 / 2.0f;
                        }
                    } else if (n == 0) {
                        f3 = Utils.calcTextWidth(this.mAxisLabelPaint, string);
                        fArray[0] = fArray[0] + f3 / 2.0f;
                    }
                }
                this.drawLabel(canvas, string, n, fArray[0], f, pointF, f2);
            }
            n += this.mXAxis.mAxisLabelModulus;
        }
    }

    protected void drawLabel(Canvas canvas, String string, int n, float f, float f2, PointF pointF, float f3) {
        String string2 = this.mXAxis.getValueFormatter().getXValue(string, n, this.mViewPortHandler);
        Utils.drawText(canvas, string2, f, f2, this.mAxisLabelPaint, pointF, f3);
    }

    @Override
    public void renderGridLines(Canvas canvas) {
        if (!this.mXAxis.isDrawGridLinesEnabled() || !this.mXAxis.isEnabled()) {
            return;
        }
        float[] fArray = new float[]{0.0f, 0.0f};
        this.mGridPaint.setColor(this.mXAxis.getGridColor());
        this.mGridPaint.setStrokeWidth(this.mXAxis.getGridLineWidth());
        this.mGridPaint.setPathEffect((PathEffect)this.mXAxis.getGridDashPathEffect());
        Path path = new Path();
        int n = this.mMinX;
        while (n <= this.mMaxX) {
            fArray[0] = n;
            this.mTrans.pointValuesToPixel(fArray);
            if (fArray[0] >= this.mViewPortHandler.offsetLeft() && fArray[0] <= this.mViewPortHandler.getChartWidth()) {
                path.moveTo(fArray[0], this.mViewPortHandler.contentBottom());
                path.lineTo(fArray[0], this.mViewPortHandler.contentTop());
                canvas.drawPath(path, this.mGridPaint);
            }
            path.reset();
            n += this.mXAxis.mAxisLabelModulus;
        }
    }

    @Override
    public void renderLimitLines(Canvas canvas) {
        List<LimitLine> list = this.mXAxis.getLimitLines();
        if (list == null || list.size() <= 0) {
            return;
        }
        float[] fArray = new float[2];
        int n = 0;
        while (n < list.size()) {
            LimitLine limitLine = list.get(n);
            if (limitLine.isEnabled()) {
                fArray[0] = limitLine.getLimit();
                fArray[1] = 0.0f;
                this.mTrans.pointValuesToPixel(fArray);
                this.renderLimitLineLine(canvas, limitLine, fArray);
                this.renderLimitLineLabel(canvas, limitLine, fArray, 2.0f + limitLine.getYOffset());
            }
            ++n;
        }
    }

    public void renderLimitLineLine(Canvas canvas, LimitLine limitLine, float[] fArray) {
        this.a[0] = fArray[0];
        this.a[1] = this.mViewPortHandler.contentTop();
        this.a[2] = fArray[0];
        this.a[3] = this.mViewPortHandler.contentBottom();
        this.a.reset();
        this.a.moveTo(this.a[0], this.a[1]);
        this.a.lineTo(this.a[2], this.a[3]);
        this.mLimitLinePaint.setStyle(Paint.Style.STROKE);
        this.mLimitLinePaint.setColor(limitLine.getLineColor());
        this.mLimitLinePaint.setStrokeWidth(limitLine.getLineWidth());
        this.mLimitLinePaint.setPathEffect((PathEffect)limitLine.getDashPathEffect());
        canvas.drawPath(this.a, this.mLimitLinePaint);
    }

    public void renderLimitLineLabel(Canvas canvas, LimitLine limitLine, float[] fArray, float f) {
        String string = limitLine.getLabel();
        if (string != null && !string.equals("")) {
            this.mLimitLinePaint.setStyle(limitLine.getTextStyle());
            this.mLimitLinePaint.setPathEffect(null);
            this.mLimitLinePaint.setColor(limitLine.getTextColor());
            this.mLimitLinePaint.setStrokeWidth(0.5f);
            this.mLimitLinePaint.setTextSize(limitLine.getTextSize());
            float f2 = limitLine.getLineWidth() + limitLine.getXOffset();
            LimitLine.LimitLabelPosition limitLabelPosition = limitLine.getLabelPosition();
            if (limitLabelPosition == LimitLine.LimitLabelPosition.RIGHT_TOP) {
                float f3 = Utils.calcTextHeight(this.mLimitLinePaint, string);
                this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
                canvas.drawText(string, fArray[0] + f2, this.mViewPortHandler.contentTop() + f + f3, this.mLimitLinePaint);
            } else if (limitLabelPosition == LimitLine.LimitLabelPosition.RIGHT_BOTTOM) {
                this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
                canvas.drawText(string, fArray[0] + f2, this.mViewPortHandler.contentBottom() - f, this.mLimitLinePaint);
            } else if (limitLabelPosition == LimitLine.LimitLabelPosition.LEFT_TOP) {
                this.mLimitLinePaint.setTextAlign(Paint.Align.RIGHT);
                float f4 = Utils.calcTextHeight(this.mLimitLinePaint, string);
                canvas.drawText(string, fArray[0] - f2, this.mViewPortHandler.contentTop() + f + f4, this.mLimitLinePaint);
            } else {
                this.mLimitLinePaint.setTextAlign(Paint.Align.RIGHT);
                canvas.drawText(string, fArray[0] - f2, this.mViewPortHandler.contentBottom() - f, this.mLimitLinePaint);
            }
        }
    }

    @Override
    public void renderIndexMarkLines(Canvas canvas) {
        int n = -6;
        float[] fArray = new float[]{0.0f, 0.0f};
        this.mGridPaint.setColor(this.mXAxis.getGridColor());
        this.mGridPaint.setStrokeWidth(this.mXAxis.getGridLineWidth());
        Path path = new Path();
        float f = this.mViewPortHandler.contentBottom();
        int n2 = this.mMinX;
        while (n2 <= this.mMaxX) {
            fArray[0] = n2;
            this.mTrans.pointValuesToPixel(fArray);
            if (fArray[0] >= this.mViewPortHandler.offsetLeft() && fArray[0] <= this.mViewPortHandler.getChartWidth()) {
                path.moveTo(fArray[0], f);
                path.lineTo(fArray[0], f + (float)n);
                canvas.drawPath(path, this.mGridPaint);
            }
            path.reset();
            n2 += this.mXAxis.mAxisLabelModulus;
        }
    }
}

