/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import com.github.mikephil.charting.charts.BarChart;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.renderer.XAxisRendererBarChart;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class XAxisRendererHorizontalBarChart
extends XAxisRendererBarChart {
    public XAxisRendererHorizontalBarChart(ViewPortHandler viewPortHandler, XAxis xAxis, Transformer transformer, BarChart barChart) {
        super(viewPortHandler, xAxis, transformer, barChart);
    }

    @Override
    public void computeAxis(float f, List<String> list) {
        this.mAxisLabelPaint.setTypeface(this.mXAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mXAxis.getTextSize());
        this.mXAxis.setValues(list);
        String string = this.mXAxis.getLongestLabel();
        FSize fSize = Utils.calcTextSize(this.mAxisLabelPaint, string);
        float f2 = (int)(fSize.width + this.mXAxis.getXOffset() * 3.5f);
        float f3 = fSize.height;
        FSize fSize2 = Utils.getSizeOfRotatedRectangleByDegrees(fSize.width, f3, this.mXAxis.getLabelRotationAngle());
        this.mXAxis.mLabelWidth = Math.round(f2);
        this.mXAxis.mLabelHeight = Math.round(f3);
        this.mXAxis.mLabelRotatedWidth = (int)(fSize2.width + this.mXAxis.getXOffset() * 3.5f);
        this.mXAxis.mLabelRotatedHeight = Math.round(fSize2.height);
    }

    @Override
    public void renderAxisLabels(Canvas canvas) {
        if (!this.mXAxis.isEnabled() || !this.mXAxis.isDrawLabelsEnabled()) {
            return;
        }
        float f = this.mXAxis.getXOffset();
        this.mAxisLabelPaint.setTypeface(this.mXAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mXAxis.getTextSize());
        this.mAxisLabelPaint.setColor(this.mXAxis.getTextColor());
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP) {
            this.drawLabels(canvas, this.mViewPortHandler.contentRight() + f, new PointF(0.0f, 0.5f));
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP_INSIDE) {
            this.drawLabels(canvas, this.mViewPortHandler.contentRight() - f, new PointF(1.0f, 0.5f));
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM) {
            this.drawLabels(canvas, this.mViewPortHandler.contentLeft() - f, new PointF(1.0f, 0.5f));
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE) {
            this.drawLabels(canvas, this.mViewPortHandler.contentLeft() + f, new PointF(0.0f, 0.5f));
        } else {
            this.drawLabels(canvas, this.mViewPortHandler.contentRight() + f, new PointF(0.0f, 0.5f));
            this.drawLabels(canvas, this.mViewPortHandler.contentLeft() - f, new PointF(1.0f, 0.5f));
        }
    }

    @Override
    protected void drawLabels(Canvas canvas, float f, PointF pointF) {
        float f2 = this.mXAxis.getLabelRotationAngle();
        float[] fArray = new float[]{0.0f, 0.0f};
        BarData barData = (BarData)this.mChart.getData();
        int n = barData.getDataSetCount();
        int n2 = this.mMinX;
        while (n2 <= this.mMaxX) {
            fArray[1] = (float)(n2 * n) + (float)n2 * barData.getGroupSpace() + barData.getGroupSpace() / 2.0f;
            if (n > 1) {
                fArray[1] = fArray[1] + ((float)n - 1.0f) / 2.0f;
            }
            this.mTrans.pointValuesToPixel(fArray);
            if (this.mViewPortHandler.isInBoundsY(fArray[1])) {
                String string = this.mXAxis.getValues().get(n2);
                this.drawLabel(canvas, string, n2, f, fArray[1], pointF, f2);
            }
            n2 += this.mXAxis.mAxisLabelModulus;
        }
    }

    @Override
    public void renderGridLines(Canvas canvas) {
        if (!this.mXAxis.isDrawGridLinesEnabled() || !this.mXAxis.isEnabled()) {
            return;
        }
        float[] fArray = new float[]{0.0f, 0.0f};
        this.mGridPaint.setColor(this.mXAxis.getGridColor());
        this.mGridPaint.setStrokeWidth(this.mXAxis.getGridLineWidth());
        BarData barData = (BarData)this.mChart.getData();
        int n = barData.getDataSetCount();
        int n2 = this.mMinX;
        while (n2 <= this.mMaxX) {
            fArray[1] = (float)(n2 * n) + (float)n2 * barData.getGroupSpace() - 0.5f;
            this.mTrans.pointValuesToPixel(fArray);
            if (this.mViewPortHandler.isInBoundsY(fArray[1])) {
                canvas.drawLine(this.mViewPortHandler.contentLeft(), fArray[1], this.mViewPortHandler.contentRight(), fArray[1], this.mGridPaint);
            }
            n2 += this.mXAxis.mAxisLabelModulus;
        }
    }

    @Override
    public void renderAxisLine(Canvas canvas) {
        if (!this.mXAxis.isDrawAxisLineEnabled() || !this.mXAxis.isEnabled()) {
            return;
        }
        this.mAxisLinePaint.setColor(this.mXAxis.getAxisLineColor());
        this.mAxisLinePaint.setStrokeWidth(this.mXAxis.getAxisLineWidth());
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP || this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP_INSIDE || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            canvas.drawLine(this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
        }
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            canvas.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
        }
    }

    @Override
    public void renderLimitLines(Canvas canvas) {
        List<LimitLine> list = this.mXAxis.getLimitLines();
        if (list == null || list.size() <= 0) {
            return;
        }
        float[] fArray = new float[2];
        Path path = new Path();
        int n = 0;
        while (n < list.size()) {
            LimitLine limitLine = list.get(n);
            if (limitLine.isEnabled()) {
                this.mLimitLinePaint.setStyle(Paint.Style.STROKE);
                this.mLimitLinePaint.setColor(limitLine.getLineColor());
                this.mLimitLinePaint.setStrokeWidth(limitLine.getLineWidth());
                this.mLimitLinePaint.setPathEffect((PathEffect)limitLine.getDashPathEffect());
                fArray[1] = limitLine.getLimit();
                this.mTrans.pointValuesToPixel(fArray);
                path.moveTo(this.mViewPortHandler.contentLeft(), fArray[1]);
                path.lineTo(this.mViewPortHandler.contentRight(), fArray[1]);
                canvas.drawPath(path, this.mLimitLinePaint);
                path.reset();
                String string = limitLine.getLabel();
                if (string != null && !string.equals("")) {
                    this.mLimitLinePaint.setStyle(limitLine.getTextStyle());
                    this.mLimitLinePaint.setPathEffect(null);
                    this.mLimitLinePaint.setColor(limitLine.getTextColor());
                    this.mLimitLinePaint.setStrokeWidth(0.5f);
                    this.mLimitLinePaint.setTextSize(limitLine.getTextSize());
                    float f = Utils.calcTextHeight(this.mLimitLinePaint, string);
                    float f2 = Utils.convertDpToPixel(4.0f) + limitLine.getXOffset();
                    float f3 = limitLine.getLineWidth() + f + limitLine.getYOffset();
                    LimitLine.LimitLabelPosition limitLabelPosition = limitLine.getLabelPosition();
                    if (limitLabelPosition == LimitLine.LimitLabelPosition.RIGHT_TOP) {
                        this.mLimitLinePaint.setTextAlign(Paint.Align.RIGHT);
                        canvas.drawText(string, this.mViewPortHandler.contentRight() - f2, fArray[1] - f3 + f, this.mLimitLinePaint);
                    } else if (limitLabelPosition == LimitLine.LimitLabelPosition.RIGHT_BOTTOM) {
                        this.mLimitLinePaint.setTextAlign(Paint.Align.RIGHT);
                        canvas.drawText(string, this.mViewPortHandler.contentRight() - f2, fArray[1] + f3, this.mLimitLinePaint);
                    } else if (limitLabelPosition == LimitLine.LimitLabelPosition.LEFT_TOP) {
                        this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
                        canvas.drawText(string, this.mViewPortHandler.contentLeft() + f2, fArray[1] - f3 + f, this.mLimitLinePaint);
                    } else {
                        this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
                        canvas.drawText(string, this.mViewPortHandler.offsetLeft() + f2, fArray[1] + f3, this.mLimitLinePaint);
                    }
                }
            }
            ++n;
        }
    }
}

