/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.renderer.AxisRenderer;
import com.github.mikephil.charting.utils.PointD;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class YAxisRenderer
extends AxisRenderer {
    protected YAxis mYAxis;
    protected Paint mZeroLinePaint;

    public YAxisRenderer(ViewPortHandler viewPortHandler, YAxis yAxis, Transformer transformer) {
        super(viewPortHandler, transformer);
        this.mYAxis = yAxis;
        this.mAxisLabelPaint.setColor(-16777216);
        this.mAxisLabelPaint.setTextSize(Utils.convertDpToPixel(10.0f));
        this.mZeroLinePaint = new Paint(1);
        this.mZeroLinePaint.setColor(-7829368);
        this.mZeroLinePaint.setStrokeWidth(1.0f);
        this.mZeroLinePaint.setStyle(Paint.Style.STROKE);
    }

    public void computeAxis(float f, float f2) {
        if (this.mViewPortHandler.contentWidth() > 10.0f && !this.mViewPortHandler.isFullyZoomedOutY()) {
            PointD pointD = this.mTrans.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop());
            PointD pointD2 = this.mTrans.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom());
            if (!this.mYAxis.isInverted()) {
                f = (float)pointD2.y;
                f2 = (float)pointD.y;
            } else {
                f = (float)pointD.y;
                f2 = (float)pointD2.y;
            }
        }
        this.computeAxisValues(f, f2);
    }

    protected void computeAxisValues(float f, float f2) {
        double d;
        float f3 = f;
        float f4 = f2;
        int n = this.mYAxis.getLabelCount();
        double d2 = Math.abs(f4 - f3);
        if (n == 0 || d2 <= 0.0) {
            this.mYAxis.mEntries = new float[0];
            this.mYAxis.mEntryCount = 0;
            return;
        }
        double d3 = d2 / (double)n;
        double d4 = Utils.roundToNextSignificant(d3);
        int n2 = (int)(d4 / (d = Math.pow(10.0, (int)Math.log10(d4))));
        if (n2 > 5) {
            d4 = Math.floor(10.0 * d);
        }
        if (this.mYAxis.isForceLabelsEnabled()) {
            float f5 = (float)d2 / (float)(n - 1);
            this.mYAxis.mEntryCount = n;
            if (this.mYAxis.mEntries.length < n) {
                this.mYAxis.mEntries = new float[n];
            }
            float f6 = f;
            int n3 = 0;
            while (n3 < n) {
                this.mYAxis.mEntries[n3] = f6;
                f6 += f5;
                ++n3;
            }
        } else if (this.mYAxis.isShowOnlyMinMaxEnabled()) {
            this.mYAxis.mEntryCount = 2;
            this.mYAxis.mEntries = new float[2];
            this.mYAxis.mEntries[0] = f3;
            this.mYAxis.mEntries[1] = f4;
        } else {
            double d5 = Math.ceil((double)f3 / d4) * d4;
            double d6 = Utils.nextUp(Math.floor((double)f4 / d4) * d4);
            int n4 = 0;
            double d7 = d5;
            while (d7 <= d6) {
                ++n4;
                d7 += d4;
            }
            this.mYAxis.mEntryCount = n4;
            if (this.mYAxis.mEntries.length < n4) {
                this.mYAxis.mEntries = new float[n4];
            }
            d7 = d5;
            int n5 = 0;
            while (n5 < n4) {
                if (d7 == 0.0) {
                    d7 = 0.0;
                }
                this.mYAxis.mEntries[n5] = (float)d7;
                d7 += d4;
                ++n5;
            }
        }
        this.mYAxis.mDecimals = d4 < 1.0 ? (int)Math.ceil(-Math.log10(d4)) : 0;
    }

    @Override
    public void renderAxisLabels(Canvas canvas) {
        if (!this.mYAxis.isEnabled() || !this.mYAxis.isDrawLabelsEnabled()) {
            return;
        }
        float[] fArray = new float[this.mYAxis.mEntryCount * 2];
        int n = 0;
        while (n < fArray.length) {
            fArray[n + 1] = this.mYAxis.mEntries[n / 2];
            n += 2;
        }
        this.mTrans.pointValuesToPixel(fArray);
        this.mAxisLabelPaint.setTypeface(this.mYAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mYAxis.getTextSize());
        this.mAxisLabelPaint.setColor(this.mYAxis.getTextColor());
        float f = this.mYAxis.getXOffset();
        float f2 = (float)Utils.calcTextHeight(this.mAxisLabelPaint, "A") / 2.5f + this.mYAxis.getYOffset();
        YAxis.AxisDependency axisDependency = this.mYAxis.getAxisDependency();
        YAxis.YAxisLabelPosition yAxisLabelPosition = this.mYAxis.getLabelPosition();
        float f3 = 0.0f;
        if (axisDependency == YAxis.AxisDependency.LEFT) {
            if (yAxisLabelPosition == YAxis.YAxisLabelPosition.OUTSIDE_CHART) {
                this.mAxisLabelPaint.setTextAlign(Paint.Align.RIGHT);
                f3 = this.mViewPortHandler.offsetLeft() - f;
            } else {
                this.mAxisLabelPaint.setTextAlign(Paint.Align.LEFT);
                f3 = this.mViewPortHandler.offsetLeft() + f;
            }
        } else if (yAxisLabelPosition == YAxis.YAxisLabelPosition.OUTSIDE_CHART) {
            this.mAxisLabelPaint.setTextAlign(Paint.Align.LEFT);
            f3 = this.mViewPortHandler.contentRight() + f;
        } else {
            this.mAxisLabelPaint.setTextAlign(Paint.Align.RIGHT);
            f3 = this.mViewPortHandler.contentRight() - f;
        }
        this.drawYLabels(canvas, f3, fArray, f2);
    }

    @Override
    public void renderAxisLine(Canvas canvas) {
        if (!this.mYAxis.isEnabled() || !this.mYAxis.isDrawAxisLineEnabled()) {
            return;
        }
        this.mAxisLinePaint.setColor(this.mYAxis.getAxisLineColor());
        this.mAxisLinePaint.setStrokeWidth(this.mYAxis.getAxisLineWidth());
        float[] fArray = new float[8];
        if (this.mYAxis.getAxisDependency() == YAxis.AxisDependency.LEFT) {
            canvas.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
            fArray[0] = this.mViewPortHandler.contentLeft() - 4.0f;
            fArray[1] = this.mViewPortHandler.contentTop() + 6.0f;
            fArray[2] = this.mViewPortHandler.contentLeft();
            fArray[3] = this.mViewPortHandler.contentTop();
            fArray[4] = this.mViewPortHandler.contentLeft();
            fArray[5] = this.mViewPortHandler.contentTop();
            fArray[6] = this.mViewPortHandler.contentLeft() + 4.0f;
            fArray[7] = this.mViewPortHandler.contentTop() + 6.0f;
        } else {
            canvas.drawLine(this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
            fArray[0] = this.mViewPortHandler.contentRight() - 4.0f;
            fArray[1] = this.mViewPortHandler.contentTop() + 6.0f;
            fArray[2] = this.mViewPortHandler.contentRight();
            fArray[3] = this.mViewPortHandler.contentTop();
            fArray[4] = this.mViewPortHandler.contentRight();
            fArray[5] = this.mViewPortHandler.contentTop();
            fArray[6] = this.mViewPortHandler.contentRight() + 4.0f;
            fArray[7] = this.mViewPortHandler.contentTop() + 6.0f;
        }
        this.mAxisLinePaint.setAntiAlias(true);
        canvas.drawLines(fArray, this.mAxisLinePaint);
    }

    protected void drawYLabels(Canvas canvas, float f, float[] fArray, float f2) {
        int n = 0;
        while (n < this.mYAxis.mEntryCount) {
            String string = this.mYAxis.getFormattedLabel(n);
            if (!this.mYAxis.isDrawTopYLabelEntryEnabled() && n >= this.mYAxis.mEntryCount - 1) {
                return;
            }
            canvas.drawText(string, f, fArray[n * 2 + 1] + f2, this.mAxisLabelPaint);
            ++n;
        }
    }

    @Override
    public void renderGridLines(Canvas canvas) {
        if (!this.mYAxis.isEnabled()) {
            return;
        }
        float[] fArray = new float[2];
        if (this.mYAxis.isDrawGridLinesEnabled()) {
            this.mGridPaint.setColor(this.mYAxis.getGridColor());
            this.mGridPaint.setStrokeWidth(this.mYAxis.getGridLineWidth());
            this.mGridPaint.setPathEffect((PathEffect)this.mYAxis.getGridDashPathEffect());
            Path path = new Path();
            int n = 0;
            while (n < this.mYAxis.mEntryCount) {
                fArray[1] = this.mYAxis.mEntries[n];
                this.mTrans.pointValuesToPixel(fArray);
                path.moveTo(this.mViewPortHandler.offsetLeft(), fArray[1]);
                path.lineTo(this.mViewPortHandler.contentRight(), fArray[1]);
                canvas.drawPath(path, this.mGridPaint);
                path.reset();
                ++n;
            }
        }
        if (this.mYAxis.isDrawZeroLineEnabled()) {
            fArray[1] = 0.0f;
            this.mTrans.pointValuesToPixel(fArray);
            if (fArray[1] != this.mViewPortHandler.contentBottom()) {
                this.drawZeroLine(canvas, this.mViewPortHandler.offsetLeft(), this.mViewPortHandler.contentRight(), fArray[1] - 1.0f, fArray[1] - 1.0f);
            }
        }
    }

    protected void drawZeroLine(Canvas canvas, float f, float f2, float f3, float f4) {
        this.mZeroLinePaint.setColor(this.mYAxis.getZeroLineColor());
        this.mZeroLinePaint.setStrokeWidth(this.mYAxis.getZeroLineWidth());
        Path path = new Path();
        path.moveTo(f, f3);
        path.lineTo(f2, f4);
        canvas.drawPath(path, this.mZeroLinePaint);
    }

    @Override
    public void renderLimitLines(Canvas canvas) {
        List<LimitLine> list = this.mYAxis.getLimitLines();
        if (list == null || list.size() <= 0) {
            return;
        }
        float[] fArray = new float[2];
        Path path = new Path();
        int n = 0;
        while (n < list.size()) {
            LimitLine limitLine = list.get(n);
            if (limitLine.isEnabled()) {
                this.mLimitLinePaint.setStyle(Paint.Style.STROKE);
                this.mLimitLinePaint.setColor(limitLine.getLineColor());
                this.mLimitLinePaint.setStrokeWidth(limitLine.getLineWidth());
                this.mLimitLinePaint.setPathEffect((PathEffect)limitLine.getDashPathEffect());
                fArray[1] = limitLine.getLimit();
                this.mTrans.pointValuesToPixel(fArray);
                path.moveTo(this.mViewPortHandler.contentLeft(), fArray[1]);
                path.lineTo(this.mViewPortHandler.contentRight(), fArray[1]);
                canvas.drawPath(path, this.mLimitLinePaint);
                path.reset();
                String string = limitLine.getLabel();
                if (string != null && !string.equals("")) {
                    this.mLimitLinePaint.setStyle(limitLine.getTextStyle());
                    this.mLimitLinePaint.setPathEffect(null);
                    this.mLimitLinePaint.setColor(limitLine.getTextColor());
                    this.mLimitLinePaint.setTypeface(limitLine.getTypeface());
                    this.mLimitLinePaint.setStrokeWidth(0.5f);
                    this.mLimitLinePaint.setTextSize(limitLine.getTextSize());
                    float f = Utils.calcTextHeight(this.mLimitLinePaint, string);
                    float f2 = Utils.convertDpToPixel(4.0f) + limitLine.getXOffset();
                    float f3 = limitLine.getLineWidth() + f + limitLine.getYOffset();
                    LimitLine.LimitLabelPosition limitLabelPosition = limitLine.getLabelPosition();
                    if (limitLabelPosition == LimitLine.LimitLabelPosition.RIGHT_TOP) {
                        this.mLimitLinePaint.setTextAlign(Paint.Align.RIGHT);
                        canvas.drawText(string, this.mViewPortHandler.contentRight() - f2, fArray[1] - f3 + f, this.mLimitLinePaint);
                    } else if (limitLabelPosition == LimitLine.LimitLabelPosition.RIGHT_BOTTOM) {
                        this.mLimitLinePaint.setTextAlign(Paint.Align.RIGHT);
                        canvas.drawText(string, this.mViewPortHandler.contentRight() - f2, fArray[1] + f3, this.mLimitLinePaint);
                    } else if (limitLabelPosition == LimitLine.LimitLabelPosition.LEFT_TOP) {
                        this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
                        canvas.drawText(string, this.mViewPortHandler.contentLeft() + f2, fArray[1] - f3 + f, this.mLimitLinePaint);
                    } else {
                        this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
                        canvas.drawText(string, this.mViewPortHandler.offsetLeft() + f2, fArray[1] + f3, this.mLimitLinePaint);
                    }
                }
            }
            ++n;
        }
    }

    @Override
    public void renderIndexMarkLines(Canvas canvas) {
        int n = 6;
        float[] fArray = new float[2];
        float f = this.mViewPortHandler.offsetLeft();
        this.mGridPaint.setColor(this.mYAxis.getGridColor());
        this.mGridPaint.setStrokeWidth(this.mYAxis.getGridLineWidth());
        this.mGridPaint.setPathEffect((PathEffect)this.mYAxis.getGridDashPathEffect());
        Path path = new Path();
        int n2 = 0;
        while (n2 < this.mYAxis.mEntryCount) {
            fArray[1] = this.mYAxis.mEntries[n2];
            this.mTrans.pointValuesToPixel(fArray);
            path.moveTo(f, fArray[1]);
            path.lineTo(f + (float)n, fArray[1]);
            canvas.drawPath(path, this.mGridPaint);
            path.reset();
            ++n2;
        }
    }
}

