/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.RadarData;
import com.github.mikephil.charting.renderer.YAxisRenderer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class YAxisRendererRadarChart
extends YAxisRenderer {
    private RadarChart a;

    public YAxisRendererRadarChart(ViewPortHandler viewPortHandler, YAxis yAxis, RadarChart radarChart) {
        super(viewPortHandler, yAxis, null);
        this.a = radarChart;
    }

    @Override
    public void computeAxis(float f, float f2) {
        this.computeAxisValues(f, f2);
    }

    @Override
    protected void computeAxisValues(float f, float f2) {
        double d;
        float f3 = f;
        float f4 = f2;
        int n = this.mYAxis.getLabelCount();
        double d2 = Math.abs(f4 - f3);
        if (n == 0 || d2 <= 0.0) {
            this.mYAxis.mEntries = new float[0];
            this.mYAxis.mEntryCount = 0;
            return;
        }
        double d3 = d2 / (double)n;
        double d4 = Utils.roundToNextSignificant(d3);
        int n2 = (int)(d4 / (d = Math.pow(10.0, (int)Math.log10(d4))));
        if (n2 > 5) {
            d4 = Math.floor(10.0 * d);
        }
        if (this.mYAxis.isForceLabelsEnabled()) {
            float f5 = (float)d2 / (float)(n - 1);
            this.mYAxis.mEntryCount = n;
            if (this.mYAxis.mEntries.length < n) {
                this.mYAxis.mEntries = new float[n];
            }
            float f6 = f;
            int n3 = 0;
            while (n3 < n) {
                this.mYAxis.mEntries[n3] = f6;
                f6 += f5;
                ++n3;
            }
        } else if (this.mYAxis.isShowOnlyMinMaxEnabled()) {
            this.mYAxis.mEntryCount = 2;
            this.mYAxis.mEntries = new float[2];
            this.mYAxis.mEntries[0] = f3;
            this.mYAxis.mEntries[1] = f4;
        } else {
            double d5;
            double d6 = (double)f3 / d4;
            double d7 = d5 = d6 < 0.0 ? Math.floor(d6) * d4 : Math.ceil(d6) * d4;
            if (d5 == 0.0) {
                d5 = 0.0;
            }
            double d8 = Utils.nextUp(Math.floor((double)f4 / d4) * d4);
            int n4 = 0;
            double d9 = d5;
            while (d9 <= d8) {
                ++n4;
                d9 += d4;
            }
            if (Float.isNaN(this.mYAxis.getAxisMaxValue())) {
                ++n4;
            }
            this.mYAxis.mEntryCount = n4;
            if (this.mYAxis.mEntries.length < n4) {
                this.mYAxis.mEntries = new float[n4];
            }
            d9 = d5;
            int n5 = 0;
            while (n5 < n4) {
                this.mYAxis.mEntries[n5] = (float)d9;
                d9 += d4;
                ++n5;
            }
        }
        this.mYAxis.mDecimals = d4 < 1.0 ? (int)Math.ceil(-Math.log10(d4)) : 0;
        if (this.mYAxis.mEntries[0] < f3) {
            this.mYAxis.mAxisMinimum = this.mYAxis.mEntries[0];
        }
        this.mYAxis.mAxisMaximum = this.mYAxis.mEntries[this.mYAxis.mEntryCount - 1];
        this.mYAxis.mAxisRange = Math.abs(this.mYAxis.mAxisMaximum - this.mYAxis.mAxisMinimum);
    }

    @Override
    public void renderAxisLabels(Canvas canvas) {
        if (!this.mYAxis.isEnabled() || !this.mYAxis.isDrawLabelsEnabled()) {
            return;
        }
        this.mAxisLabelPaint.setTypeface(this.mYAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mYAxis.getTextSize());
        this.mAxisLabelPaint.setColor(this.mYAxis.getTextColor());
        PointF pointF = this.a.getCenterOffsets();
        float f = this.a.getFactor();
        int n = this.mYAxis.mEntryCount;
        int n2 = 0;
        while (n2 < n) {
            if (n2 == n - 1 && !this.mYAxis.isDrawTopYLabelEntryEnabled()) break;
            float f2 = (this.mYAxis.mEntries[n2] - this.mYAxis.mAxisMinimum) * f;
            PointF pointF2 = Utils.getPosition(pointF, f2, this.a.getRotationAngle());
            String string = this.mYAxis.getFormattedLabel(n2);
            canvas.drawText(string, pointF2.x + 10.0f, pointF2.y, this.mAxisLabelPaint);
            ++n2;
        }
    }

    @Override
    public void renderLimitLines(Canvas canvas) {
        List<LimitLine> list = this.mYAxis.getLimitLines();
        if (list == null) {
            return;
        }
        float f = this.a.getSliceAngle();
        float f2 = this.a.getFactor();
        PointF pointF = this.a.getCenterOffsets();
        int n = 0;
        while (n < list.size()) {
            LimitLine limitLine = list.get(n);
            if (limitLine.isEnabled()) {
                this.mLimitLinePaint.setColor(limitLine.getLineColor());
                this.mLimitLinePaint.setPathEffect((PathEffect)limitLine.getDashPathEffect());
                this.mLimitLinePaint.setStrokeWidth(limitLine.getLineWidth());
                float f3 = (limitLine.getLimit() - this.a.getYChartMin()) * f2;
                Path path = new Path();
                int n2 = 0;
                while (n2 < ((RadarData)this.a.getData()).getXValCount()) {
                    PointF pointF2 = Utils.getPosition(pointF, f3, f * (float)n2 + this.a.getRotationAngle());
                    if (n2 == 0) {
                        path.moveTo(pointF2.x, pointF2.y);
                    } else {
                        path.lineTo(pointF2.x, pointF2.y);
                    }
                    ++n2;
                }
                path.close();
                canvas.drawPath(path, this.mLimitLinePaint);
            }
            ++n;
        }
    }
}

