/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.RectF;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.CandleEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.interfaces.datasets.IBubbleDataSet;
import com.github.mikephil.charting.interfaces.datasets.ICandleDataSet;
import com.github.mikephil.charting.interfaces.datasets.ILineDataSet;
import com.github.mikephil.charting.interfaces.datasets.IScatterDataSet;
import com.github.mikephil.charting.utils.PointD;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class Transformer {
    protected Matrix mMatrixValueToPx = new Matrix();
    protected Matrix mMatrixOffset = new Matrix();
    protected ViewPortHandler mViewPortHandler;
    private Matrix a = new Matrix();
    private Matrix b = new Matrix();

    public Transformer(ViewPortHandler viewPortHandler) {
        this.mViewPortHandler = viewPortHandler;
    }

    public void prepareMatrixValuePx(float f, float f2, float f3, float f4) {
        float f5 = this.mViewPortHandler.contentWidth() / f2;
        float f6 = this.mViewPortHandler.contentHeight() / f3;
        if (Float.isInfinite(f5)) {
            f5 = 0.0f;
        }
        if (Float.isInfinite(f6)) {
            f6 = 0.0f;
        }
        this.mMatrixValueToPx.reset();
        this.mMatrixValueToPx.postTranslate(-f, -f4);
        this.mMatrixValueToPx.postScale(f5, -f6);
    }

    public void prepareMatrixOffset(boolean bl) {
        this.mMatrixOffset.reset();
        if (!bl) {
            this.mMatrixOffset.postTranslate(this.mViewPortHandler.offsetLeft(), this.mViewPortHandler.getChartHeight() - this.mViewPortHandler.offsetBottom());
        } else {
            this.mMatrixOffset.setTranslate(this.mViewPortHandler.offsetLeft(), -this.mViewPortHandler.offsetTop());
            this.mMatrixOffset.postScale(1.0f, -1.0f);
        }
    }

    public float[] generateTransformedValuesScatter(IScatterDataSet iScatterDataSet, float f) {
        float[] fArray = new float[iScatterDataSet.getEntryCount() * 2];
        int n = 0;
        while (n < fArray.length) {
            Object t = iScatterDataSet.getEntryForIndex(n / 2);
            if (t != null) {
                fArray[n] = ((Entry)t).getXIndex();
                fArray[n + 1] = ((Entry)t).getVal() * f;
            }
            n += 2;
        }
        this.getValueToPixelMatrix().mapPoints(fArray);
        return fArray;
    }

    public float[] generateTransformedValuesBubble(IBubbleDataSet iBubbleDataSet, float f, float f2, int n, int n2) {
        int n3 = (int)Math.ceil(n2 - n) * 2;
        float[] fArray = new float[n3];
        int n4 = 0;
        while (n4 < n3) {
            Object t = iBubbleDataSet.getEntryForIndex(n4 / 2 + n);
            if (t != null) {
                fArray[n4] = (float)(((Entry)t).getXIndex() - n) * f + (float)n;
                fArray[n4 + 1] = ((Entry)t).getVal() * f2;
            }
            n4 += 2;
        }
        this.getValueToPixelMatrix().mapPoints(fArray);
        return fArray;
    }

    public float[] generateTransformedValuesLine(ILineDataSet iLineDataSet, float f, float f2, int n, int n2) {
        int n3 = (int)Math.ceil((float)(n2 - n) * f) * 2;
        float[] fArray = new float[n3];
        int n4 = 0;
        while (n4 < n3) {
            Object t = iLineDataSet.getEntryForIndex(n4 / 2 + n);
            if (t != null) {
                fArray[n4] = ((Entry)t).getXIndex();
                fArray[n4 + 1] = ((Entry)t).getVal() * f2;
            }
            n4 += 2;
        }
        this.getValueToPixelMatrix().mapPoints(fArray);
        return fArray;
    }

    public float[] generateTransformedValuesCandle(ICandleDataSet iCandleDataSet, float f, float f2, int n, int n2) {
        int n3 = (int)Math.ceil((float)(n2 - n) * f) * 2;
        float[] fArray = new float[n3];
        int n4 = 0;
        while (n4 < n3) {
            CandleEntry candleEntry = (CandleEntry)iCandleDataSet.getEntryForIndex(n4 / 2 + n);
            if (candleEntry != null) {
                fArray[n4] = candleEntry.getXIndex();
                fArray[n4 + 1] = candleEntry.getHigh() * f2;
            }
            n4 += 2;
        }
        this.getValueToPixelMatrix().mapPoints(fArray);
        return fArray;
    }

    public float[] generateTransformedValuesBarChart(IBarDataSet iBarDataSet, int n, BarData barData, float f) {
        float[] fArray = new float[iBarDataSet.getEntryCount() * 2];
        int n2 = barData.getDataSetCount();
        float f2 = barData.getGroupSpace();
        int n3 = 0;
        while (n3 < fArray.length) {
            Object t = iBarDataSet.getEntryForIndex(n3 / 2);
            int n4 = ((Entry)t).getXIndex();
            float f3 = (float)(((Entry)t).getXIndex() + n4 * (n2 - 1) + n) + f2 * (float)n4 + f2 / 2.0f;
            float f4 = ((Entry)t).getVal();
            fArray[n3] = f3;
            fArray[n3 + 1] = f4 * f;
            n3 += 2;
        }
        this.getValueToPixelMatrix().mapPoints(fArray);
        return fArray;
    }

    public float[] generateTransformedValuesHorizontalBarChart(IBarDataSet iBarDataSet, int n, BarData barData, float f) {
        float[] fArray = new float[iBarDataSet.getEntryCount() * 2];
        int n2 = barData.getDataSetCount();
        float f2 = barData.getGroupSpace();
        int n3 = 0;
        while (n3 < fArray.length) {
            Object t = iBarDataSet.getEntryForIndex(n3 / 2);
            int n4 = ((Entry)t).getXIndex();
            float f3 = (float)(n4 + n4 * (n2 - 1) + n) + f2 * (float)n4 + f2 / 2.0f;
            float f4 = ((Entry)t).getVal();
            fArray[n3] = f4 * f;
            fArray[n3 + 1] = f3;
            n3 += 2;
        }
        this.getValueToPixelMatrix().mapPoints(fArray);
        return fArray;
    }

    public void pathValueToPixel(Path path) {
        path.transform(this.mMatrixValueToPx);
        path.transform(this.mViewPortHandler.getMatrixTouch());
        path.transform(this.mMatrixOffset);
    }

    public void pathValuesToPixel(List<Path> list) {
        int n = 0;
        while (n < list.size()) {
            this.pathValueToPixel(list.get(n));
            ++n;
        }
    }

    public void pointValuesToPixel(float[] fArray) {
        this.mMatrixValueToPx.mapPoints(fArray);
        this.mViewPortHandler.getMatrixTouch().mapPoints(fArray);
        this.mMatrixOffset.mapPoints(fArray);
    }

    public void rectValueToPixel(RectF rectF) {
        this.mMatrixValueToPx.mapRect(rectF);
        this.mViewPortHandler.getMatrixTouch().mapRect(rectF);
        this.mMatrixOffset.mapRect(rectF);
    }

    public void rectValueToPixel(RectF rectF, float f) {
        rectF.top *= f;
        rectF.bottom *= f;
        this.mMatrixValueToPx.mapRect(rectF);
        this.mViewPortHandler.getMatrixTouch().mapRect(rectF);
        this.mMatrixOffset.mapRect(rectF);
    }

    public void rectValueToPixelHorizontal(RectF rectF) {
        this.mMatrixValueToPx.mapRect(rectF);
        this.mViewPortHandler.getMatrixTouch().mapRect(rectF);
        this.mMatrixOffset.mapRect(rectF);
    }

    public void rectValueToPixelHorizontal(RectF rectF, float f) {
        rectF.left *= f;
        rectF.right *= f;
        this.mMatrixValueToPx.mapRect(rectF);
        this.mViewPortHandler.getMatrixTouch().mapRect(rectF);
        this.mMatrixOffset.mapRect(rectF);
    }

    public void rectValuesToPixel(List<RectF> list) {
        Matrix matrix = this.getValueToPixelMatrix();
        int n = 0;
        while (n < list.size()) {
            matrix.mapRect(list.get(n));
            ++n;
        }
    }

    public void pixelsToValue(float[] fArray) {
        Matrix matrix = new Matrix();
        this.mMatrixOffset.invert(matrix);
        matrix.mapPoints(fArray);
        this.mViewPortHandler.getMatrixTouch().invert(matrix);
        matrix.mapPoints(fArray);
        this.mMatrixValueToPx.invert(matrix);
        matrix.mapPoints(fArray);
    }

    public PointD getValuesByTouchPoint(float f, float f2) {
        float[] fArray = new float[]{f, f2};
        this.pixelsToValue(fArray);
        double d = fArray[0];
        double d2 = fArray[1];
        return new PointD(d, d2);
    }

    public Matrix getValueMatrix() {
        return this.mMatrixValueToPx;
    }

    public Matrix getOffsetMatrix() {
        return this.mMatrixOffset;
    }

    public Matrix getValueToPixelMatrix() {
        this.a.set(this.mMatrixValueToPx);
        this.a.postConcat(this.mViewPortHandler.mMatrixTouch);
        this.a.postConcat(this.mMatrixOffset);
        return this.a;
    }

    public Matrix getPixelToValueMatrix() {
        this.getValueToPixelMatrix().invert(this.b);
        return this.b;
    }
}

