/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.formatter.DefaultValueFormatter;
import com.github.mikephil.charting.formatter.ValueFormatter;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.SelectionDetail;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class Utils {
    private static DisplayMetrics a;
    private static int a;
    private static int b;
    public static final double DEG2RAD = Math.PI / 180;
    public static final float FDEG2RAD = (float)Math.PI / 180;
    private static final int[] a;
    private static Rect a;
    private static Paint.FontMetrics a;

    static {
        a = 50;
        b = 8000;
        a = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
        a = new Rect();
        a = new Paint.FontMetrics();
    }

    public static void init(Context context) {
        if (context == null) {
            a = ViewConfiguration.getMinimumFlingVelocity();
            b = ViewConfiguration.getMaximumFlingVelocity();
            Log.e((String)"MPChartLib-Utils", (String)"Utils.init(...) PROVIDED CONTEXT OBJECT IS NULL");
        } else {
            ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
            a = viewConfiguration.getScaledMinimumFlingVelocity();
            b = viewConfiguration.getScaledMaximumFlingVelocity();
            Resources resources = context.getResources();
            a = resources.getDisplayMetrics();
        }
    }

    @Deprecated
    public static void init(Resources resources) {
        a = resources.getDisplayMetrics();
        a = ViewConfiguration.getMinimumFlingVelocity();
        b = ViewConfiguration.getMaximumFlingVelocity();
    }

    public static float convertDpToPixel(float f) {
        if (a == null) {
            Log.e((String)"MPChartLib-Utils", (String)"Utils NOT INITIALIZED. You need to call Utils.init(...) at least once before calling Utils.convertDpToPixel(...). Otherwise conversion does not take place.");
            return f;
        }
        DisplayMetrics displayMetrics = a;
        float f2 = f * ((float)displayMetrics.densityDpi / 160.0f);
        return f2;
    }

    public static float convertPixelsToDp(float f) {
        if (a == null) {
            Log.e((String)"MPChartLib-Utils", (String)"Utils NOT INITIALIZED. You need to call Utils.init(...) at least once before calling Utils.convertPixelsToDp(...). Otherwise conversion does not take place.");
            return f;
        }
        DisplayMetrics displayMetrics = a;
        float f2 = f / ((float)displayMetrics.densityDpi / 160.0f);
        return f2;
    }

    public static int calcTextWidth(Paint paint, String string) {
        return (int)paint.measureText(string);
    }

    public static int calcTextHeight(Paint paint, String string) {
        Rect rect = new Rect();
        paint.getTextBounds(string, 0, string.length(), rect);
        return rect.height();
    }

    public static float getLineHeight(Paint paint) {
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        return fontMetrics.descent - fontMetrics.ascent;
    }

    public static float getLineSpacing(Paint paint) {
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        return fontMetrics.ascent - fontMetrics.top + fontMetrics.bottom;
    }

    public static FSize calcTextSize(Paint paint, String string) {
        Rect rect = new Rect();
        paint.getTextBounds(string, 0, string.length(), rect);
        return new FSize(rect.width(), rect.height());
    }

    public static String formatNumber(float f, int n, boolean bl) {
        return Utils.formatNumber(f, n, bl, '.');
    }

    public static String formatNumber(float f, int n, boolean bl, char c) {
        int n2;
        char[] cArray = new char[35];
        boolean bl2 = false;
        if (f == 0.0f) {
            return "0";
        }
        boolean bl3 = false;
        if (f < 1.0f && f > -1.0f) {
            bl3 = true;
        }
        if (f < 0.0f) {
            bl2 = true;
            f = -f;
        }
        if (n > a.length) {
            n = a.length - 1;
        }
        long l = Math.round(f *= (float)a[n]);
        int n3 = cArray.length - 1;
        int n4 = 0;
        boolean bl4 = false;
        while (l != 0L || n4 < n + 1) {
            n2 = (int)(l % 10L);
            l /= 10L;
            cArray[n3--] = (char)(n2 + 48);
            if (++n4 == n) {
                cArray[n3--] = 44;
                ++n4;
                bl4 = true;
                continue;
            }
            if (!bl || l == 0L || n4 <= n) continue;
            if (bl4) {
                if ((n4 - n) % 4 != 0) continue;
                cArray[n3--] = c;
                ++n4;
                continue;
            }
            if ((n4 - n) % 4 != 3) continue;
            cArray[n3--] = c;
            ++n4;
        }
        if (bl3) {
            cArray[n3--] = 48;
            ++n4;
        }
        if (bl2) {
            cArray[n3--] = 45;
            ++n4;
        }
        n2 = cArray.length - n4;
        return String.valueOf(cArray, n2, cArray.length - n2);
    }

    public static float roundToNextSignificant(double d) {
        float f = (float)Math.ceil((float)Math.log10(d < 0.0 ? -d : d));
        int n = 1 - (int)f;
        float f2 = (float)Math.pow(10.0, n);
        long l = Math.round(d * (double)f2);
        return (float)l / f2;
    }

    public static int getDecimals(float f) {
        float f2 = Utils.roundToNextSignificant(f);
        return (int)Math.ceil(-Math.log10(f2)) + 2;
    }

    public static int[] convertIntegers(List<Integer> list) {
        int[] nArray = new int[list.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = list.get(n);
            ++n;
        }
        return nArray;
    }

    public static String[] convertStrings(List<String> list) {
        String[] stringArray = new String[list.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = list.get(n);
            ++n;
        }
        return stringArray;
    }

    public static double nextUp(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            return d;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d += 0.0) + (d >= 0.0 ? 1L : -1L));
    }

    public static int getClosestDataSetIndex(List<SelectionDetail> list, float f, YAxis.AxisDependency axisDependency) {
        int n = -2147483647;
        float f2 = Float.MAX_VALUE;
        int n2 = 0;
        while (n2 < list.size()) {
            float f3;
            SelectionDetail selectionDetail = list.get(n2);
            if ((axisDependency == null || selectionDetail.dataSet.getAxisDependency() == axisDependency) && (f3 = Math.abs(selectionDetail.val - f)) < f2) {
                n = list.get((int)n2).dataSetIndex;
                f2 = f3;
            }
            ++n2;
        }
        return n;
    }

    public static float getMinimumDistance(List<SelectionDetail> list, float f, YAxis.AxisDependency axisDependency) {
        float f2 = Float.MAX_VALUE;
        int n = 0;
        while (n < list.size()) {
            float f3;
            SelectionDetail selectionDetail = list.get(n);
            if (selectionDetail.dataSet.getAxisDependency() == axisDependency && (f3 = Math.abs(selectionDetail.val - f)) < f2) {
                f2 = f3;
            }
            ++n;
        }
        return f2;
    }

    public static boolean needsDefaultFormatter(ValueFormatter valueFormatter) {
        if (valueFormatter == null) {
            return true;
        }
        return valueFormatter instanceof DefaultValueFormatter;
    }

    public static PointF getPosition(PointF pointF, float f, float f2) {
        PointF pointF2 = new PointF((float)((double)pointF.x + (double)f * Math.cos(Math.toRadians(f2))), (float)((double)pointF.y + (double)f * Math.sin(Math.toRadians(f2))));
        return pointF2;
    }

    public static void velocityTrackerPointerUpCleanUpIfNecessary(MotionEvent motionEvent, VelocityTracker velocityTracker) {
        velocityTracker.computeCurrentVelocity(1000, (float)b);
        int n = motionEvent.getActionIndex();
        int n2 = motionEvent.getPointerId(n);
        float f = velocityTracker.getXVelocity(n2);
        float f2 = velocityTracker.getYVelocity(n2);
        int n3 = 0;
        int n4 = motionEvent.getPointerCount();
        while (n3 < n4) {
            float f3;
            int n5;
            float f4;
            float f5;
            if (n3 != n && (f5 = (f4 = f * velocityTracker.getXVelocity(n5 = motionEvent.getPointerId(n3))) + (f3 = f2 * velocityTracker.getYVelocity(n5))) < 0.0f) {
                velocityTracker.clear();
                break;
            }
            ++n3;
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void postInvalidateOnAnimation(View view) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.postInvalidateOnAnimation();
        } else {
            view.postInvalidateDelayed(10L);
        }
    }

    public static int getMinimumFlingVelocity() {
        return a;
    }

    public static int getMaximumFlingVelocity() {
        return b;
    }

    public static float getNormalizedAngle(float f) {
        while (f < 0.0f) {
            f += 360.0f;
        }
        return f % 360.0f;
    }

    public static void drawText(Canvas canvas, String string, float f, float f2, Paint paint, PointF pointF, float f3) {
        float f4 = 0.0f;
        float f5 = 0.0f;
        paint.getTextBounds(string, 0, string.length(), a);
        float f6 = a.height();
        f4 -= (float)Utils.a.left;
        f5 += f6;
        Paint.Align align = paint.getTextAlign();
        paint.setTextAlign(Paint.Align.LEFT);
        if (f3 != 0.0f) {
            f4 -= (float)a.width() * 0.5f;
            f5 -= f6 * 0.5f;
            float f7 = f;
            float f8 = f2;
            if (pointF.x != 0.5f || pointF.y != 0.5f) {
                FSize fSize = Utils.getSizeOfRotatedRectangleByDegrees(a.width(), f6, f3);
                f7 -= fSize.width * (pointF.x - 0.5f);
                f8 -= fSize.height * (pointF.y - 0.5f);
            }
            canvas.save();
            canvas.translate(f7, f8);
            canvas.rotate(f3);
            canvas.drawText(string, f4, f5, paint);
            canvas.restore();
        } else {
            if (pointF.x != 0.0f || pointF.y != 0.0f) {
                f4 -= (float)a.width() * pointF.x;
                f5 -= f6 * pointF.y;
            }
            canvas.drawText(string, f4 += f, f5 += f2, paint);
        }
        paint.setTextAlign(align);
    }

    public static void drawMultilineText(Canvas canvas, StaticLayout staticLayout, float f, float f2, TextPaint textPaint, PointF pointF, float f3) {
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = textPaint.getFontMetrics(a);
        float f7 = staticLayout.getWidth();
        float f8 = (float)staticLayout.getLineCount() * f6;
        f4 -= (float)Utils.a.left;
        f5 += f8;
        Paint.Align align = textPaint.getTextAlign();
        textPaint.setTextAlign(Paint.Align.LEFT);
        if (f3 != 0.0f) {
            f4 -= f7 * 0.5f;
            f5 -= f8 * 0.5f;
            float f9 = f;
            float f10 = f2;
            if (pointF.x != 0.5f || pointF.y != 0.5f) {
                FSize fSize = Utils.getSizeOfRotatedRectangleByDegrees(f7, f8, f3);
                f9 -= fSize.width * (pointF.x - 0.5f);
                f10 -= fSize.height * (pointF.y - 0.5f);
            }
            canvas.save();
            canvas.translate(f9, f10);
            canvas.rotate(f3);
            canvas.translate(f4, f5);
            staticLayout.draw(canvas);
            canvas.restore();
        } else {
            if (pointF.x != 0.0f || pointF.y != 0.0f) {
                f4 -= f7 * pointF.x;
                f5 -= f8 * pointF.y;
            }
            canvas.save();
            canvas.translate(f4 += f, f5 += f2);
            staticLayout.draw(canvas);
            canvas.restore();
        }
        textPaint.setTextAlign(align);
    }

    public static void drawMultilineText(Canvas canvas, String string, float f, float f2, TextPaint textPaint, FSize fSize, PointF pointF, float f3) {
        StaticLayout staticLayout = new StaticLayout((CharSequence)string, 0, string.length(), textPaint, (int)Math.max(Math.ceil(fSize.width), 1.0), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        Utils.drawMultilineText(canvas, staticLayout, f, f2, textPaint, pointF, f3);
    }

    public static FSize getSizeOfRotatedRectangleByDegrees(FSize fSize, float f) {
        float f2 = f * ((float)Math.PI / 180);
        return Utils.getSizeOfRotatedRectangleByRadians(fSize.width, fSize.height, f2);
    }

    public static FSize getSizeOfRotatedRectangleByRadians(FSize fSize, float f) {
        return Utils.getSizeOfRotatedRectangleByRadians(fSize.width, fSize.height, f);
    }

    public static FSize getSizeOfRotatedRectangleByDegrees(float f, float f2, float f3) {
        float f4 = f3 * ((float)Math.PI / 180);
        return Utils.getSizeOfRotatedRectangleByRadians(f, f2, f4);
    }

    public static FSize getSizeOfRotatedRectangleByRadians(float f, float f2, float f3) {
        return new FSize(Math.abs(f * (float)Math.cos(f3)) + Math.abs(f2 * (float)Math.sin(f3)), Math.abs(f * (float)Math.sin(f3)) + Math.abs(f2 * (float)Math.cos(f3)));
    }
}

