/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst;

import com.supermap.analyst.BufferAnalystGeometryNative;
import com.supermap.analyst.BufferAnalystParameter;
import com.supermap.analyst.BufferEndType;
import com.supermap.analyst.BufferRadiusUnit;
import com.supermap.analyst.a;
import com.supermap.analyst.b;
import com.supermap.analyst.c;
import com.supermap.analyst.d;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Toolkit;

public class BufferAnalystGeometry {
    private BufferAnalystGeometry() {
    }

    public static GeoRegion createBuffer(Geometry geometry, BufferAnalystParameter bufferAnalystParameter, PrjCoordSys prjCoordSys) {
        double d2;
        BufferEndType bufferEndType = bufferAnalystParameter.getEndType();
        int n2 = bufferAnalystParameter.getSemicircleLineSegment();
        Object object = bufferAnalystParameter.getLeftDistance();
        Object object2 = bufferAnalystParameter.getRightDistance();
        BufferRadiusUnit bufferRadiusUnit = bufferAnalystParameter.getRadiusUnit();
        long l2 = b.a(prjCoordSys);
        if (geometry == null) {
            String string = c.a("geometry", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = b.a(geometry);
        if (l3 == 0L) {
            String string = c.a("geometry", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        int n3 = -1;
        GeoRegion geoRegion = null;
        GeometryType geometryType = geometry.getType();
        if (bufferEndType.equals(BufferEndType.FLAT)) {
            if (object == null && object2 == null) {
                String string = c.a("objLeftDistance and objRightDistance", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (geometryType != GeometryType.GEOLINE) {
                String string = c.a("geometry", "BufferAnalyst_BufferGeometryTypeShouldBeLine", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (object instanceof String || object2 instanceof String) {
                String string = c.a("LeftDistance and RightDistance", "BufferAnalyst_DistenceOfStringTypeIsInvalidForGeometryBuffer", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            d2 = d.a(object);
            double d3 = d.a(object2);
            if (object != null && d2 <= 0.0) {
                String string = c.a("leftDistance", "BufferAnalyst_BufferDistanceShouldBePositive", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (object2 != null && d3 <= 0.0) {
                String string = c.a("rightDistance", "BufferAnalyst_BufferDistanceShouldBePositive", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (object == null) {
                n3 = d.a.d.value();
            } else if (object2 == null) {
                n3 = d.a.c.value();
            } else if (d2 == d3) {
                n3 = d.a.b.value();
            } else if (d2 != d3) {
                n3 = d.a.e.value();
            }
            if (geometry.isEmpty()) {
                return new GeoRegion();
            }
            int n4 = BufferEndType.FLAT.value();
            long l4 = BufferAnalystGeometryNative.jni_CreateLineBuffer(l3, l2, d2, d3, bufferRadiusUnit.value(), n2, n3, n4);
            geoRegion = l4 != 0L ? (GeoRegion)a.a(l4) : new GeoRegion();
        }
        if (bufferEndType.equals(BufferEndType.ROUND)) {
            if (geometryType != GeometryType.GEOPOINT && geometryType != GeometryType.GEOLINE && geometryType != GeometryType.GEOREGION) {
                String string = c.a("geometry", "BufferAnalyst_BufferGeometryTypeInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (object instanceof String) {
                String string = c.a("LeftDistance", "BufferAnalyst_DistenceOfStringTypeIsInvalidForGeometryBuffer", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            d2 = d.a(object);
            if (object == null) {
                String string = c.a("objLeftDistance", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!geometryType.equals(GeometryType.GEOREGION) && d2 <= 0.0) {
                String string = c.a("", "BufferAnalyst_BufferDistanceShouldBePositive", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometryType.equals(GeometryType.GEOREGION) && Toolkit.isZero(d2)) {
                String string = c.a("", "BufferAnalyst_BufferDistanceShouldNotBeZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometryType.equals(GeometryType.GEOLINE)) {
                n3 = d.a.b.value();
            }
            if (geometry.isEmpty()) {
                return new GeoRegion();
            }
            int n5 = BufferEndType.ROUND.value();
            long l5 = BufferAnalystGeometryNative.jni_CreateGeometryBuffer(l3, l2, d2, bufferRadiusUnit.value(), n2, n3, n5);
            geoRegion = l5 != 0L ? (GeoRegion)a.a(l5) : new GeoRegion();
        }
        return geoRegion;
    }
}

