/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Color;
import com.supermap.data.ColorGradientType;
import com.supermap.data.ColorsNative;
import com.supermap.data.E;
import com.supermap.data.InternalHandleDisposable;

public class Colors
extends InternalHandleDisposable {
    private boolean a = false;

    public Colors() {
        this.setHandle(ColorsNative.jni_New(), true);
    }

    public Colors(Color[] colorArray) {
        if (colorArray == null) {
            String string = E.a("colors", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        this.setHandle(ColorsNative.jni_New(), true);
        this.addRange(colorArray);
    }

    public Colors(Colors colors) {
        if (colors == null) {
            throw new NullPointerException("colors");
        }
        if (colors.getHandle() == 0L) {
            String string = E.a("colors", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(ColorsNative.jni_New(), true);
        this.addRange(colors.toArray());
    }

    Colors(long l2, boolean bl) {
        this.a = bl;
        this.setHandle(l2, false);
    }

    Colors(long l2, boolean bl, boolean bl2) {
        this.a = bl2;
        this.setHandle(l2, bl);
    }

    public Color get(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = ColorsNative.jni_GetItem(this.getHandle(), n2);
        Color color = new Color(n3);
        if (this.a) {
            color = this.a(color);
        }
        return color;
    }

    public void set(int n2, Color color) {
        if (this.getHandle() == 0L) {
            String string = E.a("set(int index, Color value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (color == null) {
            String string = E.a("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        Color color2 = color;
        if (this.a) {
            color2 = this.a(color);
        }
        ColorsNative.jni_Set(this.getHandle(), n2, color2.getRGB());
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = E.a("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ColorsNative.jni_GetCount(this.getHandle());
    }

    public int add(Color color) {
        if (this.getHandle() == 0L) {
            String string = E.a("add(Color color)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = E.a("color", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        Color color2 = color;
        if (this.a) {
            color2 = this.a(color);
        }
        return ColorsNative.jni_Add(this.getHandle(), color2.getRGB());
    }

    public int addRange(Color[] colorArray) {
        if (this.getHandle() == 0L) {
            String string = E.a("addRange(Color[] colors)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (colorArray == null) {
            throw new NullPointerException("colors");
        }
        int n2 = colorArray.length;
        int[] nArray = new int[n2];
        if (this.a) {
            for (int i2 = 0; i2 < n2; ++i2) {
                Color color = this.a(colorArray[i2]);
                nArray[i2] = color.getRGB();
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                nArray[i3] = colorArray[i3].getRGB();
            }
        }
        return ColorsNative.jni_AddRange(this.getHandle(), nArray);
    }

    public boolean insert(int n2, Color color) {
        if (this.getHandle() == 0L) {
            String string = E.a("insert(int index, Color color)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 > this.getCount()) {
            String string = E.a("index", "Global_InvalidInsertPosition", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (color == null) {
            String string = E.a("color", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (n2 == this.getCount()) {
            return this.add(color) != -1;
        }
        Color color2 = color;
        if (this.a) {
            color2 = this.a(color);
        }
        boolean bl = ColorsNative.jni_Insert(this.getHandle(), n2, color2.getRGB());
        return bl;
    }

    public boolean remove(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("remove(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return ColorsNative.jni_Remove(this.getHandle(), n2);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = E.a("clear()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ColorsNative.jni_Clear(this.getHandle());
    }

    public static Colors makeRandom(int n2) {
        if (n2 <= 0) {
            String string = E.a("count", "Colors_CountShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ColorsNative.jni_MakeRandom(n2);
        if (l2 == 0L) {
            return null;
        }
        return new Colors(l2, true, false);
    }

    public static Colors makeGradient(int n2, Color[] colorArray) {
        if (n2 <= 0) {
            String string = E.a("count", "Colors_CountShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorArray == null) {
            String string = E.a("intervalColors", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (colorArray.length < 2) {
            String string = E.a("intervalColors", "Colors_IntervalColorsLengthInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n3 = colorArray.length;
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            nArray[i2] = colorArray[i2].getRGB();
        }
        long l2 = ColorsNative.jni_MakeGradient1(n2, nArray);
        if (l2 == 0L) {
            return null;
        }
        return new Colors(l2, true, false);
    }

    public static Colors makeGradient(int n2, ColorGradientType colorGradientType, boolean bl) {
        if (n2 <= 0) {
            String string = E.a("count", "Colors_CountShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorGradientType == null) {
            String string = E.a("type", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l2 = ColorsNative.jni_MakeGradient2(n2, colorGradientType.getUGCValue(), bl);
        if (l2 == 0L) {
            return null;
        }
        return new Colors(l2, true, false);
    }

    public Color[] toArray() {
        if (this.getHandle() == 0L) {
            String string = E.a("toArray()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = this.getCount();
        Color[] colorArray = new Color[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            colorArray[i2] = this.get(i2);
        }
        return colorArray;
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = E.a("toString()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Count=");
        stringBuffer.append(this.getCount());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            ColorsNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
    }

    protected static Colors createInstance(long l2, boolean bl) {
        if (l2 == 0L) {
            String string = E.a("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new Colors(l2, bl);
    }

    protected static void clearHandle(Colors colors) {
        colors.clearHandle();
    }

    protected static void changeHandle(Colors colors, long l2) {
        colors.a(l2);
    }

    private void a(long l2) {
        if (l2 == 0L) {
            String string = E.a("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() != 0L) {
            ColorsNative.jni_Delete(this.getHandle());
        }
        this.setHandle(l2, false);
    }

    private Color a(Color color) {
        Color color2 = new Color(color.getB(), color.getG(), color.getR());
        return color2;
    }

    public Colors makeRandom(int n2, Color[] colorArray) {
        if (n2 < 2) {
            String string = E.a("count", "Colors_CountShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorArray == null) {
            String string = E.a("color", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (colorArray.length < 2) {
            String string = E.a("color", "Colors_IntervalColorsLengthInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorArray.length > n2) {
            String string = E.a("count", "Colors_IntervalColorsLengthInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n3 = colorArray.length;
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            nArray[i2] = colorArray[i2].getRGB();
        }
        long l2 = ColorsNative.jni_MakeRandom1(n2, nArray);
        if (l2 == 0L) {
            return null;
        }
        return new Colors(l2, true, false);
    }
}

