/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CoordSysTransMethod;
import com.supermap.data.CoordSysTransParameter;
import com.supermap.data.CoordSysTranslatorNative;
import com.supermap.data.E;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import com.supermap.data.PrjCoordSys;

public final class CoordSysTranslator {
    public static boolean forward(Point2Ds point2Ds, PrjCoordSys prjCoordSys) {
        int n2;
        if (point2Ds == null) {
            String string = E.a("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2Ds.a a2 = point2Ds.a();
        point2Ds.a(Point2Ds.a.a);
        int n3 = point2Ds.getCount();
        if (n3 < 1) {
            String string = E.a("points", "Point2DsIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = E.a("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = point2Ds.getItem(n2).getX();
            dArray2[n2] = point2Ds.getItem(n2).getY();
            if (!(dArray[n2] > 180.0 || dArray[n2] < -180.0 || dArray2[n2] > 90.0) && !(dArray2[n2] < -90.0)) continue;
            String string = E.a("points", "InvalidLongitudeLatitudeCoord", "data_resources");
            throw new IllegalArgumentException(string);
        }
        n2 = CoordSysTranslatorNative.jni_Forward(dArray, dArray2, prjCoordSys.getHandle()) ? 1 : 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            point2Ds.setItem(i2, new Point2D(dArray[i2], dArray2[i2]));
        }
        point2Ds.a(a2);
        return n2 != 0;
    }

    public static boolean inverse(Point2Ds point2Ds, PrjCoordSys prjCoordSys) {
        int n2;
        if (point2Ds == null) {
            String string = E.a("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2Ds.a a2 = point2Ds.a();
        point2Ds.a(Point2Ds.a.a);
        int n3 = point2Ds.getCount();
        if (n3 < 1) {
            String string = E.a("points", "Point2DsIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = E.a("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = point2Ds.getItem(n2).getX();
            dArray2[n2] = point2Ds.getItem(n2).getY();
        }
        n2 = CoordSysTranslatorNative.jni_Inverse(dArray, dArray2, prjCoordSys.getHandle()) ? 1 : 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            point2Ds.setItem(i2, new Point2D(dArray[i2], dArray2[i2]));
        }
        point2Ds.a(a2);
        return n2 != 0;
    }

    public static boolean convert(Point2Ds point2Ds, PrjCoordSys prjCoordSys, PrjCoordSys prjCoordSys2, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        int n2;
        if (point2Ds == null) {
            String string = E.a("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2Ds.a a2 = point2Ds.a();
        point2Ds.a(Point2Ds.a.a);
        int n3 = point2Ds.getCount();
        if (n3 < 1) {
            String string = E.a("points", "Point2DsIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = E.a("srcPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys2 == null || prjCoordSys2.getHandle() == 0L) {
            String string = E.a("targetPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = E.a("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = point2Ds.getItem(n2).getX();
            dArray2[n2] = point2Ds.getItem(n2).getY();
        }
        n2 = CoordSysTranslatorNative.jni_ConvertPoints(dArray, dArray2, prjCoordSys.getHandle(), prjCoordSys2.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue()) ? 1 : 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            point2Ds.setItem(i2, new Point2D(dArray[i2], dArray2[i2]));
        }
        point2Ds.a(a2);
        return n2 != 0;
    }

    public static boolean convert(Point3Ds point3Ds, PrjCoordSys prjCoordSys, PrjCoordSys prjCoordSys2, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        int n2;
        if (point3Ds == null) {
            String string = E.a("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n3 = point3Ds.getCount();
        if (n3 < 1) {
            String string = E.a("points", "Point2DsIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = E.a("srcPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys2 == null || prjCoordSys2.getHandle() == 0L) {
            String string = E.a("targetPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = E.a("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = point3Ds.getItem(n2).getX();
            dArray2[n2] = point3Ds.getItem(n2).getY();
            dArray3[n2] = point3Ds.getItem(n2).getZ();
        }
        n2 = CoordSysTranslatorNative.jni_ConvertPoint3Ds(dArray, dArray2, dArray3, prjCoordSys.getHandle(), prjCoordSys2.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue()) ? 1 : 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            point3Ds.setItem(i2, new Point3D(dArray[i2], dArray2[i2], dArray3[i2]));
        }
        return n2 != 0;
    }

    public static boolean convert(Geometry geometry, PrjCoordSys prjCoordSys, PrjCoordSys prjCoordSys2, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = E.a("srcPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys2 == null || prjCoordSys2.getHandle() == 0L) {
            String string = E.a("desPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = E.a("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = CoordSysTranslatorNative.jni_ConvertGeometry(geometry.getHandle(), prjCoordSys.getHandle(), prjCoordSys2.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue());
        if (geometry.getType() == GeometryType.GEOREGION) {
            ((GeoRegion)geometry).refrashPartsList();
        }
        return bl;
    }
}

