/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Colors;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGridNative;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.E;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PixelFormat;
import com.supermap.data.Point;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.StatisticsResult;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DatasetGrid
extends Dataset {
    private GeoRegion a;
    private static Integer a = new Integer(0);
    private Colors a;
    private DatasetVector a = null;

    protected DatasetGrid() {
        m_senderMethodName = "buildPyramid";
    }

    DatasetGrid(long l2, Datasource datasource) {
        if (l2 == 0L) {
            String string = E.a("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource == null) {
            String string = E.a("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasource.getHandle() == 0L) {
            String string = E.a("datasource", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l2);
        this.m_datasource = datasource;
    }

    public int getWidth() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_GetWidth(this.getHandle());
    }

    public int getHeight() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_GetHeight(this.getHandle());
    }

    public void setGeoReference(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            String string = E.a("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetGridNative.jni_SetBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
    }

    public PixelFormat getPixelFormat() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = DatasetGridNative.jni_GetPixelFormat(this.getHandle());
        return (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n2);
    }

    public int getBlockSize() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_GetBlockSize(this.getHandle());
    }

    public int getRowBlockCount() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_GetRowBlockCount(this.getHandle());
    }

    public int getColumnBlockCount() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_GetColumnBlockCount(this.getHandle());
    }

    public double getNoValue() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_GetNoValue(this.getHandle());
    }

    public void setNoValue(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetGridNative.jni_SetNoValue(this.getHandle(), d2);
    }

    public double getMinValue() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_GetMinValue(this.getHandle());
    }

    public double getMaxValue() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_GetMaxValue(this.getHandle());
    }

    public boolean getHasPyramid() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_GetHasPyramid(this.getHandle());
    }

    public GeoRegion getClipRegion() {
        long l2;
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null && (l2 = DatasetGridNative.jni_GetClipRegion(this.getHandle())) != 0L) {
            this.a = (GeoRegion)Geometry.createInstance(l2);
        }
        return this.a;
    }

    public void setClipRegion(GeoRegion geoRegion) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoRegion == null) {
            if (this.a != null) {
                this.a.clearHandle();
                this.a = null;
            }
            DatasetGridNative.jni_SetClipRegion(this.getHandle(), 0L);
        } else {
            if (geoRegion.getHandle() == 0L) {
                String string = E.a("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetGridNative.jni_SetClipRegion(this.getHandle(), geoRegion.getHandle());
            if (this.a != null) {
                this.a.fromXML(geoRegion.toXML());
            }
        }
    }

    public boolean calculateExtremum() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_CalculateExtremum(this.getHandle());
    }

    public double getValue(int n2, int n3) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getWidth()) {
            String string = E.a("column", "DatasetGrid_ColumnIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n3 < 0 || n3 >= this.getHeight()) {
            String string = E.a("row", "DatasetGrid_RowIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return DatasetGridNative.jni_GetValue(this.getHandle(), n2, n3);
    }

    public double setValue(int n2, int n3, double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = E.a("", "DatasetGrid_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getWidth()) {
            String string = E.a("column", "DatasetGrid_ColumnIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n3 < 0 || n3 >= this.getHeight()) {
            String string = E.a("row", "DatasetGrid_RowIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return DatasetGridNative.jni_SetValue(this.getHandle(), n2, n3, d2);
    }

    public Point2D gridToXY(Point point) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        DatasetGridNative.jni_GridToXY(this.getHandle(), point.getX(), point.getY(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public Point xyToGrid(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        DatasetGridNative.jni_XYToGrid(this.getHandle(), point2D.getX(), point2D.getY(), nArray);
        return new Point(nArray[0], nArray[1]);
    }

    public boolean updatePyramid(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = DatasetGridNative.jni_UpdatePyramid(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        return bl;
    }

    public boolean removePyramid() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_RemovePyramid(this.getHandle());
    }

    public Colors getColorTable() {
        long l2;
        if (this.getHandle() == 0L) {
            String string = E.a("getColorTable()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null && (l2 = DatasetGridNative.jni_GetColorTable(this.getHandle())) != 0L) {
            this.a = Colors.createInstance(l2, false);
        }
        return this.a;
    }

    public void setColorTable(Colors colors) {
        if (this.getHandle() == 0L) {
            String string = E.a("setColorTable(Colors colors)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (colors == null) {
            String string = E.a("colors", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandleDisposable.getHandle(colors);
        if (l2 == 0L) {
            String string = E.a("colors", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Colors colors2 = new Colors(colors);
        long l3 = InternalHandleDisposable.getHandle(colors2);
        DatasetGridNative.jni_SetColorTable(this.getHandle(), l3);
    }

    public DatasetVector buildValueTable(Datasource datasource, String string) {
        if (this.getHandle() == 0L) {
            String string2 = E.a("buildValueTable(Datasource ds,String)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (datasource == null) {
            String string3 = E.a("datasource", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        long l2 = DatasetGridNative.jni_BuildValueTable(this.getHandle(), datasource.getHandle(), string);
        DatasetVector datasetVector = null;
        if (l2 != 0L) {
            datasetVector = new DatasetVector(l2, datasource);
        }
        return datasetVector;
    }

    public StatisticsResult getGridStatisticsResult() {
        if (this.getHandle() == 0L) {
            String string = E.a("statictic(StatisticMode mode)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = DatasetGridNative.jni_GetRasterStatisticsResult(this.getHandle());
        StatisticsResult statisticsResult = null;
        if (l2 != 0L) {
            statisticsResult = new StatisticsResult(l2);
        }
        return statisticsResult;
    }

    public StatisticsResult buildStatistics() {
        if (this.getHandle() == 0L) {
            String string = E.a("statictic(StatisticMode mode)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = DatasetGridNative.jni_BuildStatistics(this.getHandle());
        StatisticsResult statisticsResult = null;
        if (l2 != 0L) {
            statisticsResult = new StatisticsResult(l2);
        }
        return statisticsResult;
    }

    public boolean update(DatasetGrid datasetGrid) {
        if (this.getHandle() == 0L) {
            String string = E.a("IndexOf(String bandName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (datasetGrid.getHandle() == 0L) {
            String string = E.a("IndexOf(String bandName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_Update(this.getHandle(), datasetGrid.getHandle());
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        this.setHandle(0L);
    }

    protected static DatasetGrid createInstance(long l2, Datasource datasource) {
        return new DatasetGrid(l2, datasource);
    }
}

