/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Color;
import com.supermap.data.ColorSpaceType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetImageNative;
import com.supermap.data.Datasource;
import com.supermap.data.E;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.MapCacheListener;
import com.supermap.data.PixelFormat;
import com.supermap.data.Rectangle2D;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DatasetImage
extends Dataset {
    private GeoRegion a;
    private boolean a;
    private static Integer a = new Integer(0);
    private MapCacheService a = new MapCacheService();

    DatasetImage(long l2, Datasource datasource) {
        if (l2 == 0L) {
            String string = E.a("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource == null) {
            String string = E.a("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasource.getHandle() == 0L) {
            String string = E.a("datasource", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l2);
        this.m_datasource = datasource;
    }

    public int getWidth() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_GetWidth(this.getHandle());
    }

    public int getHeight() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_GetHeight(this.getHandle());
    }

    public PixelFormat getPixelFormat() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = DatasetImageNative.jni_GetPixelFormat(this.getHandle());
        return (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n2);
    }

    public Color getPixel(int n2, int n3) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getWidth()) {
            String string = E.a("column", "DataseImage_ColumnIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n3 < 0 || n3 >= this.getHeight()) {
            String string = E.a("row", "DatasetImage_RowIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n4 = DatasetImageNative.jni_GetPixel(this.getHandle(), n2, n3);
        return new Color(n4);
    }

    private boolean a() {
        if (this.getHandle() == 0L) {
            String string = E.a("isMultiBand()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_IsMultiBand(this.getHandle());
    }

    public ColorSpaceType getColorSpace() {
        if (this.getHandle() == 0L) {
            String string = E.a("getColorSpace()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.a()) {
            String string = E.a("getColorSpace()", "DatasetImage_ThisOperationIsAvailableForMultibandsDataOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        int n2 = DatasetImageNative.jni_GetColorSpaceType(this.getHandle());
        return (ColorSpaceType)Enum.parseUGCValue(ColorSpaceType.class, n2);
    }

    public int getBandCount() {
        if (this.getHandle() == 0L) {
            String string = E.a("GetBandCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.a()) {
            String string = E.a("getBandCount()", "DatasetImage_ThisOperationIsAvailableForMultibandsDataOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        return DatasetImageNative.jni_GetBandCount(this.getHandle());
    }

    public boolean getHasPyramid() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_GetHasPyramid(this.getHandle());
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        this.setHandle(0L);
    }

    public MapCacheService getMapCacheService() {
        return this.a;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class MapCacheService {
        Vector<MapCacheListener> a;
        private ExecutorService a = new Vector();

        public void startDownload(Rectangle2D rectangle2D) {
            if (DatasetImage.this.getHandle() == 0L) {
                String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (rectangle2D == null || rectangle2D.isEmpty()) {
                String string = E.a("rcBounds", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetImageNative.jni_RegisterAllEvent(DatasetImage.this.getHandle(), this);
            DatasetImageNative.jni_StartDownload(DatasetImage.this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }

        public void stopDownload() {
            if (DatasetImage.this.getHandle() == 0L) {
                String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            DatasetImageNative.jni_StopDownload(DatasetImage.this.getHandle());
        }

        public void setListener(MapCacheListener mapCacheListener) {
            if (mapCacheListener != null && !this.a.contains(mapCacheListener)) {
                this.a.add(mapCacheListener);
            }
        }

        public void removeListener(MapCacheListener mapCacheListener) {
            if (this.a != null && this.a.contains(mapCacheListener)) {
                this.a.remove(mapCacheListener);
            }
        }

        protected void onCheckedCallBack() {
            if (this.a != null) {
                Vector<MapCacheListener> vector = this.a;
                int n2 = vector.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    vector.elementAt(i2).onChecked();
                }
            }
        }

        protected void onCompleteCallBack(int n2) {
            if (this.a != null) {
                Vector<MapCacheListener> vector = this.a;
                int n3 = vector.size();
                for (int i2 = 0; i2 < n3; ++i2) {
                    vector.elementAt(i2).onComplete(n2);
                }
            }
        }

        protected void onProgressCallBack(int n2) {
            if (this.a != null) {
                Vector<MapCacheListener> vector = this.a;
                int n3 = vector.size();
                for (int i2 = 0; i2 < n3; ++i2) {
                    vector.elementAt(i2).onProgress(n2);
                }
            }
        }

        private void a() {
            if (DatasetImage.this.getHandle() == 0L) {
                String string = E.a("removeCache(Rectangle2D rcBounds)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            DatasetImageNative.jni_RenameCache(DatasetImage.this.getHandle());
        }

        private void b() {
            if (DatasetImage.this.getHandle() == 0L) {
                String string = E.a("removeCache(Rectangle2D rcBounds)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            DatasetImageNative.jni_RemoveCache(DatasetImage.this.getHandle());
        }

        public void removeCache() {
            this.a();
            if (this.a == null) {
                this.a = Executors.newSingleThreadExecutor();
            }
            this.a.execute(new Runnable(){

                @Override
                public void run() {
                    MapCacheService.this.b();
                }
            });
        }
    }
}

