/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVectorNative;
import com.supermap.data.Datasource;
import com.supermap.data.E;
import com.supermap.data.Enum;
import com.supermap.data.Environment;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.G;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.QueryListener;
import com.supermap.data.QueryParameter;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SpatialIndexInfo;
import com.supermap.data.SpatialIndexType;
import com.supermap.data.SpatialQueryMode;
import com.supermap.data.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DatasetVector
extends Dataset {
    private FieldInfos a;
    private DatasetVector a;
    private Dataset a;
    private static Integer a = new Integer(0);
    private QueryListener a = null;

    protected DatasetVector() {
    }

    DatasetVector(long l2, Datasource datasource) {
        if (l2 == 0L) {
            String string = E.a("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource == null) {
            String string = E.a("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasource.getHandle() == 0L) {
            String string = E.a("datasource", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l2);
        this.m_datasource = datasource;
    }

    public boolean append(Recordset recordset) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = E.a("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (recordset == null) {
            String string = E.a("recordset", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (recordset.getHandle() == 0L) {
            String string = E.a("recordset", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return this.append(recordset, "");
    }

    public boolean append(Recordset recordset, String string) {
        if (this.getHandle() == 0L) {
            String string2 = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (this.isReadOnly()) {
            String string4 = E.a("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string4);
        }
        if (recordset == null) {
            String string5 = E.a("recordset", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string5);
        }
        if (recordset.getHandle() == 0L) {
            String string6 = E.a("recordset", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        return DatasetVectorNative.jni_Append(this.getHandle(), recordset.getHandle(), string);
    }

    public boolean deleteRecords(int[] nArray) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = E.a("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (nArray == null || nArray.length == 0) {
            return true;
        }
        boolean bl = true;
        if (!this.open()) {
            bl = this.open();
        }
        if (bl) {
            Recordset recordset = this.query(nArray, CursorType.DYNAMIC);
            bl = recordset.deleteAll();
            recordset.close();
        }
        return bl;
    }

    public Recordset query(int[] nArray, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (nArray == null) {
            String string = E.a("id", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        int n2 = cursorType.getUGCValue();
        long l2 = DatasetVectorNative.jni_QueryById(this.getHandle(), nArray, n2);
        if (l2 == 0L) {
            return this.getRecordset(true, cursorType);
        }
        Recordset recordset = new Recordset(l2, this);
        return recordset;
    }

    public boolean isAvailableFieldName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        boolean bl = false;
        if (string.startsWith("Sm") || string.startsWith("SM") || string.startsWith("sm")) {
            return bl;
        }
        if (string != null && string.trim().length() != 0) {
            bl = DatasetVectorNative.jni_IsAvailableFieldName(this.getHandle(), string);
        }
        return bl;
    }

    public int getFieldCount() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getFieldInfos().getCount();
    }

    public DatasetVector getChildDataset() {
        long l2;
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null && (l2 = DatasetVectorNative.jni_GetChildDataset(this.getHandle())) != 0L) {
            this.a = new DatasetVector(l2, this.m_datasource);
        }
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfos getFieldInfos() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Integer n2 = a;
        synchronized (n2) {
            if (this.a == null) {
                long l2 = DatasetVectorNative.jni_GetFieldInfos(this.getHandle());
                if (l2 == 0L) {
                    return null;
                }
                this.a = new FieldInfos(l2, this);
                this.a.setIsDisposable(false);
            } else if (!this.isOpen()) {
                DatasetVectorNative.jni_GetFieldInfos(this.getHandle());
            }
            return this.a;
        }
    }

    public Recordset query(String string, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string2 = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null) {
            string = "";
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        int n2 = cursorType.getUGCValue();
        long l2 = DatasetVectorNative.jni_Query1(this.getHandle(), string, n2);
        if (l2 == 0L) {
            return this.getRecordset(true, cursorType);
        }
        Recordset recordset = new Recordset(l2, this);
        return recordset;
    }

    public Recordset query(Geometry geometry, double d2, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType().equals(DatasetType.TABULAR)) {
            String string = E.a("", "DatasetVector_TabularUnsupport", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = E.a("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = E.a("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType().equals(GeometryType.GEOTEXT)) {
            String string = E.a("geometry", "DatasetVector_GeoTextIsUnsupported", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        if (geometry.isEmpty()) {
            return this.getRecordset(true, cursorType);
        }
        if (d2 < 0.0) {
            String string = E.a("bufferDistance", "DatasetVector_QueryBufferInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Recordset recordset = this.query(geometry, d2, "", cursorType);
        return recordset;
    }

    public Recordset query(Geometry geometry, double d2, String string, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string2 = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (this.getType().equals(DatasetType.TABULAR)) {
            String string4 = E.a("", "DatasetVector_TabularUnsupport", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (geometry == null) {
            String string5 = E.a("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string5);
        }
        if (geometry.getHandle() == 0L) {
            String string6 = E.a("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (geometry.getType().equals(GeometryType.GEOTEXT)) {
            String string7 = E.a("geometry", "DatasetVector_GeoTextIsUnsupported", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        if (geometry.isEmpty()) {
            return this.getRecordset(true, cursorType);
        }
        if (d2 < 0.0) {
            String string8 = E.a("bufferDistance", "DatasetVector_QueryBufferInvalid", "data_resources");
            throw new IllegalArgumentException(string8);
        }
        if (string == null) {
            string = "";
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        int n2 = cursorType.getUGCValue();
        long l2 = DatasetVectorNative.jni_Query2(this.getHandle(), geometry.getHandle(), d2, string, n2);
        if (l2 == 0L) {
            return this.getRecordset(true, cursorType);
        }
        Recordset recordset = new Recordset(l2, this);
        return recordset;
    }

    public Recordset query(Rectangle2D rectangle2D, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType().equals(DatasetType.TABULAR)) {
            String string = E.a("", "DatasetVector_TabularUnsupport", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D == null) {
            String string = E.a("bounds", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        Recordset recordset = this.query(rectangle2D, "", cursorType);
        return recordset;
    }

    public Recordset query(Rectangle2D rectangle2D, String string, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string2 = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (this.getType().equals(DatasetType.TABULAR)) {
            String string4 = E.a("", "DatasetVector_TabularUnsupport", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (rectangle2D == null) {
            String string5 = E.a("bounds", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string5);
        }
        if (string == null) {
            string = "";
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        int n2 = cursorType.getUGCValue();
        long l2 = DatasetVectorNative.jni_Query3(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop(), string, n2);
        if (l2 == 0L) {
            return this.getRecordset(true, cursorType);
        }
        Recordset recordset = new Recordset(l2, this);
        return recordset;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Recordset query(QueryParameter queryParameter) {
        Object object;
        Object object2;
        String string;
        long l2;
        long l3;
        int n2;
        QueryParameter queryParameter2;
        int n3;
        long l4;
        block25: {
            if (this.getHandle() == 0L) {
                String string2 = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string2);
            }
            if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
                String string3 = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string3);
            }
            if (queryParameter == null) {
                String string4 = E.a("queryParameter", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string4);
            }
            if (this.getType().equals(DatasetType.TABULAR) && !queryParameter.getSpatialQueryMode().equals(SpatialQueryMode.NONE)) {
                String string5 = E.a("", "DatasetVector_TabularUnsupport", "data_resources");
                throw new IllegalArgumentException(string5);
            }
            l4 = 0L;
            n3 = -1;
            queryParameter2 = null;
            n2 = -1;
            l3 = 0L;
            l2 = 0L;
            string = "";
            queryParameter2 = new QueryParameter(queryParameter);
            Object object3 = queryParameter2.getSpatialQueryObject();
            if (object3 != null) {
                if (object3.getClass().equals(Rectangle2D.class)) {
                    if (!queryParameter2.getSpatialQueryMode().equals(SpatialQueryMode.INTERSECT)) {
                        object2 = (Rectangle2D)object3;
                        if (Toolkit.isZero(((Rectangle2D)object2).getWidth()) || Toolkit.isZero(((Rectangle2D)object2).getHeight())) {
                            return this.getRecordset(true, queryParameter.getCursorType());
                        }
                        object = new Point2Ds();
                        ((Point2Ds)object).add(new Point2D(((Rectangle2D)object2).getLeft(), ((Rectangle2D)object2).getBottom()));
                        ((Point2Ds)object).add(new Point2D(((Rectangle2D)object2).getLeft(), ((Rectangle2D)object2).getTop()));
                        ((Point2Ds)object).add(new Point2D(((Rectangle2D)object2).getRight(), ((Rectangle2D)object2).getTop()));
                        ((Point2Ds)object).add(new Point2D(((Rectangle2D)object2).getRight(), ((Rectangle2D)object2).getBottom()));
                        GeoRegion geoRegion = new GeoRegion((Point2Ds)object);
                        queryParameter2.setSpatialQueryObject(geoRegion);
                        break block25;
                    } else {
                        Rectangle2D rectangle2D = (Rectangle2D)object3;
                        l2 = DatasetVectorNative.jni_Query6(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop(), queryParameter2.getHandle());
                        Recordset recordset = null;
                        recordset = l2 == 0L ? this.getRecordset(true, queryParameter.getCursorType()) : new Recordset(l2, this);
                        queryParameter2.dispose();
                        return recordset;
                    }
                }
                if (object3.getClass().equals(Point2D.class)) {
                    object2 = (Point2D)object3;
                    if (((Point2D)object2).isEmpty()) {
                        return this.getRecordset(true, queryParameter.getCursorType());
                    }
                    object = new GeoPoint(((Point2D)object2).getX(), ((Point2D)object2).getY());
                    queryParameter2.setSpatialQueryObject(object);
                } else if (object3.getClass().getSuperclass().getClass().equals(Geometry.class) && ((Geometry)(object2 = (Geometry)object3)).isEmpty()) {
                    return this.getRecordset(true, queryParameter.getCursorType());
                }
            }
        }
        l4 = queryParameter2.getHandle();
        if (queryParameter2.getSpatialQueryObject() != null) {
            l3 = ((InternalHandle)queryParameter2.getSpatialQueryObject()).getHandle();
        }
        n3 = queryParameter2.getSpatialQueryMode().getUGCValue();
        object2 = null;
        if (queryParameter2.getSpatialQueryObject() != null) {
            object2 = queryParameter2.getSpatialQueryObject().getClass().equals(DatasetVector.class) ? G.t : (queryParameter2.getSpatialQueryObject().getClass().equals(Recordset.class) ? G.y : G.h);
        }
        if (object2 != null) {
            n2 = ((Enum)object2).getUGCValue();
        }
        l2 = DatasetVectorNative.jni_Query5(this.getHandle(), l4, n3, l3, n2, string);
        object = null;
        if (l2 == 0L) {
            String[] stringArray = queryParameter2.getGroupBy();
            if (n3 == -1 && stringArray.length > 0) {
                String string6 = this.m_datasource.getConnectionInfo().getServer();
                String string7 = string6.replace(".udb", ".udd");
                Context context = Environment.getContext();
                Environment.getContext();
                SQLiteDatabase sQLiteDatabase = context.openOrCreateDatabase(string7, 0, null);
                if (sQLiteDatabase == null) {
                    String string8 = E.a("SQLiteDatabase", "Global_ArgumentNull", "data_resources");
                    throw new NullPointerException(string8);
                }
                String string9 = this.getName();
                String string10 = " SELECT SMID FROM " + string9 + " GROUP BY ";
                for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
                    string10 = string10 + stringArray[i2] + ",";
                }
                string10 = string10 + stringArray[stringArray.length - 1];
                Cursor cursor = sQLiteDatabase.rawQuery(string10, null);
                int n4 = cursor.getCount();
                long l5 = 0L;
                if (n4 > 0) {
                    int n5;
                    int[] nArray = new int[n4];
                    int n6 = cursor.getColumnIndex("SmID");
                    cursor.moveToFirst();
                    for (n5 = 0; n5 < n4; ++n5) {
                        nArray[n5] = cursor.getInt(n6);
                        cursor.moveToNext();
                    }
                    n5 = CursorType.STATIC.getUGCValue();
                    queryParameter2.setGroupBy(null);
                    l4 = queryParameter2.getHandle();
                    l5 = DatasetVectorNative.jni_Query7(this.getHandle(), nArray, l4, n5);
                }
                if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                    sQLiteDatabase.close();
                }
                object = l5 == 0L ? this.getRecordset(true, CursorType.STATIC) : new Recordset(l5, this);
            } else {
                object = this.getRecordset(true, queryParameter.getCursorType());
            }
        } else {
            object = new Recordset(l2, this);
        }
        queryParameter2.dispose();
        return object;
    }

    public Recordset getRecordset(boolean bl, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = 0L;
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        int n2 = cursorType.getUGCValue();
        l2 = bl ? DatasetVectorNative.jni_GetEmptyRecordset(this.getHandle(), n2) : DatasetVectorNative.jni_GetAllRecordsByRecordset(this.getHandle(), n2);
        Recordset recordset = null;
        if (l2 != 0L) {
            recordset = new Recordset(l2, this);
            recordset.setIsDisposable(true);
        }
        return recordset;
    }

    protected static DatasetVector createInstance(long l2, Datasource datasource) {
        return new DatasetVector(l2, datasource);
    }

    @Override
    protected final void clearHandle() {
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        this.setHandle(0L);
    }

    public boolean fromGeoJSON(String string) {
        DatasetType datasetType = this.getType();
        if (datasetType != DatasetType.POINT && datasetType != DatasetType.LINE && datasetType != DatasetType.REGION && datasetType != DatasetType.CAD) {
            Log.e((String)"DatasetVector", (String)("\u4e0d\u652f\u6301\u7684\u6570\u636e\u96c6\u7c7b\u578b\uff1a" + datasetType));
            return false;
        }
        Recordset recordset = null;
        boolean bl = false;
        recordset = this.getRecordset(false, CursorType.DYNAMIC);
        bl = recordset.fromGeoJSON(string);
        recordset.dispose();
        return bl;
    }

    public String toGeoJSON(boolean bl, int n2, int n3) {
        DatasetType datasetType = this.getType();
        if (datasetType != DatasetType.POINT && datasetType != DatasetType.LINE && datasetType != DatasetType.REGION && datasetType != DatasetType.CAD) {
            Log.e((String)"DatasetVector", (String)("\u4e0d\u652f\u6301\u7684\u6570\u636e\u96c6\u7c7b\u578b\uff1a" + datasetType));
            return null;
        }
        if (n2 < 0 || n3 < 0 || n2 > n3) {
            Log.e((String)"DatasetVector", (String)"startID\u548c endID\u5fc5\u987b\u5927\u4e8e0\uff0c\u4e14endID\u4e0d\u5c0f\u4e8estartID");
            return null;
        }
        Recordset recordset = null;
        String string = null;
        int n4 = n3 - n2 + 1;
        recordset = this.getRecordset(false, CursorType.DYNAMIC);
        boolean bl2 = recordset.seekID(n2);
        if (bl2) {
            string = recordset.toGeoJSON(bl, n4, n3);
        } else {
            Log.e((String)"DatasetVector", (String)("Not found start SmID: " + n2));
        }
        recordset.dispose();
        return string;
    }

    public void queryByKeyword(String string, String string2, Geometry geometry, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + " like \"%" + string2 + "\"%");
        int n3 = 0;
        if (n2 < 1) {
            n3 = 10;
        } else if (n2 > 100) {
            n3 = 100;
        }
        stringBuilder.append(" limit " + n3);
        this.queryTask(this, string, stringBuilder.toString(), geometry);
    }

    public void queryByFilter(String string, Geometry geometry, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        int n3 = 0;
        if (n2 < 1) {
            n3 = 10;
        } else if (n2 > 100) {
            n3 = 100;
        }
        stringBuilder.append(" limit " + n3);
        this.queryTask(this, string, stringBuilder.toString(), geometry);
    }

    public void setQueryListener(QueryListener queryListener) {
        this.a = queryListener;
    }

    private void queryTask(final Dataset dataset, final String string, final String string2, final Geometry geometry) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                QueryParameter queryParameter = new QueryParameter();
                if (geometry != null) {
                    queryParameter.setSpatialQueryObject(geometry);
                    queryParameter.setSpatialQueryMode(SpatialQueryMode.CONTAIN);
                }
                queryParameter.setCursorType(CursorType.STATIC);
                queryParameter.setAttributeFilter(string2);
                Recordset recordset = ((DatasetVector)dataset).query(queryParameter);
                Vector<Integer> vector = new Vector<Integer>();
                if (recordset != null) {
                    recordset.moveFirst();
                    while (!recordset.isEOF()) {
                        vector.add(recordset.getID());
                        recordset.moveNext();
                    }
                    recordset.close();
                    recordset.dispose();
                    DatasetVector.this.a.queryResult(dataset, string, vector);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public int fromGeoJSON(File file) {
        if (file == null) {
            Log.e((String)"DatasetVecotor", (String)"IllegalArgument, the parameter is null.");
            return 0;
        }
        if (!file.exists() || file.isDirectory()) {
            Log.e((String)"DatasetVecotor", (String)("The file doesn't exist, or it's a directory; " + file.getAbsolutePath()));
            return 0;
        }
        int n2 = 0;
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = null;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                bl = this.fromGeoJSON(string);
                if (!bl) continue;
                ++n2;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }

    public int toGeoJSON(File file) {
        if (file == null) {
            Log.e((String)"DatasetVecotor", (String)"IllegalArgument, the parameter is null.");
            return 0;
        }
        if (file.isDirectory()) {
            Log.e((String)"DatasetVecotor", (String)("The file is a directory; " + file.getAbsolutePath()));
            return 0;
        }
        if (!file.exists() && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileWriter fileWriter = null;
        int n2 = 0;
        try {
            Recordset recordset = null;
            String string = null;
            recordset = this.getRecordset(false, CursorType.DYNAMIC);
            recordset.moveFirst();
            while (!recordset.isEOF()) {
                string = recordset.toGeoJSON(true, 1);
                if (string != null) {
                    fileWriter = new FileWriter(file, true);
                    fileWriter.write(string + "\n");
                    fileWriter.close();
                    ++n2;
                }
                recordset.moveNext();
            }
            recordset.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }

    public GeoLine convertToLine() {
        Recordset recordset;
        GeoLine geoLine = null;
        if (this.getType() == DatasetType.POINT) {
            recordset = this.getRecordset(false, CursorType.STATIC);
            if (recordset == null) {
                return null;
            }
            int n2 = recordset.getRecordCount();
            if (n2 > 1) {
                GeoPoint geoPoint = null;
                Point2Ds point2Ds = new Point2Ds();
                geoLine = new GeoLine();
                recordset.moveFirst();
                while (!recordset.isEOF()) {
                    geoPoint = (GeoPoint)recordset.getGeometry();
                    point2Ds.add(geoPoint.getInnerPoint());
                    geoPoint.dispose();
                    recordset.moveNext();
                }
                geoLine.addPart(point2Ds);
            }
        } else {
            throw new IllegalArgumentException("\u6570\u636e\u96c6\uff1a" + this.getName() + "\u4e0d\u662f\u70b9\u6570\u636e\u96c6");
        }
        recordset.close();
        recordset.dispose();
        return geoLine;
    }

    public GeoLine convertToLine(String string, String string2) {
        Recordset recordset;
        GeoLine geoLine = null;
        if (this.getType() == DatasetType.POINT) {
            if (string == null || string2 == null) {
                return null;
            }
            FieldInfos fieldInfos = this.getFieldInfos();
            FieldInfo fieldInfo = fieldInfos.get(string);
            if (fieldInfo == null) {
                return null;
            }
            FieldType fieldType = fieldInfo.getType();
            String string3 = null;
            string3 = string + "=" + string2;
            if (fieldType == FieldType.TEXT || fieldType == FieldType.WTEXT || fieldType == FieldType.CHAR) {
                string3 = string + "=" + "'" + string2 + "'";
            }
            if (fieldType == FieldType.DATETIME) {
                string3 = string + "=" + "to_date(" + string2 + ")";
            }
            if ((recordset = this.query(string3, CursorType.STATIC)) == null) {
                return null;
            }
            int n2 = recordset.getRecordCount();
            if (n2 > 1) {
                GeoPoint geoPoint = null;
                Point2Ds point2Ds = new Point2Ds();
                geoLine = new GeoLine();
                recordset.moveFirst();
                while (!recordset.isEOF()) {
                    geoPoint = (GeoPoint)recordset.getGeometry();
                    point2Ds.add(geoPoint.getInnerPoint());
                    geoPoint.dispose();
                    recordset.moveNext();
                }
                geoLine.addPart(point2Ds);
            }
        } else {
            throw new IllegalArgumentException("\u6570\u636e\u96c6\uff1a" + this.getName() + "\u4e0d\u662f\u70b9\u6570\u636e\u96c6");
        }
        recordset.close();
        recordset.dispose();
        return geoLine;
    }

    public SpatialIndexType getSpatialIndexType() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = DatasetVectorNative.jni_GetSpatialIndexType(this.getHandle());
        return (SpatialIndexType)Enum.parseUGCValue(SpatialIndexType.class, n2);
    }

    public boolean isSpatialIndexDirty() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_GetIsSpatialIndexDirty(this.getHandle());
    }

    public boolean isSpatialIndexTypeSupported(SpatialIndexType spatialIndexType) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (spatialIndexType == null) {
            String string = E.a("spatialIndexType", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new NullPointerException(string);
        }
        return DatasetVectorNative.jni_IsSpatialIndexTypeSupported(this.getHandle(), spatialIndexType.getUGCValue());
    }

    public boolean buildSpatialIndex(SpatialIndexInfo spatialIndexInfo) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SpatialIndexType spatialIndexType = spatialIndexInfo.getType();
        if (!this.isSpatialIndexTypeSupported(spatialIndexType)) {
            String string = E.a("spatialIndexInfo", "DatasetVector_BuildSpatialIndexUnsupportTheSpatialIndexType", "data_resources");
            throw new IllegalStateException(string);
        }
        if (spatialIndexInfo == null || spatialIndexInfo.getHandle() == 0L) {
            String string = E.a("spatialIndexInfo", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new NullPointerException(string);
        }
        boolean bl = DatasetVectorNative.jni_BuildSpatialIndex2(this.getHandle(), spatialIndexInfo.getHandle());
        return bl;
    }

    public boolean buildSpatialIndex(SpatialIndexType spatialIndexType) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (spatialIndexType == null) {
            String string = E.a("spatialIndexType", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new NullPointerException(string);
        }
        if (!this.isSpatialIndexTypeSupported(spatialIndexType)) {
            String string = E.a("spatialIndexType", "DatasetVector_BuildSpatialIndexUnsupportTheSpatialIndexType", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_BuildSpatialIndex1(this.getHandle(), spatialIndexType.getUGCValue());
    }

    public boolean reBuildSpatialIndex() {
        if (this.getHandle() == 0L) {
            String string = E.a("reBuildSpatialIndex()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_ReBuildSpatialIndex(this.getHandle());
    }

    public boolean dropSpatialIndex() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_DropSpatialIndex(this.getHandle());
    }

    public Rectangle2D computeBounds() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = E.a("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        DatasetVectorNative.jni_ComputeBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }
}

