/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.C;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfoNative;
import com.supermap.data.E;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;

public class DatasetVectorInfo
extends InternalHandleDisposable {
    public DatasetVectorInfo() {
        this.setHandle(DatasetVectorInfoNative.jni_New(), true);
        this.a();
    }

    public DatasetVectorInfo(String string, DatasetType datasetType) {
        if (string == null || string.trim().length() == 0) {
            String string2 = E.a("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        C c2 = Dataset.isValidDatasetName(string);
        if (c2 != null) {
            String string3 = "";
            if (c2.equals(C.a)) {
                string3 = "Dataset_NameIsEmpty";
            } else if (c2.equals(C.g)) {
                string3 = "Dataset_NameAgainstSys";
            } else if (c2.equals(C.b)) {
                string3 = "Dataset_NameBeyondLimit";
            } else if (c2.equals(C.c)) {
                string3 = "Dataset_NameIncludeInvalidChar";
            } else if (c2.equals(C.f)) {
                string3 = "Dataset_NameErrorPrefix";
            }
            String string4 = E.a("value", string3, "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (datasetType == null) {
            String string5 = E.a("type", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string5);
        }
        this.setHandle(DatasetVectorInfoNative.jni_New(), true);
        this.a();
        this.setName(string);
        this.setType(datasetType);
    }

    public DatasetVectorInfo(DatasetVectorInfo datasetVectorInfo) {
        if (datasetVectorInfo == null) {
            String string = E.a("datasetVectorInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetVectorInfo.getHandle() == 0L) {
            String string = E.a("datasetVectorInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = DatasetVectorInfoNative.jni_Clone(datasetVectorInfo.getHandle());
        this.setHandle(l2, true);
    }

    public DatasetVectorInfo(String string, DatasetVector datasetVector) {
        if (datasetVector == null) {
            String string2 = E.a("templateDataset", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string2);
        }
        long l2 = datasetVector.getHandle();
        if (l2 == 0L) {
            String string3 = E.a("templateDataset", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        long l3 = DatasetVectorInfoNative.jni_New2(l2);
        this.setHandle(l3, true);
        this.setName(string);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorInfoNative.jni_GetName(this.getHandle());
    }

    public void setName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = E.a("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        C c2 = Dataset.isValidDatasetName(string);
        if (c2 != null) {
            String string4 = "";
            if (c2.equals(C.a)) {
                string4 = "Dataset_NameIsEmpty";
            } else if (c2.equals(C.g)) {
                string4 = "Dataset_NameAgainstSys";
            } else if (c2.equals(C.b)) {
                string4 = "Dataset_NameBeyondLimit";
            } else if (c2.equals(C.c)) {
                string4 = "Dataset_NameIncludeInvalidChar";
            } else if (c2.equals(C.f)) {
                string4 = "Dataset_NameErrorPrefix";
            }
            String string5 = E.a("value", string4, "data_resources");
            throw new IllegalArgumentException(string5);
        }
        DatasetVectorInfoNative.jni_SetName(this.getHandle(), string);
    }

    public DatasetType getType() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = DatasetVectorInfoNative.jni_GetType(this.getHandle());
        return (DatasetType)Enum.parseUGCValue(DatasetType.class, n2);
    }

    public void setType(DatasetType datasetType) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (datasetType == null) {
            String string = E.a("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetVectorInfoNative.jni_SetType(this.getHandle(), datasetType.getUGCValue());
    }

    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = DatasetVectorInfoNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)Enum.parseUGCValue(EncodeType.class, n2);
    }

    public void setEncodeType(EncodeType encodeType) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (encodeType == null) {
            String string = E.a("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetVectorInfoNative.jni_SetEncodeType(this.getHandle(), encodeType.getUGCValue());
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = "{Name=\"" + this.getName() + "\",Type=" + this.getType().name() + ",EncodeType=" + this.getEncodeType().name() + "}";
        return string;
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            DatasetVectorInfoNative.jni_Delete(super.getHandle());
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
    }

    void a() {
        if (this.getHandle() != 0L) {
            DatasetVectorInfoNative.jni_Reset(this.getHandle());
        }
    }
}

