/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.DatasetsNative;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceNative;
import com.supermap.data.E;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import java.util.ArrayList;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Datasets {
    private ArrayList a;
    private Datasource a = null;

    protected Datasets() {
    }

    Datasets(Datasource datasource) {
        this.a();
        this.a = new ArrayList();
        this.a = datasource;
        this.b();
    }

    public DatasetVector create(DatasetVectorInfo datasetVectorInfo) {
        if (!this.a()) {
            String string = E.a("create(DatasetVectorInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a.isReadOnly()) {
            String string = E.a("create(DatasetVectorInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (datasetVectorInfo == null) {
            String string = E.a("datasetInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetVectorInfo.getHandle() == 0L) {
            String string = E.a("datasetInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Datasets.isCreatableVectorType(datasetVectorInfo.getType())) {
            String string = E.a("type", "Datasets_FailToCreateBecauseOfType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Datasets.isCreatableEnCodeType(datasetVectorInfo.getType(), datasetVectorInfo.getEncodeType())) {
            String string = E.a("encodeType", "Datasets_FailToCreateBecauseOfEncodeType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVector datasetVector = null;
        if (datasetVectorInfo.getName().trim().equals("") || !this.isAvailableDatasetName(datasetVectorInfo.getName())) {
            String string = E.a("name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = DatasetsNative.jni_CreateDatasetVector(this.a.getHandle(), datasetVectorInfo.getHandle());
        if (l2 != 0L) {
            datasetVector = new DatasetVector(l2, this.a);
            this.a(datasetVector);
        }
        return datasetVector;
    }

    public boolean delete(int n2) {
        if (!this.a()) {
            String string = E.a("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a.isReadOnly()) {
            String string = E.a("delete(int index)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (n2 < 0 || n2 >= this.getCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Dataset dataset = this.get(n2);
        String string = dataset.getName();
        boolean bl = DatasetsNative.jni_DeleteDataset2(this.a.getHandle(), string);
        if (bl) {
            dataset.clearHandle();
            this.a.remove(n2);
        }
        return bl;
    }

    public boolean delete(String string) {
        if (!this.a()) {
            String string2 = E.a("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a.isReadOnly()) {
            String string3 = E.a("delete(String name)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string3);
        }
        int n2 = this.indexOf(string);
        if (-1 == n2) {
            return false;
        }
        boolean bl = DatasetsNative.jni_DeleteDataset2(this.a.getHandle(), string);
        if (bl) {
            Dataset dataset = this.get(n2);
            dataset.clearHandle();
            this.a.remove(n2);
        }
        return bl;
    }

    public int getCount() {
        if (!this.a()) {
            String string = E.a("getCount()", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a.size();
    }

    public Dataset get(String string) {
        if (!this.a()) {
            String string2 = E.a("get(String name)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        Dataset dataset = null;
        int n2 = this.indexOf(string);
        if (n2 != -1) {
            dataset = this.get(n2);
        }
        return dataset;
    }

    public Dataset get(int n2) {
        if (!this.a()) {
            String string = E.a("get(int index)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return (Dataset)this.a.get(n2);
    }

    public String getAvailableDatasetName(String string) {
        if (!this.a()) {
            String string2 = E.a("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        return DatasetsNative.jni_GetUnoccupiedDatasetName(this.a.getHandle(), string);
    }

    public boolean isAvailableDatasetName(String string) {
        if (!this.a()) {
            String string2 = E.a("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (string != null && string.trim().length() != 0) {
            bl = DatasetsNative.jni_IsAvailableDatasetName(this.a.getHandle(), string);
        }
        return bl;
    }

    public boolean contains(String string) {
        boolean bl = false;
        if (this.indexOf(string) != -1) {
            bl = true;
        }
        return bl;
    }

    public int indexOf(String string) {
        if (!this.a()) {
            String string2 = E.a("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        int n2 = -1;
        if (string != null && string.trim().length() != 0) {
            int n3 = this.getCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!string.equalsIgnoreCase(this.get(i2).getName())) continue;
                return i2;
            }
        }
        return n2;
    }

    void a() {
        if (this.a != null) {
            int n2 = this.a.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.a.get(i2) == null) continue;
                ((Dataset)this.a.get(i2)).clearHandle();
            }
            this.a.clear();
            this.a = null;
        }
        this.a = null;
    }

    void b() {
        this.a.clear();
        int n2 = DatasourceNative.jni_GetDatasetsCount(this.a.getHandle());
        long[] lArray = new long[n2];
        int[] nArray = new int[n2];
        DatasourceNative.jni_GetDatasets(this.a.getHandle(), lArray, nArray);
        for (int i2 = 0; i2 < n2; ++i2) {
            DatasetType datasetType;
            try {
                datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, nArray[i2]);
            }
            catch (RuntimeException runtimeException) {
                if (nArray[i2] != 88) continue;
                datasetType = DatasetType.IMAGE;
            }
            try {
                Dataset dataset = Dataset.createInstance(lArray[i2], datasetType, this.a);
                if (dataset == null) continue;
                this.a.add(dataset);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    void a(Dataset dataset) {
        String string = dataset.getName();
        if (!this.contains(string)) {
            this.a.add(dataset);
        }
    }

    protected static void add(Datasets datasets, Dataset dataset) {
        if (datasets != null) {
            datasets.a(dataset);
        }
    }

    private boolean a() {
        boolean bl = true;
        if (this.a == null || this.a.getHandle() == 0L || this.a.getWorkspace() == null || this.a.getWorkspace().getHandle() == 0L) {
            bl = false;
        }
        return bl;
    }

    static boolean isCreatableVectorType(DatasetType datasetType) {
        boolean bl = true;
        if (datasetType.equals(DatasetType.IMAGE)) {
            bl = false;
        }
        return bl;
    }

    static boolean isCreatableEnCodeType(DatasetType datasetType, EncodeType encodeType) {
        boolean bl = true;
        if (datasetType.equals(DatasetType.TABULAR) || datasetType.equals(DatasetType.POINT)) {
            bl = bl && encodeType.equals(EncodeType.NONE);
        } else if (Datasets.isCreatableVectorType(datasetType)) {
            bl = bl && !encodeType.equals(EncodeType.DCT);
            bl = bl && !encodeType.equals(EncodeType.SGL);
            bl = bl && !encodeType.equals(EncodeType.LZW);
        } else if (datasetType.equals(DatasetType.IMAGE)) {
            bl = encodeType.equals(EncodeType.NONE) || encodeType.equals(EncodeType.DCT) || encodeType.equals(EncodeType.SGL) || encodeType.equals(EncodeType.LZW);
        }
        return bl;
    }
}

