/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import android.content.Context;
import android.content.res.AssetManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.supermap.data.E;
import com.supermap.data.LicenseStatus;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Environment {
    private static final String a = android.os.Environment.getExternalStorageDirectory() + "/SuperMap/config/";
    private static final String b = android.os.Environment.getExternalStorageDirectory() + "/SuperMap/data/";
    private static final String c = android.os.Environment.getExternalStorageDirectory() + "/SuperMap/temp/";
    private static final String d = android.os.Environment.getExternalStorageDirectory() + "/SuperMap/license/";
    private static String e = "";
    private static String f = "";
    private static String g = "";
    private static String h = "";
    private static String i = "/system/fonts/";
    private static String j = "/oda/adinit.dat";
    private static boolean a = false;
    public static final double DEFAULT_MAX_EQUAL_ZERO_PRECISION = 1.0E-10;
    public static final double DEFAULT_MIN_EQUAL_ZERO_PRECISION = -1.0E-10;
    private static double a = 1.0E-10;
    private static double b = -1.0E-10;
    private static boolean b = false;
    private static boolean c = false;
    private static Context a = null;
    private static a a = new a();
    private static boolean d = false;

    protected Environment() {
    }

    public static double getMaxEqualZeroPrecision() {
        return a;
    }

    public static double getMinEqualZeroPrecision() {
        return b;
    }

    public static String getTemporaryPath() {
        return Environment.jni_getTempPath();
    }

    public static void setTemporaryPath(String string) {
        File file;
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if ((file = new File(string)).exists() ? !file.isDirectory() : !file.mkdirs()) {
            throw new IllegalArgumentException(string + " is not a correct directory");
        }
        g = string;
        if (b) {
            Environment.jni_setTempPath(g);
        }
    }

    static a getDeviceInfo() {
        if (!Environment.hasInitUGCEnv()) {
            throw new IllegalStateException("Please call com.supermap.data.Environment.initialization() firstly");
        }
        return a;
    }

    @Deprecated
    public static String getConfigFileDirectory() {
        return Environment.jni_getConfigDir();
    }

    public static void setDebugMode(boolean bl) {
        Environment.jni_SetDebugMode(bl);
    }

    @Deprecated
    public static void setConfigFileDirectory(String string) {
        File file;
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if ((file = new File(string)).exists() ? !file.isDirectory() : !file.mkdirs()) {
            throw new IllegalArgumentException(string + " is not a correct directory");
        }
    }

    public static String getWebCacheDirectory() {
        return Environment.jni_getWebCacheDir();
    }

    public static void setWebCacheDirectory(String string) {
        File file;
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if ((file = new File(string)).exists() ? !file.isDirectory() : !file.mkdirs()) {
            throw new IllegalArgumentException(string + " is not a correct directory");
        }
        f = string;
        if (b) {
            Environment.jni_setWebCacheDir(string);
        }
    }

    public static void setFontsPath(String string) {
        File file;
        if (!Environment.hasInitUGCEnv()) {
            throw new IllegalStateException("Please call com.supermap.data.Environment.initialization() firstly");
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if ((file = new File(string)).exists() ? !file.isDirectory() : !file.mkdirs()) {
            throw new IllegalArgumentException(string + " is not a correct directory");
        }
        i = string;
        if (b) {
            Environment.jni_setFontsPath(string);
        }
    }

    static void LoadWrapJ() {
        if (!b) {
            System.loadLibrary("imb");
            b = true;
        }
    }

    public static String getDeviceID() {
        if (!Environment.hasInitUGCEnv()) {
            throw new IllegalStateException("Please call com.supermap.data.Environment.initialization() firstly");
        }
        return Environment.jni_getDeviceID();
    }

    public static String getLicensePath() {
        return Environment.jni_getLicensePath();
    }

    protected static boolean hasInitUGCEnv() {
        return c;
    }

    public static void setLicensePath(String string) {
        File file;
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if ((file = new File(string)).exists() ? !file.isDirectory() : !file.mkdirs()) {
            throw new IllegalArgumentException(string + " is not a correct directory");
        }
        h = string;
        if (b) {
            Environment.jni_setLicensePath(string);
        }
    }

    static Context getContext() {
        return a;
    }

    public static boolean initialization(Context context) {
        if (c) {
            return c;
        }
        a = context;
        Environment.checkAndLoadLibrary(context);
        e = context.getFilesDir().getAbsolutePath() + "/config/";
        Environment.checkAPK(context);
        if (Environment.checkConfigFile()) {
            c = true;
        } else {
            b b2 = new b();
            b2.a(context, e);
            c = Environment.checkConfigFile();
        }
        Environment.checkDevice(context);
        Environment.jni_JniLoading(context);
        Environment.setTemporaryPath(g);
        Environment.setWebCacheDirectory(f);
        Environment.setLicensePath(h);
        if (!c) {
            throw new IllegalStateException("Environment initialize Failed");
        }
        Environment.jni_setConfigDir(e);
        Environment.jni_InitEnvironment();
        Environment.setFontsPath(i);
        Environment.jni_setAppCachePath(context.getCacheDir().toString());
        return c;
    }

    private static void checkDevice(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        int n2 = wifiManager.getWifiState();
        for (int i2 = 0; i2 < 20 && wifiManager.getWifiState() != 3; ++i2) {
            wifiManager.setWifiEnabled(true);
            try {
                Thread.sleep(150L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        String string = wifiInfo.getMacAddress();
        if (string == null) {
            string = "none";
        }
        if (n2 == 1) {
            wifiManager.setWifiEnabled(false);
        }
        Environment.a.c = string;
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null && (string = telephonyManager.getDeviceId()) == null) {
            string = "none";
        }
        Environment.a.d = string;
        Environment.a.a = Build.MODEL;
        Environment.a.b = Build.VERSION.RELEASE;
    }

    static LicenseStatus verifyLicenseCode(String string) {
        String[] stringArray = new String[]{new String()};
        if (Environment.jni_VerifyLicenseCode(string, stringArray)) {
            return Environment.getLicenseStatus();
        }
        throw new IllegalArgumentException(stringArray[0]);
    }

    private static boolean checkConfigFile() {
        File file = new File(e);
        File file2 = new File(e + "/ProjectionMappingTable/");
        if (file.isDirectory() && file2.exists()) {
            File[] fileArray = file.listFiles();
            int n2 = 0;
            for (File file3 : fileArray) {
                if (!file3.getName().equals("SuperMap.xml") && !file3.getName().equals("PrjConfig.xml") && !file3.getName().equals("GraphicsMemFonts.xml") && !file3.getName().equals("CodeTransition.xml") && !file3.getName().equals("resource.xml")) continue;
                ++n2;
            }
            if (n2 >= 5) {
                File file4;
                File file3;
                File file5 = new File(file.getAbsolutePath() + "/Resource/BMapCitySetting.xml");
                if (!file5.exists()) {
                    return false;
                }
                if (a && !(file4 = new File(file.getAbsolutePath() + "/voice/resource.irf")).exists()) {
                    return false;
                }
                File file6 = new File(file.getParent() + "/icu/icudt50l.dat");
                if (!file6.exists()) {
                    return false;
                }
                File file7 = new File(file.getAbsolutePath() + "/mapRes/map.jar");
                if (!file7.exists()) {
                    return false;
                }
                if (!Environment.checkResVersion(file)) {
                    return false;
                }
                file3 = new File(file.getParent() + j);
                return file3.exists();
            }
        }
        return false;
    }

    public static LicenseStatus getLicenseStatus() {
        if (!Environment.hasInitUGCEnv()) {
            throw new IllegalStateException("Please call com.supermap.data.Environment.initialization() firstly");
        }
        return Environment.readLiceseState();
    }

    private static LicenseStatus readLiceseState() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        long l2 = 0L;
        Date date = new Date();
        Date date2 = new Date();
        bl = Environment.jni_IsLicenseValid();
        bl3 = Environment.jni_IsLicenseExsit();
        if (!bl3) {
            return new LicenseStatus(bl, bl2, l2, date, date2, bl3);
        }
        bl2 = Environment.jni_IsTrailLicense();
        l2 = Environment.jni_GetVersion();
        long l3 = Environment.jni_GetStartDate();
        int n2 = (int)l3 / 10000;
        int n3 = (int)(l3 % 10000L) / 100;
        int n4 = (int)l3 % 100;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, n2);
        calendar.set(2, n3 - 1);
        calendar.set(5, n4);
        date = new Date(calendar.getTimeInMillis());
        long l4 = Environment.jni_GetExpireDate();
        n2 = (int)l4 / 10000;
        n3 = (int)(l4 % 10000L) / 100;
        n4 = (int)l4 % 100;
        calendar.clear();
        calendar.set(1, n2);
        calendar.set(2, n3 - 1);
        calendar.set(5, n4);
        date2 = new Date(calendar.getTimeInMillis());
        return new LicenseStatus(bl, bl2, l2, date, date2, bl3);
    }

    protected static void InternalLoadWrapJ() {
        Environment.LoadWrapJ();
    }

    public static boolean isSuportSpeeking() {
        return a;
    }

    private static void checkAPK(Context context) {
        String[] stringArray;
        boolean bl = false;
        boolean bl2 = false;
        AssetManager assetManager = context.getAssets();
        String string = "voice";
        String string2 = "resource.mp3";
        try {
            String[] stringArray2;
            for (String string3 : stringArray2 = assetManager.list(string)) {
                if (!string3.equals(string2)) continue;
                bl = true;
                break;
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        String string4 = context.getFilesDir().getAbsolutePath().replace("files", "lib");
        String string5 = "libAisound.so";
        File file = new File(string4);
        for (String string6 : stringArray = file.list()) {
            if (!string6.equals(string5)) continue;
            System.loadLibrary("Aisound");
            bl2 = true;
            break;
        }
        a = bl2 && bl;
    }

    protected static native void jni_InitEnvironment();

    private static native String jni_getTempPath();

    private static native void jni_setTempPath(String var0);

    private static native String jni_getWebCacheDir();

    private static native void jni_setWebCacheDir(String var0);

    private static native String jni_getConfigDir();

    private static native void jni_setConfigDir(String var0);

    private static native void jni_setFontsPath(String var0);

    private static native String jni_getDeviceID();

    private static native String jni_getLicensePath();

    private static native void jni_setLicensePath(String var0);

    private static native void jni_JniLoading(Context var0);

    private static native void jni_SetDebugMode(boolean var0);

    private static native boolean jni_VerifyLicenseCode(String var0, String[] var1);

    private static native boolean jni_IsLicenseValid();

    private static native boolean jni_IsTrailLicense();

    private static native boolean jni_IsLicenseExsit();

    private static native long jni_GetVersion();

    private static native long jni_GetStartDate();

    private static native long jni_GetExpireDate();

    private static native boolean jni_IsFiledMapperValid();

    private static native boolean jni_IsGeoSurveyValid();

    private static native String jni_getAppCachePath();

    private static native void jni_setAppCachePath(String var0);

    protected static boolean isFiledMapperVaild() {
        return Environment.jni_IsFiledMapperValid();
    }

    protected static boolean isGeoSurveryVaild() {
        return Environment.jni_IsGeoSurveyValid();
    }

    private static void checkAndLoadLibrary(Context context) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        String string = context.getFilesDir().getAbsolutePath().replace("files", "lib");
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String[] stringArray4 = Environment.getlibName(context);
        if (stringArray4[0] != null && stringArray4[1] != null) {
            string2 = stringArray4[0];
            string3 = stringArray4[1];
            string6 = stringArray4[2];
            stringArray3 = string2.split("\\.");
            stringArray2 = string3.split("\\.");
            stringArray = string6.split("\\.");
            string4 = stringArray3[0].substring(3);
            string5 = stringArray2[0].substring(3);
            string7 = stringArray[0].substring(3);
        }
        stringArray3 = new File(string);
        stringArray2 = stringArray3.list();
        stringArray = new ArrayList();
        for (String string8 : stringArray2) {
            stringArray.add(string8);
        }
        if (stringArray.contains(string6)) {
            System.loadLibrary(string7);
            b = true;
            bl = true;
        } else if (stringArray.contains(string2)) {
            System.loadLibrary(string4);
            b = true;
            bl = true;
        } else if (stringArray.contains(string3)) {
            System.loadLibrary(string5);
            b = true;
            bl = true;
        } else if (stringArray.contains("libimbAutoCAD.so")) {
            System.loadLibrary("imbAutoCAD");
            b = true;
            bl = true;
        } else if (stringArray.contains("libimb.so")) {
            System.loadLibrary("imb");
            b = true;
            bl = true;
        } else if (stringArray.contains("libimb2d.so")) {
            System.loadLibrary("imb2d");
            b = true;
            bl = true;
        } else if (stringArray.contains("libimb7c.so")) {
            System.loadLibrary("imb7c");
            b = true;
            bl = true;
        } else if (stringArray.contains("libimb7c2d.so")) {
            System.loadLibrary("imb7c2d");
            b = true;
            bl = true;
        }
        if (!bl) {
            String string9 = E.a("so\u5e93\u548cjar\u5305\u7248\u672c\u4e0d\u5339\u914d", "", "");
            throw new IllegalArgumentException(string9);
        }
    }

    private static String[] getlibName(Context context) {
        String[] stringArray = new String[3];
        AssetManager assetManager = context.getAssets();
        try {
            InputStream inputStream = assetManager.open("ver/ver.txt");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            stringArray[0] = bufferedReader.readLine();
            stringArray[1] = bufferedReader.readLine();
            stringArray[2] = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            String string = E.a("\u7248\u672c\u53f7\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u635f\u6bc1, " + iOException, "", "");
            throw new IllegalArgumentException(string);
        }
        return stringArray;
    }

    private static String getCode(InputStream inputStream) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            String string = null;
            int n2 = (bufferedInputStream.read() << 8) + bufferedInputStream.read();
            switch (n2) {
                case 61371: {
                    string = "UTF-8";
                    break;
                }
                case 65534: {
                    string = "Unicode";
                    break;
                }
                case 65279: {
                    string = "UTF-16BE";
                    break;
                }
                default: {
                    string = "GBK";
                }
            }
            inputStream.close();
            return string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static void setOpenGLMode(boolean bl) {
        d = bl;
    }

    public static boolean isOpenGLMode() {
        return d;
    }

    private static boolean checkResVersion(File file) {
        Object object;
        Closeable closeable;
        FileInputStream fileInputStream;
        String string = null;
        String string2 = null;
        File file2 = new File(file.getAbsolutePath() + "/ver/res_ver.txt");
        if (!file2.exists()) {
            return false;
        }
        try {
            fileInputStream = new FileInputStream(file2);
            if (fileInputStream != null) {
                closeable = new InputStreamReader(fileInputStream);
                object = new BufferedReader((Reader)closeable);
                string = ((BufferedReader)object).readLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        fileInputStream = a.getAssets();
        try {
            closeable = fileInputStream.open("ver/res_ver.txt");
            object = new BufferedReader(new InputStreamReader((InputStream)closeable));
            string2 = ((BufferedReader)object).readLine();
        }
        catch (IOException iOException) {
            object = E.a("\u8d44\u6e90\u7248\u672c\u53f7\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u635f\u6bc1, " + iOException, "", "");
            throw new IllegalArgumentException((String)object);
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    static {
        e = a;
        f = b;
        g = c;
        h = d;
    }

    static class b {
        b() {
        }

        public boolean a(Context context, String string) {
            AssetManager assetManager = context.getAssets();
            try {
                InputStream inputStream;
                File file;
                File file2;
                Object object;
                Object object2;
                String[] stringArray = assetManager.list("config");
                if (stringArray.length < 5) {
                    throw new IllegalArgumentException("There's no config file in assets directory or config file which in assets directory has lost");
                }
                for (String string2 : stringArray) {
                    String string3 = "config/" + string2;
                    object2 = assetManager.open(string3);
                    int n2 = string2.indexOf(".ogg");
                    object = string + "/" + string2.substring(0, n2);
                    file2 = new File((String)object);
                    this.a((InputStream)object2, file2, false);
                }
                String[] stringArray2 = null;
                for (String string4 : stringArray2 = (stringArray = assetManager.list("config4wkt"))) {
                    object2 = "config4wkt/" + string4;
                    InputStream inputStream2 = assetManager.open((String)object2);
                    object = string + "ProjectionMappingTable/" + string4;
                    file2 = new File((String)object);
                    this.a(inputStream2, file2, false);
                }
                this.b(context, string);
                File file3 = new File(string + "/Resource/BMapCitySetting.xml");
                InputStream inputStream3 = assetManager.open("res/BMapCitySetting.xml.ogg");
                this.a(inputStream3, file3, false);
                File file4 = new File(string + "/mapRes/map.jar");
                InputStream inputStream4 = assetManager.open("mapRes/map.ogg");
                this.a(inputStream4, file4, true);
                object2 = assetManager.open("icu/icudt50l.dat");
                File file5 = new File(context.getFileStreamPath("icu").getAbsoluteFile() + "/icudt50l.dat");
                this.a((InputStream)object2, file5, false);
                object = assetManager.open("oda/adinit.dat");
                file2 = new File(context.getFileStreamPath("oda").getAbsoluteFile() + "/adinit.dat");
                this.a((InputStream)object, file2, false);
                if (a) {
                    file = new File(string + "/voice/resource.irf");
                    inputStream = assetManager.open("voice/resource.mp3");
                    this.a(inputStream, file, false);
                }
                file = new File(string + "/ver/res_ver.txt");
                inputStream = assetManager.open("ver/res_ver.txt");
                this.a(inputStream, file, true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return true;
        }

        public boolean a(InputStream inputStream, File file, boolean bl) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (file.exists()) {
                if (bl) {
                    file.delete();
                } else {
                    return false;
                }
            }
            try {
                InputStream inputStream2 = inputStream;
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[1024];
                int n2 = -1;
                while ((n2 = inputStream2.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n2);
                }
                fileOutputStream.flush();
                fileOutputStream.close();
                inputStream2.close();
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }

        public boolean b(Context context, String string) {
            AssetManager assetManager = context.getAssets();
            try {
                String[] stringArray = assetManager.list("3dRes");
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (!stringArray[i2].contains("3dRes.zip")) continue;
                    File file = new File(string + "/Resource/3dRes.zip");
                    InputStream inputStream = assetManager.open("3dRes/3dRes.zip");
                    if (this.a(inputStream, file, false)) {
                        com.supermap.data.b.a(string + "/Resource/3dRes.zip", string + "/Resource/");
                        if (file.exists()) {
                            file.delete();
                        }
                    }
                    return true;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return false;
        }
    }

    static class a {
        public String a = "";
        public String b = "";
        public String c = "";
        public String d = "none";

        a() {
        }
    }
}

