/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.E;
import com.supermap.data.GeoBSplineNative;
import com.supermap.data.GeoCardinalNative;
import com.supermap.data.GeoLine;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;

public class GeoBSpline
extends Geometry {
    private Point2Ds a = null;

    public GeoBSpline() {
        long l2 = GeoBSplineNative.jni_New();
        this.setHandle(l2, true);
    }

    public GeoBSpline(GeoBSpline geoBSpline) {
        if (geoBSpline == null) {
            String string = E.a("geoBSpline", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandleDisposable.getHandle(geoBSpline);
        if (l2 == 0L) {
            String string = E.a("geoBSpline", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = GeoBSplineNative.jni_Clone(l2);
        this.setHandle(l3, true);
        this.a = new Point2Ds(geoBSpline.getControlPoints(), this);
    }

    public GeoBSpline(Point2Ds point2Ds) {
        int n2 = point2Ds.getCount();
        if (n2 < 4) {
            String string = E.a("controlPoints", "GeoBSpline_ControlPointsLengthShouldNotLessThanFour", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = point2Ds.getItem(i2).getX();
            dArray2[i2] = point2Ds.getItem(i2).getY();
        }
        long l2 = GeoBSplineNative.jni_New2(dArray, dArray2);
        this.setHandle(l2, true);
        this.a = new Point2Ds(point2Ds, this);
    }

    GeoBSpline(long l2) {
        this.setHandle(l2, false);
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = E.a("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoBSplineNative.jni_GetLength(this.getHandle());
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = E.a("isEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoBSplineNative.jni_IsEmpty(this.getHandle());
    }

    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = E.a("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.a.clear();
        this.a = null;
        GeoBSplineNative.jni_SetEmpty(this.getHandle());
    }

    public Point2Ds getControlPoints() {
        if (this.getHandle() == 0L) {
            String string = E.a("getControlPoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = GeoBSplineNative.jni_GetPartPointCount(this.getHandle());
        if (n2 >= 4) {
            int n3;
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            GeoBSplineNative.jni_GetControlPoints(this.getHandle(), dArray, dArray2);
            Point2Ds point2Ds = new Point2Ds();
            for (n3 = 0; n3 < n2; ++n3) {
                point2Ds.add(new Point2D(dArray[n3], dArray2[n3]));
            }
            if (this.a == null) {
                this.a = new Point2Ds(point2Ds, this);
            } else {
                for (n3 = 0; n3 < n2; ++n3) {
                    this.a.add(new Point2D(dArray[n3], dArray2[n3]));
                }
                n3 = this.a.getCount();
                this.a.removeRange(0, n3 - n2);
            }
        }
        return this.a;
    }

    public void setControlPoints(Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = E.a("setControlPoints(Point2Ds controlPoints)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = point2Ds.getCount();
        if (n2 < 4) {
            String string = E.a("controlPoints", "GeoBSpline_ControlPointsLengthShouldNotLessThanFour", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = point2Ds.getItem(i2).getX();
            dArray2[i2] = point2Ds.getItem(i2).getY();
        }
        GeoBSplineNative.jni_SetControlPoints(this.getHandle(), dArray, dArray2);
    }

    public GeoLine convertToLine(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("convertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 2) {
            String string = E.a("pointCountPerSegment", "Global_ArgumentShouldNotSmallerThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoBSplineNative.jni_ConvertToLine(this.getHandle(), n2);
        GeoLine geoLine = null;
        if (l2 != 0L) {
            geoLine = new GeoLine(l2);
            geoLine.setIsDisposable(true);
        }
        return geoLine;
    }

    @Override
    public GeoBSpline clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoBSpline(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoCardinalNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }

    @Override
    public boolean fromJson(String string) {
        return false;
    }

    @Override
    public String toJson() {
        return null;
    }
}

