/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.E;
import com.supermap.data.GeoChordNative;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point2D;

public class GeoChord
extends Geometry {
    public GeoChord() {
        long l2 = GeoChordNative.jni_New();
        this.setHandle(l2, true);
    }

    public GeoChord(GeoChord geoChord) {
        if (geoChord == null) {
            String string = E.a("geoChord", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandleDisposable.getHandle(geoChord);
        if (l2 == 0L) {
            String string = E.a("geoChord", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = GeoChordNative.jni_Clone(l2);
        this.setHandle(l3, true);
    }

    public GeoChord(Point2D point2D, double d2, double d3, double d4, double d5, double d6) {
        double d7 = point2D.getX();
        double d8 = point2D.getY();
        if (d2 <= 0.0) {
            String string = E.a("semimajorAxis", "GeoChord_SemimajorAxisShouldBePositive", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d3 <= 0.0) {
            String string = E.a("semiminorAxis", "GeoChord_SemiMinorAxisShouldBePositive", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d5 <= -360.0 || d5 >= 360.0) {
            String string = E.a("sweepAngle", "GeoChord_SweepAngleRange:(-360,0)||(0,360)", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d5 == 0.0) {
            String string = E.a("sweepAngle", "GeoChord_SweepAngleShouldNotBeZero", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = GeoChordNative.jni_New2(d7, d8, d2, d3, d4, d5, d6);
        this.setHandle(l2, true);
    }

    GeoChord(long l2) {
        this.setHandle(l2, false);
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = E.a("getCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoChordNative.jni_GetCenter(this.getHandle(), dArray);
        Point2D point2D = new Point2D();
        point2D.setX(dArray[0]);
        point2D.setY(dArray[1]);
        return point2D;
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = E.a("setCenter(Point2D center)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        GeoChordNative.jni_SetCenter(this.getHandle(), d2, d3);
    }

    public double getSemimajorAxis() {
        if (this.getHandle() == 0L) {
            String string = E.a("getSemimajorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoChordNative.jni_GetSemimajorAxis(this.getHandle());
    }

    public void setSemimajorAxis(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setSemimajorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("value", "GeoChord_SemimajorAxisShouldBePositive", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoChordNative.jni_SetSemimajorAxis(this.getHandle(), d2);
    }

    public double getSemiminorAxis() {
        if (this.getHandle() == 0L) {
            String string = E.a("getSemiminorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoChordNative.jni_GetSemiminorAxis(this.getHandle());
    }

    public void setSemiminorAxis(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setSemiminorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("value", "GeoChord_SemiMinorAxisShouldBePositive", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoChordNative.jni_SetSemiminorAxis(this.getHandle(), d2);
    }

    public double getStartAngle() {
        if (this.getHandle() == 0L) {
            String string = E.a("getStartAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoChordNative.jni_GetStartAngle(this.getHandle());
    }

    public void setStartAngle(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setStartAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoChordNative.jni_SetStartAngle(this.getHandle(), d2);
    }

    public double getSweepAngle() {
        if (this.getHandle() == 0L) {
            String string = E.a("getSweepAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoChordNative.jni_GetSweepAngle(this.getHandle());
    }

    public void setSweepAngle(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setSweepAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= -360.0 || d2 >= 360.0) {
            String string = E.a("sweepAngle", "GeoChord_SweepAngleRange:(-360,0)||(0,360)", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 == 0.0) {
            String string = E.a("sweepAngle", "GeoChord_SweepAngleShouldNotBeZero", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoChordNative.jni_SetSweepAngle(this.getHandle(), d2);
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = E.a("getRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoChordNative.jni_GetRotation(this.getHandle());
    }

    public void setRotation(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoChordNative.jni_SetRotation(this.getHandle(), d2);
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = E.a("getPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoChordNative.jni_GetPerimeter(this.getHandle());
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = E.a("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoChordNative.jni_GetArea(this.getHandle());
    }

    public GeoLine convertToLine(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("convertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 2) {
            String string = E.a("segmentCount", "Global_ArgumentShouldNotSmallerThanOne", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoChordNative.jni_ConvertToLine(this.getHandle(), n2);
        GeoLine geoLine = null;
        if (l2 != 0L) {
            geoLine = new GeoLine(l2);
            geoLine.setIsDisposable(true);
        }
        return geoLine;
    }

    public GeoRegion convertToRegion(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("convertToRegion(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 2) {
            String string = E.a("segmentCount", "Global_ArgumentShouldNotSmallerThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoChordNative.jni_ConvertToRegion(this.getHandle(), n2);
        GeoRegion geoRegion = null;
        if (l2 != 0L) {
            geoRegion = new GeoRegion(l2);
            geoRegion.setIsDisposable(true);
        }
        return geoRegion;
    }

    @Override
    public GeoChord clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoChord(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoChordNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }

    @Override
    public boolean fromJson(String string) {
        return false;
    }

    @Override
    public String toJson() {
        return null;
    }
}

