/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.E;
import com.supermap.data.GeoEllipseNative;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRectangle;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;

public class GeoEllipse
extends Geometry {
    public GeoEllipse() {
        long l2 = GeoEllipseNative.jni_New();
        this.setHandle(l2, true);
    }

    public GeoEllipse(GeoEllipse geoEllipse) {
        if (geoEllipse == null) {
            String string = E.a("geoEllipse", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(geoEllipse);
        if (l2 == 0L) {
            String string = E.a("GeoEllipse geoEllipse", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l3 = GeoEllipseNative.jni_Clone(l2);
        this.setHandle(l3, true);
    }

    public GeoEllipse(Point2D point2D, double d2, double d3, double d4) {
        if (d2 <= 0.0) {
            String string = E.a("semimajorAxis", "GeoEllipse_SemimajorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d3 <= 0.0) {
            String string = E.a("semiminorAxis", "GeoEllipse_SemiMinorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoEllipseNative.jni_New1(point2D.getX(), point2D.getY(), d2, d3, d4);
        this.setHandle(l2, true);
    }

    public GeoEllipse(GeoRectangle geoRectangle) {
        if (geoRectangle == null) {
            String string = E.a("geoRectangle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(geoRectangle);
        if (l2 == 0L) {
            String string = E.a("GeoRectangle geoRectangle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l3 = GeoEllipseNative.jni_New2(l2);
        this.setHandle(l3, true);
    }

    public GeoEllipse(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            String string = E.a("rectangle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoEllipseNative.jni_New3(rectangle2D.getLeft(), rectangle2D.getRight(), rectangle2D.getTop(), rectangle2D.getBottom());
        this.setHandle(l2, true);
    }

    GeoEllipse(long l2) {
        this.setHandle(l2, false);
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = E.a("GetCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoEllipseNative.jni_getCenter(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = E.a("SetCenter(Point2D point2D)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoEllipseNative.jni_setCenter(this.getHandle(), point2D.getX(), point2D.getY());
    }

    public double getSemimajorAxis() {
        if (this.getHandle() == 0L) {
            String string = E.a("GetSemimajorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipseNative.jni_getSemimajorAxis(this.getHandle());
    }

    public void setSemimajorAxis(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("SetSemimajorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("value", "GeoEllipse_SemimajorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoEllipseNative.jni_setSemimajorAxis(this.getHandle(), d2);
    }

    public double getSemiminorAxis() {
        if (this.getHandle() == 0L) {
            String string = E.a("GetSemiminorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipseNative.jni_getSemiminorAxis(this.getHandle());
    }

    public void setSemiminorAxis(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("SetSemiminorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("value", "GeoEllipse_SemiMinorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoEllipseNative.jni_setSemiminorAxis(this.getHandle(), d2);
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = E.a("getRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipseNative.jni_getAngle(this.getHandle());
    }

    public void setRotation(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setRotation(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoEllipseNative.jni_setAngle(this.getHandle(), d2);
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = E.a("GetPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipseNative.jni_getPerimeter(this.getHandle());
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = E.a("GetArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipseNative.jni_getArea(this.getHandle());
    }

    public GeoLine convertToLine(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("ConvertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 2) {
            String string = E.a("ConvertToLine(int segmentCount)", "GeoEllipse_GeoLineSegmentCountShouldGreaterThanOne", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = GeoEllipseNative.jni_convertToLine(this.getHandle(), n2);
        GeoLine geoLine = null;
        if (l2 != 0L) {
            geoLine = new GeoLine(l2);
            geoLine.setHandle(l2, true);
        }
        return geoLine;
    }

    public GeoRegion convertToRegion(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("ConvertToRegion(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 2) {
            String string = E.a("convertToRegion(int segmentCount)", "GeoEllipse_GeoRegionSegmentCountShouldGreaterThanOne", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = GeoEllipseNative.jni_convertToRegion(this.getHandle(), n2);
        GeoRegion geoRegion = null;
        if (l2 != 0L) {
            geoRegion = new GeoRegion(l2);
            geoRegion.setHandle(l2, true);
        }
        return geoRegion;
    }

    @Override
    public GeoEllipse clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoEllipse(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoEllipseNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }

    @Override
    public boolean fromJson(String string) {
        return false;
    }

    @Override
    public String toJson() {
        return null;
    }
}

