/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.E;
import com.supermap.data.GeoEllipticArcNative;
import com.supermap.data.GeoLine;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point2D;

public class GeoEllipticArc
extends Geometry {
    private double a;
    private double b;

    public GeoEllipticArc() {
        long l2 = GeoEllipticArcNative.jni_New();
        this.setHandle(l2, true);
        this.a = 0.0;
        this.b = 180.0;
    }

    public GeoEllipticArc(GeoEllipticArc geoEllipticArc) {
        if (geoEllipticArc == null) {
            String string = E.a("geoEllipticArc", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(geoEllipticArc);
        if (l2 == 0L) {
            String string = E.a("geoEllipticArc", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.a = geoEllipticArc.getStartAngle();
        this.b = geoEllipticArc.getSweepAngle();
        long l3 = GeoEllipticArcNative.jni_Clone(l2);
        this.setHandle(l3, true);
    }

    public GeoEllipticArc(Point2D point2D, double d2, double d3, double d4, double d5, double d6) {
        if (d2 <= 0.0) {
            String string = E.a("semimajorAxis", "GeoEllipticArc_SemimajorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d3 <= 0.0) {
            String string = E.a("semiminorAxis", "GeoEllipticArc_SemiMinorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d5 <= -360.0 || d5 >= 360.0) {
            String string = E.a("sweepAngle", "GeoEllipticArc_SweepAngleRange(-360,0)||(0,360)", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d5 == 0.0) {
            String string = E.a("sweepAngle", "GeoEllipticArc_StartAngleShouldNotBeZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.a = d4;
        this.b = d5;
        double d7 = 0.0;
        double d8 = 0.0;
        if (d5 < 0.0) {
            d7 = d4 + d5;
            d8 = d4;
        } else {
            d7 = d4;
            d8 = d4 + d5;
        }
        long l2 = GeoEllipticArcNative.jni_New1(point2D.getX(), point2D.getY(), d2, d3, d7, d8, d6);
        this.setHandle(l2, true);
    }

    GeoEllipticArc(long l2) {
        this.setHandle(l2, false);
        this.a = GeoEllipticArcNative.jni_getStartAngle(l2);
        this.b = GeoEllipticArcNative.jni_getSweepAngle(l2);
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = E.a("GetCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoEllipticArcNative.jni_getCenter(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = E.a("SetCenter(Point2D point2D)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoEllipticArcNative.jni_setCenter(this.getHandle(), point2D.getX(), point2D.getY());
    }

    public double getSemimajorAxis() {
        if (this.getHandle() == 0L) {
            String string = E.a("GetSemimajorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipticArcNative.jni_getSemimajorAxis(this.getHandle());
    }

    public void setSemimajorAxis(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("SetSemimajorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("value", "GeoEllipse_SemimajorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoEllipticArcNative.jni_setSemimajorAxis(this.getHandle(), d2);
    }

    public double getSemiminorAxis() {
        if (this.getHandle() == 0L) {
            String string = E.a("GetSemiminorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipticArcNative.jni_getSemiminorAxis(this.getHandle());
    }

    public void setSemiminorAxis(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("SetSemiminorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("value", "GeoEllipse_SemiMinorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoEllipticArcNative.jni_setSemiminorAxis(this.getHandle(), d2);
    }

    public double getStartAngle() {
        if (this.getHandle() == 0L) {
            String string = E.a("GetStartAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public void setStartAngle(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("SetStartAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d3 = this.getSweepAngle();
        double d4 = 0.0;
        double d5 = 0.0;
        double[] dArray = GeoEllipticArc.valueToUGC(d2, d3, d4, d5);
        GeoEllipticArcNative.jni_setStartAngle(this.getHandle(), dArray[0], dArray[1]);
        this.a = d2;
    }

    public double getSweepAngle() {
        if (this.getHandle() == 0L) {
            String string = E.a("getSweepAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.b;
    }

    public void setSweepAngle(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setSweepAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= -360.0 || d2 >= 360.0) {
            String string = E.a("value", "GeoEllipticArc_SweepAngleRange(-360,0)||(0,360)", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 == 0.0) {
            String string = E.a("value", "GeoEllipticArc_StartAngleShouldNotBeZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d3 = this.getStartAngle();
        double d4 = 0.0;
        double d5 = 0.0;
        double[] dArray = GeoEllipticArc.valueToUGC(d3, d2, d4, d5);
        GeoEllipticArcNative.jni_setStartAngle(this.getHandle(), dArray[0], dArray[1]);
        this.b = d2;
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = E.a("getRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipticArcNative.jni_getAngle(this.getHandle());
    }

    public void setRotation(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setRotation(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoEllipticArcNative.jni_setAngle(this.getHandle(), d2);
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = E.a("GetLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipticArcNative.jni_getLength(this.getHandle());
    }

    public GeoLine convertToLine(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("ConvertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 2) {
            String string = E.a("ConvertToLine(int segmentCount)", "GeoEllipticArc_GeoLineSegmentCountShouldNotBeNeagtive", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = GeoEllipticArcNative.jni_convertToLine(this.getHandle(), n2);
        GeoLine geoLine = null;
        if (l2 != 0L) {
            geoLine = new GeoLine(l2);
            geoLine.setHandle(l2, true);
        }
        return geoLine;
    }

    public Point2D findPointOnArc(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("FindPointOnArc(double sweepAngle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 > this.getSweepAngle() || d2 < 0.0) {
            String string = E.a("FindPointOnArc(double sweepAngle)", "GeoEllipticArc_ArgumentOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoEllipticArcNative.jni_findPointOnArc(this.getHandle(), d2, dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    @Override
    public GeoEllipticArc clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoEllipticArc(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoEllipticArcNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    protected static double[] valueToUGC(double d2, double d3, double d4, double d5) {
        int n2 = (int)d2;
        int n3 = n2 / 360;
        d2 -= (double)(360 * n3);
        if (d3 < 0.0) {
            d4 = d2 + d3;
            d5 = d2;
        } else {
            d4 = d2;
            d5 = d2 + d3;
        }
        double[] dArray = new double[]{d4, d5};
        return dArray;
    }

    @Override
    public boolean fromJson(String string) {
        return false;
    }

    @Override
    public String toJson() {
        return null;
    }
}

