/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import android.util.Log;
import com.supermap.data.E;
import com.supermap.data.GeoLineNative;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.imb.jsonlib.SiJsonArray;
import com.supermap.imb.jsonlib.SiJsonObject;
import java.util.ArrayList;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GeoLine
extends Geometry {
    private ArrayList a;

    public GeoLine() {
        long l2 = GeoLineNative.jni_New();
        this.setHandle(l2, true);
        this.a = new ArrayList();
    }

    public GeoLine(GeoLine geoLine) {
        if (geoLine == null) {
            String string = E.a("geoLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoLine.getHandle() == 0L) {
            String string = E.a("geoLine", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoLineNative.jni_Clone(geoLine.getHandle());
        this.setHandle(l2, true);
        this.a = new ArrayList();
        for (int i2 = 0; i2 < geoLine.a().size(); ++i2) {
            Point2Ds point2Ds = (Point2Ds)geoLine.a().get(i2);
            this.a.add(point2Ds.clone());
        }
    }

    public GeoLine(Point2Ds point2Ds) {
        this();
        this.addPart(point2Ds);
    }

    GeoLine(long l2) {
        this.setHandle(l2, false);
        this.a = new ArrayList();
        this.a();
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = E.a("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    @Override
    public GeoLine clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoLine(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoLineNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = E.a("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineNative.jni_GetLength(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = E.a("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineNative.jni_GetPartCount(this.getHandle());
    }

    public int addPart(Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = E.a("addPart()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = point2Ds.getCount();
        if (n2 < 2) {
            String string = E.a("points", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = point2Ds.getItem(i2).getX();
            dArray2[i2] = point2Ds.getItem(i2).getY();
        }
        Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
        this.a.add(point2Ds2);
        return GeoLineNative.jni_AddPart(this.getHandle(), dArray, dArray2);
    }

    public boolean removePart(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("removePart()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoLineNative.jni_RemovePart(this.getHandle(), n2);
        if (bl) {
            this.a.remove(n2);
        }
        return bl;
    }

    public Point2D findPointOnLineByDistance(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("findPointOnLineByDistance(double distance)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 < 0.0) {
            String string = E.a("distance", "GeoLine_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2D point2D = new Point2D();
        if (this.getPartCount() > 0) {
            double[] dArray = new double[2];
            GeoLineNative.jni_FindPointOnLineByDistance(this.getHandle(), d2, dArray);
            point2D.setX(dArray[0]);
            point2D.setY(dArray[1]);
        }
        return point2D;
    }

    public Point2Ds getPart(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("getPart()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return (Point2Ds)this.a.get(n2);
    }

    public boolean insertPart(int n2, Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = E.a("insertPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n3 = point2Ds.getCount();
        if (n3 < 2) {
            String string = E.a("Point2Ds", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        int n4 = this.getPartCount();
        if (n4 == n2) {
            int n5 = this.addPart(point2Ds);
            boolean bl2 = bl = n5 == n2;
            if (bl) {
                Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
                this.a.add(n2, point2Ds2);
            }
            return bl;
        }
        if (n2 < 0 || n2 > this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray[i2] = point2Ds.getItem(i2).getX();
            dArray2[i2] = point2Ds.getItem(i2).getY();
        }
        bl = GeoLineNative.jni_InsertPart(this.getHandle(), n2, dArray, dArray2);
        if (bl) {
            Point2Ds point2Ds3 = new Point2Ds(point2Ds, this);
            this.a.add(n2, point2Ds3);
        }
        return bl;
    }

    public boolean setPart(int n2, Point2Ds point2Ds) {
        int n3;
        if (this.getHandle() == 0L) {
            String string = E.a("setPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n4 = point2Ds.getCount();
        if (n4 < 2) {
            String string = E.a("Point2Ds", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = point2Ds.getItem(n3).getX();
            dArray2[n3] = point2Ds.getItem(n3).getY();
        }
        n3 = GeoLineNative.jni_SetPart(this.getHandle(), n2, dArray, dArray2) ? 1 : 0;
        if (n3 == 1) {
            Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
            this.a.set(n2, point2Ds2);
        }
        return n3 != 0;
    }

    @Override
    public void rotate(Point2D point2D, double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("rotate(Point2D basePoint, double angle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.rotate(point2D, d2);
        this.b();
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
    }

    ArrayList a() {
        return this.a;
    }

    private Point2D[] a(int n2) {
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = GeoLineNative.jni_GetPartPointCount(this.getHandle(), n2);
        if (n3 > 1) {
            Point2D[] point2DArray = new Point2D[n3];
            double[] dArray = new double[n3];
            double[] dArray2 = new double[n3];
            GeoLineNative.jni_GetPart(this.getHandle(), n2, dArray, dArray2);
            for (int i2 = 0; i2 < n3; ++i2) {
                point2DArray[i2] = new Point2D(dArray[i2], dArray2[i2]);
            }
            return point2DArray;
        }
        return null;
    }

    private void b() {
        int n2 = this.getPartCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Point2Ds point2Ds = (Point2Ds)this.a.get(i2);
            point2Ds.a(Point2Ds.a.a);
            point2Ds.clear();
            point2Ds.addRange(this.a(i2));
            point2Ds.a(Point2Ds.a.b);
        }
    }

    void a() {
        int n2 = this.getPartCount();
        this.a.clear();
        for (int i2 = 0; i2 < n2; ++i2) {
            Point2Ds point2Ds = new Point2Ds(this.a(i2));
            Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
            this.a.add(point2Ds2);
        }
    }

    @Override
    public boolean fromJson(SiJsonObject siJsonObject) {
        if (super.fromJson(siJsonObject)) {
            SiJsonArray siJsonArray = siJsonObject.getJsonArray("parts");
            SiJsonArray siJsonArray2 = siJsonObject.getJsonArray("points");
            int n2 = siJsonArray.getArraySize();
            int n3 = 0;
            int n4 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 = siJsonArray.getInt(i2);
                Point2Ds point2Ds = new Point2Ds();
                for (int i3 = 0; i3 < n3; ++i3) {
                    SiJsonObject siJsonObject2;
                    Point2D point2D = new Point2D();
                    if (!point2D.fromJson(siJsonObject2 = siJsonArray2.getJsonObject(n4++))) {
                        siJsonObject2.dispose();
                        continue;
                    }
                    siJsonObject2.dispose();
                    point2Ds.add(point2D);
                }
                this.addPart(point2Ds);
            }
            siJsonArray.dispose();
            siJsonArray2.dispose();
            return true;
        }
        return false;
    }

    @Override
    public boolean fromJson(String string) {
        SiJsonObject siJsonObject = new SiJsonObject(string);
        boolean bl = this.fromJson(siJsonObject);
        siJsonObject.dispose();
        return bl;
    }

    @Override
    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder(super.toJson());
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(",");
        String string = "";
        int n2 = this.getPartCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + this.getPart(i2).getCount();
            if (i2 == n2 - 1) continue;
            string = string + ",";
        }
        stringBuilder.append(" \"parts\": [" + string + "]" + ",");
        stringBuilder.append(" \"type\": LINE,");
        String string2 = "";
        int n3 = 0;
        for (int i3 = 0; i3 < n2; ++i3) {
            Point2Ds point2Ds = this.getPart(i3);
            n3 = point2Ds.getCount();
            for (int i4 = 0; i4 < n3; ++i4) {
                string2 = string2 + point2Ds.getItem(i4).toJson();
                if (i3 == n2 - 1 && i4 == n3 - 1) continue;
                string2 = string2 + ",";
            }
        }
        stringBuilder.append(" \"points\" :[" + string2 + "]");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String toGeoJSON() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.getPartCount();
        if (n2 > 1) {
            stringBuilder.append("{\"type\": \"MultiLineString\",");
        } else {
            stringBuilder.append("{\"type\": \"LineString\",");
        }
        stringBuilder.append("\"coordinates\":[");
        this.a(stringBuilder, n2);
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    @Override
    public boolean fromGeoJSON(String string) {
        if (string.contains("LineString") || string.contains("MultiLineString")) {
            ArrayList<Point2Ds> arrayList = this.getPointsFromGeoJSON(string);
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.addPart(arrayList.get(i2));
            }
        } else {
            Log.e((String)"GeoLine", (String)"Not match the type of LineString or MultiLineString");
            return false;
        }
        return true;
    }

    private void a(StringBuilder stringBuilder, int n2) {
        String string = "";
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (n2 > 1) {
                string = "[";
            }
            Point2Ds point2Ds = this.getPart(i2);
            n3 = point2Ds.getCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                string = string + "[" + point2Ds.getItem(i3).getX() + "," + point2Ds.getItem(i3).getY() + "]";
                if (i3 >= n3 - 1) continue;
                string = string + ",";
            }
            if (n2 > 1) {
                string = string + "]";
            }
            if (i2 < n2 - 1) {
                string = string + ",";
            }
            stringBuilder.append(string);
        }
    }
}

