/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.E;
import com.supermap.data.GeoLine3DNative;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.Geometry3D;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import com.supermap.imb.jsonlib.SiJsonArray;
import com.supermap.imb.jsonlib.SiJsonObject;
import java.util.ArrayList;

public class GeoLine3D
extends Geometry3D {
    private ArrayList<Point3Ds> a;

    public GeoLine3D() {
        long l2 = GeoLine3DNative.jni_New();
        this.setHandle(l2, true);
        this.a = new ArrayList();
    }

    public GeoLine3D(Point3Ds point3Ds) {
        this();
        this.addPart(point3Ds);
    }

    public GeoLine3D(GeoLine3D geoLine3D) {
        if (geoLine3D == null) {
            String string = E.a("geoLine3D", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoLine3D.getHandle() == 0L) {
            String string = E.a("geoLine3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoLine3DNative.jni_Clone(geoLine3D.getHandle());
        this.setHandle(l2, true);
        this.a = new ArrayList();
        for (int i2 = 0; i2 < geoLine3D.a().size(); ++i2) {
            Point3Ds point3Ds = geoLine3D.a().get(i2);
            this.a.add(point3Ds.clone());
        }
    }

    GeoLine3D(long l2) {
        this(l2, false);
    }

    GeoLine3D(long l2, boolean bl) {
        this.setHandle(l2, bl);
        this.a = new ArrayList();
        this.a();
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoLine3DNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = E.a("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLine3DNative.jni_GetPartCount(this.getHandle());
    }

    public int addPart(Point3Ds point3Ds) {
        if (this.getHandle() == 0L) {
            String string = E.a("addPart(points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = point3Ds.getCount();
        if (n2 < 2) {
            String string = E.a("points", "GeoLine3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = point3Ds.getItem(i2).getX();
            dArray2[i2] = point3Ds.getItem(i2).getY();
            dArray3[i2] = point3Ds.getItem(i2).getZ();
        }
        Point3Ds point3Ds2 = new Point3Ds(point3Ds, this);
        this.a.add(point3Ds2);
        return GeoLine3DNative.jni_AddPart(this.getHandle(), dArray, dArray2, dArray3);
    }

    public boolean removePart(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("removePart(index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoLine3DNative.jni_RemovePart(this.getHandle(), n2);
        if (bl) {
            this.a.remove(n2);
        }
        return bl;
    }

    public Point3Ds getPart(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("getPart(index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.a.get(n2);
    }

    public boolean insertPart(int n2, Point3Ds point3Ds) {
        if (this.getHandle() == 0L) {
            String string = E.a("insertPart(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n3 = this.getPartCount();
        if (n3 == n2) {
            int n4 = this.addPart(point3Ds);
            boolean bl2 = bl = n4 == n2;
            if (bl) {
                Point3Ds point3Ds2 = new Point3Ds(point3Ds, this);
                this.a.add(n2, point3Ds2);
            }
            return bl;
        }
        if (n2 < 0 || n2 > this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n5 = point3Ds.getCount();
        if (n5 < 2) {
            String string = E.a("Point2Ds", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        double[] dArray3 = new double[n5];
        for (int i2 = 0; i2 < n5; ++i2) {
            dArray[i2] = point3Ds.getItem(i2).getX();
            dArray2[i2] = point3Ds.getItem(i2).getY();
            dArray3[i2] = point3Ds.getItem(i2).getZ();
        }
        bl = GeoLine3DNative.jni_InsertPart(this.getHandle(), n2, dArray, dArray2, dArray3);
        if (bl) {
            Point3Ds point3Ds3 = new Point3Ds(point3Ds, this);
            this.a.add(n2, point3Ds3);
        }
        return bl;
    }

    public boolean setPart(int n2, Point3Ds point3Ds) {
        int n3;
        if (this.getHandle() == 0L) {
            String string = E.a("setPart(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n4 = point3Ds.getCount();
        if (n4 < 2) {
            String string = E.a("points", "GeoLine3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = point3Ds.getItem(n3).getX();
            dArray2[n3] = point3Ds.getItem(n3).getY();
            dArray3[n3] = point3Ds.getItem(n3).getZ();
        }
        n3 = GeoLine3DNative.jni_SetPart(this.getHandle(), n2, dArray, dArray2, dArray3) ? 1 : 0;
        if (n3 == 1) {
            Point3Ds point3Ds2 = new Point3Ds(point3Ds, this);
            this.a.set(n2, point3Ds2);
        }
        return n3 != 0;
    }

    boolean a(int n2, Point3Ds point3Ds) {
        int n3;
        if (this.getHandle() == 0L) {
            String string = E.a("setPartJustToUGC(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n4 = point3Ds.getCount();
        if (n4 < 2) {
            String string = E.a("points", "GeoLine3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = point3Ds.getItem(n3).getX();
            dArray2[n3] = point3Ds.getItem(n3).getY();
            dArray3[n3] = point3Ds.getItem(n3).getZ();
        }
        n3 = GeoLine3DNative.jni_SetPart(this.getHandle(), n2, dArray, dArray2, dArray3) ? 1 : 0;
        return n3 != 0;
    }

    public int indexOf(Point3Ds point3Ds) {
        if (this.getHandle() == 0L) {
            String string = E.a("indexOf(part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a.indexOf(point3Ds);
    }

    public GeoRegion3D convertToRegion() {
        int n2 = this.getPartCount();
        GeoRegion3D geoRegion3D = new GeoRegion3D();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            Point3Ds point3Ds = this.getPart(i2);
            int n3 = point3Ds.getCount();
            if (n3 < 3) {
                object = E.a("convertToRegion()", "GeoLine3D_UnsupportOperation", "data_resources");
                throw new UnsupportedOperationException((String)object);
            }
            object = point3Ds.clone();
            if (point3Ds.getItem(0).equals(point3Ds.getItem(n3 - 1))) {
                geoRegion3D.addPart((Point3Ds)object);
                continue;
            }
            ((Point3Ds)object).add(point3Ds.getItem(0));
            geoRegion3D.addPart((Point3Ds)object);
        }
        return geoRegion3D;
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
    }

    ArrayList<Point3Ds> a() {
        return this.a;
    }

    private void a() {
        int n2 = this.getPartCount();
        this.a.clear();
        for (int i2 = 0; i2 < n2; ++i2) {
            Point3Ds point3Ds = new Point3Ds(this.a(i2));
            Point3Ds point3Ds2 = new Point3Ds(point3Ds, this);
            this.a.add(point3Ds2);
        }
    }

    private Point3D[] a(int n2) {
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = GeoLine3DNative.jni_GetPartPointCount(this.getHandle(), n2);
        if (n3 > 1) {
            Point3D[] point3DArray = new Point3D[n3];
            double[] dArray = new double[n3];
            double[] dArray2 = new double[n3];
            double[] dArray3 = new double[n3];
            GeoLine3DNative.jni_GetPart(this.getHandle(), n2, dArray, dArray2, dArray3);
            for (int i2 = 0; i2 < n3; ++i2) {
                point3DArray[i2] = new Point3D(dArray[i2], dArray2[i2], dArray3[i2]);
            }
            return point3DArray;
        }
        return null;
    }

    @Override
    public GeoLine3D clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoLine3D(this);
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = E.a("isEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    protected static GeoLine3D creatInstance(long l2, boolean bl) {
        if (l2 == 0L) {
            String string = E.a("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoLine3D(l2, bl);
    }

    @Override
    public boolean fromJson(SiJsonObject siJsonObject) {
        if (super.fromJson(siJsonObject)) {
            SiJsonArray siJsonArray = siJsonObject.getJsonArray("parts");
            SiJsonArray siJsonArray2 = siJsonObject.getJsonArray("points");
            int n2 = siJsonArray.getArraySize();
            int n3 = 0;
            int n4 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 = siJsonArray.getInt(i2);
                Point3Ds point3Ds = new Point3Ds();
                for (int i3 = 0; i3 < n3; ++i3) {
                    SiJsonObject siJsonObject2;
                    Point3D point3D = new Point3D();
                    if (!point3D.fromJson(siJsonObject2 = siJsonArray2.getJsonObject(n4++))) {
                        siJsonObject2.dispose();
                        continue;
                    }
                    siJsonObject2.dispose();
                    point3Ds.add(point3D);
                }
                this.addPart(point3Ds);
            }
            siJsonArray.dispose();
            siJsonArray2.dispose();
            return true;
        }
        return false;
    }

    @Override
    public boolean fromJson(String string) {
        SiJsonObject siJsonObject = new SiJsonObject(string);
        boolean bl = this.fromJson(siJsonObject);
        siJsonObject.dispose();
        return bl;
    }

    @Override
    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder(super.toJson());
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(",");
        String string = "";
        int n2 = this.getPartCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + this.getPart(i2).getCount();
            if (i2 == n2 - 1) continue;
            string = string + ",";
        }
        stringBuilder.append(" \"parts\": [" + string + "]" + ",");
        stringBuilder.append(" \"type\": LINE3D,");
        String string2 = "";
        int n3 = 0;
        for (int i3 = 0; i3 < n2; ++i3) {
            Point3Ds point3Ds = this.getPart(i3);
            n3 = point3Ds.getCount();
            for (int i4 = 0; i4 < n3; ++i4) {
                string2 = string2 + point3Ds.getItem(i4).toJson();
                if (i3 == n2 - 1 && i4 == n3 - 1) continue;
                string2 = string2 + ",";
            }
        }
        stringBuilder.append(" \"points\" :[" + string2 + "]");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

