/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.E;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoPieNative;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point2D;

public class GeoPie
extends Geometry {
    public GeoPie() {
        this.setHandle(GeoPieNative.jni_New(), true);
        this.a(0.0, 0.0, 1.0, 1.0, 0.0, 180.0, 0.0);
    }

    public GeoPie(GeoPie geoPie) {
        if (geoPie == null) {
            String string = E.a("geoPie", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle(geoPie);
        if (l2 == 0L) {
            String string = E.a("geoPie", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = GeoPieNative.jni_Clone(l2);
        super.setHandle(l3, true);
    }

    public GeoPie(Point2D point2D, double d2, double d3, double d4, double d5, double d6) {
        this();
        if (d2 <= 0.0) {
            String string = E.a("semimajorAxis", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d3 <= 0.0) {
            String string = E.a("semiminorAxis", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d5 <= -360.0 || d5 >= 360.0) {
            String string = E.a("sweepAngle", "GeoPie_SweepAngleRange:(-360,0)||(0,360)", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d5 == 0.0) {
            String string = E.a("sweepAngle", "GeoPie_SweepAngleShouldNotBeZero", "data_resources");
            throw new IllegalStateException(string);
        }
        this.a(point2D.getX(), point2D.getY(), d2, d3, d4, d4 + d5, d6);
    }

    GeoPie(long l2) {
        this.setHandle(l2, false);
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = E.a("getCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoPieNative.jni_GetCenter(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = E.a("setCenter(Point2D value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPieNative.jni_SetCenter(this.getHandle(), point2D.getX(), point2D.getY());
    }

    public double getSemimajorAxis() {
        if (this.getHandle() == 0L) {
            String string = E.a("getSemimajorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPieNative.jni_GetSemimajorAxis(this.getHandle());
    }

    public void setSemimajorAxis(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setSemimajorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPieNative.jni_SetSemimajorAxis(this.getHandle(), d2);
    }

    public double getSemiminorAxis() {
        if (this.getHandle() == 0L) {
            String string = E.a("getSemiminorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPieNative.jni_GetSemiminorAxis(this.getHandle());
    }

    public void setSemiminorAxis(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setSemiminorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPieNative.jni_SetSemiminorAxis(this.getHandle(), d2);
    }

    public double getStartAngle() {
        if (this.getHandle() == 0L) {
            String string = E.a("getStartAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPieNative.jni_GetStartAngle(this.getHandle());
    }

    public void setStartAngle(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setStartAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPieNative.jni_SetStartAngle(this.getHandle(), d2);
    }

    public double getSweepAngle() {
        if (this.getHandle() == 0L) {
            String string = E.a("getSweepAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPieNative.jni_GetSweepAngle(this.getHandle());
    }

    public void setSweepAngle(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setSweepAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= -360.0 || d2 >= 360.0) {
            String string = E.a("value", "GeoPie_SweepAngleRange:(-360,0)||(0,360)", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 == 0.0) {
            String string = E.a("value", "GeoPie_SweepAngleShouldNotBeZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPieNative.jni_SetSweepAngle(this.getHandle(), d2);
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = E.a("getAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPieNative.jni_GetAngle(this.getHandle());
    }

    public void setRotation(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPieNative.jni_SetAngle(this.getHandle(), d2);
    }

    public GeoLine convertToLine(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("convertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 2) {
            String string = E.a("segmentCount", "Global_ArgumentShouldNotSmallerThanTwo", "data_resources");
            throw new NullPointerException(string);
        }
        long l2 = GeoPieNative.jni_ConvertToLine(this.getHandle(), n2);
        GeoLine geoLine = null;
        if (l2 != 0L) {
            geoLine = new GeoLine(l2);
            geoLine.setIsDisposable(true);
        }
        return geoLine;
    }

    public GeoRegion convertToRegion(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("convertToRegion(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 2) {
            String string = E.a("segmentCount", "Global_ArgumentShouldNotSmallerThanTwo", "data_resources");
            throw new NullPointerException(string);
        }
        long l2 = GeoPieNative.jni_ConvertToRegion(this.getHandle(), n2);
        GeoRegion geoRegion = null;
        if (l2 != 0L) {
            geoRegion = new GeoRegion(l2);
            geoRegion.setIsDisposable(true);
        }
        return geoRegion;
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = E.a("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPieNative.jni_GetArea(this.getHandle());
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = E.a("getPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPieNative.jni_GetPerimeter(this.getHandle());
    }

    @Override
    public GeoPie clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoPie(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoPieNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    void a(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        GeoPieNative.jni_Reset(this.getHandle(), d2, d3, d4, d5, d6, d7, d8);
    }

    @Override
    public boolean fromJson(String string) {
        return false;
    }

    @Override
    public String toJson() {
        return null;
    }
}

