/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import android.util.Log;
import com.supermap.data.E;
import com.supermap.data.GeoPointNative;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Toolkit;
import com.supermap.imb.jsonlib.SiJsonObject;
import java.util.ArrayList;

public class GeoPoint
extends Geometry {
    public GeoPoint() {
        long l2 = GeoPointNative.jni_New();
        this.setHandle(l2, true);
        this.a();
    }

    public GeoPoint(double d2, double d3) {
        this();
        this.setX(d2);
        this.setY(d3);
    }

    public GeoPoint(GeoPoint geoPoint) {
        if (geoPoint.getHandle() == 0L) {
            String string = E.a("point", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoPointNative.jni_Clone(geoPoint.getHandle());
        this.setHandle(l2, true);
    }

    public GeoPoint(Point2D point2D) {
        this(point2D.getX(), point2D.getY());
    }

    GeoPoint(long l2) {
        this.setHandle(l2, false);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoPointNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            super.clearHandle();
        }
    }

    public double getX() {
        if (this.getHandle() == 0L) {
            String string = E.a("getX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPointNative.jni_GetX(this.getHandle());
    }

    public double getY() {
        if (this.getHandle() == 0L) {
            String string = E.a("getY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPointNative.jni_GetY(this.getHandle());
    }

    public void setX(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPointNative.jni_SetX(this.getHandle(), d2);
    }

    public void setY(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPointNative.jni_SetY(this.getHandle(), d2);
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = E.a("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = Toolkit.isZero(this.getX() - -1.7976931348623157E308, -1.0E-10, 1.0E-10) && Toolkit.isZero(this.getY() - -1.7976931348623157E308, -1.0E-10, 1.0E-10);
        return bl;
    }

    @Override
    public GeoPoint clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoPoint(this);
    }

    void a() {
        this.setX(-1.7976931348623157E308);
        this.setY(-1.7976931348623157E308);
    }

    @Override
    public boolean fromJson(String string) {
        SiJsonObject siJsonObject = new SiJsonObject(string);
        boolean bl = this.fromJson(siJsonObject);
        siJsonObject.dispose();
        return bl;
    }

    @Override
    public boolean fromJson(SiJsonObject siJsonObject) {
        if (super.fromJson(siJsonObject)) {
            double d2 = siJsonObject.getJsonArray("points").getJsonObject(0).getDouble("x");
            double d3 = siJsonObject.getJsonArray("points").getJsonObject(0).getDouble("y");
            this.setX(d2);
            this.setY(d3);
            return true;
        }
        return false;
    }

    @Override
    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder(super.toJson());
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(",");
        stringBuilder.append(" \"parts\" :[1],");
        stringBuilder.append(" \"type\" :\"POINT\",");
        stringBuilder.append(" \"points\" : [" + new Point2D(this.getX(), this.getY()).toJson() + "]");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String toGeoJSON() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"type\": \"Point\",");
        stringBuilder.append("\"coordinates\":[");
        stringBuilder.append(this.getX() + "," + this.getY());
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    @Override
    public boolean fromGeoJSON(String string) {
        if (!string.contains("Point")) {
            Log.e((String)"GeoPoint", (String)"Not match the type of Point");
            return false;
        }
        ArrayList<Point2Ds> arrayList = this.getPointsFromGeoJSON(string);
        if (arrayList.size() > 0) {
            this.setX(arrayList.get(0).getItem(0).getX());
            this.setY(arrayList.get(0).getItem(0).getY());
        }
        return true;
    }
}

